/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.vivaldi.ver2.stats;

import com.aelitis.azureus.vivaldi.ver2.stats.VivaldiStatistics;
import edu.harvard.syrah.nc.Coordinate;
import edu.harvard.syrah.nc.VivaldiClient;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class V1Statistics
implements VivaldiStatistics {
    public Coordinate sys_coord;
    public Coordinate app_coord;
    public float error;
    public float dist_to_nearest_neighbor;
    public float age_difference;
    public float valid_link_count;
    public float gravity;
    public float relative_rank_loss;
    public float norm_app_latency_penalty;
    public float relative_app_latency_penalty;
    public float sys_re50;
    public float sys_re95;
    public float app_re50;
    public float app_re95;
    public float sys_dd;
    public float app_dd;
    public float neighbors_used_per_update;
    public float running_relative_diff;
    public float running_sys_update_frequency;
    public float running_app_update_frequency;
    public boolean keepStatistics;
    protected static final NumberFormat nf = NumberFormat.getInstance();
    protected static final int NFDigits = 3;
    static boolean haveSetFormat = false;

    @Override
    public boolean isValid() {
        if (this.sys_coord == null || this.app_coord == null || this.error < 0.0f || this.dist_to_nearest_neighbor < 0.0f) {
            return false;
        }
        return !this.keepStatistics || !(this.sys_re50 > this.sys_re95 || this.app_re50 > this.app_re95 || this.running_sys_update_frequency > this.running_app_update_frequency || this.age_difference < 0.0f) && !(this.valid_link_count < 0.0f);
    }

    void checkFormat() {
        if (!haveSetFormat) {
            if (nf.getMaximumFractionDigits() > 3) {
                nf.setMaximumFractionDigits(3);
            }
            if (nf.getMinimumFractionDigits() > 3) {
                nf.setMinimumFractionDigits(3);
            }
            nf.setGroupingUsed(false);
        }
        haveSetFormat = true;
    }

    public String toString() {
        this.checkFormat();
        String string = new String("sc " + this.sys_coord + " ac " + this.app_coord + " er " + nf.format(this.error) + " nn " + nf.format(this.dist_to_nearest_neighbor));
        if (this.keepStatistics) {
            String string2 = new String(" rrl " + nf.format(this.relative_rank_loss) + " narl " + nf.format(this.norm_app_latency_penalty) + " ralp " + nf.format(this.relative_app_latency_penalty) + " age " + nf.format(this.age_difference) + " gr " + nf.format(this.gravity) + " vl " + nf.format(this.valid_link_count) + " sys_re50 " + nf.format(this.sys_re50) + " sys_re95 " + nf.format(this.sys_re95) + " app_re50 " + nf.format(this.app_re50) + " app_re95 " + nf.format(this.app_re95) + " sys_dd " + nf.format(this.sys_dd) + " app_dd " + nf.format(this.app_dd) + " ne " + nf.format(this.neighbors_used_per_update) + " rd " + nf.format(this.running_relative_diff) + " sf " + nf.format(this.running_sys_update_frequency) + " af " + nf.format(this.running_app_update_frequency));
            return new String(string + string2);
        }
        return string;
    }

    public V1Statistics(DataInputStream dataInputStream) {
        try {
            if (1 == dataInputStream.readByte()) {
                int n = dataInputStream.readInt();
                this.sys_coord = new Coordinate(n, dataInputStream);
                this.app_coord = new Coordinate(n, dataInputStream);
                this.error = dataInputStream.readFloat();
                this.dist_to_nearest_neighbor = dataInputStream.readFloat();
                this.keepStatistics = dataInputStream.readBoolean();
                if (this.keepStatistics) {
                    this.relative_rank_loss = dataInputStream.readFloat();
                    this.norm_app_latency_penalty = dataInputStream.readFloat();
                    this.relative_app_latency_penalty = dataInputStream.readFloat();
                    this.age_difference = dataInputStream.readFloat();
                    this.valid_link_count = dataInputStream.readFloat();
                    this.gravity = dataInputStream.readFloat();
                    this.sys_re50 = dataInputStream.readFloat();
                    this.sys_re95 = dataInputStream.readFloat();
                    this.app_re50 = dataInputStream.readFloat();
                    this.app_re95 = dataInputStream.readFloat();
                    this.sys_dd = dataInputStream.readFloat();
                    this.app_dd = dataInputStream.readFloat();
                    this.neighbors_used_per_update = dataInputStream.readFloat();
                    this.running_relative_diff = dataInputStream.readFloat();
                    this.running_sys_update_frequency = dataInputStream.readFloat();
                    this.running_app_update_frequency = dataInputStream.readFloat();
                }
            }
        }
        catch (IOException iOException) {
            this.error = -1.0f;
        }
    }

    public static void toSerialized(DataOutputStream dataOutputStream, VivaldiClient<?> vivaldiClient) throws IOException {
        dataOutputStream.writeByte(1);
        dataOutputStream.writeInt(vivaldiClient.getSystemCoords().getNumDimensions());
        vivaldiClient.getSystemCoords().toSerialized(dataOutputStream);
        vivaldiClient.getApplicationCoords().toSerialized(dataOutputStream);
        Hashtable<String, Double> hashtable = vivaldiClient.getStatistics();
        dataOutputStream.writeFloat(new Float(hashtable.get("er")).floatValue());
        dataOutputStream.writeFloat(new Float(hashtable.get("nn")).floatValue());
        if (VivaldiClient.keepStatistics) {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeFloat(new Float(hashtable.get("rrl")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("narl")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("ralp")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("age")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("vl")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("gr")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("sys_re50")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("sys_re95")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("app_re50")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("app_re95")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("sys_dd")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("app_dd")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("ne")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("rd")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("sf")).floatValue());
            dataOutputStream.writeFloat(new Float(hashtable.get("af")).floatValue());
        } else {
            dataOutputStream.writeBoolean(false);
        }
    }

    @Override
    public byte getSerializedVersion() {
        return 1;
    }

    public long getDBValuesStored() {
        return 0L;
    }

    public long getDBKeysBlocked() {
        return 0L;
    }

    public long getRouterNodes() {
        return 0L;
    }

    public long getRouterLeaves() {
        return 0L;
    }

    public long getRouterContacts() {
        return 0L;
    }

    public long getRouterUptime() {
        return 0L;
    }

    public int getRouterCount() {
        return 0;
    }

    public long getTotalBytesReceived() {
        return 0L;
    }

    public long getTotalBytesSent() {
        return 0L;
    }

    public long getTotalPacketsReceived() {
        return 0L;
    }

    public long getTotalPacketsSent() {
        return 0L;
    }

    public long getTotalPingsReceived() {
        return 0L;
    }

    public long getTotalFindNodesReceived() {
        return 0L;
    }

    public long getTotalFindValuesReceived() {
        return 0L;
    }

    public long getTotalStoresReceived() {
        return 0L;
    }

    public long getTotalKeyBlocksReceived() {
        return 0L;
    }

    public long getIncomingRequests() {
        return 0L;
    }

    public long getAverageBytesReceived() {
        return 0L;
    }

    public long getAverageBytesSent() {
        return 0L;
    }

    public long getAveragePacketsReceived() {
        return 0L;
    }

    public long getAveragePacketsSent() {
        return 0L;
    }

    public String getVersion() {
        return new String("");
    }

    public String getString() {
        return new String("foo");
    }
}

