/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.udp.uc;

import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReplyDecoder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;

public abstract class PRUDPPacketReply
extends PRUDPPacket {
    public static final int PR_HEADER_SIZE = 8;
    private static AEMonitor class_mon = new AEMonitor("PRUDPPacketReply:class");
    private static Map packet_decoders = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDecoders(Map map) {
        try {
            class_mon.enter();
            HashMap hashMap = new HashMap(packet_decoders);
            for (Integer n : map.keySet()) {
                if (!packet_decoders.containsKey(n)) continue;
                Debug.out("Duplicate codec! " + n);
            }
            hashMap.putAll(map);
            packet_decoders = hashMap;
        }
        finally {
            class_mon.exit();
        }
    }

    public PRUDPPacketReply(int n, int n2) {
        super(n, n2);
    }

    public void serialise(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.getAction());
        dataOutputStream.writeInt(this.getTransactionId());
    }

    public static PRUDPPacketReply deserialiseReply(PRUDPPacketHandler pRUDPPacketHandler, InetSocketAddress inetSocketAddress, DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        PRUDPPacketReplyDecoder pRUDPPacketReplyDecoder = (PRUDPPacketReplyDecoder)packet_decoders.get(new Integer(n));
        if (pRUDPPacketReplyDecoder == null) {
            throw new IOException("No decoder registered for action '" + n + "'");
        }
        int n2 = dataInputStream.readInt();
        return pRUDPPacketReplyDecoder.decode(pRUDPPacketHandler, inetSocketAddress, dataInputStream, n, n2);
    }

    public String getString() {
        return super.getString() + ":reply[trans=" + this.getTransactionId() + "]";
    }
}

