/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl;

import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPAdapter;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPListener;
import com.aelitis.net.upnp.UPnPLogListener;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPService;
import com.aelitis.net.upnp.impl.SSDPIGD;
import com.aelitis.net.upnp.impl.SSDPIGDFactory;
import com.aelitis.net.upnp.impl.SSDPIGDListener;
import com.aelitis.net.upnp.impl.device.UPnPDeviceImpl;
import com.aelitis.net.upnp.impl.device.UPnPRootDeviceImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.ThreadPool;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;

public class UPnPImpl
extends ResourceDownloaderAdapter
implements UPnP,
SSDPIGDListener {
    public static final String NL = "\r\n";
    private static UPnPImpl singleton;
    private static AEMonitor class_mon;
    private UPnPAdapter adapter;
    private SSDPIGD ssdp;
    private Map<String, UPnPRootDeviceImpl> root_locations = new HashMap<String, UPnPRootDeviceImpl>();
    private List log_listeners = new ArrayList();
    private List log_history = new ArrayList();
    private List log_alert_history = new ArrayList();
    private List rd_listeners = new ArrayList();
    private AEMonitor rd_listeners_mon = new AEMonitor("UPnP:L");
    private int http_calls_ok = 0;
    private int direct_calls_ok = 0;
    private int trace_index = 0;
    private ThreadPool device_dispatcher = new ThreadPool("UPnPDispatcher", 1, true);
    private Set device_dispatcher_pending = new HashSet();
    private Map<String, long[]> failed_urls = new HashMap<String, long[]>();
    protected AEMonitor this_mon = new AEMonitor("UPnP");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UPnP getSingleton(UPnPAdapter uPnPAdapter, String[] stringArray) throws UPnPException {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new UPnPImpl(uPnPAdapter, stringArray);
            }
            UPnPImpl uPnPImpl = singleton;
            Object var4_3 = null;
            class_mon.exit();
            return uPnPImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected UPnPImpl(UPnPAdapter uPnPAdapter, String[] stringArray) throws UPnPException {
        this.adapter = uPnPAdapter;
        this.ssdp = SSDPIGDFactory.create(this, stringArray);
        this.ssdp.addListener(this);
        this.ssdp.start();
    }

    public void injectDiscoveryCache(Map map) {
        try {
            String string = new String((byte[])map.get("ni"), "UTF-8");
            String string2 = new String((byte[])map.get("la"), "UTF-8");
            String string3 = new String((byte[])map.get("usn"), "UTF-8");
            String string4 = new String((byte[])map.get("loc"), "UTF-8");
            NetworkInterface networkInterface2 = NetworkInterface.getByName(string);
            if (networkInterface2 == null) {
                return;
            }
            InetAddress inetAddress = InetAddress.getByName(string2);
            URL uRL = new URL(string4);
            this.rootDiscovered(networkInterface2, inetAddress, string3, uRL);
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rootDiscovered(final NetworkInterface networkInterface2, final InetAddress inetAddress, final String string, final URL uRL) {
        try {
            this.rd_listeners_mon.enter();
            if (this.device_dispatcher_pending.contains(string)) {
                Object var6_5 = null;
                this.rd_listeners_mon.exit();
                return;
            }
            if (this.device_dispatcher_pending.size() > 512) {
                Debug.out("Device dispatcher queue is full - dropping discovery of " + string + "/" + uRL);
            }
            this.device_dispatcher_pending.add(string);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.rd_listeners_mon.exit();
            throw throwable;
        }
        Object var6_6 = null;
        this.rd_listeners_mon.exit();
        this.device_dispatcher.run(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                ArrayList arrayList;
                String string3;
                UPnPRootDeviceImpl uPnPRootDeviceImpl;
                try {
                    UPnPImpl.this.rd_listeners_mon.enter();
                    uPnPRootDeviceImpl = (UPnPRootDeviceImpl)UPnPImpl.this.root_locations.get(string);
                    UPnPImpl.this.device_dispatcher_pending.remove(string);
                    Object var3_2 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                    throw throwable;
                }
                if (uPnPRootDeviceImpl != null) {
                    if (!uPnPRootDeviceImpl.getNetworkInterface().getName().equals(networkInterface2.getName())) {
                        return;
                    }
                    if (uPnPRootDeviceImpl.getLocation().equals(uRL)) {
                        return;
                    }
                }
                if (uPnPRootDeviceImpl != null) {
                    try {
                        UPnPImpl.this.rd_listeners_mon.enter();
                        UPnPImpl.this.root_locations.remove(string);
                        string3 = null;
                        UPnPImpl.this.rd_listeners_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var5_10 = null;
                        UPnPImpl.this.rd_listeners_mon.exit();
                        throw throwable;
                    }
                    uPnPRootDeviceImpl.destroy(true);
                }
                try {
                    UPnPImpl.this.rd_listeners_mon.enter();
                    arrayList = new ArrayList(UPnPImpl.this.rd_listeners);
                    Object var7_16 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var7_17 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                    throw throwable;
                }
                for (int i = 0; i < arrayList.size(); ++i) {
                    try {
                        if (((UPnPListener)arrayList.get(i)).deviceDiscovered(string, uRL)) continue;
                        return;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                UPnPImpl.this.log("UPnP: root discovered: usn=" + string + ", location=" + uRL + ", ni=" + networkInterface2.getName() + ",local=" + inetAddress.toString());
                try {
                    UPnPRootDeviceImpl uPnPRootDeviceImpl2 = new UPnPRootDeviceImpl(UPnPImpl.this, networkInterface2, inetAddress, string, uRL);
                    try {
                        UPnPImpl.this.rd_listeners_mon.enter();
                        UPnPImpl.this.root_locations.put(string, uPnPRootDeviceImpl2);
                        arrayList = new ArrayList(UPnPImpl.this.rd_listeners);
                        Object var9_19 = null;
                        UPnPImpl.this.rd_listeners_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var9_20 = null;
                        UPnPImpl.this.rd_listeners_mon.exit();
                        throw throwable;
                    }
                    for (int i = 0; i < arrayList.size(); ++i) {
                        try {
                            ((UPnPListener)arrayList.get(i)).rootDeviceFound(uPnPRootDeviceImpl2);
                            continue;
                        }
                        catch (Throwable throwable) {
                            Debug.printStackTrace(throwable);
                        }
                    }
                }
                catch (UPnPException uPnPException) {
                    String string2 = uPnPException.getMessage();
                    string3 = string2 == null ? Debug.getNestedExceptionMessageAndStack(uPnPException) : string2;
                    UPnPImpl.this.adapter.log(string3);
                }
            }
        });
    }

    public void rootAlive(String string, URL uRL) {
        UPnPRootDeviceImpl uPnPRootDeviceImpl = this.root_locations.get(string);
        if (uPnPRootDeviceImpl == null) {
            this.ssdp.searchNow();
        }
    }

    public void rootLost(InetAddress inetAddress, final String string) {
        this.device_dispatcher.run(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                UPnPRootDeviceImpl uPnPRootDeviceImpl = null;
                try {
                    UPnPImpl.this.rd_listeners_mon.enter();
                    uPnPRootDeviceImpl = (UPnPRootDeviceImpl)UPnPImpl.this.root_locations.remove(string);
                    Object var3_2 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    UPnPImpl.this.rd_listeners_mon.exit();
                    throw throwable;
                }
                if (uPnPRootDeviceImpl == null) {
                    return;
                }
                UPnPImpl.this.log("UPnP: root lost: usn=" + string + ", location=" + uPnPRootDeviceImpl.getLocation() + ", ni=" + uPnPRootDeviceImpl.getNetworkInterface().getName() + ",local=" + uPnPRootDeviceImpl.getLocalAddress().toString());
                uPnPRootDeviceImpl.destroy(false);
            }
        });
    }

    public void interfaceChanged(NetworkInterface networkInterface2) {
        this.reset();
    }

    public void search() {
        this.ssdp.searchNow();
    }

    public void search(String[] stringArray) {
        this.ssdp.searchNow(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ArrayList<UPnPRootDeviceImpl> arrayList;
        this.log("UPnP: reset");
        try {
            this.rd_listeners_mon.enter();
            arrayList = new ArrayList<UPnPRootDeviceImpl>(this.root_locations.values());
            this.root_locations.clear();
            Object var3_2 = null;
            this.rd_listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.rd_listeners_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((UPnPRootDeviceImpl)arrayList.get(i)).destroy(true);
        }
        this.ssdp.searchNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleXMLParserDocument parseXML(InputStream inputStream) throws SimpleXMLParserDocumentException, IOException {
        Closeable closeable;
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            closeable = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            byteArrayOutputStream.close();
            throw throwable;
        }
        byteArrayOutputStream.close();
        byArray = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            String string;
            StringBuffer stringBuffer = new StringBuffer(1024);
            closeable = new LineNumberReader(new InputStreamReader((InputStream)byteArrayInputStream, "UTF-8"));
            HashSet<Character> hashSet = null;
            while ((string = ((LineNumberReader)closeable).readLine()) != null) {
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c < ' ' && c != '\r' && c != '\t') {
                        Character c2;
                        stringBuffer.append(' ');
                        if (hashSet == null) {
                            hashSet = new HashSet<Character>();
                        }
                        if (hashSet.contains(c2 = new Character(c))) continue;
                        hashSet.add(c2);
                        this.adapter.trace("    ignoring character(s) " + c + " in xml response");
                        continue;
                    }
                    stringBuffer.append(c);
                }
                stringBuffer.append("\n");
            }
            string = stringBuffer.toString();
            this.adapter.trace("UPnP:Response:" + string);
            return this.adapter.parseXML(string);
        }
        catch (Throwable throwable) {
            try {
                closeable = new FileOutputStream(this.getTraceFile());
                ((FileOutputStream)closeable).write(byArray);
                ((FileOutputStream)closeable).close();
            }
            catch (Throwable throwable2) {
                this.adapter.log(throwable2);
            }
            if (throwable instanceof SimpleXMLParserDocumentException) {
                throw (SimpleXMLParserDocumentException)throwable;
            }
            throw new SimpleXMLParserDocumentException(throwable);
        }
    }

    public SimpleXMLParserDocument downloadXML(UPnPRootDeviceImpl uPnPRootDeviceImpl, URL uRL) throws UPnPException {
        return this.downloadXMLSupport(null, uRL);
    }

    public SimpleXMLParserDocument downloadXML(UPnPDeviceImpl uPnPDeviceImpl, URL uRL) throws UPnPException {
        try {
            if (uPnPDeviceImpl != null) {
                uPnPDeviceImpl.restoreRelativeBaseURL();
            }
            return this.downloadXMLSupport(uPnPDeviceImpl.getFriendlyName(), uRL);
        }
        catch (UPnPException uPnPException) {
            if (uPnPDeviceImpl != null) {
                uPnPDeviceImpl.clearRelativeBaseURL();
                return this.downloadXMLSupport(uPnPDeviceImpl.getFriendlyName(), uRL);
            }
            throw uPnPException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SimpleXMLParserDocument downloadXMLSupport(String string, URL uRL) throws UPnPException {
        Object object;
        String string2 = uRL.toExternalForm();
        boolean bl = true;
        try {
            try {
                int n;
                Object object2;
                TorrentUtils.setTLSDescription("UPnP Device" + (string == null ? "" : ": " + string));
                ResourceDownloaderFactory resourceDownloaderFactory = this.adapter.getResourceDownloaderFactory();
                Object object3 = this.failed_urls;
                synchronized (object3) {
                    object2 = this.failed_urls.get(string2);
                    if (object2 == null) {
                        n = 3;
                    } else {
                        long l = object2[0];
                        long l2 = object2[1];
                        long l3 = 600000L;
                        long l4 = 60000L;
                        int n2 = 0;
                        while ((long)n2 < l) {
                            if ((l4 <<= 1) >= l3) {
                                l4 = l3;
                                break;
                            }
                            ++n2;
                        }
                        if (SystemTime.getMonotonousTime() - l2 < l4) {
                            bl = false;
                            throw new UPnPException("Download failed too recently, ignoring");
                        }
                        n = 1;
                    }
                }
                object3 = resourceDownloaderFactory.getRetryDownloader(resourceDownloaderFactory.create(uRL, true), n);
                object3.addListener(this);
                object2 = object3.download();
                try {
                    SimpleXMLParserDocument simpleXMLParserDocument = this.parseXML((InputStream)object2);
                    object = this.failed_urls;
                    synchronized (object) {
                        this.failed_urls.remove(string2);
                    }
                    object = simpleXMLParserDocument;
                    Object var21_19 = null;
                }
                catch (Throwable throwable) {
                    Object var21_20 = null;
                    ((InputStream)object2).close();
                    throw throwable;
                }
                ((InputStream)object2).close();
                Object var24_21 = null;
            }
            catch (Throwable throwable) {
                if (bl) {
                    Map<String, long[]> map = this.failed_urls;
                    synchronized (map) {
                        long[] lArray;
                        if (this.failed_urls.size() >= 64) {
                            this.failed_urls.clear();
                        }
                        if ((lArray = this.failed_urls.get(string2)) == null) {
                            lArray = new long[2];
                            this.failed_urls.put(string2, lArray);
                        }
                        lArray[0] = lArray[0] + 1L;
                        lArray[1] = SystemTime.getMonotonousTime();
                    }
                    this.adapter.log(Debug.getNestedExceptionMessageAndStack(throwable));
                }
                if (!(throwable instanceof UPnPException)) throw new UPnPException("Root device location '" + uRL + "' - data read failed", throwable);
                throw (UPnPException)throwable;
            }
        }
        catch (Throwable throwable) {
            Object var24_22 = null;
            TorrentUtils.setTLSDescription(null);
            throw throwable;
        }
        TorrentUtils.setTLSDescription(null);
        return object;
    }

    protected boolean forceDirect() {
        String string = System.getProperty("http.proxyHost");
        String string2 = System.getProperty("socksProxyHost");
        boolean bl = string != null && string.trim().length() > 0 || string2 != null && string2.trim().length() > 0;
        return bl;
    }

    public SimpleXMLParserDocument performSOAPRequest(UPnPService uPnPService, String string, String string2) throws SimpleXMLParserDocumentException, UPnPException, IOException {
        SimpleXMLParserDocument simpleXMLParserDocument;
        block4: {
            if (uPnPService.getDirectInvocations() || this.forceDirect()) {
                simpleXMLParserDocument = this.performSOAPRequest(uPnPService, string, string2, false);
            } else {
                try {
                    simpleXMLParserDocument = this.performSOAPRequest(uPnPService, string, string2, true);
                    ++this.http_calls_ok;
                }
                catch (IOException iOException) {
                    simpleXMLParserDocument = this.performSOAPRequest(uPnPService, string, string2, false);
                    ++this.direct_calls_ok;
                    if (this.direct_calls_ok != 1) break block4;
                    this.log("Invocation via http connection failed (" + iOException.getMessage() + ") but socket connection succeeded");
                }
            }
        }
        return simpleXMLParserDocument;
    }

    /*
     * Exception decompiling
     */
    public SimpleXMLParserDocument performSOAPRequest(UPnPService var1_1, String var2_2, String var3_3, boolean var4_4) throws SimpleXMLParserDocumentException, UPnPException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 6[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File getTraceFile() {
        try {
            this.this_mon.enter();
            ++this.trace_index;
            if (this.trace_index == 6) {
                this.trace_index = 1;
            }
            File file = new File(this.adapter.getTraceDir(), "upnp_trace" + this.trace_index + ".log");
            Object var3_2 = null;
            this.this_mon.exit();
            return file;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public UPnPAdapter getAdapter() {
        return this.adapter;
    }

    public void reportActivity(ResourceDownloader resourceDownloader, String string) {
        this.log(string);
    }

    public void failed(ResourceDownloader resourceDownloader, ResourceDownloaderException resourceDownloaderException) {
        this.log(resourceDownloaderException);
    }

    public void log(Throwable throwable) {
        this.log(throwable.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String string) {
        ArrayList arrayList;
        try {
            this.this_mon.enter();
            arrayList = new ArrayList(this.log_listeners);
            this.log_history.add(string);
            if (this.log_history.size() > 32) {
                this.log_history.remove(0);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((UPnPLogListener)arrayList.get(i)).log(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logAlert(String string, boolean bl, int n) {
        ArrayList arrayList;
        try {
            this.this_mon.enter();
            arrayList = new ArrayList(this.log_listeners);
            this.log_alert_history.add(new Object[]{string, new Boolean(bl), new Integer(n)});
            if (this.log_alert_history.size() > 32) {
                this.log_alert_history.remove(0);
            }
            Object var6_5 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((UPnPLogListener)arrayList.get(i)).logAlert(string, bl, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogListener(UPnPLogListener uPnPLogListener) {
        int n;
        Object[] objectArray;
        ArrayList arrayList;
        ArrayList arrayList2;
        try {
            this.this_mon.enter();
            arrayList2 = new ArrayList(this.log_history);
            arrayList = new ArrayList(this.log_alert_history);
            this.log_listeners.add(uPnPLogListener);
            objectArray = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            uPnPLogListener.log((String)arrayList2.get(n));
        }
        for (n = 0; n < arrayList.size(); ++n) {
            objectArray = (Object[])arrayList.get(n);
            uPnPLogListener.logAlert((String)objectArray[0], (Boolean)objectArray[1], (Integer)objectArray[2]);
        }
    }

    public void removeLogListener(UPnPLogListener uPnPLogListener) {
        this.log_listeners.remove(uPnPLogListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPnPRootDevice[] getRootDevices() {
        try {
            this.this_mon.enter();
            UPnPRootDevice[] uPnPRootDeviceArray = this.root_locations.values().toArray(new UPnPRootDevice[this.root_locations.size()]);
            Object var3_2 = null;
            this.this_mon.exit();
            return uPnPRootDeviceArray;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRootDeviceListener(UPnPListener uPnPListener) {
        UPnPRootDevice uPnPRootDevice;
        ArrayList<UPnPRootDeviceImpl> arrayList;
        try {
            this.this_mon.enter();
            arrayList = new ArrayList<UPnPRootDeviceImpl>(this.root_locations.values());
            this.rd_listeners.add(uPnPListener);
            uPnPRootDevice = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            uPnPRootDevice = (UPnPRootDevice)arrayList.get(i);
            try {
                if (!uPnPListener.deviceDiscovered(uPnPRootDevice.getUSN(), uPnPRootDevice.getLocation())) continue;
                uPnPListener.rootDeviceFound(uPnPRootDevice);
                continue;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRootDeviceListener(UPnPListener uPnPListener) {
        try {
            this.this_mon.enter();
            this.rd_listeners.remove(uPnPListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    static {
        class_mon = new AEMonitor("UPnP:class");
    }
}

