/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.device;

import com.aelitis.net.upnp.UPnP;
import com.aelitis.net.upnp.UPnPDevice;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPRootDevice;
import com.aelitis.net.upnp.UPnPRootDeviceListener;
import com.aelitis.net.upnp.impl.UPnPImpl;
import com.aelitis.net.upnp.impl.device.UPnPDeviceImpl;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;

public class UPnPRootDeviceImpl
implements UPnPRootDevice {
    public static final String[] ROUTERS = new String[]{"3Com ADSL 11g"};
    public static final String[] BAD_ROUTER_VERSIONS = new String[]{"2.05"};
    public static final boolean[] BAD_ROUTER_REPORT_FAIL = new boolean[]{true};
    private final UPnPImpl upnp;
    private final NetworkInterface network_interface;
    private final InetAddress local_address;
    private final String usn;
    private final URL location;
    private URL url_base_for_relative_urls;
    private URL saved_url_base_for_relative_urls;
    private String info;
    private UPnPDeviceImpl root_device;
    private boolean port_mapping_result_received;
    private boolean destroyed;
    private List listeners = new ArrayList();

    public UPnPRootDeviceImpl(UPnPImpl uPnPImpl, NetworkInterface networkInterface2, InetAddress inetAddress, String string, URL uRL) throws UPnPException {
        Object object;
        this.upnp = uPnPImpl;
        this.network_interface = networkInterface2;
        this.local_address = inetAddress;
        this.usn = string;
        this.location = uRL;
        SimpleXMLParserDocument simpleXMLParserDocument = this.upnp.downloadXML(this, this.location);
        SimpleXMLParserDocumentNode simpleXMLParserDocumentNode = simpleXMLParserDocument.getChild("URLBase");
        try {
            if (simpleXMLParserDocumentNode != null && ((String)(object = simpleXMLParserDocumentNode.getValue().trim())).length() > 0) {
                this.url_base_for_relative_urls = new URL((String)object);
            }
            this.upnp.log("Relative URL base is " + (this.url_base_for_relative_urls == null ? "unspecified" : this.url_base_for_relative_urls.toString()));
        }
        catch (MalformedURLException malformedURLException) {
            this.upnp.log("Invalid URLBase - " + (simpleXMLParserDocumentNode == null ? "mill" : simpleXMLParserDocumentNode.getValue()));
            this.upnp.log(malformedURLException);
            Debug.printStackTrace(malformedURLException);
        }
        object = simpleXMLParserDocument.getChild("Device");
        if (object == null) {
            throw new UPnPException("Root device '" + this.usn + "(" + this.location + ") is missing the device description");
        }
        this.root_device = new UPnPDeviceImpl(this, "", (SimpleXMLParserDocumentNode)object);
        this.info = this.root_device.getFriendlyName();
        String string2 = this.root_device.getModelNumber();
        if (string2 != null) {
            this.info = this.info + "/" + string2;
        }
    }

    public Map getDiscoveryCache() {
        try {
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
            hashMap.put("ni", this.network_interface.getName().getBytes("UTF-8"));
            hashMap.put("la", this.local_address.getHostAddress().getBytes("UTF-8"));
            hashMap.put("usn", this.usn.getBytes("UTF-8"));
            hashMap.put("loc", this.location.toExternalForm().getBytes("UTF-8"));
            return hashMap;
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    public void portMappingResult(boolean bl) {
        if (this.port_mapping_result_received) {
            return;
        }
        this.port_mapping_result_received = true;
        this.info = bl ? this.info + "/OK" : this.info + "/Failed";
        String string = this.root_device.getModelName();
        String string2 = this.root_device.getModelNumber();
        if (string == null || string2 == null) {
            return;
        }
        for (int i = 0; i < ROUTERS.length; ++i) {
            if (!ROUTERS[i].equals(string) || !this.isBadVersion(string2, BAD_ROUTER_VERSIONS[i])) continue;
            boolean bl2 = BAD_ROUTER_REPORT_FAIL[i];
            if (bl2 && bl) break;
            String string3 = this.root_device.getModelURL();
            this.upnp.logAlert("Device '" + string + "', version '" + string2 + "' has known problems with UPnP. Please update to the latest software version (see " + (string3 == null ? "the manufacturer's web site" : string3) + ") and refer to http://www.azureuswiki.com/index.php/UPnP", false, 3);
            break;
        }
    }

    public String getInfo() {
        return this.info;
    }

    protected String getAbsoluteURL(String string) {
        String string2 = string.toLowerCase().trim();
        if (string2.startsWith("http://") || string2.startsWith("https://")) {
            return string;
        }
        if (this.url_base_for_relative_urls != null) {
            String string3 = this.url_base_for_relative_urls.toString();
            if (!string3.endsWith("/")) {
                string3 = string3 + "/";
            }
            string3 = string.startsWith("/") ? string3 + string.substring(1) : string3 + string;
            return string3;
        }
        String string4 = this.location.toString();
        int n = string4.indexOf("://") + 3;
        n = string4.indexOf("/", n);
        string4 = string4.substring(0, n);
        return string4 + (string.startsWith("/") ? "" : "/") + string;
    }

    protected synchronized void clearRelativeBaseURL() {
        if (this.url_base_for_relative_urls != null) {
            this.saved_url_base_for_relative_urls = this.url_base_for_relative_urls;
            this.url_base_for_relative_urls = null;
        }
    }

    protected synchronized void restoreRelativeBaseURL() {
        if (this.saved_url_base_for_relative_urls != null) {
            this.url_base_for_relative_urls = this.saved_url_base_for_relative_urls;
            this.saved_url_base_for_relative_urls = null;
        }
    }

    public UPnP getUPnP() {
        return this.upnp;
    }

    public NetworkInterface getNetworkInterface() {
        return this.network_interface;
    }

    public InetAddress getLocalAddress() {
        return this.local_address;
    }

    public String getUSN() {
        return this.usn;
    }

    public URL getLocation() {
        return this.location;
    }

    public UPnPDevice getDevice() {
        return this.root_device;
    }

    public void destroy(boolean bl) {
        this.destroyed = true;
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((UPnPRootDeviceListener)this.listeners.get(i)).lost(this, bl);
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void addListener(UPnPRootDeviceListener uPnPRootDeviceListener) {
        this.listeners.add(uPnPRootDeviceListener);
    }

    public void removeListener(UPnPRootDeviceListener uPnPRootDeviceListener) {
        this.listeners.remove(uPnPRootDeviceListener);
    }

    protected boolean isBadVersion(String string, String string2) {
        char c;
        int n;
        if (string2.equals("any")) {
            return true;
        }
        Comparator comparator = this.upnp.getAdapter().getAlphanumericComparator();
        HashSet<Character> hashSet = new HashSet<Character>();
        char c2 = '1';
        char c3 = '1';
        for (n = 0; n < string.length(); ++n) {
            c = string.charAt(n);
            if (Character.isLetterOrDigit(c)) continue;
            hashSet.add(new Character(c));
            c2 = c;
        }
        for (n = 0; n < string2.length(); ++n) {
            c = string2.charAt(n);
            if (Character.isLetterOrDigit(c)) continue;
            hashSet.add(new Character(c));
            c3 = c;
        }
        if (hashSet.size() != 1 || c2 != c3) {
            return comparator.compare(string, string2) <= 0;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "" + c2);
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "" + c3);
        int n2 = stringTokenizer.countTokens();
        int n3 = stringTokenizer2.countTokens();
        for (int i = 0; i < Math.min(n2, n3); ++i) {
            String string3;
            String string4 = stringTokenizer.nextToken();
            int n4 = comparator.compare(string4, string3 = stringTokenizer2.nextToken());
            if (n4 == 0) continue;
            return n4 < 0;
        }
        return n2 <= n3;
    }
}

