/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.net.upnp.impl.ssdp;

import com.aelitis.net.udp.mc.MCGroup;
import com.aelitis.net.udp.mc.MCGroupAdapter;
import com.aelitis.net.udp.mc.MCGroupFactory;
import com.aelitis.net.upnp.UPnPException;
import com.aelitis.net.upnp.UPnPSSDP;
import com.aelitis.net.upnp.UPnPSSDPAdapter;
import com.aelitis.net.upnp.UPnPSSDPListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.utils.UTTimer;
import org.gudy.azureus2.plugins.utils.UTTimerEvent;
import org.gudy.azureus2.plugins.utils.UTTimerEventPerformer;

public class SSDPCore
implements UPnPSSDP,
MCGroupAdapter {
    private static final String HTTP_VERSION = "1.1";
    private static final String NL = "\r\n";
    private static Map singletons = new HashMap();
    private static AEMonitor class_mon = new AEMonitor("SSDPCore:class");
    private MCGroup mc_group;
    private UPnPSSDPAdapter adapter;
    private String group_address_str;
    private int group_port;
    private boolean first_response = true;
    private List listeners = new ArrayList();
    private UTTimer timer;
    private List timer_queue = new ArrayList();
    private long time_event_next;
    protected AEMonitor this_mon = new AEMonitor("SSDP");
    private Set<String> ignore_mx = new HashSet<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSDPCore getSingleton(UPnPSSDPAdapter uPnPSSDPAdapter, String string, int n, int n2, String[] stringArray) throws UPnPException {
        try {
            class_mon.enter();
            String string2 = string + ":" + n + ":" + n2;
            SSDPCore sSDPCore = (SSDPCore)singletons.get(string2);
            if (sSDPCore == null) {
                sSDPCore = new SSDPCore(uPnPSSDPAdapter, string, n, n2, stringArray);
                singletons.put(string2, sSDPCore);
            }
            SSDPCore sSDPCore2 = sSDPCore;
            Object var9_8 = null;
            class_mon.exit();
            return sSDPCore2;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    private SSDPCore(UPnPSSDPAdapter uPnPSSDPAdapter, String string, int n, int n2, String[] stringArray) throws UPnPException {
        this.adapter = uPnPSSDPAdapter;
        this.group_address_str = string;
        this.group_port = n;
        try {
            this.mc_group = MCGroupFactory.getSingleton(this, string, this.group_port, n2, stringArray);
        }
        catch (Throwable throwable) {
            throw new UPnPException("Failed to initialise SSDP", throwable);
        }
    }

    public int getControlPort() {
        return this.mc_group.getControlPort();
    }

    public void trace(String string) {
        this.adapter.log(string);
    }

    public void log(Throwable throwable) {
        this.adapter.log(throwable);
    }

    public void notify(String string, String string2, String string3, String string4) {
        if (string4.startsWith("/")) {
            string4 = string4.substring(1);
        }
        String string5 = "NOTIFY * HTTP/1.1\r\nHOST: " + this.group_address_str + ":" + this.group_port + NL + "CACHE-CONTROL: max-age=3600" + NL + "LOCATION: http://%AZINTERFACE%:" + this.mc_group.getControlPort() + "/" + string4 + NL + "NT: " + string + NL + "NTS: " + string2 + NL + "SERVER: " + this.getServerName() + NL + "USN: " + (string3 == null ? "" : string3 + "::") + string + NL + NL;
        try {
            this.mc_group.sendToGroup(string5);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected String getServerName() {
        return System.getProperty("os.name") + "/" + System.getProperty("os.version") + " UPnP/1.0 " + "Azureus" + "/" + "4.3.0.4";
    }

    public void search(String[] stringArray) {
        for (String string : stringArray) {
            String string2 = "M-SEARCH * HTTP/1.1\r\nST: " + string + NL + "MX: 3" + NL + "MAN: \"ssdp:discover\"" + NL + "HOST: " + this.group_address_str + ":" + this.group_port + NL + NL;
            this.sendMC(string2);
        }
    }

    protected void sendMC(String string) {
        byte[] byArray = string.getBytes();
        try {
            this.mc_group.sendToGroup(byArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void interfaceChanged(NetworkInterface networkInterface2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((UPnPSSDPListener)this.listeners.get(i)).interfaceChanged(networkInterface2);
                continue;
            }
            catch (Throwable throwable) {
                this.adapter.log(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void received(NetworkInterface networkInterface2, InetAddress inetAddress, final InetSocketAddress inetSocketAddress, byte[] byArray, int n) {
        Object object;
        String string;
        Object object2;
        Object object3;
        int n2;
        String string2 = new String(byArray, 0, n);
        if (this.first_response) {
            this.first_response = false;
            this.adapter.trace("UPnP:SSDP: first response:\n" + string2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n3 = 0;
        do {
            if ((n2 = string2.indexOf(NL, n3)) == -1) {
                object3 = string2.substring(n3);
            } else {
                object3 = string2.substring(n3, n2);
                n3 = n2 + 1;
            }
            arrayList.add(((String)object3).trim());
        } while (n2 != -1);
        if (arrayList.size() == 0) {
            this.adapter.trace("SSDP::receive packet - 0 line reply");
            return;
        }
        String string3 = (String)arrayList.get(0);
        object3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        for (int i = 1; i < arrayList.size(); ++i) {
            object2 = (String)arrayList.get(i);
            int n4 = ((String)object2).indexOf(":");
            if (n4 == -1) continue;
            string = ((String)object2).substring(0, n4).trim().toUpperCase();
            object = ((String)object2).substring(n4 + 1).trim();
            if (string.equals("LOCATION")) {
                try {
                    if (((String)object).equals("*")) continue;
                    object3 = new URL((String)object);
                }
                catch (MalformedURLException malformedURLException) {
                    this.adapter.log(malformedURLException);
                }
                continue;
            }
            if (string.equals("NT")) {
                string5 = object;
                continue;
            }
            if (string.equals("USN")) {
                string4 = object;
                continue;
            }
            if (string.equals("NTS")) {
                string6 = object;
                continue;
            }
            if (string.equals("ST")) {
                string7 = object;
                continue;
            }
            if (string.equals("AL")) {
                string8 = object;
                continue;
            }
            if (string.equals("MX")) {
                string9 = object;
                continue;
            }
            if (!string.equals("SERVER")) continue;
            string10 = object;
        }
        if (string10 != null && string10.toLowerCase().startsWith("xbox")) {
            String string11 = inetSocketAddress.getAddress().getHostAddress();
            object2 = this.ignore_mx;
            synchronized (object2) {
                this.ignore_mx.add(string11);
            }
        }
        if (string9 != null) {
            String string12 = inetSocketAddress.getAddress().getHostAddress();
            object2 = this.ignore_mx;
            synchronized (object2) {
                if (this.ignore_mx.contains(string12)) {
                    string9 = null;
                }
            }
        }
        if (string3.startsWith("M-SEARCH")) {
            if (string7 != null) {
                String[] stringArray = this.informSearch(networkInterface2, inetAddress, inetSocketAddress.getAddress(), string7);
                if (stringArray != null) {
                    object2 = stringArray[0];
                    String string13 = stringArray[1];
                    if (string13.startsWith("/")) {
                        string13 = string13.substring(1);
                    }
                    string = "HTTP/1.1 200 OK\r\nUSN: " + (String)object2 + "::" + string7 + NL + "ST: " + string7 + NL + "EXT:" + NL + "Location: http://" + inetAddress.getHostAddress() + ":" + this.mc_group.getControlPort() + "/" + string13 + NL + "Server: Azureus/" + "4.3.0.4" + " UPnP/1.0 Azureus/" + "4.3.0.4" + NL + "Cache-Control: max-age=3600" + NL + "Date: " + TimeFormatter.getHTTPDate(SystemTime.getCurrentTime()) + NL + "Content-Length: 0" + NL + NL;
                    object = string.getBytes();
                    if (this.timer == null) {
                        this.timer = this.adapter.createTimer("SSDPCore:MX");
                    }
                    int n5 = 0;
                    if (string9 != null) {
                        try {
                            n5 = Integer.parseInt(string9) * 1000;
                            n5 = (int)(Math.random() * (double)n5);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    Runnable runnable = new Runnable((byte[])object){
                        final /* synthetic */ byte[] val$data_bytes;
                        {
                            this.val$data_bytes = byArray;
                        }

                        public void run() {
                            try {
                                SSDPCore.this.mc_group.sendToMember(inetSocketAddress, this.val$data_bytes);
                            }
                            catch (Throwable throwable) {
                                SSDPCore.this.adapter.log(throwable);
                            }
                        }
                    };
                    if (n5 == 0) {
                        runnable.run();
                    } else {
                        boolean bl;
                        long l = SystemTime.getCurrentTime() + (long)n5;
                        List list = this.timer_queue;
                        synchronized (list) {
                            this.timer_queue.add(runnable);
                            boolean bl2 = bl = this.time_event_next == 0L || l < this.time_event_next;
                            if (bl) {
                                this.time_event_next = l;
                            }
                        }
                        if (bl) {
                            this.timer.addEvent(l, new UTTimerEventPerformer(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void perform(UTTimerEvent uTTimerEvent) {
                                    while (true) {
                                        Runnable runnable;
                                        List list = SSDPCore.this.timer_queue;
                                        synchronized (list) {
                                            if (SSDPCore.this.timer_queue.size() <= 0) {
                                                SSDPCore.this.time_event_next = 0L;
                                                return;
                                            }
                                            runnable = (Runnable)SSDPCore.this.timer_queue.remove(0);
                                        }
                                        try {
                                            runnable.run();
                                            continue;
                                        }
                                        catch (Throwable throwable) {
                                            Debug.printStackTrace(throwable);
                                            continue;
                                        }
                                        break;
                                    }
                                }
                            });
                        }
                    }
                }
            } else {
                this.adapter.trace("SSDP::receive M-SEARCH - bad header:" + string3);
            }
        } else if (string3.startsWith("NOTIFY")) {
            if (string5 != null && string6 != null) {
                this.informNotify(networkInterface2, inetAddress, inetSocketAddress.getAddress(), string4, (URL)object3, string5, string6);
            } else {
                this.adapter.trace("SSDP::receive NOTIFY - bad header:" + string3);
            }
        } else if (string3.startsWith("HTTP") && string3.indexOf("200") != -1) {
            if (object3 != null && string7 != null) {
                this.informResult(networkInterface2, inetAddress, inetSocketAddress.getAddress(), string4, (URL)object3, string7, string8);
            } else {
                this.adapter.trace("SSDP::receive HTTP - bad header:" + string3);
            }
        } else {
            this.adapter.trace("SSDP::receive packet - bad header:" + string3);
        }
    }

    protected void informResult(NetworkInterface networkInterface2, InetAddress inetAddress, InetAddress inetAddress2, String string, URL uRL, String string2, String string3) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((UPnPSSDPListener)this.listeners.get(i)).receivedResult(networkInterface2, inetAddress, inetAddress2, string, uRL, string2, string3);
                continue;
            }
            catch (Throwable throwable) {
                this.adapter.log(throwable);
            }
        }
    }

    protected void informNotify(NetworkInterface networkInterface2, InetAddress inetAddress, InetAddress inetAddress2, String string, URL uRL, String string2, String string3) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((UPnPSSDPListener)this.listeners.get(i)).receivedNotify(networkInterface2, inetAddress, inetAddress2, string, uRL, string2, string3);
                continue;
            }
            catch (Throwable throwable) {
                this.adapter.log(throwable);
            }
        }
    }

    protected String[] informSearch(NetworkInterface networkInterface2, InetAddress inetAddress, InetAddress inetAddress2, String string) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                String[] stringArray = ((UPnPSSDPListener)this.listeners.get(i)).receivedSearch(networkInterface2, inetAddress, inetAddress2, string);
                if (stringArray == null) continue;
                return stringArray;
            }
            catch (Throwable throwable) {
                this.adapter.log(throwable);
            }
        }
        return null;
    }

    public void addListener(UPnPSSDPListener uPnPSSDPListener) {
        this.listeners.add(uPnPSSDPListener);
    }

    public void removeListener(UPnPSSDPListener uPnPSSDPListener) {
        this.listeners.remove(uPnPSSDPListener);
    }
}

