/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import edu.harvard.syrah.nc.Vec;
import edu.harvard.syrah.nc.VivaldiClient;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class Coordinate {
    protected static final int CLASS_HASH = Coordinate.class.hashCode();
    protected final double[] coords;
    protected final byte version;
    protected final int num_dims;
    public static double MIN_COORD = 0.1;

    public byte getVersion() {
        return this.version;
    }

    public Coordinate makeCopy() {
        return new Coordinate(this.coords, true);
    }

    public Coordinate(int n) {
        this.coords = new double[n];
        this.version = (byte)4;
        if (VivaldiClient.USE_HEIGHT) {
            --n;
        }
        this.num_dims = n;
    }

    public Coordinate(int n, DataInputStream dataInputStream) throws IOException {
        this.coords = new double[n];
        this.version = dataInputStream.readByte();
        for (int i = 0; i < n; ++i) {
            this.coords[i] = dataInputStream.readFloat();
        }
        if (VivaldiClient.USE_HEIGHT) {
            --n;
        }
        this.num_dims = n;
    }

    public void toSerialized(DataOutputStream dataOutputStream) throws IOException {
        int n = this.coords.length;
        dataOutputStream.writeByte(this.version);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeFloat((float)this.coords[i]);
        }
    }

    protected Coordinate(Coordinate coordinate) {
        this(coordinate.coords, true);
    }

    protected Coordinate(double[] dArray, boolean bl) {
        int n = dArray.length;
        if (bl) {
            this.coords = new double[n];
            System.arraycopy(dArray, 0, this.coords, 0, n);
        } else {
            this.coords = dArray;
        }
        this.version = (byte)4;
        if (VivaldiClient.USE_HEIGHT) {
            --n;
        }
        this.num_dims = n;
    }

    public Coordinate(float[] fArray) {
        int n = fArray.length;
        this.coords = new double[n];
        for (int i = 0; i < n; ++i) {
            this.coords[i] = fArray[i];
        }
        this.version = (byte)4;
        if (VivaldiClient.USE_HEIGHT) {
            --n;
        }
        this.num_dims = n;
    }

    public boolean isCompatible(Coordinate coordinate) {
        return coordinate != null && this.version == coordinate.version && this.num_dims == coordinate.num_dims;
    }

    public void bump() {
        for (int i = 0; i < this.coords.length; ++i) {
            if (!(Math.abs(this.coords[i]) < MIN_COORD)) continue;
            double d = VivaldiClient.random.nextDouble() + MIN_COORD;
            if ((!VivaldiClient.USE_HEIGHT || i < this.coords.length - 1) && VivaldiClient.random.nextBoolean()) {
                d *= -1.0;
            }
            int n = i;
            this.coords[n] = this.coords[n] + d;
        }
    }

    public int getNumDimensions() {
        return this.coords.length;
    }

    public double distanceToNonOriginCoord(Coordinate coordinate) {
        if (this.atOrigin() || coordinate.atOrigin()) {
            return Double.NaN;
        }
        return this.distanceTo(coordinate);
    }

    double uncheckedDistanceTo(Coordinate coordinate) {
        if (!this.isCompatible(coordinate)) {
            return Double.NaN;
        }
        assert (VivaldiClient.USE_HEIGHT && this.num_dims == this.coords.length - 1 || !VivaldiClient.USE_HEIGHT && this.num_dims == this.coords.length);
        if (coordinate == null) {
            return -1.0;
        }
        double d = 0.0;
        for (int i = 0; i < this.num_dims; ++i) {
            double d2 = this.coords[i] - coordinate.coords[i];
            d += d2 * d2;
        }
        d = Math.sqrt(d);
        if (VivaldiClient.USE_HEIGHT && d > 0.0) {
            d = d + this.coords[this.coords.length - 1] + coordinate.coords[this.coords.length - 1];
        }
        return d;
    }

    public double distanceTo(Coordinate coordinate) {
        if (coordinate == null || !this.isValid() || !coordinate.isValid()) {
            return Double.NaN;
        }
        return this.uncheckedDistanceTo(coordinate);
    }

    public void add(Vec vec) {
        int n = this.coords.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.coords[n2] = this.coords[n2] + vec.direction[i];
        }
    }

    public double[] getCoordinates() {
        if (this.num_dims < this.coords.length) {
            double[] dArray = new double[this.num_dims];
            System.arraycopy(this.coords, 0, dArray, 0, this.num_dims);
            return dArray;
        }
        return this.coords;
    }

    protected Vec getDirection(Coordinate coordinate) {
        double d = this.uncheckedDistanceTo(coordinate);
        if (d == 0.0) {
            return null;
        }
        Vec vec = new Vec(this.coords.length);
        for (int i = 0; i < this.num_dims; ++i) {
            vec.direction[i] = (coordinate.coords[i] - this.coords[i]) / d;
        }
        if (VivaldiClient.USE_HEIGHT) {
            vec.direction[this.coords.length - 1] = (coordinate.coords[this.coords.length - 1] + this.coords[this.coords.length - 1]) / d;
        }
        return vec;
    }

    protected boolean assign(Coordinate coordinate) {
        if (this.coords.length != coordinate.coords.length) {
            return false;
        }
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i] = coordinate.coords[i];
        }
        return true;
    }

    public void checkHeight() {
        if (!VivaldiClient.USE_HEIGHT) {
            return;
        }
        if (this.coords[this.coords.length - 1] <= MIN_COORD) {
            this.coords[this.coords.length - 1] = VivaldiClient.random.nextDouble() + MIN_COORD;
        }
    }

    public boolean atOrigin() {
        for (int i = 0; i < this.coords.length; ++i) {
            if (this.coords[i] == 0.0) continue;
            return false;
        }
        return true;
    }

    public Vec asVectorFromZero(boolean bl) {
        return new Vec(this.coords, bl);
    }

    public boolean isValid() {
        for (int i = 0; i < this.coords.length; ++i) {
            if (Double.isNaN(this.coords[i])) {
                return false;
            }
            if (!(this.coords[i] > 60000.0) && !(this.coords[i] < -60000.0)) continue;
            return false;
        }
        return !VivaldiClient.USE_HEIGHT || !(this.coords[this.coords.length - 1] < 0.0);
    }

    protected void reset() {
        for (int i = 0; i < this.coords.length; ++i) {
            this.coords[i] = 0.0;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Coordinate) {
            Coordinate coordinate = (Coordinate)object;
            int n = this.coords.length;
            for (int i = 0; i < n; ++i) {
                if (this.coords[i] == coordinate.coords[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = this.coords.length;
        int n2 = CLASS_HASH;
        for (int i = 0; i < n; ++i) {
            n2 ^= new Double(this.coords[i]).hashCode();
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("[");
        int n = this.coords.length;
        int n2 = 0;
        while (true) {
            if (n2 == n - 1 && VivaldiClient.USE_HEIGHT) {
                stringBuffer.append('h');
            }
            stringBuffer.append(VivaldiClient.nf.format(this.coords[n2]));
            if (++n2 >= n) break;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toStringAsVector() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        for (int i = 0; i < this.coords.length; ++i) {
            if (i == this.coords.length - 1 && VivaldiClient.USE_HEIGHT) {
                stringBuffer.append('h');
            }
            stringBuffer.append(VivaldiClient.nf.format(this.coords[i]));
            if (i == this.coords.length - 1) continue;
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

