/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import com.aelitis.azureus.vivaldi.ver2.IDWrapper;
import edu.harvard.syrah.nc.Coordinate;
import edu.harvard.syrah.nc.WindowStatistic;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteState<T> {
    protected static double SAMPLE_PERCENTILE = 0.5;
    public static int MAX_SAMPLE_SIZE = 16;
    public static int MIN_SAMPLE_SIZE = 4;
    protected final T addr;
    protected final WindowStatistic ping_samples;
    protected Coordinate last_coords;
    protected double last_error;
    protected long last_update_time;

    public RemoteState(T t) {
        this.addr = t;
        this.ping_samples = new WindowStatistic(MAX_SAMPLE_SIZE);
        this.last_coords = null;
        this.last_error = 0.0;
        this.last_update_time = -1L;
    }

    public void toSerialized(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(((IDWrapper)this.addr).getRawId());
        this.last_coords.toSerialized(dataOutputStream);
        dataOutputStream.writeFloat((float)this.last_error);
        dataOutputStream.writeFloat((float)this.getSample());
    }

    public RemoteState(int n, int n2, long l, DataInputStream dataInputStream) throws IOException {
        byte[] byArray = new byte[n2];
        dataInputStream.read(byArray);
        this.addr = new IDWrapper(byArray);
        this.last_coords = new Coordinate(n, dataInputStream);
        this.last_error = dataInputStream.readFloat();
        double d = dataInputStream.readFloat();
        this.ping_samples = new WindowStatistic(MAX_SAMPLE_SIZE);
        this.last_update_time = l;
        if (!this.last_coords.isValid() || Double.isNaN(this.last_error) || this.last_error <= 0.0 || this.last_error > 1.0 || Double.isNaN(d) || d <= 0.0 || d >= 20000.0) {
            this.ping_samples.clear();
            this.last_error = 1.0;
            this.last_coords = new Coordinate(n);
            return;
        }
        for (int i = 0; i < MIN_SAMPLE_SIZE; ++i) {
            this.ping_samples.add(d);
        }
    }

    public T getAddress() {
        return this.addr;
    }

    public void assign(Coordinate coordinate, double d, long l) {
        this.last_coords = coordinate;
        this.last_error = d;
        this.last_update_time = l;
    }

    public void addSample(double d, long l, Coordinate coordinate, double d2, long l2) {
        this.ping_samples.add(d);
        this.last_coords = coordinate;
        this.last_error = d2;
        this.last_update_time = l > 0L ? l2 - l : l2;
    }

    public boolean isValid(long l) {
        if (this.getLastError() <= 0.0 || this.last_update_time <= 0L || this.last_coords.atOrigin()) {
            return false;
        }
        if (this.getSampleSize() >= MIN_SAMPLE_SIZE && this.getSample() > 0.0) {
            return true;
        }
        return this.getSampleSize() >= 2 && this.ping_samples.withinVariance(0.1);
    }

    public double getSample() {
        return this.ping_samples.getPercentile(SAMPLE_PERCENTILE);
    }

    public int getSampleSize() {
        return this.ping_samples.getSize();
    }

    public Coordinate getLastCoordinate() {
        return this.last_coords;
    }

    public double getLastError() {
        return this.last_error;
    }

    public long getLastUpdateTime() {
        return this.last_update_time;
    }

    public static void main(String[] stringArray) {
        System.out.println("Testing Remote State Object");
        String string = stringArray[0];
        RemoteState<String> remoteState = new RemoteState<String>(string);
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(new File(string)));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Cannot open file " + string + ": " + fileNotFoundException);
            System.exit(-1);
        }
        long l = 0L;
        Coordinate coordinate = null;
        double d = 0.0;
        try {
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                long l2 = Long.parseLong((String)stringTokenizer.nextElement());
                int n = Integer.parseInt((String)stringTokenizer.nextElement());
                string2 = bufferedReader.readLine();
                remoteState.addSample(n, l, coordinate, d, l2);
                double d2 = remoteState.getSample();
                System.out.println(l2 + " raw " + n + " smooth " + d2);
            }
        }
        catch (Exception exception) {
            System.err.println("Problem parsing " + string + ": " + exception);
            System.exit(-1);
        }
    }
}

