/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import edu.harvard.syrah.nc.Coordinate;
import edu.harvard.syrah.nc.VivaldiClient;

public class Vec {
    protected static final int CLASS_HASH = Vec.class.hashCode();
    protected final double[] direction;
    protected final int num_dims;

    public static Vec scale(Vec vec, double d) {
        Vec vec2 = new Vec(vec);
        vec2.scale(d);
        return vec2;
    }

    public static Vec makeRandom(int n, double d) {
        Vec vec = new Vec(n);
        for (int i = 0; i < n; ++i) {
            double d2 = VivaldiClient.random.nextDouble() * d;
            if ((!VivaldiClient.USE_HEIGHT || i < n - 1) && VivaldiClient.random.nextBoolean()) {
                d2 *= -1.0;
            }
            vec.direction[i] = d2;
        }
        return vec;
    }

    public Vec(int n) {
        this.direction = new double[n];
        if (VivaldiClient.USE_HEIGHT) {
            --n;
        }
        this.num_dims = n;
    }

    public Vec(Vec vec) {
        this(vec.direction, true);
    }

    public Vec(double[] dArray, boolean bl) {
        int n;
        if (bl) {
            n = dArray.length;
            this.direction = new double[n];
            System.arraycopy(dArray, 0, this.direction, 0, n);
        } else {
            this.direction = dArray;
        }
        n = dArray.length;
        if (VivaldiClient.USE_HEIGHT) {
            --n;
        }
        this.num_dims = n;
    }

    public int getNumDimensions() {
        return this.direction.length;
    }

    public double[] getComponents() {
        double[] dArray = new double[this.direction.length];
        System.arraycopy(this.direction, 0, dArray, 0, this.direction.length);
        return dArray;
    }

    public void add(Vec vec) {
        for (int i = 0; i < this.direction.length; ++i) {
            int n = i;
            this.direction[n] = this.direction[n] + vec.direction[i];
        }
    }

    public void subtract(Vec vec) {
        for (int i = 0; i < this.direction.length; ++i) {
            int n = i;
            this.direction[n] = this.direction[n] - vec.direction[i];
        }
    }

    public void scale(double d) {
        int n = 0;
        while (n < this.direction.length) {
            int n2 = n++;
            this.direction[n2] = this.direction[n2] * d;
        }
    }

    public boolean isUnit() {
        return this.getLength() == 1.0;
    }

    public double getLength() {
        double d = this.getPlanarLength();
        if (VivaldiClient.USE_HEIGHT) {
            d += this.direction[this.direction.length - 1];
        }
        return d;
    }

    double getPlanarLength() {
        double d = 0.0;
        for (int i = 0; i < this.num_dims; ++i) {
            d += this.direction[i] * this.direction[i];
        }
        return Math.sqrt(d);
    }

    public void makeUnit() {
        double d = this.getLength();
        if (d != 1.0) {
            this.scale(1.0 / d);
        }
    }

    public Coordinate asCoordinateFromZero(boolean bl) {
        return new Coordinate(this.direction, bl);
    }

    public boolean equals(Object object) {
        if (object instanceof Vec) {
            Vec vec = (Vec)object;
            int n = this.direction.length;
            for (int i = 0; i < n; ++i) {
                if (this.direction[i] == vec.direction[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = this.direction.length;
        int n2 = CLASS_HASH;
        for (int i = 0; i < n; ++i) {
            n2 ^= new Double(this.direction[i]).hashCode();
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1024);
        stringBuffer.append("[");
        int n = this.direction.length;
        int n2 = 0;
        while (true) {
            if (n2 == n - 1 && VivaldiClient.USE_HEIGHT) {
                stringBuffer.append('h');
            }
            stringBuffer.append(VivaldiClient.nf.format(this.direction[n2]));
            if (++n2 >= n) break;
            stringBuffer.append(",");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

