/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import com.aelitis.azureus.vivaldi.ver2.IDWrapper;
import edu.harvard.syrah.nc.ApplicationObserver;
import edu.harvard.syrah.nc.Coordinate;
import edu.harvard.syrah.nc.EWMAStatistic;
import edu.harvard.syrah.nc.ObserverList;
import edu.harvard.syrah.nc.RemoteState;
import edu.harvard.syrah.nc.Vec;
import edu.harvard.syrah.nc.WindowStatistic;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class VivaldiClient<T> {
    protected static Logger slog = Logger.getLogger(VivaldiClient.class.getName());
    public static final boolean SIMULATION = false;
    public static boolean debug = false;
    public static boolean debugCrawler = false;
    public static boolean debugGood = false;
    public static final byte VERSION_02 = 2;
    public static final byte VERSION_03 = 3;
    public static final byte VERSION_04 = 4;
    public static final byte CURRENT_VERSION = 4;
    public static double COORD_ERROR = 0.1;
    public static double COORD_CONTROL = 0.25;
    public static boolean USE_HEIGHT = true;
    public static final int MAX_NEIGHBORS = 512;
    protected static final int WINDOW_SIZE = 64;
    public static long RS_EXPIRATION = 86400000L;
    public static final long MAINTENANCE_PERIOD = 600000L;
    public static final int MAX_RS_MAP_SIZE = 2048;
    public static final int MIN_SYS_UPDATE_PERIOD = 30000;
    private long lastMaintenanceStamp = 0L;
    public static Random random = new Random();
    public static final double APP_UPDATE_THRESHOLD = 0.1;
    public static final double OUTRAGEOUSLY_LARGE_RTT = 20000.0;
    public static double GRAVITY_DIAMETER = 512.0;
    public static final double MAX_DIST_FROM_ORIGIN = 60000.0;
    public static final double NEG_MAX_DIST_FROM_ORIGIN = -60000.0;
    protected static final NumberFormat nf = NumberFormat.getInstance();
    protected static final int NFDigits = 3;
    static boolean haveSetFormat = false;
    protected final int num_dims;
    protected Coordinate app_coord;
    protected Coordinate sys_coord;
    protected double error;
    public static final double MAX_ERROR = 1.0;
    public static boolean keepStatistics = false;
    public static final int RUNNING_STAT_HISTORY = 1024;
    protected WindowStatistic running_sys_error;
    protected WindowStatistic running_app_error;
    protected EWMAStatistic running_sys_dd;
    protected EWMAStatistic running_app_dd;
    protected EWMAStatistic running_neighbors_used;
    protected EWMAStatistic running_neighbor_error;
    protected EWMAStatistic running_relative_diff;
    protected EWMAStatistic running_sys_update_frequency;
    protected EWMAStatistic running_app_update_frequency;
    protected EWMAStatistic running_age;
    protected EWMAStatistic running_gravity;
    protected EWMAStatistic running_remote_error;
    protected EWMAStatistic running_neighbor_latency;
    protected long time_of_last_app_update = -1L;
    protected long update_counter = 0L;
    protected long bump_error_counter = 0L;
    protected boolean bump_error_flag = false;
    protected final List<RemoteState<T>> neighbors;
    protected long time_of_last_sys_update = -1L;
    protected final ObserverList obs_list;
    protected final HashMap<T, RemoteState<T>> rs_map;
    protected final Set<T> hosts;
    protected Coordinate start_centroid;
    protected boolean updated_app_coord_at_least_once = false;
    protected final List<Coordinate> start_coords;
    protected final List<Coordinate> current_coords;
    protected Coordinate nearest_neighbor;
    protected T local_addr;
    private AEMonitor2 lock = new AEMonitor2("VivaldiClient");
    private Map<T, Integer> addr2id = new HashMap<T, Integer>();
    private int idCounter = 0;

    public VivaldiClient(int n) {
        this.num_dims = n;
        this.app_coord = new Coordinate(this.num_dims);
        this.sys_coord = new Coordinate(this.num_dims);
        this.error = 1.0;
        this.neighbors = new ArrayList<RemoteState<T>>();
        this.obs_list = new ObserverList();
        this.rs_map = new HashMap();
        this.hosts = Collections.unmodifiableSet(this.rs_map.keySet());
        this.start_coords = new LinkedList<Coordinate>();
        this.current_coords = new LinkedList<Coordinate>();
        this.nearest_neighbor = null;
        this.running_neighbors_used = new EWMAStatistic();
        this.running_neighbor_error = new EWMAStatistic();
        this.running_remote_error = new EWMAStatistic();
        this.running_neighbor_latency = new EWMAStatistic();
        if (keepStatistics) {
            this.running_sys_update_frequency = new EWMAStatistic();
            this.running_app_update_frequency = new EWMAStatistic();
            this.running_sys_error = new WindowStatistic(1024);
            this.running_app_error = new WindowStatistic(1024);
            this.running_sys_dd = new EWMAStatistic();
            this.running_app_dd = new EWMAStatistic();
            this.running_relative_diff = new EWMAStatistic();
            this.running_age = new EWMAStatistic();
            this.running_gravity = new EWMAStatistic();
        }
        if (!haveSetFormat) {
            if (nf.getMaximumFractionDigits() > 3) {
                nf.setMaximumFractionDigits(3);
            }
            if (nf.getMinimumFractionDigits() > 3) {
                nf.setMinimumFractionDigits(3);
            }
            nf.setGroupingUsed(false);
            haveSetFormat = true;
        }
    }

    public void setLocalID(T t) {
        this.local_addr = t;
    }

    protected ApplicationStatistics computeApplicationStatistics() {
        ApplicationStatistics applicationStatistics = new ApplicationStatistics();
        if (this.sys_coord.atOrigin() || this.neighbors == null || this.neighbors.size() == 0) {
            return applicationStatistics;
        }
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (RemoteState<T> remoteState : this.neighbors) {
            double d5 = remoteState.getSample();
            double d6 = this.sys_coord.distanceTo(remoteState.getLastCoordinate());
            if (!(d5 > 0.0) || !(d6 > 0.0)) continue;
            for (RemoteState<T> remoteState2 : this.neighbors) {
                if (remoteState.addr.equals(remoteState2.addr)) continue;
                double d7 = remoteState2.getSample();
                double d8 = this.sys_coord.distanceTo(remoteState2.getLastCoordinate());
                if (!(d7 > 0.0) || !(d8 > 0.0)) continue;
                double d9 = Math.abs(d5 - d7);
                ++n2;
                d2 += d9;
                if (d5 > d7 && d6 < d8 || d7 > d5 && d8 < d6) {
                    ++n;
                    d += d9;
                }
                if (d5 > d7 && d6 < d8) {
                    d3 += d9;
                    d4 += d5;
                }
                if (!(d7 > d5) || !(d8 < d6)) continue;
                d3 += d9;
                d4 += d7;
            }
        }
        applicationStatistics.validLinkCount = n2;
        if (n2 > 0) {
            applicationStatistics.rrl = (double)n / (double)n2;
        }
        if (d2 > 0.0) {
            applicationStatistics.narl = d / d2;
        }
        if (d4 > 0.0) {
            applicationStatistics.ralp = d3 / d4;
        }
        return applicationStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long l;
        block3: {
            try {
                this.lock.enter();
                l = this.update_counter;
                this.update_counter = 0L;
                if (!keepStatistics) break block3;
                ApplicationStatistics applicationStatistics = this.computeApplicationStatistics();
                String string = new String("[sc=" + this.sys_coord + ",ac=" + this.app_coord + ",er=" + nf.format(this.error) + ",sys_re50=" + nf.format(this.running_sys_error.getPercentile(0.5)) + ",sys_re95=" + nf.format(this.running_sys_error.getPercentile(0.95)) + ",app_re50=" + nf.format(this.running_app_error.getPercentile(0.5)) + ",app_re95=" + nf.format(this.running_app_error.getPercentile(0.95)) + ",sys_dd=" + nf.format(this.running_sys_dd.get()) + ",app_dd=" + nf.format(this.running_app_dd.get()) + ",ns=" + nf.format(this.running_neighbors_used.get()) + ",rd=" + nf.format(this.running_relative_diff.get()) + ",sf=" + nf.format(this.running_sys_update_frequency.get()) + ",af=" + nf.format(this.running_app_update_frequency.get()) + ",rrl=" + nf.format(applicationStatistics.rrl) + ",narl=" + nf.format(applicationStatistics.narl) + ",ralp=" + nf.format(applicationStatistics.ralp) + ",age=" + this.getAge(System.currentTimeMillis()) + ",vl=" + nf.format(applicationStatistics.validLinkCount) + ",gr=" + nf.format(this.running_gravity.get()) + ",nn=" + nf.format(this.sys_coord.distanceTo(this.nearest_neighbor)) + ",uc=" + l + "]");
                Object var6_5 = null;
                this.lock.exit();
                return string;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.lock.exit();
                throw throwable;
            }
        }
        String string = new String("[sc=" + this.sys_coord + ",ac=" + this.app_coord + ",er=" + nf.format(this.error) + ",nn=" + nf.format(this.sys_coord.distanceTo(this.nearest_neighbor)) + ",uc=" + l + ",ns=" + nf.format(this.running_neighbors_used.get()) + ",ne=" + nf.format(this.running_neighbor_error.get()) + ",rEr=" + nf.format(this.running_remote_error.get()) + ",rLat=" + nf.format(this.running_neighbor_latency.get()) + "]");
        Object var6_6 = null;
        this.lock.exit();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<String, Double> getStatistics() {
        try {
            this.lock.enter();
            Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
            for (int i = 0; i < this.num_dims; ++i) {
                hashtable.put("sys_coord_" + i, this.sys_coord.coords[i]);
                hashtable.put("app_coord_" + i, this.sys_coord.coords[i]);
            }
            hashtable.put("er", this.error);
            hashtable.put("nn", this.sys_coord.distanceTo(this.nearest_neighbor));
            if (keepStatistics) {
                ApplicationStatistics applicationStatistics = this.computeApplicationStatistics();
                hashtable.put("rrl", applicationStatistics.rrl);
                hashtable.put("narl", applicationStatistics.narl);
                hashtable.put("ralp", applicationStatistics.ralp);
                hashtable.put("age", new Double(this.getAge(System.currentTimeMillis())));
                hashtable.put("vl", new Double(applicationStatistics.validLinkCount));
                hashtable.put("gr", this.running_gravity.get());
                hashtable.put("sys_re50", this.running_sys_error.getPercentile(0.5));
                hashtable.put("sys_re95", this.running_sys_error.getPercentile(0.95));
                hashtable.put("app_re50", this.running_app_error.getPercentile(0.5));
                hashtable.put("app_re95", this.running_app_error.getPercentile(0.95));
                hashtable.put("sys_dd", this.running_sys_dd.get());
                hashtable.put("app_dd", this.running_app_dd.get());
                hashtable.put("ne", this.running_neighbors_used.get());
                hashtable.put("rd", this.running_relative_diff.get());
                hashtable.put("sf", this.running_sys_update_frequency.get());
                hashtable.put("af", this.running_app_update_frequency.get());
            }
            Hashtable<String, Double> hashtable2 = hashtable;
            Object var4_5 = null;
            this.lock.exit();
            return hashtable2;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        try {
            this.lock.enter();
            this.sys_coord.reset();
            this.app_coord.reset();
            this.error = 1.0;
            this.rs_map.clear();
            this.start_coords.clear();
            this.current_coords.clear();
            this.nearest_neighbor = null;
            Object var2_1 = null;
            this.lock.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatedYet() {
        try {
            this.lock.enter();
            boolean bl = this.updated_app_coord_at_least_once;
            Object var3_2 = null;
            this.lock.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumDimensions() {
        try {
            this.lock.enter();
            int n = this.num_dims;
            Object var3_2 = null;
            this.lock.exit();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coordinate getApplicationCoords() {
        try {
            this.lock.enter();
            Coordinate coordinate = new Coordinate(this.app_coord);
            Object var3_2 = null;
            this.lock.exit();
            return coordinate;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Coordinate getSystemCoords() {
        try {
            this.lock.enter();
            Coordinate coordinate = new Coordinate(this.sys_coord);
            Object var3_2 = null;
            this.lock.exit();
            return coordinate;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getSystemError() {
        try {
            this.lock.enter();
            double d = this.error;
            Object var4_2 = null;
            this.lock.exit();
            return d;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAge(long l) {
        block3: {
            try {
                this.lock.enter();
                if (l >= this.time_of_last_sys_update) break block3;
                long l2 = 0L;
                Object var6_4 = null;
                this.lock.exit();
                return l2;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.lock.exit();
                throw throwable;
            }
        }
        long l3 = l - this.time_of_last_sys_update;
        Object var6_5 = null;
        this.lock.exit();
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObserverList getObserverList() {
        try {
            this.lock.enter();
            ObserverList observerList = this.obs_list;
            Object var3_2 = null;
            this.lock.exit();
            return observerList;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addHost(T t) {
        block3: {
            try {
                this.lock.enter();
                if (!this.rs_map.containsKey(t)) break block3;
                boolean bl = false;
                Object var5_4 = null;
                this.lock.exit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.lock.exit();
                throw throwable;
            }
        }
        RemoteState<T> remoteState = new RemoteState<T>(t);
        this.rs_map.put(t, remoteState);
        boolean bl = true;
        Object var5_5 = null;
        this.lock.exit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addHost(T t, Coordinate coordinate, double d, long l, boolean bl) {
        boolean bl2;
        try {
            this.lock.enter();
            RemoteState<T> remoteState = null;
            if (this.rs_map.containsKey(t)) {
                if (!bl) {
                    boolean bl3 = false;
                    Object var12_9 = null;
                    this.lock.exit();
                    return bl3;
                }
                remoteState = this.rs_map.get(t);
            } else {
                remoteState = new RemoteState<T>(t);
                this.rs_map.put(t, remoteState);
            }
            Coordinate coordinate2 = coordinate.makeCopy();
            remoteState.assign(coordinate2, d, l);
            bl2 = true;
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.lock.exit();
            throw throwable;
        }
        Object var12_10 = null;
        this.lock.exit();
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeHost(T t) {
        block3: {
            try {
                this.lock.enter();
                if (!this.rs_map.containsKey(t)) break block3;
                boolean bl = true;
                Object var4_4 = null;
                this.lock.exit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.lock.exit();
                throw throwable;
            }
        }
        boolean bl = false;
        Object var4_5 = null;
        this.lock.exit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsHost(T t) {
        try {
            this.lock.enter();
            boolean bl = this.rs_map.containsKey(t);
            Object var4_3 = null;
            this.lock.exit();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<T> getHosts() {
        try {
            this.lock.enter();
            Set<T> set = this.hosts;
            Object var3_2 = null;
            this.lock.exit();
            return set;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processSample(T t, Coordinate coordinate, double d, double d2, long l, long l2, boolean bl) {
        boolean bl2;
        block28: {
            boolean bl3;
            block27: {
                boolean bl4;
                block26: {
                    boolean bl5;
                    block25: {
                        try {
                            this.lock.enter();
                            int n = this.getIdFromAddr(t);
                            if (debugCrawler && debugGood) {
                                slog.info(n + " START");
                            }
                            assert (coordinate != this.sys_coord);
                            assert (coordinate != null);
                            assert (this.sys_coord != null);
                            if (!this.sys_coord.isCompatible(coordinate)) {
                                if (debugCrawler && debug) {
                                    slog.info("INVALID " + n + " s " + d2 + " NOT_COMPAT " + coordinate.getVersion());
                                }
                                boolean bl6 = false;
                                Object var22_13 = null;
                                this.lock.exit();
                                return bl6;
                            }
                            if (!this.sys_coord.isValid() || Double.isNaN(this.error)) {
                                if (debugCrawler) {
                                    slog.info(n + " RESET, USE_HEIGHT=" + USE_HEIGHT);
                                }
                                this.reset();
                            }
                            if (d <= 0.0 || d > 1.0 || Double.isNaN(d) || !coordinate.isValid()) {
                                if (debugCrawler) {
                                    slog.info(n + " BUSTED his coord is busted: r_error " + d + " r_coord " + coordinate);
                                }
                                bl5 = false;
                                break block25;
                            }
                            if (d2 > 20000.0) {
                                if (debug) {
                                    System.err.println("Warning: skipping huge RTT of " + nf.format(d2) + " from " + t);
                                }
                                if (debugCrawler) {
                                    slog.info(n + " HUGE " + d2);
                                }
                                bl4 = false;
                                break block26;
                            }
                            RemoteState<T> remoteState = this.rs_map.get(t);
                            if (remoteState == null) {
                                if (!bl) {
                                    if (debugCrawler) {
                                        slog.info(n + " NO_ADD");
                                    }
                                    bl3 = false;
                                    break block27;
                                }
                                this.addHost(t);
                                remoteState = this.rs_map.get(t);
                            }
                            Coordinate coordinate2 = coordinate.makeCopy();
                            remoteState.addSample(d2, l, coordinate2, d, l2);
                            if (this.sys_coord.atOrigin()) {
                                this.sys_coord.bump();
                            }
                            boolean bl7 = false;
                            int n2 = remoteState.getSampleSize();
                            double d3 = remoteState.getSample();
                            if (remoteState.isValid(l2)) {
                                this.addNeighbor(remoteState);
                                this.updateError(t, coordinate2, d, d3, d2, l, n2, l2);
                                long l3 = l2 - this.time_of_last_sys_update;
                                if (l3 > 30000L) {
                                    if (debugCrawler) {
                                        slog.info("time_since_last_sys_update=" + l3);
                                    }
                                    this.updateSystemCoordinate(l2);
                                    this.tryUpdateAppCoordinate(l2);
                                }
                                bl7 = true;
                                ++this.update_counter;
                            } else if (debugCrawler) {
                                String string = remoteState.getSampleSize() < RemoteState.MIN_SAMPLE_SIZE ? "TOO_FEW" : (remoteState.getSample() <= 0.0 ? "sample is " + remoteState.getSample() : (remoteState.getLastError() <= 0.0 ? "error is " + remoteState.getLastError() : (remoteState.getLastUpdateTime() <= 0L ? "last update " + remoteState.getLastUpdateTime() : (remoteState.getLastCoordinate().atOrigin() ? "AT_ORIGIN" : "UNKNOWN"))));
                                slog.info("INVALID " + n + " s " + d2 + " ss " + d3 + " c " + n2 + " " + string);
                            }
                            if (this.lastMaintenanceStamp < l2 - 600000L) {
                                this.performMaintenance(l2);
                                this.lastMaintenanceStamp = l2;
                            }
                            bl2 = bl7;
                            break block28;
                        }
                        catch (Throwable throwable) {
                            Object var22_18 = null;
                            this.lock.exit();
                            throw throwable;
                        }
                    }
                    Object var22_14 = null;
                    this.lock.exit();
                    return bl5;
                }
                Object var22_15 = null;
                this.lock.exit();
                return bl4;
            }
            Object var22_16 = null;
            this.lock.exit();
            return bl3;
        }
        Object var22_17 = null;
        this.lock.exit();
        return bl2;
    }

    private int getIdFromAddr(T t) {
        if (debugCrawler) {
            if (t instanceof Integer) {
                return (Integer)t;
            }
            if (!this.addr2id.containsKey(t)) {
                this.addr2id.put(t, this.idCounter);
                ++this.idCounter;
            }
            return this.addr2id.get(t);
        }
        return 0;
    }

    protected void updateError(T t, Coordinate coordinate, double d, double d2, double d3, long l, int n, long l2) {
        double d4 = this.sys_coord.distanceTo(coordinate);
        double d5 = 0.0;
        if (this.app_coord != null) {
            d5 = this.app_coord.distanceTo(coordinate);
        }
        if (d5 == 0.0 || d4 == 0.0) {
            if (debugCrawler) {
                slog.info("bad distance sys " + d4 + " app " + d5);
            }
            return;
        }
        assert (d2 > 0.0);
        double d6 = Math.abs(d4 - d2) / d2;
        double d7 = Math.abs(d5 - d2) / d2;
        this.running_remote_error.add(d);
        this.running_neighbor_latency.add(d2);
        if (debugCrawler) {
            int n2 = this.getIdFromAddr(t);
            String string = "UPDATE " + n2 + " re " + nf.format(d6) + " rtt " + nf.format(d2) + " raw " + nf.format(d3) + " age " + l + " dist " + nf.format(d4) + " ssize " + n + " lE " + nf.format(this.error) + " rE " + nf.format(d) + " rV " + coordinate.getVersion() + " lc " + this.sys_coord + " rc " + coordinate;
            slog.info(string);
        }
        if (d6 < 0.0) {
            d6 = 0.0;
        }
        if (d6 > 1.0) {
            d6 = 1.0;
        }
        double d8 = this.error / (this.error + d) * COORD_ERROR;
        this.error = d6 * d8 + (1.0 - d8) * this.error;
        if (keepStatistics) {
            this.running_sys_error.add(d6);
            this.running_app_error.add(d7);
        }
    }

    protected boolean addNeighbor(RemoteState<T> remoteState) {
        boolean bl = false;
        if (!this.neighbors.contains(remoteState)) {
            this.neighbors.add(remoteState);
            bl = true;
        }
        if (this.neighbors.size() > 512) {
            this.neighbors.remove(0);
        }
        return bl;
    }

    protected boolean removeNeighbor(RemoteState<T> remoteState) {
        if (this.neighbors.contains(remoteState)) {
            this.neighbors.remove(remoteState);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getNeighborToPing(long l) {
        Object object;
        block5: {
            RemoteState<T> remoteState2;
            try {
                this.lock.enter();
                double d = this.running_remote_error.get();
                double d2 = this.running_neighbor_latency.get();
                long l2 = l - 600000L;
                ArrayList<RemoteState<T>> arrayList = new ArrayList<RemoteState<T>>();
                for (RemoteState<T> remoteState2 : this.neighbors) {
                    if (remoteState2.getLastUpdateTime() <= l2 || !(remoteState2.getSample() > d2) || !(remoteState2.getLastError() < d)) continue;
                    arrayList.add(remoteState2);
                }
                if (arrayList.size() <= 0) break block5;
                object = (RemoteState)arrayList.get(random.nextInt(arrayList.size()));
                if (debugCrawler && debugGood) {
                    slog.info("pinging neighbor: error=" + ((RemoteState)object).getLastError() + " rtt=" + ((RemoteState)object).getSample() + " coord=" + ((RemoteState)object).getLastCoordinate() + " addr=" + ((RemoteState)object).getAddress());
                }
                remoteState2 = ((RemoteState)object).getAddress();
                Object var15_8 = null;
                this.lock.exit();
            }
            catch (Throwable throwable) {
                Object var15_10 = null;
                this.lock.exit();
                throw throwable;
            }
            return (T)remoteState2;
        }
        object = null;
        Object var15_9 = null;
        this.lock.exit();
        return (T)object;
    }

    protected void updateSystemCoordinate(long l) {
        Vec vec;
        long l2 = l;
        double d = Double.MAX_VALUE;
        Collections.shuffle(this.neighbors);
        if (debugCrawler) {
            slog.info(l + " updateSysCoord, nSize=" + this.neighbors.size() + " bump_error_counter=" + this.bump_error_counter);
        }
        for (RemoteState<T> remoteState : this.neighbors) {
            double d2 = this.sys_coord.uncheckedDistanceTo(remoteState.getLastCoordinate());
            if (d2 < d && d2 > 0.0) {
                d = d2;
                this.nearest_neighbor = remoteState.getLastCoordinate();
            }
            if (l2 <= remoteState.getLastUpdateTime()) continue;
            l2 = remoteState.getLastUpdateTime();
        }
        double d3 = 0.0;
        for (RemoteState<T> object2 : this.neighbors) {
            d3 += (double)(object2.getLastUpdateTime() - l2);
        }
        assert (d3 >= 0.0);
        Vec vec2 = new Vec(this.sys_coord.getNumDimensions());
        for (RemoteState<T> remoteState : this.neighbors) {
            double d2 = this.sys_coord.uncheckedDistanceTo(remoteState.getLastCoordinate());
            for (int i = 0; d2 == 0.0 && i < 3; ++i) {
                this.sys_coord.bump();
                d2 = this.sys_coord.distanceTo(remoteState.getLastCoordinate());
            }
            if (d2 == 0.0) {
                ++this.bump_error_counter;
                this.bump_error_flag = true;
                continue;
            }
            Vec vec3 = this.sys_coord.getDirection(remoteState.getLastCoordinate());
            double d4 = remoteState.getSample();
            double d5 = this.error / (remoteState.getLastError() + this.error);
            if (d5 == 0.0) continue;
            double d6 = d2 - d4;
            double d7 = Math.abs(d6) / d4;
            this.running_neighbor_error.add(d7);
            double d8 = 1.0;
            if (d3 > 0.0) {
                d8 = (double)(remoteState.getLastUpdateTime() - l2) / d3;
            }
            if (debugCrawler && debugGood) {
                int n = this.getIdFromAddr(remoteState.getAddress());
                slog.info("f " + n + " age " + Math.round((double)(l - remoteState.getLastUpdateTime()) / 1000.0) + " er " + d6 + " sw " + d8 + " comb " + d6 * d8);
            }
            vec3.scale(d6 * d8);
            vec2.add(vec3);
        }
        if (USE_HEIGHT) {
            vec2.direction[vec2.direction.length - 1] = -1.0 * vec2.direction[vec2.direction.length - 1];
        }
        vec2.scale(COORD_CONTROL);
        if (debugCrawler && debugGood) {
            slog.info("t " + vec2.getLength() + " " + vec2);
        }
        if (GRAVITY_DIAMETER > 0.0 && (vec = this.sys_coord.asVectorFromZero(true)).getLength() > 0.0) {
            double d9 = Math.pow(vec.getLength() / GRAVITY_DIAMETER, 2.0);
            vec.makeUnit();
            vec.scale(d9);
            vec2.subtract(vec);
            if (keepStatistics) {
                this.running_gravity.add(d9);
            }
        }
        this.sys_coord.add(vec2);
        this.sys_coord.checkHeight();
        double d10 = vec2.getLength();
        if (keepStatistics) {
            this.running_sys_dd.add(d10);
            if (this.time_of_last_sys_update > 0L) {
                long l3 = l - this.time_of_last_sys_update;
                this.running_sys_update_frequency.add(l3);
            }
        }
        if (this.neighbors != null) {
            this.running_neighbors_used.add(this.neighbors.size());
        }
        this.time_of_last_sys_update = l;
    }

    protected void performMaintenance(long l) {
        if (debugCrawler && debugGood) {
            slog.info("performing maintenance");
        }
        if (this.rs_map.size() > 2048) {
            RS_EXPIRATION = (long)(0.9 * (double)RS_EXPIRATION);
            if (debugCrawler && debugGood) {
                slog.info("lowered RS_EXPIRATION to " + RS_EXPIRATION + " size " + this.rs_map.size());
            }
        }
        long l2 = l - RS_EXPIRATION;
        Set<Map.Entry<T, RemoteState<T>>> set = this.rs_map.entrySet();
        Iterator<Map.Entry<T, RemoteState<T>>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, RemoteState<T>> entry = iterator.next();
            if (entry.getValue().getLastUpdateTime() >= l2) continue;
            if (debugCrawler && debugGood) {
                slog.info("tossing " + entry.getValue().getAddress());
            }
            this.removeNeighbor(entry.getValue());
            iterator.remove();
        }
    }

    protected void tryUpdateAppCoordinate(long l) {
        Vec vec;
        if (this.start_coords.size() < 64) {
            vec = new Vec(this.num_dims);
            this.start_coords.add(this.sys_coord);
            for (Coordinate coordinate : this.start_coords) {
                vec.add(coordinate.asVectorFromZero(false));
            }
            vec.scale(0.015625);
            this.start_centroid = vec.asCoordinateFromZero(false);
        }
        this.current_coords.add(this.sys_coord);
        if (this.current_coords.size() > 64) {
            this.current_coords.remove(0);
        }
        vec = new Vec(this.num_dims);
        for (Coordinate coordinate : this.current_coords) {
            vec.add(coordinate.asVectorFromZero(false));
        }
        vec.scale(0.015625);
        Coordinate coordinate = vec.asCoordinateFromZero(false);
        double d = this.start_centroid.distanceTo(this.nearest_neighbor);
        double d2 = coordinate.distanceTo(this.nearest_neighbor);
        double d3 = Math.abs((d - d2) / d);
        if (keepStatistics) {
            this.running_relative_diff.add(d3);
        }
        if (d3 > 0.1) {
            this.updated_app_coord_at_least_once = true;
            this.start_coords.clear();
            this.current_coords.clear();
        }
        boolean bl = false;
        if (d3 > 0.1 || !this.updated_app_coord_at_least_once) {
            if (keepStatistics) {
                double d4 = this.app_coord.distanceTo(coordinate);
                this.running_app_dd.add(d4);
            }
            this.app_coord = coordinate;
            bl = true;
            if (keepStatistics && !this.updated_app_coord_at_least_once && (double)this.running_sys_error.getSize() > 128.0 && this.running_sys_error.getPercentile(0.5) < 0.2) {
                this.updated_app_coord_at_least_once = true;
            }
            Iterator<ApplicationObserver> iterator = this.obs_list.iterator();
            while (iterator.hasNext()) {
                ApplicationObserver applicationObserver = iterator.next();
                applicationObserver.coordinatesUpdated(this.app_coord);
            }
            if (keepStatistics) {
                if (this.time_of_last_app_update > 0L) {
                    long l2 = l - this.time_of_last_app_update;
                    this.running_app_update_frequency.add(l2);
                }
                this.time_of_last_app_update = l;
            }
        }
        if (debug && debugCrawler) {
            slog.info("app_coord update: done " + bl + " rolling " + this.updated_app_coord_at_least_once + " start " + this.start_coords.size() + " current " + this.current_coords.size() + " diff " + nf.format(d3));
        }
    }

    public static void setRandomSeed(long l) {
        random = new Random(l);
    }

    public void startUp(DataInputStream dataInputStream) throws IOException {
        if (debugCrawler) {
            slog.info("startUp");
        }
        boolean bl = false;
        if (dataInputStream.available() > 0) {
            int n = 1;
            if (dataInputStream.available() != 25) {
                n = dataInputStream.readInt();
                if (debugCrawler) {
                    slog.info("Read version= " + n);
                }
            }
            try {
                this.sys_coord = new Coordinate(this.num_dims, dataInputStream);
                this.app_coord.assign(this.sys_coord);
                this.error = dataInputStream.readFloat();
                this.error = 1.0;
                if (this.sys_coord.isValid() && !Double.isNaN(this.error)) {
                    bl = true;
                } else if (debugCrawler) {
                    slog.info("Invalid coordinate or error");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n >= 2) {
                int n2 = dataInputStream.readInt();
                int n3 = dataInputStream.readInt();
                long l = System.currentTimeMillis();
                for (int i = 0; i < n2; ++i) {
                    RemoteState remoteState = new RemoteState(this.num_dims, n3, l, dataInputStream);
                    this.neighbors.add(remoteState);
                    this.rs_map.put(remoteState.getAddress(), remoteState);
                }
            }
        }
        if (!bl) {
            if (debugCrawler) {
                slog.info("Error deserializing coordinate during startup.  Starting afresh.");
            }
            this.sys_coord = new Coordinate(this.num_dims);
            this.app_coord = new Coordinate(this.num_dims);
            this.error = 1.0;
        } else {
            this.updated_app_coord_at_least_once = true;
            if (debugCrawler) {
                slog.info("Deserialized coordinate OK during startup " + this.sys_coord + " er " + this.error + " rs_map " + this.rs_map.size());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown(DataOutputStream dataOutputStream) throws IOException {
        try {
            this.lock.enter();
            if (debugCrawler) {
                slog.info("shutDown");
            }
            dataOutputStream.writeInt(2);
            if (debugCrawler) {
                slog.info("Saving coordinates during shutdown " + this.sys_coord + " er=" + this.error + " bump_error_flag=" + this.bump_error_flag + " neighbors_size=" + this.neighbors.size());
            }
            this.sys_coord.toSerialized(dataOutputStream);
            dataOutputStream.writeFloat((float)this.error);
            int n = this.neighbors.size();
            if (this.bump_error_flag) {
                n = 0;
            }
            dataOutputStream.writeInt(n);
            if (n > 0) {
                int n2 = ((IDWrapper)this.neighbors.get(0).getAddress()).getRawId().length;
                dataOutputStream.writeInt(n2);
                for (RemoteState<T> remoteState : this.neighbors) {
                    remoteState.toSerialized(dataOutputStream);
                }
            } else {
                dataOutputStream.writeInt(0);
            }
            Object var7_6 = null;
            this.lock.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.exit();
            throw throwable;
        }
    }

    class ApplicationStatistics {
        double rrl = 0.0;
        double narl = 0.0;
        double ralp = 0.0;
        int validLinkCount = 0;
    }
}

