/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.syrah.nc;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class WindowStatistic {
    public static boolean debug = false;
    protected final int max_history;
    protected final List<Statistic> samples;
    protected boolean dirty = true;
    protected double previousPercentile = -1.0;
    protected double previousValue = -1.0;

    public WindowStatistic(int n) {
        assert (n >= 0);
        this.max_history = n;
        this.samples = new LinkedList<Statistic>();
    }

    public synchronized void clear() {
        this.samples.clear();
        this.dirty = true;
    }

    public synchronized void add(double d) {
        this.samples.add(new Statistic(d));
        this.dirty = true;
        while (this.samples.size() > this.max_history) {
            this.samples.remove(0);
            if (!debug) continue;
            System.out.println("tossing sample " + this.samples.get(0) + ", size=" + this.samples.size());
        }
    }

    public synchronized int getSize() {
        return this.samples.size();
    }

    public synchronized boolean withinVariance(double d) {
        if (this.samples.size() < 2) {
            return true;
        }
        double d2 = this.getMean();
        for (int i = 0; i < this.samples.size(); ++i) {
            double d3 = Math.abs(this.samples.get((int)i).sample - d2) / d2;
            if (!(d3 > d)) continue;
            return false;
        }
        return true;
    }

    public synchronized double getPercentile(double d) {
        if (!this.dirty && d == this.previousPercentile) {
            return this.previousValue;
        }
        double d2 = this.calcPercentile(d);
        this.previousPercentile = d;
        this.previousValue = d2;
        this.dirty = false;
        return d2;
    }

    protected double calcPercentile(double d) {
        int n;
        if (this.samples.size() == 0) {
            return 0.0;
        }
        Object[] objectArray = new Double[this.samples.size()];
        for (n = 0; n < this.samples.size(); ++n) {
            objectArray[n] = this.samples.get((int)n).sample;
            if (!debug) continue;
            System.out.println(n + " " + objectArray[n]);
        }
        Arrays.sort(objectArray);
        n = (int)((double)objectArray.length * d);
        if (n < 0) {
            n = 0;
        }
        double d2 = (Double)objectArray[n];
        if (debug) {
            System.out.println("p= " + d + " per=" + n + " val=" + d2);
        }
        return d2;
    }

    protected double getSum() {
        double d = 0.0;
        if (this.samples.size() > 0) {
            for (int i = 0; i < this.samples.size(); ++i) {
                d += this.samples.get((int)i).sample;
            }
        }
        return d;
    }

    public double getMean() {
        return this.getSum() / (double)this.getSize();
    }

    class Statistic {
        public final double sample;

        public Statistic(double d) {
            this.sample = d;
        }

        public String toString() {
            return new String("v=" + this.sample);
        }
    }
}

