/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.category.impl;

import com.aelitis.azureus.core.networkmanager.LimitedRateGroup;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryListener;
import org.gudy.azureus2.core3.category.impl.CategoryManagerImpl;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

public class CategoryImpl
implements Category,
Comparable {
    private String sName;
    private int type;
    private List managers = new ArrayList();
    private int upload_speed;
    private int download_speed;
    private LimitedRateGroup upload_limiter = new LimitedRateGroup(){

        public String getName() {
            return "cat_up: " + CategoryImpl.this.sName;
        }

        public int getRateLimitBytesPerSecond() {
            return CategoryImpl.this.upload_speed;
        }
    };
    private LimitedRateGroup download_limiter = new LimitedRateGroup(){

        public String getName() {
            return "cat_down: " + CategoryImpl.this.sName;
        }

        public int getRateLimitBytesPerSecond() {
            return CategoryImpl.this.download_speed;
        }
    };
    private static final int LDT_CATEGORY_DMADDED = 1;
    private static final int LDT_CATEGORY_DMREMOVED = 2;
    private ListenerManager category_listeners = ListenerManager.createManager("CatListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object object, int n, Object object2) {
            CategoryListener categoryListener = (CategoryListener)object;
            if (n == 1) {
                categoryListener.downloadManagerAdded(CategoryImpl.this, (DownloadManager)object2);
            } else if (n == 2) {
                categoryListener.downloadManagerRemoved(CategoryImpl.this, (DownloadManager)object2);
            }
        }
    });

    public CategoryImpl(String string, int n, int n2) {
        this.sName = string;
        this.type = 0;
        this.upload_speed = n;
        this.download_speed = n2;
    }

    public CategoryImpl(String string, int n) {
        this.sName = string;
        this.type = n;
    }

    public void addCategoryListener(CategoryListener categoryListener) {
        this.category_listeners.addListener(categoryListener);
    }

    public void removeCategoryListener(CategoryListener categoryListener) {
        this.category_listeners.removeListener(categoryListener);
    }

    public String getName() {
        return this.sName;
    }

    public int getType() {
        return this.type;
    }

    public List getDownloadManagers(List list) {
        if (this.type == 0) {
            return this.managers;
        }
        if (this.type == 1) {
            return list;
        }
        ArrayList<DownloadManager> arrayList = new ArrayList<DownloadManager>();
        for (int i = 0; i < list.size(); ++i) {
            DownloadManager downloadManager = (DownloadManager)list.get(i);
            Category category = downloadManager.getDownloadState().getCategory();
            if (category != null && category.getType() != 2) continue;
            arrayList.add(downloadManager);
        }
        return arrayList;
    }

    public void addManager(DownloadManagerState downloadManagerState) {
        if (downloadManagerState.getCategory() != this) {
            downloadManagerState.setCategory(this);
            return;
        }
        DownloadManager downloadManager = downloadManagerState.getDownloadManager();
        if (downloadManager == null) {
            return;
        }
        if (!this.managers.contains(downloadManager)) {
            this.managers.add(downloadManager);
            downloadManager.addRateLimiter(this.upload_limiter, true);
            downloadManager.addRateLimiter(this.download_limiter, false);
            this.category_listeners.dispatch(1, downloadManager);
        }
    }

    public void removeManager(DownloadManagerState downloadManagerState) {
        if (downloadManagerState.getCategory() == this) {
            downloadManagerState.setCategory(null);
            return;
        }
        DownloadManager downloadManager = downloadManagerState.getDownloadManager();
        if (downloadManager == null) {
            return;
        }
        if (this.managers.contains(downloadManager) || this.type != 0) {
            this.managers.remove(downloadManager);
            downloadManager.removeRateLimiter(this.upload_limiter, true);
            downloadManager.removeRateLimiter(this.download_limiter, false);
            this.category_listeners.dispatch(2, downloadManager);
        }
    }

    public void setDownloadSpeed(int n) {
        if (this.download_speed != n) {
            this.download_speed = n;
            CategoryManagerImpl.getInstance().saveCategories();
        }
    }

    public int getDownloadSpeed() {
        return this.download_speed;
    }

    public void setUploadSpeed(int n) {
        if (this.upload_speed != n) {
            this.upload_speed = n;
            CategoryManagerImpl.getInstance().saveCategories();
        }
    }

    public int getUploadSpeed() {
        return this.upload_speed;
    }

    public int compareTo(Object object) {
        boolean bl;
        boolean bl2 = this.type == 0;
        boolean bl3 = bl = ((Category)object).getType() == 0;
        if (bl2 == bl) {
            return this.sName.compareToIgnoreCase(((Category)object).getName());
        }
        if (bl2) {
            return 1;
        }
        return -1;
    }
}

