/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.category.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManagerListener;
import org.gudy.azureus2.core3.category.impl.CategoryImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

public class CategoryManagerImpl {
    private static final String UNCAT_NAME = "__uncategorised__";
    private static CategoryManagerImpl catMan;
    private static Category catAll;
    private static Category catUncategorized;
    private static boolean doneLoading;
    private static AEMonitor class_mon;
    private Map categories = new HashMap();
    private AEMonitor categories_mon = new AEMonitor("Categories");
    private static final int LDT_CATEGORY_ADDED = 1;
    private static final int LDT_CATEGORY_REMOVED = 2;
    private ListenerManager category_listeners = ListenerManager.createManager("CatListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object object, int n, Object object2) {
            CategoryManagerListener categoryManagerListener = (CategoryManagerListener)object;
            if (n == 1) {
                categoryManagerListener.categoryAdded((Category)object2);
            } else if (n == 2) {
                categoryManagerListener.categoryRemoved((Category)object2);
            }
        }
    });

    protected CategoryManagerImpl() {
        this.loadCategories();
    }

    public void addCategoryManagerListener(CategoryManagerListener categoryManagerListener) {
        this.category_listeners.addListener(categoryManagerListener);
    }

    public void removeCategoryManagerListener(CategoryManagerListener categoryManagerListener) {
        this.category_listeners.removeListener(categoryManagerListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CategoryManagerImpl getInstance() {
        try {
            class_mon.enter();
            if (catMan == null) {
                catMan = new CategoryManagerImpl();
            }
            CategoryManagerImpl categoryManagerImpl = catMan;
            Object var2_1 = null;
            class_mon.exit();
            return categoryManagerImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void loadCategories() {
        block29: {
            if (doneLoading) {
                return;
            }
            doneLoading = true;
            FileInputStream fileInputStream = null;
            BufferedInputStream bufferedInputStream = null;
            this.makeSpecialCategories();
            File file = FileUtil.getUserFile("categories.config");
            fileInputStream = new FileInputStream(file);
            bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
            Map map = BDecoder.decode(bufferedInputStream);
            List list = (List)map.get("categories");
            for (int i = 0; i < list.size(); ++i) {
                Map map2 = (Map)list.get(i);
                try {
                    String string = new String((byte[])map2.get("name"), "UTF8");
                    Long l = (Long)map2.get("maxup");
                    Long l2 = (Long)map2.get("maxdown");
                    if (string.equals(UNCAT_NAME)) {
                        catUncategorized.setUploadSpeed(l == null ? 0 : l.intValue());
                        catUncategorized.setDownloadSpeed(l2 == null ? 0 : l2.intValue());
                        continue;
                    }
                    this.categories.put(string, new CategoryImpl(string, l == null ? 0 : l.intValue(), l2 == null ? 0 : l2.intValue()));
                    continue;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
            Object var12_14 = null;
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                break block29;
            }
            catch (Exception exception) {}
            break block29;
            {
                catch (FileNotFoundException fileNotFoundException) {
                    Object var12_15 = null;
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block29;
                    }
                    catch (Exception exception) {}
                    break block29;
                }
                catch (Exception exception) {
                    Debug.printStackTrace(exception);
                    Object var12_16 = null;
                    try {
                        if (bufferedInputStream != null) {
                            bufferedInputStream.close();
                        }
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    try {
                        if (fileInputStream != null) {
                            fileInputStream.close();
                        }
                        break block29;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var12_17 = null;
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void saveCategories() {
        try {
            block15: {
                Object object;
                block14: {
                    Object object22222;
                    this.categories_mon.enter();
                    HashMap hashMap = new HashMap();
                    ArrayList<Object> arrayList = new ArrayList<Object>(this.categories.size());
                    for (Object object22222 : this.categories.values()) {
                        if (object22222.getType() != 0) continue;
                        object = new HashMap<String, Object>();
                        object.put("name", object22222.getName());
                        object.put("maxup", new Long(object22222.getUploadSpeed()));
                        object.put("maxdown", new Long(object22222.getDownloadSpeed()));
                        arrayList.add(object);
                    }
                    object22222 = new HashMap();
                    object22222.put("name", UNCAT_NAME);
                    object22222.put("maxup", new Long(catUncategorized.getUploadSpeed()));
                    object22222.put("maxdown", new Long(catUncategorized.getDownloadSpeed()));
                    arrayList.add(object22222);
                    hashMap.put("categories", arrayList);
                    object = null;
                    byte[] byArray = BEncoder.encode(hashMap);
                    File file = FileUtil.getUserFile("categories.config");
                    File file2 = FileUtil.getUserFile("categories.config.new");
                    object = new FileOutputStream(file2);
                    ((FileOutputStream)object).write(byArray);
                    ((OutputStream)object).flush();
                    ((FileOutputStream)object).getFD().sync();
                    ((FileOutputStream)object).close();
                    object = null;
                    if (file.exists() && !file.delete()) break block14;
                    file2.renameTo(file);
                }
                Object var10_10 = null;
                try {
                    if (object != null) {
                        ((FileOutputStream)object).close();
                    }
                    break block15;
                }
                catch (Exception exception) {}
                break block15;
                {
                    catch (Exception exception) {
                        Debug.printStackTrace(exception);
                        Object var10_11 = null;
                        try {
                            if (object != null) {
                                ((FileOutputStream)object).close();
                            }
                            break block15;
                        }
                        catch (Exception exception2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    try {
                        if (object != null) {
                            ((FileOutputStream)object).close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
            Object var13_17 = null;
            this.categories_mon.exit();
        }
        catch (Throwable throwable) {
            Object var13_18 = null;
            this.categories_mon.exit();
            throw throwable;
        }
    }

    public Category createCategory(String string) {
        this.makeSpecialCategories();
        Category category = this.getCategory(string);
        if (category == null) {
            category = new CategoryImpl(string, 0, 0);
            this.categories.put(string, category);
            this.saveCategories();
            this.category_listeners.dispatch(1, category);
            return (Category)this.categories.get(string);
        }
        return category;
    }

    public void removeCategory(Category category) {
        if (this.categories.containsKey(category.getName())) {
            this.categories.remove(category.getName());
            this.saveCategories();
            this.category_listeners.dispatch(2, category);
        }
    }

    public Category[] getCategories() {
        if (this.categories.size() > 0) {
            return this.categories.values().toArray(new Category[this.categories.size()]);
        }
        return new Category[0];
    }

    public Category getCategory(String string) {
        return (Category)this.categories.get(string);
    }

    public Category getCategory(int n) {
        if (n == 1) {
            return catAll;
        }
        if (n == 2) {
            return catUncategorized;
        }
        return null;
    }

    private void makeSpecialCategories() {
        if (catAll == null) {
            catAll = new CategoryImpl("Categories.all", 1);
            this.categories.put("Categories.all", catAll);
        }
        if (catUncategorized == null) {
            catUncategorized = new CategoryImpl("Categories.uncategorized", 2);
            this.categories.put("Categories.uncategorized", catUncategorized);
        }
    }

    static {
        catAll = null;
        catUncategorized = null;
        doneLoading = false;
        class_mon = new AEMonitor("CategoryManager:class");
    }
}

