/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.protocol.AzURLStreamHandlerFactory;

public class COConfigurationManager {
    public static final int CONFIG_DEFAULT_MIN_MAX_UPLOAD_SPEED = 5;
    public static final int CONFIG_DEFAULT_MAX_DOWNLOAD_SPEED = 0;
    public static final int CONFIG_DEFAULT_MAX_CONNECTIONS_PER_TORRENT = 50;
    public static final int CONFIG_DEFAULT_MAX_CONNECTIONS_GLOBAL = 250;
    public static final int CONFIG_CACHE_SIZE_MAX_MB;
    public static final boolean ENABLE_MULTIPLE_UDP_PORTS = false;
    private static boolean pre_initialised;

    public static synchronized void preInitialise() {
        if (!pre_initialised) {
            pre_initialised = true;
            try {
                URL.setURLStreamHandlerFactory(new AzURLStreamHandlerFactory());
                System.setProperty("sun.net.inetaddr.ttl", "60");
                System.setProperty("networkaddress.cache.ttl", "60");
                System.setProperty("sun.net.client.defaultConnectTimeout", "120000");
                System.setProperty("sun.net.client.defaultReadTimeout", "60000");
                if (Constants.isOSX) {
                    System.setProperty("java.nio.preferSelect", "true");
                }
                SystemProperties.determineApplicationName();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static ConfigurationManager initialise() {
        COConfigurationManager.preInitialise();
        return ConfigurationManager.getInstance();
    }

    public static ConfigurationManager initialiseFromMap(Map map) {
        COConfigurationManager.preInitialise();
        return ConfigurationManager.getInstance(map);
    }

    public static final boolean isNewInstall() {
        return ConfigurationManager.getInstance().isNewInstall();
    }

    public static String getStringParameter(String string) {
        return ConfigurationManager.getInstance().getStringParameter(string);
    }

    public static String getStringParameter(String string, String string2) {
        return ConfigurationManager.getInstance().getStringParameter(string, string2);
    }

    public static boolean setParameter(String string, String string2) {
        return ConfigurationManager.getInstance().setParameter(string, string2);
    }

    public static boolean verifyParameter(String string, String string2) {
        return ConfigurationManager.getInstance().verifyParameter(string, string2);
    }

    public static boolean getBooleanParameter(String string) {
        return ConfigurationManager.getInstance().getBooleanParameter(string);
    }

    public static boolean getBooleanParameter(String string, boolean bl) {
        return ConfigurationManager.getInstance().getBooleanParameter(string, bl);
    }

    public static boolean setParameter(String string, boolean bl) {
        return ConfigurationManager.getInstance().setParameter(string, bl);
    }

    public static int getIntParameter(String string) {
        return ConfigurationManager.getInstance().getIntParameter(string);
    }

    public static int getIntParameter(String string, int n) {
        return ConfigurationManager.getInstance().getIntParameter(string, n);
    }

    public static boolean setParameter(String string, int n) {
        return ConfigurationManager.getInstance().setParameter(string, n);
    }

    public static boolean setParameter(String string, long l) {
        return ConfigurationManager.getInstance().setParameter(string, l);
    }

    public static long getLongParameter(String string) {
        return ConfigurationManager.getInstance().getLongParameter(string);
    }

    public static long getLongParameter(String string, long l) {
        return ConfigurationManager.getInstance().getLongParameter(string, l);
    }

    public static byte[] getByteParameter(String string) {
        return ConfigurationManager.getInstance().getByteParameter(string);
    }

    public static byte[] getByteParameter(String string, byte[] byArray) {
        return ConfigurationManager.getInstance().getByteParameter(string, byArray);
    }

    public static boolean setParameter(String string, byte[] byArray) {
        return ConfigurationManager.getInstance().setParameter(string, byArray);
    }

    public static String getDirectoryParameter(String string) throws IOException {
        return ConfigurationManager.getInstance().getDirectoryParameter(string);
    }

    public static boolean setRGBParameter(String string, int n, int n2, int n3) {
        return ConfigurationManager.getInstance().setRGBParameter(string, n, n2, n3);
    }

    public static boolean setRGBParameter(String string, int[] nArray, boolean bl) {
        return ConfigurationManager.getInstance().setRGBParameter(string, nArray, bl);
    }

    public static float getFloatParameter(String string) {
        return ConfigurationManager.getInstance().getFloatParameter(string);
    }

    public static float getFloatParameter(String string, float f) {
        return ConfigurationManager.getInstance().getFloatParameter(string, f);
    }

    public static boolean setParameter(String string, float f) {
        return ConfigurationManager.getInstance().setParameter(string, f);
    }

    public static boolean setParameter(String string, StringList stringList) {
        return ConfigurationManager.getInstance().setParameter(string, stringList);
    }

    public static StringList getStringListParameter(String string) {
        return ConfigurationManager.getInstance().getStringListParameter(string);
    }

    public static boolean setParameter(String string, List list) {
        return ConfigurationManager.getInstance().setParameter(string, list);
    }

    public static List getListParameter(String string, List list) {
        return ConfigurationManager.getInstance().getListParameter(string, list);
    }

    public static boolean setParameter(String string, Map map) {
        return ConfigurationManager.getInstance().setParameter(string, map);
    }

    public static Map getMapParameter(String string, Map map) {
        return ConfigurationManager.getInstance().getMapParameter(string, map);
    }

    public static boolean hasParameter(String string, boolean bl) {
        return ConfigurationManager.getInstance().hasParameter(string, bl);
    }

    public static void save() {
        ConfigurationManager.getInstance().save();
    }

    public static void setDirty() {
        ConfigurationManager.getInstance().setDirty();
    }

    public static void addListener(COConfigurationListener cOConfigurationListener) {
        ConfigurationManager.getInstance().addListener(cOConfigurationListener);
    }

    public static void addParameterListener(String string, ParameterListener parameterListener) {
        ConfigurationManager.getInstance().addParameterListener(string, parameterListener);
    }

    public static void addParameterListener(String[] stringArray, ParameterListener parameterListener) {
        ConfigurationManager configurationManager = ConfigurationManager.getInstance();
        for (int i = 0; i < stringArray.length; ++i) {
            configurationManager.addParameterListener(stringArray[i], parameterListener);
        }
    }

    public static void addAndFireParameterListener(String string, ParameterListener parameterListener) {
        ConfigurationManager.getInstance().addParameterListener(string, parameterListener);
        parameterListener.parameterChanged(string);
    }

    public static void addAndFireParameterListeners(String[] stringArray, ParameterListener parameterListener) {
        for (int i = 0; i < stringArray.length; ++i) {
            ConfigurationManager.getInstance().addParameterListener(stringArray[i], parameterListener);
        }
        parameterListener.parameterChanged(null);
    }

    public static void removeParameterListener(String string, ParameterListener parameterListener) {
        ConfigurationManager.getInstance().removeParameterListener(string, parameterListener);
    }

    public static void removeListener(COConfigurationListener cOConfigurationListener) {
        ConfigurationManager.getInstance().removeListener(cOConfigurationListener);
    }

    public static Set getAllowedParameters() {
        return ConfigurationDefaults.getInstance().getAllowedParameters();
    }

    public static Set getDefinedParameters() {
        return ConfigurationManager.getInstance().getDefinedParameters();
    }

    public static Object getParameter(String string) {
        return ConfigurationManager.getInstance().getParameter(string);
    }

    public static boolean doesParameterDefaultExist(String string) {
        return ConfigurationDefaults.getInstance().doesParameterDefaultExist(string);
    }

    public static boolean doesParameterNonDefaultExist(String string) {
        return ConfigurationManager.getInstance().doesParameterNonDefaultExist(string);
    }

    public static void registerExternalDefaults(Map map) {
        ConfigurationDefaults.getInstance().registerExternalDefaults(map);
    }

    public static void setBooleanDefault(String string, boolean bl) {
        ConfigurationDefaults.getInstance().addParameter(string, bl);
    }

    public static void setFloatDefault(String string, float f) {
        ConfigurationDefaults.getInstance().addParameter(string, f);
    }

    public static void setIntDefault(String string, int n) {
        ConfigurationDefaults.getInstance().addParameter(string, n);
    }

    public static void setLongDefault(String string, long l) {
        ConfigurationDefaults.getInstance().addParameter(string, l);
    }

    public static void setStringDefault(String string, String string2) {
        ConfigurationDefaults.getInstance().addParameter(string, string2);
    }

    public static void setByteDefault(String string, byte[] byArray) {
        ConfigurationDefaults.getInstance().addParameter(string, byArray);
    }

    public static Object getDefault(String string) {
        return ConfigurationDefaults.getInstance().getParameter(string);
    }

    public static boolean removeParameter(String string) {
        return ConfigurationManager.getInstance().removeParameter(string);
    }

    public static boolean removeRGBParameter(String string) {
        return ConfigurationManager.getInstance().removeRGBParameter(string);
    }

    static {
        long l;
        long l2;
        long l3 = Runtime.getRuntime().maxMemory();
        int n = (int)((l3 - (l2 = 32L * (l = 0x100000L))) / l);
        if (n > 1024) {
            n = 1024;
        }
        if (n < 1) {
            n = 1;
        }
        CONFIG_CACHE_SIZE_MAX_MB = n;
    }

    public static interface ParameterVerifier {
        public boolean verify(String var1, Object var2);
    }
}

