/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.config.impl;

import com.aelitis.azureus.core.proxy.socks.AESocksProxy;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyFactory;
import com.aelitis.azureus.core.util.FeatureAvailability;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemProperties;

public class ConfigurationChecker {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static boolean system_properties_set = false;
    private static boolean checked = false;
    private static boolean new_install = false;
    private static AEMonitor class_mon = new AEMonitor("ConfigChecker");
    private static boolean new_version = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void setSystemProperties() {
        try {
            class_mon.enter();
            if (system_properties_set) {
                Object var10 = null;
                class_mon.exit();
                return;
            }
            COConfigurationManager.preInitialise();
            String string = SystemProperties.getApplicationPath();
            String string2 = SystemProperties.getUserPath();
            ConfigurationChecker.loadProperties(string);
            if (!string.equals(string2)) {
                ConfigurationChecker.loadProperties(string2);
            }
            COConfigurationManager.addAndFireParameterListener("IPV6 Prefer Addresses", new ParameterListener(){
                private boolean done_something = false;

                public void parameterChanged(String string) {
                    boolean bl;
                    boolean bl2 = COConfigurationManager.getBooleanParameter(string);
                    boolean bl3 = bl = !System.getProperty("java.net.preferIPv6Addresses", "false").equalsIgnoreCase("false");
                    if (bl && !this.done_something) {
                        return;
                    }
                    if (bl != bl2) {
                        this.done_something = true;
                        System.setProperty("java.net.preferIPv6Addresses", bl2 ? "true" : "false");
                        try {
                            Field field = InetAddress.class.getDeclaredField("preferIPv6Address");
                            field.setAccessible(true);
                            field.setBoolean(null, bl2);
                        }
                        catch (Throwable throwable) {
                            Debug.out("Failed to update 'preferIPv6Address'", throwable);
                        }
                    }
                }
            });
            int n = COConfigurationManager.getIntParameter("Tracker Client Connect Timeout");
            int n2 = COConfigurationManager.getIntParameter("Tracker Client Read Timeout");
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TrackerClient: connect timeout = " + n + ", read timeout = " + n2));
            }
            System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(n * 1000));
            System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(n2 * 1000));
            boolean bl = false;
            if (bl) {
                try {
                    AESocksProxy aESocksProxy = AESocksProxyFactory.create(16234, 0L, 0L);
                    System.setProperty("socksProxyHost", "127.0.0.1");
                    System.setProperty("socksProxyPort", "" + aESocksProxy.getPort());
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            } else if (COConfigurationManager.getBooleanParameter("Enable.Proxy")) {
                String string3 = COConfigurationManager.getStringParameter("Proxy.Host");
                String string4 = COConfigurationManager.getStringParameter("Proxy.Port");
                String string5 = COConfigurationManager.getStringParameter("Proxy.Username");
                String string6 = COConfigurationManager.getStringParameter("Proxy.Password");
                if (string5.trim().equalsIgnoreCase("<none>")) {
                    string5 = "";
                }
                if (COConfigurationManager.getBooleanParameter("Enable.SOCKS")) {
                    System.setProperty("socksProxyHost", string3);
                    System.setProperty("socksProxyPort", string4);
                    if (string5.length() > 0) {
                        System.setProperty("java.net.socks.username", string5);
                        System.setProperty("java.net.socks.password", string6);
                    }
                } else {
                    System.setProperty("http.proxyHost", string3);
                    System.setProperty("http.proxyPort", string4);
                    System.setProperty("https.proxyHost", string3);
                    System.setProperty("https.proxyPort", string4);
                    if (string5.length() > 0) {
                        System.setProperty("http.proxyUser", string5);
                        System.setProperty("http.proxyPassword", string6);
                    }
                }
            }
            SESecurityManager.initialise();
        }
        catch (Throwable throwable) {
            Object var10_2 = null;
            class_mon.exit();
            throw throwable;
        }
        Object var10_1 = null;
        class_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadProperties(String string) {
        block5: {
            try {
                File file = new File(string, "azureus.properties");
                if (!file.exists()) break block5;
                Logger.log(new LogEvent(LOGID, "Loading properties file from " + file.getAbsolutePath()));
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(file);
                try {
                    properties.load(fileInputStream);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String string2 = (String)entry.getKey();
                        String string3 = (String)entry.getValue();
                        Logger.log(new LogEvent(LOGID, "    " + string2 + "=" + string3));
                        System.setProperty(string2, string3);
                    }
                    Object var9_9 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                ((InputStream)fileInputStream).close();
                {
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkConfiguration() {
        try {
            Object object;
            int n;
            int n2;
            String string;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            String string2;
            class_mon.enter();
            if (checked) {
                Object var19 = null;
                class_mon.exit();
                return;
            }
            checked = true;
            boolean bl = false;
            String string3 = COConfigurationManager.getStringParameter("azureus.version", "");
            if (!string3.equals(string2 = "4.3.0.4")) {
                if (!Constants.getBaseVersion(string3).equals(Constants.getBaseVersion())) {
                    COConfigurationManager.setParameter("Last Version", string3);
                    new_version = true;
                }
                if (!COConfigurationManager.hasParameter("First Recorded Version", true)) {
                    COConfigurationManager.setParameter("First Recorded Version", string3.length() == 0 ? string2 : string3);
                } else {
                    String string4;
                    String string5 = COConfigurationManager.getStringParameter("First Recorded Version");
                    String string6 = string4 = Constants.compareVersions(string5, string2) > 0 ? string2 : string5;
                    if (string3.length() > 0) {
                        string4 = Constants.compareVersions(string4, string3) > 0 ? string3 : string4;
                    }
                    COConfigurationManager.setParameter("First Recorded Version", string4);
                }
                COConfigurationManager.setParameter("azureus.version", string2);
                bl = true;
            }
            if (string3.length() == 0) {
                new_install = true;
                if (COConfigurationManager.doesParameterNonDefaultExist("diagnostics.tidy_close")) {
                    if (!COConfigurationManager.doesParameterNonDefaultExist("Use default data dir")) {
                        COConfigurationManager.setParameter("Use default data dir", true);
                        bl = true;
                    }
                    if (!COConfigurationManager.doesParameterNonDefaultExist("Tracker Port Enable")) {
                        COConfigurationManager.setParameter("Tracker Port Enable", true);
                        bl = true;
                    }
                }
                if (COConfigurationManager.getBooleanParameter("Use default data dir") && !COConfigurationManager.doesParameterNonDefaultExist("Default save path")) {
                    COConfigurationManager.setParameter("Default save path", SystemProperties.getUserPath() + "downloads");
                    bl = true;
                }
                if (!COConfigurationManager.doesParameterNonDefaultExist("User Mode")) {
                    COConfigurationManager.setParameter("User Mode", 0);
                    bl = true;
                }
                if (!COConfigurationManager.doesParameterNonDefaultExist("TCP.Listen.Port")) {
                    int n11 = RandomUtils.generateRandomNetworkListenPort();
                    COConfigurationManager.setParameter("TCP.Listen.Port", n11);
                    COConfigurationManager.setParameter("UDP.Listen.Port", n11);
                    COConfigurationManager.setParameter("UDP.NonData.Listen.Port", n11);
                    bl = true;
                }
            } else {
                if (COConfigurationManager.getBooleanParameter("network.tcp.enable_safe_selector_mode") && (!Constants.isWindows || !Constants.JAVA_VERSION.startsWith("1.4") && !Constants.JAVA_VERSION.startsWith("1.5"))) {
                    COConfigurationManager.removeParameter("network.tcp.enable_safe_selector_mode");
                    bl = true;
                }
                if (COConfigurationManager.doesParameterNonDefaultExist("TCP.Announce.Port")) {
                    COConfigurationManager.setParameter("TCP.Listen.Port.Override", COConfigurationManager.getStringParameter("TCP.Announce.Port", ""));
                    COConfigurationManager.removeParameter("TCP.Announce.Port");
                    bl = true;
                }
                if (!COConfigurationManager.doesParameterNonDefaultExist("User Mode")) {
                    COConfigurationManager.setParameter("User Mode", 2);
                    bl = true;
                }
            }
            if (!COConfigurationManager.doesParameterNonDefaultExist("UDP.Listen.Port")) {
                COConfigurationManager.setParameter("UDP.Listen.Port", COConfigurationManager.getIntParameter("TCP.Listen.Port"));
                bl = true;
            }
            if (!COConfigurationManager.getBooleanParameter("Plugin.DHT.dht.portdefault", true)) {
                COConfigurationManager.removeParameter("Plugin.DHT.dht.portdefault");
                int n12 = COConfigurationManager.getIntParameter("TCP.Listen.Port");
                int n13 = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                n10 = COConfigurationManager.getIntParameter("Plugin.DHT.dht.port", n13);
                if (n10 != n13 && n12 == n13) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", n10);
                }
                bl = true;
            }
            if (!COConfigurationManager.doesParameterNonDefaultExist("UDP.NonData.Listen.Port")) {
                COConfigurationManager.setParameter("UDP.NonData.Listen.Port", COConfigurationManager.getIntParameter("UDP.Listen.Port"));
                bl = true;
            }
            if ((n9 = COConfigurationManager.getIntParameter("UDP.Listen.Port")) != (n8 = COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port"))) {
                COConfigurationManager.setParameter("UDP.NonData.Listen.Port", n9);
                bl = true;
            }
            if ((n9 = COConfigurationManager.getIntParameter("TCP.Listen.Port")) == 6880 || n9 >= 45100 && n9 <= 45103) {
                n8 = RandomUtils.generateRandomNetworkListenPort();
                COConfigurationManager.setParameter("TCP.Listen.Port", n8);
                if (COConfigurationManager.getIntParameter("UDP.Listen.Port") == n9) {
                    COConfigurationManager.setParameter("UDP.Listen.Port", n8);
                }
                if (COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port") == n9) {
                    COConfigurationManager.setParameter("UDP.NonData.Listen.Port", n8);
                }
                bl = true;
            }
            if (!COConfigurationManager.doesParameterDefaultExist("Tracker Key Enable Client")) {
                n8 = COConfigurationManager.getBooleanParameter("Tracker Key Enable") ? 1 : 0;
                COConfigurationManager.setParameter("Tracker Key Enable Client", n8 != 0);
                COConfigurationManager.setParameter("Tracker Key Enable Server", n8 != 0);
                bl = true;
            }
            n8 = COConfigurationManager.getIntParameter("Max Upload Speed KBs", 0);
            n10 = COConfigurationManager.getIntParameter("Max Download Speed KBs", 0);
            if (n8 > 0 && n8 < 5 && (n10 == 0 || n10 > 2 * n8)) {
                bl = true;
                COConfigurationManager.setParameter("Max Upload Speed KBs", 5);
            }
            if ((n7 = COConfigurationManager.getIntParameter("Stop Peers Ratio", 0)) > 14) {
                COConfigurationManager.setParameter("Stop Peers Ratio", 14);
                bl = true;
            }
            if ((n6 = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_ShareRatio")) < 500) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_ShareRatio", 500);
                bl = true;
            }
            if ((n5 = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_SeedingMinutes")) < 90 && n5 != 0) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_SeedingMinutes", 90);
                bl = true;
            }
            if ((n4 = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_DLMinutes")) < 180 && n4 != 0) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_DLMinutes", 180);
                bl = true;
            }
            if ((n3 = COConfigurationManager.getIntParameter("StartStopManager_iFirstPriority_ignoreSPRatio")) < 10 && n3 != 0) {
                COConfigurationManager.setParameter("StartStopManager_iFirstPriority_ignoreSPRatio", 10);
                bl = true;
            }
            if ((string = COConfigurationManager.getStringParameter("ID", null)) == null || string.length() != 20) {
                string = RandomUtils.generateRandomAlphanumerics(20);
                COConfigurationManager.setParameter("ID", string);
                bl = true;
            }
            if ((n2 = COConfigurationManager.getIntParameter("diskmanager.perf.cache.size")) > COConfigurationManager.CONFIG_CACHE_SIZE_MAX_MB) {
                COConfigurationManager.setParameter("diskmanager.perf.cache.size", COConfigurationManager.CONFIG_CACHE_SIZE_MAX_MB);
                bl = true;
            }
            if (n2 < 1) {
                COConfigurationManager.setParameter("diskmanager.perf.cache.size", 4);
                bl = true;
            }
            if (Constants.isOSX) {
                boolean bl2 = COConfigurationManager.getBooleanParameter("Play Download Finished", true);
                n = COConfigurationManager.getBooleanParameter("confirmationOnExit");
                if (bl2 || n != 0) {
                    COConfigurationManager.setParameter("Play Download Finished", false);
                    COConfigurationManager.setParameter("confirmationOnExit", false);
                    bl = true;
                }
            }
            if (Constants.isOSX) {
                if (COConfigurationManager.getBooleanParameter("enable_small_osx_fonts")) {
                    System.setProperty("org.eclipse.swt.internal.carbon.smallFonts", "1");
                } else {
                    System.getProperties().remove("org.eclipse.swt.internal.carbon.smallFonts");
                }
                System.setProperty("org.eclipse.swt.internal.carbon.noFocusRing", "1");
            }
            String[] stringArray = new String[]{"Default save path", "General_sDefaultTorrent_Directory", "Watch Torrent Folder Path", "Completed Files Directory"};
            for (n = 0; n < stringArray.length; ++n) {
                if (!stringArray[n].endsWith(SystemProperties.SEP)) continue;
                object = stringArray[n].substring(0, stringArray[n].length() - 1);
                COConfigurationManager.setParameter(stringArray[n], (String)object);
                bl = true;
            }
            if (ConfigurationManager.getInstance().doesParameterNonDefaultExist("General_bEnableLanguageUpdate")) {
                File file = new File(SystemProperties.getUserPath());
                object = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.startsWith("MessagesBundle") && string.endsWith(".properties");
                    }
                });
                for (int i = 0; i < ((File[])object).length; ++i) {
                    File file2 = object[i];
                    if (!file2.exists()) continue;
                    if (Logger.isEnabled()) {
                        Logger.log(new LogEvent(LOGID, 1, "ConfigurationChecker:: removing old language file: " + file2.getAbsolutePath()));
                    }
                    file2.renameTo(new File(file2.getParentFile(), "delme" + file2.getName()));
                }
                ConfigurationManager.getInstance().removeParameter("General_bEnableLanguageUpdate");
                bl = true;
            }
            if (FeatureAvailability.isAutoSpeedDefaultClassic()) {
                ConfigurationDefaults.getInstance().addParameter("Auto Upload Speed Version", 1);
            }
            if (bl) {
                COConfigurationManager.save();
            }
        }
        catch (Throwable throwable) {
            Object var19_2 = null;
            class_mon.exit();
            throw throwable;
        }
        Object var19_1 = null;
        class_mon.exit();
        ConfigurationDefaults.getInstance().runVerifiers();
    }

    public static final boolean isNewInstall() {
        return new_install;
    }

    public static final boolean isNewVersion() {
        return new_version;
    }

    public static void main(String[] stringArray) {
        Integer n = new Integer(1);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n2 = 0;
        for (int i = 0; i < 1000000; ++i) {
            String string = RandomUtils.generateRandomAlphanumerics(20);
            if (hashMap.containsKey(string)) {
                ++n2;
            } else {
                hashMap.put(string, n);
            }
            if (i % 1000 != 0) continue;
            System.out.println(i + " : " + string + " : " + n2);
        }
        System.out.println("\n" + n2);
    }
}

