/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.util.Arrays;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerHelper;
import org.gudy.azureus2.core3.disk.impl.DiskManagerUtil;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.util.Debug;

public class DiskManagerFileInfoSetImpl
implements DiskManagerFileInfoSet {
    final DiskManagerFileInfoImpl[] files;
    final DiskManagerHelper diskManager;

    public DiskManagerFileInfoSetImpl(DiskManagerFileInfoImpl[] diskManagerFileInfoImplArray, DiskManagerHelper diskManagerHelper) {
        this.files = diskManagerFileInfoImplArray;
        this.diskManager = diskManagerHelper;
    }

    public DiskManagerFileInfo[] getFiles() {
        return this.files;
    }

    public int nbFiles() {
        return this.files.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(boolean[] blArray, boolean bl) {
        if (blArray.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        DownloadManagerState downloadManagerState = this.diskManager.getDownloadState();
        try {
            downloadManagerState.suppressStateSave(true);
            for (int i = 0; i < this.files.length; ++i) {
                if (!blArray[i]) continue;
                this.files[i].setPriority(bl);
            }
            Object var6_5 = null;
            downloadManagerState.suppressStateSave(false);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            downloadManagerState.suppressStateSave(false);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSkipped(boolean[] blArray, boolean bl) {
        if (blArray.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        DownloadManagerState downloadManagerState = this.diskManager.getDownloadState();
        try {
            downloadManagerState.suppressStateSave(true);
            if (!bl && !Arrays.equals(blArray, this.setStorageTypes(blArray, 1))) {
                Object var6_4 = null;
                downloadManagerState.suppressStateSave(false);
                return;
            }
            for (int i = 0; i < this.files.length; ++i) {
                if (!blArray[i]) continue;
                this.files[i].skipped = bl;
                this.diskManager.skippedFileSetChanged(this.files[i]);
            }
            if (!bl) {
                DiskManagerUtil.doFileExistenceChecks(this, blArray, this.diskManager.getDownloadState().getDownloadManager(), true);
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            downloadManagerState.suppressStateSave(false);
            throw throwable;
        }
        Object var6_5 = null;
        downloadManagerState.suppressStateSave(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean[] setStorageTypes(boolean[] blArray, int n) {
        if (blArray.length != this.files.length) {
            throw new IllegalArgumentException("array length mismatches the number of files");
        }
        if (this.files.length == 0) {
            return new boolean[0];
        }
        String[] stringArray = this.diskManager.getStorageTypes();
        boolean[] blArray2 = new boolean[this.files.length];
        DownloadManagerState downloadManagerState = this.diskManager.getDownloadState();
        if (n == 2) {
            Debug.out("Download must be stopped for linear -> compact conversion");
            return blArray2;
        }
        try {
            downloadManagerState.suppressStateSave(true);
            for (int i = 0; i < this.files.length; ++i) {
                Object var11_9;
                int n2;
                if (!blArray[i]) continue;
                int n3 = n2 = stringArray[i].equals("L") ? 1 : 2;
                if (n == n2) {
                    blArray2[i] = true;
                    continue;
                }
                DiskManagerFileInfoImpl diskManagerFileInfoImpl = this.files[i];
                try {
                    try {
                        diskManagerFileInfoImpl.getCacheFile().setStorageType(n == 1 ? 1 : 2);
                        blArray2[i] = true;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        this.diskManager.setFailed(diskManagerFileInfoImpl, "Failed to change storage type for '" + diskManagerFileInfoImpl.getFile(true) + "': " + Debug.getNestedExceptionMessage(throwable));
                        var11_9 = null;
                        stringArray[i] = diskManagerFileInfoImpl.getCacheFile().getStorageType() == 1 ? "L" : "C";
                        break;
                    }
                    var11_9 = null;
                    stringArray[i] = diskManagerFileInfoImpl.getCacheFile().getStorageType() == 1 ? "L" : "C";
                    continue;
                }
                catch (Throwable throwable) {
                    var11_9 = null;
                    stringArray[i] = diskManagerFileInfoImpl.getCacheFile().getStorageType() == 1 ? "L" : "C";
                    throw throwable;
                }
            }
            downloadManagerState.setListAttribute("storetypes", stringArray);
            DiskManagerUtil.doFileExistenceChecks(this, blArray, downloadManagerState.getDownloadManager(), true);
            Object var13_12 = null;
            downloadManagerState.suppressStateSave(false);
            downloadManagerState.save();
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            downloadManagerState.suppressStateSave(false);
            downloadManagerState.save();
            throw throwable;
        }
        return blArray2;
    }
}

