/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl;

import java.io.File;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.resume.RDResumeHandler;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;

public class DiskManagerUtil {
    private static final LogIDs LOGID = LogIDs.DISK;
    protected static int max_read_block_size;

    public static boolean checkBlockConsistencyForHint(DiskManager diskManager, String string, int n, int n2, int n3) {
        if (n3 <= 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " length=" + n3 + " <= 0"));
            }
            return false;
        }
        if (n < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " pieceNumber=" + n + " < 0"));
            }
            return false;
        }
        if (n >= diskManager.getNbPieces()) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " pieceNumber=" + n + " >= this.nbPieces=" + diskManager.getNbPieces()));
            }
            return false;
        }
        int n4 = diskManager.getPieceLength(n);
        if (n2 < 0) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " offset=" + n2 + " < 0"));
            }
            return false;
        }
        if (n2 > n4) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " offset=" + n2 + " > pLength=" + n4));
            }
            return false;
        }
        if (n2 + n3 > n4) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Hint invalid: " + string + " offset=" + n2 + " + length=" + n3 + " > pLength=" + n4));
            }
            return false;
        }
        return true;
    }

    public static boolean checkBlockConsistencyForRead(DiskManager diskManager, String string, int n, int n2, int n3) {
        if (!DiskManagerUtil.checkBlockConsistencyForHint(diskManager, string, n, n2, n3)) {
            return false;
        }
        if (n3 > max_read_block_size) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Read invalid: " + string + " length=" + n3 + " > " + max_read_block_size));
            }
            return false;
        }
        if (!diskManager.getPiece(n).isDone()) {
            Logger.log(new LogEvent((Object)diskManager, LOGID, 3, "Read invalid: " + string + " piece #" + n + " not done"));
            return false;
        }
        return true;
    }

    public static void doFileExistenceChecks(DiskManagerFileInfoSet diskManagerFileInfoSet, boolean[] blArray, DownloadManager downloadManager, boolean bl) {
        DiskManagerFileInfo[] diskManagerFileInfoArray = diskManagerFileInfoSet.getFiles();
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        String[] stringArray = DiskManagerImpl.getStorageTypes(downloadManager);
        for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
            int n4 = diskManagerFileInfoArray[i].getFirstPieceNumber();
            int n5 = diskManagerFileInfoArray[i].getLastPieceNumber();
            if (blArray[i]) {
                if (n < n4) {
                    n2 = n4;
                    while (i > 0 && diskManagerFileInfoArray[i - 1].getLastPieceNumber() >= n2) {
                        --i;
                    }
                }
                if (n3 < n5) {
                    n3 = n5;
                }
            }
            if ((n2 > n4 || n4 > n3) && (n2 > n5 || n5 > n3)) continue;
            File file = diskManagerFileInfoArray[i].getFile(true);
            if (!RDResumeHandler.fileMustExist(downloadManager, diskManagerFileInfoArray[i])) {
                if (stringArray[i].equals("C")) {
                    file.delete();
                }
            } else if (bl && stringArray[i].equals("L") && !file.exists()) {
                downloadManager.setDataAlreadyAllocated(false);
            }
            n = n5;
        }
    }

    static {
        ParameterListener parameterListener = new ParameterListener(){

            public void parameterChanged(String string) {
                max_read_block_size = COConfigurationManager.getIntParameter("BT Request Max Block Size");
            }
        };
        COConfigurationManager.addAndFireParameterListener("BT Request Max Block Size", parameterListener);
    }
}

