/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.access.impl;

import org.gudy.azureus2.core3.disk.DiskManagerReadRequest;
import org.gudy.azureus2.core3.disk.impl.access.impl.DiskManagerRequestImpl;
import org.gudy.azureus2.core3.util.SystemTime;

public class DiskManagerReadRequestImpl
extends DiskManagerRequestImpl
implements DiskManagerReadRequest {
    private static final int EXPIRATION_TIME = 60000;
    private final int pieceNumber;
    private final int offset;
    private final int length;
    private final int hashcode;
    private long timeCreated;
    private boolean flush;
    private boolean cancelled;
    private boolean use_cache = true;

    public DiskManagerReadRequestImpl(int n, int n2, int n3) {
        this.pieceNumber = n;
        this.offset = n2;
        this.length = n3;
        this.timeCreated = SystemTime.getCurrentTime();
        this.hashcode = this.pieceNumber + this.offset + this.length;
    }

    protected String getName() {
        return "Read: " + this.pieceNumber + ",off=" + this.offset + ",len=" + this.length + ",fl=" + this.flush + ",uc=" + this.use_cache;
    }

    public boolean isExpired() {
        long l = SystemTime.getCurrentTime();
        if (l >= this.timeCreated) {
            return l - this.timeCreated > 60000L;
        }
        this.timeCreated = l;
        return false;
    }

    public void resetTime(long l) {
        this.timeCreated = l;
    }

    public int getPieceNumber() {
        return this.pieceNumber;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public void setFlush(boolean bl) {
        this.flush = bl;
    }

    public boolean getFlush() {
        return this.flush;
    }

    public void setUseCache(boolean bl) {
        this.use_cache = bl;
    }

    public boolean getUseCache() {
        return this.use_cache;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DiskManagerReadRequestImpl)) {
            return false;
        }
        DiskManagerReadRequestImpl diskManagerReadRequestImpl = (DiskManagerReadRequestImpl)object;
        if (diskManagerReadRequestImpl.pieceNumber != this.pieceNumber) {
            return false;
        }
        if (diskManagerReadRequestImpl.offset != this.offset) {
            return false;
        }
        return diskManagerReadRequestImpl.length == this.length;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public long getTimeCreated(long l) {
        if (this.timeCreated > l) {
            this.timeCreated = l;
        }
        return this.timeCreated;
    }
}

