/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.disk.impl.resume;

import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequest;
import org.gudy.azureus2.core3.disk.DiskManagerCheckRequestListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerPiece;
import org.gudy.azureus2.core3.disk.impl.DiskManagerFileInfoImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerImpl;
import org.gudy.azureus2.core3.disk.impl.DiskManagerRecheckInstance;
import org.gudy.azureus2.core3.disk.impl.access.DMChecker;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceList;
import org.gudy.azureus2.core3.disk.impl.piecemapper.DMPieceMapEntry;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;

public class RDResumeHandler {
    private static final LogIDs LOGID = LogIDs.DISK;
    private static final byte PIECE_NOT_DONE = 0;
    private static final byte PIECE_DONE = 1;
    private static final byte PIECE_RECHECK_REQUIRED = 2;
    private static final byte PIECE_STARTED = 3;
    private static boolean use_fast_resume;
    private static boolean use_fast_resume_recheck_all;
    private DiskManagerImpl disk_manager;
    private DMChecker checker;
    private volatile boolean started;
    private volatile boolean stopped;
    private volatile boolean stopped_for_close;
    private volatile boolean check_in_progress;
    private volatile boolean check_resume_was_valid;
    private volatile boolean check_is_full_check;
    private volatile boolean check_interrupted;
    private volatile int check_position;

    public RDResumeHandler(DiskManagerImpl diskManagerImpl, DMChecker dMChecker) {
        this.disk_manager = diskManagerImpl;
        this.checker = dMChecker;
    }

    public void start() {
        if (this.started) {
            Debug.out("RDResumeHandler: reuse not supported");
        }
        this.started = true;
    }

    public void stop(boolean bl) {
        this.stopped_for_close |= bl;
        if (this.check_in_progress) {
            this.check_interrupted = true;
        }
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAllPieces(boolean bl) {
        DiskManagerRecheckInstance diskManagerRecheckInstance = this.disk_manager.getRecheckScheduler().register(this.disk_manager, false);
        final AESemaphore aESemaphore = new AESemaphore("RDResumeHandler::checkAllPieces:runsem", 2);
        try {
            try {
                boolean bl2 = false;
                try {
                    Object object;
                    int n;
                    this.check_in_progress = true;
                    boolean bl3 = use_fast_resume;
                    if (bl) {
                        bl3 = false;
                    }
                    final AESemaphore aESemaphore2 = new AESemaphore("RD:PendingChecks");
                    int n2 = 0;
                    DiskManagerPiece[] diskManagerPieceArray = this.disk_manager.getPieces();
                    DiskManagerFileInfo[] diskManagerFileInfoArray = this.disk_manager.getFiles();
                    HashMap<DiskManagerFileInfo, Long> hashMap = new HashMap<DiskManagerFileInfo, Long>();
                    for (n = 0; n < diskManagerFileInfoArray.length; ++n) {
                        try {
                            object = new Long(((DiskManagerFileInfoImpl)diskManagerFileInfoArray[n]).getCacheFile().getLength());
                            hashMap.put(diskManagerFileInfoArray[n], (Long)object);
                            continue;
                        }
                        catch (CacheFileManagerException cacheFileManagerException) {
                            Debug.printStackTrace(cacheFileManagerException);
                        }
                    }
                    if (bl3) {
                        Object object2;
                        Object object3;
                        Object object4;
                        int n3;
                        n = 0;
                        object = null;
                        Map map = null;
                        Map map2 = this.getResumeData();
                        if (map2 != null) {
                            try {
                                object = (byte[])map2.get("resume data");
                                if (object != null && ((Object)object).length != diskManagerPieceArray.length) {
                                    Debug.out("Resume data array length mismatch: " + ((Object)object).length + "/" + diskManagerPieceArray.length);
                                    object = null;
                                }
                                map = (Map)map2.get("blocks");
                                int n4 = n = ((Long)map2.get("valid")).intValue() == 1 ? 1 : 0;
                                if (RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState(), map2)) {
                                    bl2 = true;
                                } else {
                                    map2.put("valid", new Long(0L));
                                    this.saveResumeData(map2);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (object == null) {
                            this.check_is_full_check = true;
                            n = 0;
                            object = new byte[diskManagerPieceArray.length];
                            Arrays.fill((byte[])object, (byte)2);
                        }
                        this.check_resume_was_valid = n;
                        boolean bl4 = use_fast_resume_recheck_all;
                        if (!bl4) {
                            long l = 0L;
                            n3 = this.disk_manager.getPieceLength();
                            for (object4 = 0; object4 < diskManagerPieceArray.length; ++object4) {
                                if (object[object4] == true) continue;
                                l += (long)n3;
                            }
                            if (l < 0x4000000L) {
                                bl4 = true;
                            }
                        }
                        if (Logger.isEnabled()) {
                            int n5 = 0;
                            int n6 = 0;
                            n3 = 0;
                            object4 = 0;
                            for (int i = 0; i < diskManagerPieceArray.length; ++i) {
                                object3 = object[i];
                                if (object3 == false) {
                                    ++n5;
                                    continue;
                                }
                                if (object3 == true) {
                                    ++n6;
                                    continue;
                                }
                                if (object3 == 3) {
                                    ++n3;
                                    continue;
                                }
                                ++object4;
                            }
                            object2 = "valid=" + (n != 0) + ",not done=" + n5 + ",done=" + n6 + ",started=" + n3 + ",recheck=" + object4 + ",rc all=" + bl4 + ",full=" + this.check_is_full_check;
                            Logger.log(new LogEvent(this.disk_manager, LOGID, (String)object2));
                        }
                        for (int i = 0; i < diskManagerPieceArray.length; ++i) {
                            this.check_position = i;
                            DiskManagerPiece diskManagerPiece = diskManagerPieceArray[i];
                            this.disk_manager.setPercentDone((i + 1) * 1000 / this.disk_manager.getNbPieces());
                            n3 = 0;
                            object4 = object[i];
                            if (object4 == 1 || n == 0 || bl4) {
                                object2 = this.disk_manager.getPieceList(i);
                                for (object3 = (Object)false; object3 < object2.size(); ++object3) {
                                    DMPieceMapEntry dMPieceMapEntry = object2.get((int)object3);
                                    Long l = (Long)hashMap.get(dMPieceMapEntry.getFile());
                                    if (l == null) {
                                        object4 = 0;
                                        n3 = 1;
                                        if (!Logger.isEnabled()) break;
                                        Logger.log(new LogEvent((Object)this.disk_manager, LOGID, 1, "Piece #" + i + ": file is missing, " + "fails re-check."));
                                        break;
                                    }
                                    long l2 = dMPieceMapEntry.getOffset() + (long)dMPieceMapEntry.getLength();
                                    if (l >= l2) continue;
                                    object4 = 0;
                                    n3 = 1;
                                    if (!Logger.isEnabled()) break;
                                    Logger.log(new LogEvent((Object)this.disk_manager, LOGID, 1, "Piece #" + i + ": file is too small, fails re-check. File size = " + l + ", piece needs " + l2));
                                    break;
                                }
                            }
                            if (object4 == 1) {
                                diskManagerPiece.setDone(true);
                                continue;
                            }
                            if (object4 == 0 && !bl4) continue;
                            if (n3 != 0) {
                                diskManagerPiece.setDone(false);
                                continue;
                            }
                            if (object4 != 2 && n != 0) continue;
                            aESemaphore.reserve();
                            while (!this.stopped && !diskManagerRecheckInstance.getPermission()) {
                            }
                            if (this.stopped) break;
                            try {
                                object2 = this.disk_manager.createCheckRequest(i, null);
                                object2.setLowPriority(true);
                                this.checker.enqueueCheckRequest((DiskManagerCheckRequest)object2, new DiskManagerCheckRequestListener(){

                                    public void checkCompleted(DiskManagerCheckRequest diskManagerCheckRequest, boolean bl) {
                                        this.complete();
                                    }

                                    public void checkCancelled(DiskManagerCheckRequest diskManagerCheckRequest) {
                                        this.complete();
                                    }

                                    public void checkFailed(DiskManagerCheckRequest diskManagerCheckRequest, Throwable throwable) {
                                        this.complete();
                                    }

                                    protected void complete() {
                                        aESemaphore.release();
                                        aESemaphore2.release();
                                    }
                                });
                                ++n2;
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                        while (n2 > 0) {
                            aESemaphore2.reserve();
                            --n2;
                        }
                        if (map != null) {
                            for (Map.Entry entry : map.entrySet()) {
                                n3 = Integer.parseInt((String)entry.getKey());
                                DiskManagerPiece diskManagerPiece = diskManagerPieceArray[n3];
                                if (diskManagerPiece.isDone()) continue;
                                object2 = (List)map.get(entry.getKey());
                                Iterator iterator = object2.iterator();
                                while (iterator.hasNext()) {
                                    diskManagerPiece.setWritten(((Long)iterator.next()).intValue());
                                }
                            }
                        }
                    } else {
                        for (n = 0; n < diskManagerPieceArray.length; ++n) {
                            this.check_position = n;
                            this.disk_manager.setPercentDone((n + 1) * 1000 / this.disk_manager.getNbPieces());
                            boolean bl5 = false;
                            DMPieceList dMPieceList = this.disk_manager.getPieceList(n);
                            for (int i = 0; i < dMPieceList.size(); ++i) {
                                DMPieceMapEntry dMPieceMapEntry = dMPieceList.get(i);
                                Long l = (Long)hashMap.get(dMPieceMapEntry.getFile());
                                if (l == null) {
                                    bl5 = true;
                                    break;
                                }
                                long l3 = dMPieceMapEntry.getOffset() + (long)dMPieceMapEntry.getLength();
                                if (l >= l3) continue;
                                bl5 = true;
                                break;
                            }
                            if (bl5) {
                                this.disk_manager.getPiece(n).setDone(false);
                                continue;
                            }
                            aESemaphore.reserve();
                            while (!this.stopped && !diskManagerRecheckInstance.getPermission()) {
                            }
                            if (this.stopped) break;
                            try {
                                DiskManagerCheckRequest diskManagerCheckRequest = this.disk_manager.createCheckRequest(n, null);
                                diskManagerCheckRequest.setLowPriority(true);
                                this.checker.enqueueCheckRequest(diskManagerCheckRequest, new DiskManagerCheckRequestListener(){

                                    public void checkCompleted(DiskManagerCheckRequest diskManagerCheckRequest, boolean bl) {
                                        this.complete();
                                    }

                                    public void checkCancelled(DiskManagerCheckRequest diskManagerCheckRequest) {
                                        this.complete();
                                    }

                                    public void checkFailed(DiskManagerCheckRequest diskManagerCheckRequest, Throwable throwable) {
                                        this.complete();
                                    }

                                    protected void complete() {
                                        aESemaphore.release();
                                        aESemaphore2.release();
                                    }
                                });
                                ++n2;
                                continue;
                            }
                            catch (Throwable throwable) {
                                Debug.printStackTrace(throwable);
                            }
                        }
                        while (n2 > 0) {
                            aESemaphore2.reserve();
                            --n2;
                        }
                    }
                    Object var27_47 = null;
                    this.check_in_progress = false;
                }
                catch (Throwable throwable) {
                    Object var27_48 = null;
                    this.check_in_progress = false;
                    throw throwable;
                }
                if (!this.stopped && !bl2) {
                    try {
                        this.saveResumeData(true);
                    }
                    catch (Exception exception) {
                        Debug.out("Failed to dump initial resume data to disk");
                        Debug.printStackTrace(exception);
                    }
                }
                Object var29_50 = null;
                diskManagerRecheckInstance.unregister();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Object var29_51 = null;
                diskManagerRecheckInstance.unregister();
            }
        }
        catch (Throwable throwable) {
            Object var29_52 = null;
            diskManagerRecheckInstance.unregister();
            throw throwable;
        }
    }

    public void saveResumeData(boolean bl) throws Exception {
        int n;
        Object object;
        if (this.check_in_progress && bl) {
            return;
        }
        DiskManagerFileInfo[] diskManagerFileInfoArray = this.disk_manager.getFiles();
        if (!use_fast_resume) {
            for (int i = 0; i < diskManagerFileInfoArray.length; ++i) {
                diskManagerFileInfoArray[i].flushCache();
            }
            return;
        }
        boolean bl2 = RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState());
        DiskManagerPiece[] diskManagerPieceArray = this.disk_manager.getPieces();
        byte[] byArray = new byte[diskManagerPieceArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            object = diskManagerPieceArray[i];
            byArray[i] = this.stopped_for_close && this.check_interrupted && this.check_is_full_check && i >= this.check_position ? 2 : (object.isDone() ? 1 : (object.getNbWritten() > 0 ? 3 : 0));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("resume data", byArray);
        object = new HashMap();
        for (int i = 0; i < diskManagerPieceArray.length; ++i) {
            DiskManagerPiece diskManagerPiece = diskManagerPieceArray[i];
            boolean[] blArray = diskManagerPiece.getWritten();
            if (diskManagerPiece.isDone() || diskManagerPiece.getNbWritten() <= 0 || blArray == null) continue;
            boolean bl3 = true;
            for (int j = 0; j < blArray.length; ++j) {
                if (blArray[j]) continue;
                bl3 = false;
                break;
            }
            if (bl3) {
                byArray[i] = 2;
                continue;
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            for (int j = 0; j < blArray.length; ++j) {
                if (!blArray[j]) continue;
                arrayList.add(new Long(j));
            }
            object.put("" + i, arrayList);
        }
        hashMap.put("blocks", object);
        long l = this.check_interrupted ? (this.check_resume_was_valid ? 1L : 0L) : (bl ? 0L : 1L);
        hashMap.put("valid", new Long(l));
        for (n = 0; n < diskManagerFileInfoArray.length; ++n) {
            diskManagerFileInfoArray[n].flushCache();
        }
        n = RDResumeHandler.isTorrentResumeDataComplete(this.disk_manager.getDownloadManager().getDownloadState(), hashMap) ? 1 : 0;
        if (!bl2 || n == 0) {
            this.saveResumeData(hashMap);
        }
    }

    protected Map getResumeData() {
        return RDResumeHandler.getResumeData(this.disk_manager.getDownloadManager());
    }

    protected static Map getResumeData(DownloadManager downloadManager) {
        return RDResumeHandler.getResumeData(downloadManager.getDownloadState());
    }

    protected static Map getResumeData(DownloadManagerState downloadManagerState) {
        Map map = downloadManagerState.getResumeData();
        if (map != null) {
            Map map2 = (Map)map.get("data");
            return map2;
        }
        return null;
    }

    protected void saveResumeData(Map map) {
        RDResumeHandler.saveResumeData(this.disk_manager.getDownloadManager().getDownloadState(), map);
    }

    protected static void saveResumeData(DownloadManagerState downloadManagerState, Map map) {
        HashMap<String, Map> hashMap = new HashMap<String, Map>();
        hashMap.put("data", map);
        downloadManagerState.setResumeData(hashMap);
    }

    public static void setTorrentResumeDataComplete(DownloadManagerState downloadManagerState) {
        TOTorrent tOTorrent = downloadManagerState.getTorrent();
        int n = tOTorrent.getNumberOfPieces();
        byte[] byArray = new byte[n];
        Arrays.fill(byArray, (byte)1);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("resume data", byArray);
        HashMap hashMap2 = new HashMap();
        hashMap.put("blocks", hashMap2);
        hashMap.put("valid", new Long(1L));
        RDResumeHandler.saveResumeData(downloadManagerState, hashMap);
    }

    protected static int clearResumeDataSupport(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo, boolean bl, boolean bl2) {
        int n;
        DiskManagerFileInfo[] diskManagerFileInfoArray;
        DownloadManagerState downloadManagerState = downloadManager.getDownloadState();
        Map map = RDResumeHandler.getResumeData(downloadManager);
        if (map == null) {
            return 0;
        }
        int n2 = 0;
        byte[] byArray = (byte[])map.get("resume data");
        int n3 = diskManagerFileInfo.getFirstPieceNumber();
        int n4 = diskManagerFileInfo.getLastPieceNumber();
        if (bl2) {
            int n5;
            diskManagerFileInfoArray = downloadManager.getDiskManagerFileInfo();
            boolean bl3 = false;
            n = 0;
            for (int i = n5 = RDResumeHandler.findFirstFileWithPieceN(n3, diskManagerFileInfoArray); i < diskManagerFileInfoArray.length; ++i) {
                DiskManagerFileInfo diskManagerFileInfo2 = diskManagerFileInfoArray[i];
                if (diskManagerFileInfo2.getLastPieceNumber() < n3 || diskManagerFileInfo2.getIndex() == diskManagerFileInfo.getIndex()) continue;
                if (diskManagerFileInfo2.getFirstPieceNumber() > n4) break;
                if (diskManagerFileInfo2.getFirstPieceNumber() <= n3 && n3 <= diskManagerFileInfo2.getLastPieceNumber()) {
                    bl3 |= !diskManagerFileInfo2.isSkipped();
                }
                if (diskManagerFileInfo2.getFirstPieceNumber() > n4 || n4 > diskManagerFileInfo2.getLastPieceNumber()) continue;
                n |= !diskManagerFileInfo2.isSkipped() ? 1 : 0;
            }
            if (bl3) {
                ++n3;
            }
            if (n != 0) {
                --n4;
            }
        }
        if (byArray != null) {
            for (int i = n3; i <= n4 && i < byArray.length; ++i) {
                if (byArray[i] == 1) {
                    ++n2;
                }
                byArray[i] = bl ? 2 : 0;
            }
        }
        if ((diskManagerFileInfoArray = (Map)map.get("blocks")) != null) {
            Iterator iterator = diskManagerFileInfoArray.keySet().iterator();
            while (iterator.hasNext()) {
                n = Integer.parseInt((String)iterator.next());
                if (n < n3 || n > n4) continue;
                iterator.remove();
            }
        }
        map.put("valid", new Long(1L));
        RDResumeHandler.saveResumeData(downloadManagerState, map);
        return n2;
    }

    private static int findFirstFileWithPieceN(int n, DiskManagerFileInfo[] diskManagerFileInfoArray) {
        int n2 = 0;
        int n3 = diskManagerFileInfoArray.length - 1;
        int n4 = 0;
        while (n2 <= n3) {
            n4 = n2 + n3 >>> 1;
            int n5 = diskManagerFileInfoArray[n4].getLastPieceNumber();
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            while (n4 > 0 && diskManagerFileInfoArray[n4 - 1].getLastPieceNumber() == n) {
                --n4;
            }
            break block0;
        }
        return n4;
    }

    public static boolean fileMustExist(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
        int n;
        Map map = RDResumeHandler.getResumeData(downloadManager);
        byte[] byArray = map != null ? (byte[])map.get("resume data") : null;
        boolean bl = false;
        DiskManagerFileInfo[] diskManagerFileInfoArray = downloadManager.getDiskManagerFileInfo();
        int n2 = diskManagerFileInfo.getFirstPieceNumber();
        int n3 = diskManagerFileInfo.getLastPieceNumber();
        for (int i = n = RDResumeHandler.findFirstFileWithPieceN(n2, diskManagerFileInfoArray); i < diskManagerFileInfoArray.length && !bl; ++i) {
            DiskManagerFileInfo diskManagerFileInfo2 = diskManagerFileInfoArray[i];
            if (diskManagerFileInfo2.getLastPieceNumber() < n2) continue;
            if (diskManagerFileInfo2.getIndex() == diskManagerFileInfo.getIndex() && byArray != null && diskManagerFileInfo.getStorageType() != 2) {
                for (int j = n2; j <= n3 && !bl; bl |= byArray[j] != 0, ++j) {
                }
            }
            if (diskManagerFileInfo2.getFirstPieceNumber() > n3) break;
            if (diskManagerFileInfo2.getFirstPieceNumber() <= n2 && n2 <= diskManagerFileInfo2.getLastPieceNumber()) {
                bl |= !diskManagerFileInfo2.isSkipped();
            }
            if (diskManagerFileInfo2.getFirstPieceNumber() > n3 || n3 > diskManagerFileInfo2.getLastPieceNumber()) continue;
            bl |= !diskManagerFileInfo2.isSkipped();
        }
        return bl;
    }

    public static int storageTypeChanged(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
        return RDResumeHandler.clearResumeDataSupport(downloadManager, diskManagerFileInfo, false, true);
    }

    public static void clearResumeData(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
        RDResumeHandler.clearResumeDataSupport(downloadManager, diskManagerFileInfo, false, false);
    }

    public static void recheckFile(DownloadManager downloadManager, DiskManagerFileInfo diskManagerFileInfo) {
        RDResumeHandler.clearResumeDataSupport(downloadManager, diskManagerFileInfo, true, false);
    }

    public static void setTorrentResumeDataNearlyComplete(DownloadManagerState downloadManagerState) {
        TOTorrent tOTorrent = downloadManagerState.getTorrent();
        long l = tOTorrent.getNumberOfPieces();
        byte[] byArray = new byte[(int)l];
        Arrays.fill(byArray, (byte)1);
        for (int i = 0; i < 3; ++i) {
            int n = (int)(Math.random() * (double)l);
            byArray[n] = 2;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("resume data", byArray);
        HashMap hashMap2 = new HashMap();
        hashMap.put("blocks", hashMap2);
        hashMap.put("valid", new Long(0L));
        RDResumeHandler.saveResumeData(downloadManagerState, hashMap);
    }

    public static boolean isTorrentResumeDataComplete(DownloadManagerState downloadManagerState) {
        Map map = RDResumeHandler.getResumeData(downloadManagerState);
        return RDResumeHandler.isTorrentResumeDataComplete(downloadManagerState, map);
    }

    protected static boolean isTorrentResumeDataComplete(DownloadManagerState downloadManagerState, Map map) {
        try {
            int n = downloadManagerState.getTorrent().getNumberOfPieces();
            if (map != null) {
                boolean bl;
                byte[] byArray = (byte[])map.get("resume data");
                Map map2 = (Map)map.get("blocks");
                boolean bl2 = bl = ((Long)map.get("valid")).intValue() == 1;
                if (map2 == null || map2.size() > 0) {
                    return false;
                }
                if (bl && byArray != null && byArray.length == n) {
                    for (int i = 0; i < byArray.length; ++i) {
                        if (byArray[i] == 1) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
        return false;
    }

    static {
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Use Resume", "On Resume Recheck All"}, new ParameterListener(){

            public void parameterChanged(String string) {
                use_fast_resume = COConfigurationManager.getBooleanParameter("Use Resume");
                use_fast_resume_recheck_all = COConfigurationManager.getBooleanParameter("On Resume Recheck All");
            }
        });
    }
}

