/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.download.impl;

import org.gudy.azureus2.core3.disk.DiskManager;
import org.gudy.azureus2.core3.download.DownloadManagerState;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.download.impl.DownloadManagerImpl;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;

public class DownloadManagerStatsImpl
implements DownloadManagerStats {
    private DownloadManagerImpl download_manager;
    private int completed;
    private int downloadCompleted;
    private long saved_data_bytes_downloaded;
    private long saved_protocol_bytes_downloaded;
    private long saved_data_bytes_uploaded;
    private long saved_protocol_bytes_uploaded;
    private long saved_discarded = 0L;
    private long saved_hashfails = 0L;
    private long saved_SecondsDownloading = 0L;
    private long saved_SecondsOnlySeeding = 0L;
    private int saved_SecondsSinceDownload = 0;
    private int saved_SecondsSinceUpload = 0;
    private int max_upload_rate_bps = 0;
    private int max_download_rate_bps = 0;

    protected DownloadManagerStatsImpl(DownloadManagerImpl downloadManagerImpl) {
        this.download_manager = downloadManagerImpl;
    }

    public long getDataReceiveRate() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.getStats().getDataReceiveRate();
        }
        return 0L;
    }

    public long getProtocolReceiveRate() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.getStats().getProtocolReceiveRate();
        }
        return 0L;
    }

    public long getDataSendRate() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.getStats().getDataSendRate();
        }
        return 0L;
    }

    public long getProtocolSendRate() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.getStats().getProtocolSendRate();
        }
        return 0L;
    }

    public long getETA() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.getETA();
        }
        return -1L;
    }

    public int getCompleted() {
        DiskManager diskManager = this.download_manager.getDiskManager();
        if (diskManager == null) {
            int n = this.download_manager.getState();
            if (n == 20 || n == 30 || n == 5) {
                return this.completed;
            }
            return this.downloadCompleted;
        }
        if (diskManager.getState() == 2 || diskManager.getState() == 3 || diskManager.getState() == 1) {
            return diskManager.getPercentDone();
        }
        long l = diskManager.getTotalLength();
        return l == 0L ? 0 : (int)(1000L * (l - diskManager.getRemaining()) / l);
    }

    public void setCompleted(int n) {
        this.completed = n;
    }

    public int getDownloadCompleted(boolean bl) {
        int n;
        DiskManager diskManager = this.download_manager.getDiskManager();
        if (diskManager == null) {
            return this.downloadCompleted;
        }
        int n2 = diskManager.getState();
        boolean bl2 = n2 == 1 || n2 == 2 || n2 == 3;
        long l = diskManager.getTotalLength();
        int n3 = n = l == 0L ? 0 : (int)(1000L * (l - diskManager.getRemaining()) / l);
        if (!bl2) {
            this.downloadCompleted = n;
        }
        if (bl) {
            return n;
        }
        return this.downloadCompleted;
    }

    public void setDownloadCompleted(int n) {
        this.downloadCompleted = n;
    }

    public String getElapsedTime() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.getElapsedTime();
        }
        return "";
    }

    public long getTimeStarted() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.getTimeStarted();
        }
        return -1L;
    }

    public long getTimeStartedSeeding() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.getTimeStartedSeeding();
        }
        return -1L;
    }

    public long getTotalDataBytesReceived() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return this.saved_data_bytes_downloaded + pEPeerManager.getStats().getTotalDataBytesReceived();
        }
        return this.saved_data_bytes_downloaded;
    }

    public long getTotalGoodDataBytesReceived() {
        long l = this.getTotalDataBytesReceived();
        if ((l -= this.getHashFailBytes() + this.getDiscarded()) < 0L) {
            l = 0L;
        }
        return l;
    }

    public long getTotalProtocolBytesReceived() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return this.saved_protocol_bytes_downloaded + pEPeerManager.getStats().getTotalProtocolBytesReceived();
        }
        return this.saved_protocol_bytes_downloaded;
    }

    public long getTotalDataBytesSent() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return this.saved_data_bytes_uploaded + pEPeerManager.getStats().getTotalDataBytesSent();
        }
        return this.saved_data_bytes_uploaded;
    }

    public long getTotalProtocolBytesSent() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return this.saved_protocol_bytes_uploaded + pEPeerManager.getStats().getTotalProtocolBytesSent();
        }
        return this.saved_protocol_bytes_uploaded;
    }

    public long getRemaining() {
        DiskManager diskManager = this.download_manager.getDiskManager();
        if (diskManager == null) {
            return this.download_manager.getSize() - (long)this.getCompleted() * this.download_manager.getSize() / 1000L;
        }
        return diskManager.getRemainingExcludingDND();
    }

    public long getDiscarded() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return this.saved_discarded + pEPeerManager.getStats().getTotalDiscarded();
        }
        return this.saved_discarded;
    }

    public long getHashFailCount() {
        TOTorrent tOTorrent = this.download_manager.getTorrent();
        if (tOTorrent == null) {
            return 0L;
        }
        long l = this.getHashFailBytes();
        long l2 = l / tOTorrent.getPieceLength();
        if (l2 == 0L && l > 0L) {
            l2 = 1L;
        }
        return l2;
    }

    public long getHashFailBytes() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return this.saved_hashfails + pEPeerManager.getStats().getTotalHashFailBytes();
        }
        return this.saved_hashfails;
    }

    public long getTotalAverage() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            return pEPeerManager.getStats().getTotalAverage();
        }
        return 0L;
    }

    public long getTotalAveragePerPeer() {
        int n = this.download_manager.getNbPeers() + (this.download_manager.isDownloadComplete(false) ? 0 : 1);
        long l = n < 1 ? 0L : this.getTotalAverage() / (long)n;
        return l;
    }

    public int getShareRatio() {
        long l = this.getTotalGoodDataBytesReceived();
        long l2 = this.getTotalDataBytesSent();
        if (l <= 0L) {
            return -1;
        }
        return (int)(1000L * l2 / l);
    }

    public long getSecondsDownloading() {
        long l = this.getTimeStarted();
        if (l >= 0L) {
            long l2 = this.getTimeStartedSeeding();
            if (l2 == -1L) {
                l2 = SystemTime.getCurrentTime();
            }
            if (l2 > l) {
                return this.saved_SecondsDownloading + (l2 - l) / 1000L;
            }
        }
        return this.saved_SecondsDownloading;
    }

    public long getSecondsOnlySeeding() {
        long l = this.getTimeStartedSeeding();
        if (l >= 0L) {
            return this.saved_SecondsOnlySeeding + (SystemTime.getCurrentTime() - l) / 1000L;
        }
        return this.saved_SecondsOnlySeeding;
    }

    public float getAvailability() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager == null) {
            return -1.0f;
        }
        return pEPeerManager.getMinAvailability();
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.max_upload_rate_bps;
    }

    public void setUploadRateLimitBytesPerSecond(int n) {
        this.max_upload_rate_bps = n;
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.max_download_rate_bps;
    }

    public void setDownloadRateLimitBytesPerSecond(int n) {
        this.max_download_rate_bps = n;
    }

    public int getTimeSinceLastDataReceivedInSeconds() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        int n = this.saved_SecondsSinceDownload;
        if (pEPeerManager != null) {
            int n2 = pEPeerManager.getStats().getTimeSinceLastDataReceivedInSeconds();
            if (n2 >= 0) {
                n = n2;
            } else if (n >= 0) {
                long l = SystemTime.getCurrentTime();
                long l2 = l - pEPeerManager.getTimeStarted();
                if (l2 < 0L) {
                    l2 = 0L;
                }
                n = (int)((long)n + l2 / 1000L);
            }
        }
        return n;
    }

    public int getTimeSinceLastDataSentInSeconds() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        int n = this.saved_SecondsSinceUpload;
        if (pEPeerManager != null) {
            int n2 = pEPeerManager.getStats().getTimeSinceLastDataSentInSeconds();
            if (n2 >= 0) {
                n = n2;
            } else if (n >= 0) {
                long l = SystemTime.getCurrentTime();
                long l2 = l - pEPeerManager.getTimeStarted();
                if (l2 < 0L) {
                    l2 = 0L;
                }
                n = (int)((long)n + l2 / 1000L);
            }
        }
        return n;
    }

    public long getAvailWentBadTime() {
        PEPeerManager pEPeerManager = this.download_manager.getPeerManager();
        if (pEPeerManager != null) {
            long l = pEPeerManager.getAvailWentBadTime();
            if (l > 0L) {
                return l;
            }
            if ((double)pEPeerManager.getMinAvailability() >= 1.0) {
                return 0L;
            }
        }
        DownloadManagerState downloadManagerState = this.download_manager.getDownloadState();
        return downloadManagerState.getLongAttribute("badavail");
    }

    protected void saveSessionTotals() {
        this.saved_data_bytes_downloaded = this.getTotalDataBytesReceived();
        this.saved_data_bytes_uploaded = this.getTotalDataBytesSent();
        this.saved_discarded = this.getDiscarded();
        this.saved_hashfails = this.getHashFailBytes();
        this.saved_SecondsDownloading = this.getSecondsDownloading();
        this.saved_SecondsOnlySeeding = this.getSecondsOnlySeeding();
        this.saved_SecondsSinceDownload = this.getTimeSinceLastDataReceivedInSeconds();
        this.saved_SecondsSinceUpload = this.getTimeSinceLastDataSentInSeconds();
        DownloadManagerState downloadManagerState = this.download_manager.getDownloadState();
        downloadManagerState.setIntAttribute("timesincedl", this.saved_SecondsSinceDownload);
        downloadManagerState.setIntAttribute("timesinceul", this.saved_SecondsSinceUpload);
        downloadManagerState.setLongAttribute("badavail", this.getAvailWentBadTime());
    }

    protected void setSavedDownloadedUploaded(long l, long l2) {
        this.saved_data_bytes_downloaded = l;
        this.saved_data_bytes_uploaded = l2;
    }

    public void restoreSessionTotals(long l, long l2, long l3, long l4, long l5, long l6) {
        this.saved_data_bytes_downloaded = l;
        this.saved_data_bytes_uploaded = l2;
        this.saved_discarded = l3;
        this.saved_hashfails = l4;
        this.saved_SecondsDownloading = l5;
        this.saved_SecondsOnlySeeding = l6;
        DownloadManagerState downloadManagerState = this.download_manager.getDownloadState();
        this.saved_SecondsSinceDownload = downloadManagerState.getIntAttribute("timesincedl");
        this.saved_SecondsSinceUpload = downloadManagerState.getIntAttribute("timesinceul");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("DownloadManagerStats");
        try {
            indentWriter.indent();
            indentWriter.println("recv_d=" + this.getTotalDataBytesReceived() + ",recv_p=" + this.getTotalProtocolBytesReceived() + ",recv_g=" + this.getTotalGoodDataBytesReceived() + ",sent_d=" + this.getTotalDataBytesSent() + ",sent_p=" + this.getTotalProtocolBytesSent() + ",discard=" + this.getDiscarded() + ",hash_fails=" + this.getHashFailCount() + "/" + this.getHashFailBytes() + ",comp=" + this.getCompleted() + "[live:" + this.getDownloadCompleted(true) + "/" + this.getDownloadCompleted(false) + "],dl_comp=" + this.downloadCompleted + ",remaining=" + this.getRemaining());
            Object var3_2 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }
}

