/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.internat;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.WeakHashMap;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;

public class IntegratedResourceBundle
extends ResourceBundle {
    private static final boolean DEBUG = false;
    private static final Object NULL_OBJECT = new Object();
    private static final Map bundle_map = new WeakHashMap();
    private static TimerEventPeriodic compact_timer;
    private Locale locale;
    private Map messages;
    private Map used_messages;
    private List null_values;
    private int clean_count = 0;
    private boolean one_off_discard_done;
    private File scratch_file_name;
    private InputStream scratch_file_is;
    private final int initCapacity;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void resetCompactTimer() {
        Map map = bundle_map;
        synchronized (map) {
            if (compact_timer == null && System.getProperty("transitory.startup", "0").equals("0")) {
                compact_timer = SimpleTimer.addPeriodicEvent("IRB:compactor", 60000L, new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void perform(TimerEvent timerEvent2) {
                        Map map = bundle_map;
                        synchronized (map) {
                            Iterator iterator = bundle_map.keySet().iterator();
                            boolean bl = false;
                            while (iterator.hasNext()) {
                                IntegratedResourceBundle integratedResourceBundle = (IntegratedResourceBundle)iterator.next();
                                if (!integratedResourceBundle.compact()) continue;
                                bl = true;
                            }
                            if (!bl) {
                                compact_timer.cancel();
                                compact_timer = null;
                            }
                        }
                    }
                });
            }
        }
    }

    public IntegratedResourceBundle(ResourceBundle resourceBundle, Map map) {
        this(resourceBundle, map, null, 10);
    }

    public IntegratedResourceBundle(ResourceBundle resourceBundle, Map map, int n) {
        this(resourceBundle, map, null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegratedResourceBundle(ResourceBundle resourceBundle, Map map, Collection collection, int n) {
        this.initCapacity = n;
        this.messages = new LightHashMap(n);
        this.locale = resourceBundle.getLocale();
        this.addResourceMessages(resourceBundle);
        Object object = map;
        synchronized (object) {
            for (String string : map.keySet()) {
                ClassLoader classLoader = (ClassLoader)map.get(string);
                this.addPluginBundle(string, classLoader);
            }
        }
        if (collection != null) {
            object = collection;
            synchronized (object) {
                Iterator<Object> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    this.addResourceMessages((ResourceBundle)iterator.next());
                }
            }
        }
        this.used_messages = new LightHashMap(this.messages.size());
        object = bundle_map;
        synchronized (object) {
            bundle_map.put(this, NULL_OBJECT);
            IntegratedResourceBundle.resetCompactTimer();
        }
    }

    public Locale getLocale() {
        return this.locale;
    }

    private Map getMessages() {
        return this.loadMessages();
    }

    public Enumeration getKeys() {
        new Exception("Don't call me, call getKeysLight").printStackTrace();
        Map map = this.loadMessages();
        return new Vector(map.keySet()).elements();
    }

    protected Iterator getKeysLight() {
        LightHashMap lightHashMap = new LightHashMap(this.loadMessages());
        return lightHashMap.keySet().iterator();
    }

    public String getString(String string, String string2) {
        String string3 = (String)this.handleGetObject(string);
        if (string3 == null) {
            if (this.parent != null) {
                string3 = this.parent.getString(string);
            }
            if (string3 == null) {
                return string2;
            }
        }
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleGetObject(String string) {
        int n;
        Object v;
        Object object = bundle_map;
        synchronized (object) {
            v = this.used_messages.get(string);
        }
        object = null;
        if (this.null_values != null && (n = Collections.binarySearch(this.null_values, object = new Integer(string.hashCode()))) >= 0) {
            return null;
        }
        if (v == NULL_OBJECT) {
            return null;
        }
        if (v == null) {
            Map map = bundle_map;
            synchronized (map) {
                this.loadMessages();
                if (this.messages != null) {
                    v = this.messages.get(string);
                }
                if (v == null && this.null_values != null) {
                    int n2 = Collections.binarySearch(this.null_values, object);
                    if (n2 < 0) {
                        n2 = -1 * n2 - 1;
                    }
                    if (n2 > this.null_values.size()) {
                        n2 = this.null_values.size();
                    }
                    this.null_values.add(n2, object);
                } else {
                    this.used_messages.put(string, v == null ? NULL_OBJECT : v);
                }
                this.clean_count = 0;
                IntegratedResourceBundle.resetCompactTimer();
            }
        }
        return v;
    }

    public void addPluginBundle(String string, ClassLoader classLoader) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = classLoader != null ? ResourceBundle.getBundle(string, this.locale, classLoader) : ResourceBundle.getBundle(string, this.locale, IntegratedResourceBundle.class.getClassLoader());
        }
        catch (Exception exception) {
            try {
                resourceBundle = classLoader != null ? ResourceBundle.getBundle(string, MessageText.LOCALE_DEFAULT, classLoader) : ResourceBundle.getBundle(string, MessageText.LOCALE_DEFAULT, IntegratedResourceBundle.class.getClassLoader());
            }
            catch (Exception exception2) {
                System.out.println(string + ": no default resource bundle");
                return;
            }
        }
        this.addResourceMessages(resourceBundle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceMessages(ResourceBundle resourceBundle) {
        Map map = bundle_map;
        synchronized (map) {
            this.loadMessages();
            if (resourceBundle != null) {
                if (resourceBundle instanceof IntegratedResourceBundle) {
                    this.messages.putAll(((IntegratedResourceBundle)resourceBundle).getMessages());
                } else {
                    Enumeration<String> enumeration = resourceBundle.getKeys();
                    while (enumeration.hasMoreElements()) {
                        String string = enumeration.nextElement();
                        this.messages.put(string, resourceBundle.getObject(string));
                    }
                }
            }
        }
    }

    protected boolean compact() {
        Object object;
        block11: {
            ++this.clean_count;
            if (this.clean_count == 1) {
                return true;
            }
            if (this.scratch_file_is == null) {
                object = null;
                FileOutputStream fileOutputStream = null;
                try {
                    Properties properties = new Properties();
                    properties.putAll((Map<?, ?>)this.messages);
                    object = AETemporaryFileHandler.createTempFile();
                    fileOutputStream = new FileOutputStream((File)object);
                    properties.store(fileOutputStream, "message cache");
                    fileOutputStream.close();
                    fileOutputStream = null;
                    this.scratch_file_name = object;
                    this.scratch_file_is = new FileInputStream((File)object);
                }
                catch (Throwable throwable) {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    if (object == null) break block11;
                    ((File)object).delete();
                }
            }
        }
        if (this.scratch_file_is != null) {
            if (this.clean_count >= 2) {
                this.messages = null;
            }
            if (this.clean_count == 5 && !this.one_off_discard_done) {
                this.one_off_discard_done = true;
                this.used_messages.clear();
            }
        }
        if (this.clean_count > 5) {
            object = new LightHashMap(this.used_messages.size() + 16);
            object.putAll(this.used_messages);
            this.used_messages = object;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map loadMessages() {
        Map map = bundle_map;
        synchronized (map) {
            if (this.messages != null) {
                return this.messages;
            }
            if (this.scratch_file_is == null) {
                return new LightHashMap();
            }
            Properties properties = new Properties();
            InputStream inputStream = this.scratch_file_is;
            try {
                properties.load(inputStream);
                inputStream.close();
                this.scratch_file_is = new FileInputStream(this.scratch_file_name);
                this.messages = new LightHashMap();
                this.messages.putAll(properties);
                return this.messages;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                Debug.out("Failed to load message bundle scratch file", throwable);
                this.scratch_file_name.delete();
                this.scratch_file_is = null;
                return new LightHashMap();
            }
        }
    }

    protected String getString() {
        return this.locale + ": use=" + this.used_messages.size() + ",map=" + (this.messages == null ? "" : String.valueOf(this.messages.size())) + (this.null_values == null ? "" : ",null=" + this.null_values.size());
    }

    public void addString(String string, String string2) {
        this.messages.put(string, string2);
    }

    public boolean getUseNullList() {
        return this.null_values != null;
    }

    public void setUseNullList(boolean bl) {
        if (bl && this.null_values == null) {
            this.null_values = new ArrayList(0);
        } else if (!bl && this.null_values != null) {
            this.null_values = null;
        }
    }

    public void clearUsedMessagesMap(int n) {
        this.used_messages = new LightHashMap(n);
        if (this.null_values != null) {
            this.null_values = new ArrayList(0);
        }
    }
}

