/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.ipfilter.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.core3.ipfilter.impl.IpRangeImpl;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UnresolvableHostManager;

public class IPAddressRangeManager {
    private static final LogIDs LOGID = LogIDs.CORE;
    protected ArrayList entries = new ArrayList();
    protected long total_span;
    protected boolean rebuild_required;
    protected long last_rebuild_time;
    protected IpRange[] mergedRanges = new IpRange[0];
    protected AEMonitor this_mon = new AEMonitor("IPAddressRangeManager");

    protected IPAddressRangeManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRange(IpRange ipRange) {
        try {
            this.this_mon.enter();
            this.entries.add(ipRange);
            this.rebuild_required = true;
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRange(IpRange ipRange) {
        try {
            this.this_mon.enter();
            this.entries.remove(ipRange);
            this.rebuild_required = true;
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object isInRange(String string) {
        if (this.entries.size() == 0) {
            return null;
        }
        try {
            Object object;
            this.this_mon.enter();
            long l = this.addressToInt(string);
            if (l < 0L) {
                l += 0x100000000L;
            }
            Object object2 = object = this.isInRange(l);
            Object var7_5 = null;
            this.this_mon.exit();
            return object2;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object isInRange(InetAddress inetAddress) {
        if (this.entries.size() == 0) {
            return null;
        }
        try {
            Object object;
            this.this_mon.enter();
            long l = this.addressToInt(inetAddress);
            if (l < 0L) {
                l += 0x100000000L;
            }
            Object object2 = object = this.isInRange(l);
            Object var7_5 = null;
            this.this_mon.exit();
            return object2;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object isInRange(long l) {
        IpRange ipRange;
        block11: {
            Object var8_18;
            block10: {
                IpRange ipRange2;
                block9: {
                    try {
                        this.this_mon.enter();
                        this.checkRebuild();
                        if (this.mergedRanges.length == 0) {
                            Object var3_2 = null;
                            Object var12_4 = null;
                            this.this_mon.exit();
                            return var3_2;
                        }
                        int n = 0;
                        int n2 = this.mergedRanges.length - 1;
                        int n3 = -1;
                        while (n2 >= 0 && n < this.mergedRanges.length && n <= n2) {
                            n3 = (n + n2) / 2;
                            ipRange = this.mergedRanges[n3];
                            long l2 = ipRange.getStartIpLong();
                            long l3 = ipRange.getMergedEndLong();
                            if (l == l2) break;
                            if (l > l2) {
                                if (l <= l3) break;
                                n = n3 + 1;
                                continue;
                            }
                            if (l == l3 || l >= l2) break;
                            n2 = n3 - 1;
                        }
                        if (n2 >= 0 && n < this.mergedRanges.length && n <= n2) {
                            ipRange = this.mergedRanges[n3];
                            if (l <= ipRange.getEndIpLong()) {
                                ipRange2 = ipRange;
                                break block9;
                            }
                            IpRange[] ipRangeArray = ipRange.getMergedEntries();
                            if (ipRangeArray == null) {
                                Debug.out("IPAddressRangeManager: inconsistent merged details - no entries");
                                var8_18 = null;
                                break block10;
                            }
                            for (int i = 0; i < ipRangeArray.length; ++i) {
                                IpRange ipRange3 = ipRangeArray[i];
                                if (ipRange3.getStartIpLong() > l || ipRange3.getEndIpLong() < l) continue;
                                IpRange ipRange4 = ipRange3;
                                Object var12_7 = null;
                                this.this_mon.exit();
                                return ipRange4;
                            }
                            Debug.out("IPAddressRangeManager: inconsistent merged details - entry not found");
                        }
                        ipRange = null;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        Object var12_9 = null;
                        this.this_mon.exit();
                        throw throwable;
                    }
                }
                Object var12_5 = null;
                this.this_mon.exit();
                return ipRange2;
            }
            Object var12_6 = null;
            this.this_mon.exit();
            return var8_18;
        }
        Object var12_8 = null;
        this.this_mon.exit();
        return ipRange;
    }

    protected int addressToInt(String string) {
        try {
            return PRHelpers.addressToInt(string);
        }
        catch (UnknownHostException unknownHostException) {
            return UnresolvableHostManager.getPseudoAddress(string);
        }
    }

    protected int addressToInt(InetAddress inetAddress) {
        return PRHelpers.addressToInt(inetAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkRebuild() {
        try {
            long l;
            long l2;
            this.this_mon.enter();
            if (this.rebuild_required && (l2 = ((l = SystemTime.getCurrentTime()) - this.last_rebuild_time) / 1000L) > (long)(this.entries.size() / 2000)) {
                this.last_rebuild_time = l;
                this.rebuild_required = false;
                this.rebuild();
            }
            Object var6_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    protected void rebuild() {
        IpRange ipRange;
        int n;
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "IPAddressRangeManager: rebuilding " + this.entries.size() + " entries starts"));
        }
        IpRange[] ipRangeArray = new IpRange[this.entries.size()];
        this.entries.toArray(ipRangeArray);
        for (int i = 0; i < ipRangeArray.length; ++i) {
            ipRangeArray[i].resetMergeInfo();
        }
        Arrays.sort(ipRangeArray, new Comparator(){

            public int compare(Object object, Object object2) {
                IpRange ipRange = (IpRange)object;
                IpRange ipRange2 = (IpRange)object2;
                long l = ipRange.getStartIpLong() - ipRange2.getStartIpLong();
                if (l == 0L) {
                    l = ipRange2.getEndIpLong() - ipRange.getEndIpLong();
                }
                return IPAddressRangeManager.this.signum(l);
            }

            public boolean equals(Object object) {
                return false;
            }
        });
        ArrayList<IpRange> arrayList = new ArrayList<IpRange>(ipRangeArray.length);
        block1: for (n = 0; n < ipRangeArray.length; ++n) {
            ipRange = ipRangeArray[n];
            if (ipRange.getMerged()) continue;
            arrayList.add(ipRange);
            int n2 = n + 1;
            while (n2 < ipRangeArray.length) {
                IpRange ipRange2;
                long l = ipRange.getMergedEndLong();
                if ((ipRange2 = ipRangeArray[n2++]).getMerged()) continue;
                if (l < ipRange2.getStartIpLong()) continue block1;
                ipRange2.setMerged();
                if (ipRange2.getEndIpLong() <= l) continue;
                ipRange.setMergedEnd(ipRange2.getEndIpLong());
                ipRange.addMergedEntry(ipRange2);
            }
        }
        this.mergedRanges = new IpRange[arrayList.size()];
        arrayList.toArray(this.mergedRanges);
        this.total_span = 0L;
        for (n = 0; n < this.mergedRanges.length; ++n) {
            ipRange = this.mergedRanges[n];
            long l = ipRange.getMergedEndLong() - ipRange.getStartIpLong() + 1L;
            this.total_span += l;
        }
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(LOGID, "IPAddressRangeManager: rebuilding " + this.entries.size() + " entries ends"));
        }
    }

    protected int signum(long l) {
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        return 0;
    }

    protected long getTotalSpan() {
        this.checkRebuild();
        return this.total_span;
    }

    public static void main(String[] stringArray) {
        Object object;
        int n;
        int n2;
        int n3;
        IPAddressRangeManager iPAddressRangeManager = new IPAddressRangeManager();
        Random random = new Random();
        for (n3 = 0; n3 < 1000000; ++n3) {
            n2 = random.nextInt(0xFFFFFFF);
            n = n2 + random.nextInt(255);
            object = PRHelpers.intToAddress(n2);
            String string = PRHelpers.intToAddress(n);
            iPAddressRangeManager.addRange(new IpRangeImpl("test_" + n3, (String)object, string, true));
        }
        n3 = 0;
        n2 = 0;
        while (true) {
            if (n3 % 1000 == 0) {
                System.out.println(n3 + "/" + n2);
            }
            ++n3;
            n = random.nextInt();
            object = iPAddressRangeManager.isInRange(n);
            if (object == null) continue;
            ++n2;
        }
    }

    public ArrayList getEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllEntries() {
        try {
            this.this_mon.enter();
            this.entries.clear();
            IpFilterManagerFactory.getSingleton().deleteAllDescriptions();
            this.rebuild_required = true;
            Object var2_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }
}

