/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.logging;

import com.aelitis.azureus.core.util.GeneralUtils;
import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;

public class LogAlert
implements org.gudy.azureus2.plugins.logging.LogAlert {
    public static final int AT_INFORMATION = 0;
    public static final int AT_WARNING = 1;
    public static final int AT_ERROR = 3;
    public static final boolean REPEATABLE = true;
    public static final boolean UNREPEATABLE = false;
    public int entryType;
    public Throwable err = null;
    public boolean repeatable;
    public String text;
    public Object[] relatedTo;
    public int timeoutSecs = -1;

    public LogAlert(boolean bl, int n, String string) {
        this.entryType = n;
        this.text = string;
        this.repeatable = bl;
    }

    public LogAlert(boolean bl, int n, String string, int n2) {
        this.entryType = n;
        this.text = string;
        this.repeatable = bl;
        this.timeoutSecs = n2;
    }

    public LogAlert(Object[] objectArray, boolean bl, int n, String string) {
        this(bl, n, string);
        this.relatedTo = objectArray;
    }

    public LogAlert(Object object, boolean bl, int n, String string) {
        this(bl, n, string);
        this.relatedTo = new Object[]{object};
    }

    public LogAlert(boolean bl, String string, Throwable throwable) {
        this(bl, 3, string);
        this.err = throwable;
    }

    public LogAlert(boolean bl, int n, String string, Throwable throwable) {
        this(bl, n, string);
        this.err = throwable;
    }

    public LogAlert(Object object, boolean bl, String string, Throwable throwable) {
        this(bl, string, throwable);
        this.relatedTo = new Object[]{object};
    }

    public int getGivenTimeoutSecs() {
        return this.timeoutSecs;
    }

    public String getText() {
        return this.text;
    }

    public Throwable getError() {
        return this.err;
    }

    public int getType() {
        switch (this.entryType) {
            case 0: {
                return 1;
            }
            case 3: {
                return 3;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    public Object[] getContext() {
        if (this.relatedTo == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < this.relatedTo.length; ++i) {
            arrayList.add(PluginCoreUtils.convert(this.relatedTo[i], false));
        }
        return arrayList.toArray();
    }

    public int getTimeoutSecs() {
        if (this.timeoutSecs != -1) {
            return this.timeoutSecs;
        }
        return COConfigurationManager.getIntParameter("Message Popup Autoclose in Seconds");
    }

    public String getPlainText() {
        return GeneralUtils.stripOutHyperlinks(this.text);
    }
}

