/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.logging;

import java.io.PrintStream;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.impl.FileLogging;
import org.gudy.azureus2.core3.logging.impl.LoggerImpl;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;

public class Logger {
    private static final LogIDs LOGID = LogIDs.LOGGER;
    private static LoggerImpl loggerImpl = null;
    private static FileLogging fileLogging = new FileLogging();

    public static boolean isEnabled() {
        return loggerImpl.isEnabled();
    }

    public static void log(LogEvent logEvent) {
        loggerImpl.log(logEvent);
    }

    public static void log(LogAlert logAlert) {
        loggerImpl.log(logAlert);
    }

    public static void logTextResource(LogEvent logEvent) {
        loggerImpl.logTextResource(logEvent);
    }

    public static void logTextResource(LogEvent logEvent, String[] stringArray) {
        loggerImpl.logTextResource(logEvent, stringArray);
    }

    public static void logTextResource(LogAlert logAlert) {
        loggerImpl.logTextResource(logAlert);
    }

    public static void logTextResource(LogAlert logAlert, String[] stringArray) {
        loggerImpl.logTextResource(logAlert, stringArray);
    }

    public static void doRedirects() {
        loggerImpl.doRedirects();
    }

    public static void addListener(ILogEventListener iLogEventListener) {
        loggerImpl.addListener(iLogEventListener);
    }

    public static void addListener(ILogAlertListener iLogAlertListener) {
        loggerImpl.addListener(iLogAlertListener);
    }

    public static void removeListener(ILogEventListener iLogEventListener) {
        loggerImpl.removeListener(iLogEventListener);
    }

    public static void removeListener(ILogAlertListener iLogAlertListener) {
        loggerImpl.removeListener(iLogAlertListener);
    }

    public static PrintStream getOldStdErr() {
        return loggerImpl.getOldStdErr();
    }

    public static FileLogging getFileLoggingInstance() {
        return fileLogging;
    }

    public static void allowLoggingToStdErr(boolean bl) {
        loggerImpl.allowLoggingToStdErr(bl);
    }

    static {
        try {
            loggerImpl = new LoggerImpl();
            loggerImpl.init();
            fileLogging.initialize();
            if (loggerImpl.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "**** Logging starts: " + Constants.APP_NAME + " " + "4.3.0.4" + " ****"));
                Logger.log(new LogEvent(LOGID, "java.home=" + System.getProperty("java.home")));
                Logger.log(new LogEvent(LOGID, "java.version=" + System.getProperty("java.version")));
                Logger.log(new LogEvent(LOGID, "os=" + System.getProperty("os.arch") + "/" + System.getProperty("os.name") + "/" + System.getProperty("os.version")));
                Logger.log(new LogEvent(LOGID, "user.dir=" + System.getProperty("user.dir")));
                Logger.log(new LogEvent(LOGID, "user.home=" + System.getProperty("user.home")));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Debug.out("Error initializing Logger", throwable);
        }
    }
}

