/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.impl;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.SystemTime;

public class PEPeerStatsImpl
implements PEPeerStats {
    private PEPeer owner;
    private long total_data_bytes_received = 0L;
    private long total_protocol_bytes_received = 0L;
    private final Average data_receive_speed = Average.getInstance(1000, 10);
    private final Average protocol_receive_speed = Average.getInstance(1000, 10);
    private long total_data_bytes_sent = 0L;
    private long total_protocol_bytes_sent = 0L;
    private final Average data_send_speed = Average.getInstance(1000, 5);
    private final Average protocol_send_speed = Average.getInstance(1000, 5);
    private final Average receive_speed_for_choking = Average.getInstance(1000, 20);
    private final Average estimated_download_speed = Average.getInstance(5000, 100);
    private final Average estimated_upload_speed = Average.getInstance(3000, 60);
    private long total_bytes_discarded = 0L;
    private long total_bytes_downloaded = 0L;
    private long disk_read_bytes = 0L;
    private int disk_read_count = 0;
    private int disk_aggregated_read_count = 0;
    private long last_new_piece_time;

    public PEPeerStatsImpl(PEPeer pEPeer) {
        this.owner = pEPeer;
    }

    public PEPeer getPeer() {
        return this.owner;
    }

    public void setPeer(PEPeer pEPeer) {
        this.owner = pEPeer;
    }

    public void dataBytesSent(int n) {
        this.total_data_bytes_sent += (long)n;
        this.data_send_speed.addValue(n);
    }

    public void protocolBytesSent(int n) {
        this.total_protocol_bytes_sent += (long)n;
        this.protocol_send_speed.addValue(n);
    }

    public void dataBytesReceived(int n) {
        this.total_data_bytes_received += (long)n;
        this.data_receive_speed.addValue(n);
        this.receive_speed_for_choking.addValue(n);
    }

    public void protocolBytesReceived(int n) {
        this.total_protocol_bytes_received += (long)n;
        this.protocol_receive_speed.addValue(n);
    }

    public void bytesDiscarded(int n) {
        this.total_bytes_discarded += (long)n;
    }

    public void hasNewPiece(int n) {
        this.total_bytes_downloaded += (long)n;
        if (this.owner.getTimeSinceConnectionEstablished() > 5000L) {
            this.estimated_download_speed.addValue(n);
            this.last_new_piece_time = SystemTime.getCurrentTime();
        }
    }

    public long getEstimatedSecondsToCompletion() {
        long l;
        long l2;
        long l3 = this.owner.getBytesRemaining();
        if (l3 == 0L) {
            return 0L;
        }
        long l4 = this.estimated_download_speed.getAverage();
        if (l4 < (l2 = this.getDataSendRate())) {
            l4 = l2;
        }
        if (l4 == 0L) {
            return Long.MAX_VALUE;
        }
        if (this.last_new_piece_time > 0L) {
            l = (SystemTime.getCurrentTime() - this.last_new_piece_time) / 1000L;
            l3 -= l * l4;
        }
        if ((l = l3 / l4) <= 0L) {
            l = 1L;
        }
        return l;
    }

    public void statisticalSentPiece(int n) {
        this.estimated_upload_speed.addValue(n);
    }

    public long getDataReceiveRate() {
        return this.data_receive_speed.getAverage();
    }

    public long getProtocolReceiveRate() {
        return this.protocol_receive_speed.getAverage();
    }

    public long getDataSendRate() {
        return this.data_send_speed.getAverage();
    }

    public long getProtocolSendRate() {
        return this.protocol_send_speed.getAverage();
    }

    public long getSmoothDataReceiveRate() {
        return this.receive_speed_for_choking.getAverage();
    }

    public long getTotalBytesDiscarded() {
        return this.total_bytes_discarded;
    }

    public long getTotalBytesDownloadedByPeer() {
        return this.total_bytes_downloaded;
    }

    public long getEstimatedDownloadRateOfPeer() {
        return this.estimated_download_speed.getAverage();
    }

    public long getEstimatedUploadRateOfPeer() {
        return this.estimated_upload_speed.getAverage();
    }

    public long getTotalDataBytesReceived() {
        return this.total_data_bytes_received;
    }

    public long getTotalProtocolBytesReceived() {
        return this.total_protocol_bytes_received;
    }

    public long getTotalDataBytesSent() {
        return this.total_data_bytes_sent;
    }

    public long getTotalProtocolBytesSent() {
        return this.total_protocol_bytes_sent;
    }

    public void diskReadComplete(long l) {
        this.disk_read_bytes += l;
        ++this.disk_read_count;
        if (l > 0L) {
            ++this.disk_aggregated_read_count;
        }
    }

    public int getTotalDiskReadCount() {
        return this.disk_read_count;
    }

    public int getAggregatedDiskReadCount() {
        return this.disk_aggregated_read_count;
    }

    public long getTotalDiskReadBytes() {
        return this.disk_read_bytes;
    }

    public void setUploadRateLimitBytesPerSecond(int n) {
        this.owner.setUploadRateLimitBytesPerSecond(n);
    }

    public void setDownloadRateLimitBytesPerSecond(int n) {
        this.owner.setDownloadRateLimitBytesPerSecond(n);
    }

    public int getUploadRateLimitBytesPerSecond() {
        return this.owner.getUploadRateLimitBytesPerSecond();
    }

    public int getDownloadRateLimitBytesPerSecond() {
        return this.owner.getDownloadRateLimitBytesPerSecond();
    }
}

