/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.peer.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.peer.util.PeerIdentityDataID;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;

public class PeerIdentityManager {
    private static final boolean MUTLI_CONTROLLERS = COConfigurationManager.getBooleanParameter("peer.multiple.controllers.per.torrent.enable", false);
    private static final AEMonitor class_mon = new AEMonitor("PeerIdentityManager:class");
    private static final Map dataMap = new LightHashMap();
    private static int totalIDs = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PeerIdentityDataID createDataID(byte[] byArray) {
        LightHashMap lightHashMap;
        PeerIdentityDataID peerIdentityDataID = new PeerIdentityDataID(byArray);
        try {
            class_mon.enter();
            lightHashMap = (LightHashMap)dataMap.get(peerIdentityDataID);
            if (lightHashMap == null) {
                lightHashMap = new LightHashMap();
                dataMap.put(peerIdentityDataID, lightHashMap);
            }
            Object var4_3 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            class_mon.exit();
            throw throwable;
        }
        peerIdentityDataID.setPeerMap(lightHashMap);
        return peerIdentityDataID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addIdentity(PeerIdentityDataID peerIdentityDataID, byte[] byArray, int n, String string) {
        block4: {
            PeerIdentity peerIdentity = new PeerIdentity(byArray, n);
            try {
                String string2;
                class_mon.enter();
                HashMap<PeerIdentity, String> hashMap = (HashMap<PeerIdentity, String>)dataMap.get(peerIdentityDataID);
                if (hashMap == null) {
                    hashMap = new HashMap<PeerIdentity, String>();
                    dataMap.put(peerIdentityDataID, hashMap);
                }
                if ((string2 = hashMap.put(peerIdentity, string)) != null) break block4;
                ++totalIDs;
                boolean bl = true;
                Object var9_9 = null;
                class_mon.exit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                class_mon.exit();
                throw throwable;
            }
        }
        boolean bl = false;
        Object var9_10 = null;
        class_mon.exit();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeIdentity(PeerIdentityDataID peerIdentityDataID, byte[] byArray, int n) {
        try {
            class_mon.enter();
            Map map = (Map)dataMap.get(peerIdentityDataID);
            if (map != null) {
                PeerIdentity peerIdentity = new PeerIdentity(byArray, n);
                String string = (String)map.remove(peerIdentity);
                if (string != null) {
                    --totalIDs;
                } else {
                    Debug.out("id not present: id=" + peerIdentity.getString());
                }
            }
            Object var7_6 = null;
            class_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsIdentity(PeerIdentityDataID peerIdentityDataID, byte[] byArray, int n) {
        block3: {
            PeerIdentity peerIdentity = new PeerIdentity(byArray, n);
            try {
                class_mon.enter();
                Map map = (Map)dataMap.get(peerIdentityDataID);
                if (map == null || !map.containsKey(peerIdentity)) break block3;
                boolean bl = true;
                Object var7_6 = null;
                class_mon.exit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                class_mon.exit();
                throw throwable;
            }
        }
        Object var7_7 = null;
        class_mon.exit();
        return false;
    }

    public static int getTotalIdentityCount() {
        return totalIDs;
    }

    public static int getIdentityCount(PeerIdentityDataID peerIdentityDataID) {
        return peerIdentityDataID.getPeerMap().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsIPAddress(PeerIdentityDataID peerIdentityDataID, String string) {
        block3: {
            try {
                class_mon.enter();
                Map map = (Map)dataMap.get(peerIdentityDataID);
                if (map == null || !map.containsValue(string)) break block3;
                boolean bl = true;
                Object var5_4 = null;
                class_mon.exit();
                return bl;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                class_mon.exit();
                throw throwable;
            }
        }
        Object var5_5 = null;
        class_mon.exit();
        return false;
    }

    private static class PeerIdentity {
        private final byte[] id;
        private final short port;
        private final int hashcode;

        private PeerIdentity(byte[] byArray, int n) {
            this.id = byArray;
            this.port = (short)n;
            this.hashcode = new String(this.id).hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object != null && object instanceof PeerIdentity) {
                PeerIdentity peerIdentity = (PeerIdentity)object;
                if (MUTLI_CONTROLLERS && this.port != peerIdentity.port) {
                    return false;
                }
                return Arrays.equals(this.id, peerIdentity.id);
            }
            return false;
        }

        public int hashCode() {
            return this.hashcode;
        }

        protected String getString() {
            return ByteFormatter.encodeString(this.id);
        }
    }
}

