/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.security.impl;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.X509V3CertificateGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.gudy.azureus2.core3.security.impl.SESecurityManagerImpl;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SystemTime;

public class SESecurityManagerBC {
    protected static void initialise() {
        Security.addProvider(new BouncyCastleProvider());
    }

    public static Certificate createSelfSignedCertificate(SESecurityManagerImpl sESecurityManagerImpl, String string, String string2, int n) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(n, RandomUtils.SECURE_RANDOM);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        X509V3CertificateGenerator x509V3CertificateGenerator = new X509V3CertificateGenerator();
        x509V3CertificateGenerator.setSignatureAlgorithm("MD5WithRSAEncryption");
        x509V3CertificateGenerator.setSerialNumber(new BigInteger("" + SystemTime.getCurrentTime()));
        X509Name x509Name = new X509Name(true, string2);
        x509V3CertificateGenerator.setIssuerDN(x509Name);
        X509Name x509Name2 = new X509Name(true, string2);
        x509V3CertificateGenerator.setSubjectDN(x509Name2);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, 1);
        x509V3CertificateGenerator.setNotAfter(calendar.getTime());
        x509V3CertificateGenerator.setNotBefore(Calendar.getInstance().getTime());
        x509V3CertificateGenerator.setPublicKey(keyPair.getPublic());
        X509Certificate x509Certificate = x509V3CertificateGenerator.generateX509Certificate(keyPair.getPrivate());
        Certificate[] certificateArray = new Certificate[]{x509Certificate};
        sESecurityManagerImpl.addCertToKeyStore(string, keyPair.getPrivate(), certificateArray);
        return x509Certificate;
    }
}

