/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentCreator;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentProgressListener;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentCreatorImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileHasher;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileHasherListener;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TOTorrentCreateImpl
extends TOTorrentImpl
implements TOTorrentFileHasherListener {
    protected File torrent_base;
    protected long piece_length;
    protected TOTorrentFileHasher file_hasher;
    protected long total_file_size = -1L;
    protected long total_file_count = 0L;
    protected long piece_count;
    protected boolean add_other_hashes;
    protected List progress_listeners = new ArrayList();
    protected int reported_progress;
    protected Set ignore_set = new HashSet();
    protected boolean cancelled;

    public static TOTorrentCreator create(File file, URL uRL, boolean bl, long l) throws TOTorrentException {
        TOTorrentCreateImpl tOTorrentCreateImpl = new TOTorrentCreateImpl(file, uRL, bl, l);
        return new TOTorrentCreatorImpl(tOTorrentCreateImpl);
    }

    public static TOTorrentCreator create(File file, URL uRL, boolean bl, long l, long l2, long l3, long l4) throws TOTorrentException {
        TOTorrentCreateImpl tOTorrentCreateImpl = new TOTorrentCreateImpl(file, uRL, bl, l, l2, l3, l4);
        return new TOTorrentCreatorImpl(tOTorrentCreateImpl);
    }

    protected TOTorrentCreateImpl(File file, URL uRL, boolean bl, long l) throws TOTorrentException {
        super(file.getName(), uRL, file.isFile());
        this.torrent_base = file;
        this.piece_length = l;
        this.add_other_hashes = bl;
    }

    protected TOTorrentCreateImpl(File file, URL uRL, boolean bl, long l, long l2, long l3, long l4) throws TOTorrentException {
        super(file.getName(), uRL, file.isFile());
        this.torrent_base = file;
        this.add_other_hashes = bl;
        long l5 = this.calculateTotalFileSize(file);
        this.piece_length = TOTorrentCreateImpl.getComputedPieceSize(l5, l, l2, l3, l4);
    }

    protected void create() throws TOTorrentException {
        this.constructFixed(this.torrent_base, this.piece_length);
    }

    protected void constructFixed(File file, long l) throws TOTorrentException {
        Object[] objectArray;
        int n;
        this.setIgnoreList();
        this.setCreationDate(SystemTime.getCurrentTime() / 1000L);
        this.setCreatedBy("Azureus/4.3.0.4");
        this.setPieceLength(l);
        this.report("Torrent.create.progress.piecelength", l);
        this.piece_count = this.calculateNumberOfPieces(file, l);
        if (this.piece_count == 0L) {
            throw new TOTorrentException("TOTorrentCreate: specified files have zero total length", 2);
        }
        this.report("Torrent.create.progress.hashing");
        for (n = 0; n < this.progress_listeners.size(); n += 1) {
            ((TOTorrentProgressListener)this.progress_listeners.get(n)).reportProgress(0);
        }
        n = this.add_other_hashes && !this.getSimpleTorrent() ? 1 : 0;
        this.file_hasher = new TOTorrentFileHasher(this.add_other_hashes, n != 0, (int)l, this.progress_listeners.size() == 0 ? null : this);
        if (this.cancelled) {
            throw new TOTorrentException("TOTorrentCreate: operation cancelled", 9);
        }
        if (this.getSimpleTorrent()) {
            long l2 = this.file_hasher.add(file);
            this.setFiles(new TOTorrentFileImpl[]{new TOTorrentFileImpl((TOTorrent)this, 0L, l2, new byte[][]{this.getName()})});
            this.setPieces(this.file_hasher.getPieces());
        } else {
            Vector vector = new Vector();
            this.processDir(this.file_hasher, file, vector, "");
            objectArray = new TOTorrentFileImpl[vector.size()];
            vector.copyInto(objectArray);
            this.setFiles((TOTorrentFileImpl[])objectArray);
        }
        this.setPieces(this.file_hasher.getPieces());
        if (this.add_other_hashes) {
            byte[] byArray = this.file_hasher.getSHA1Digest();
            objectArray = this.file_hasher.getED2KDigest();
            this.addAdditionalInfoProperty("sha1", byArray);
            this.addAdditionalInfoProperty("ed2k", objectArray);
        }
    }

    protected void processDir(TOTorrentFileHasher tOTorrentFileHasher, File file, Vector vector, String string) throws TOTorrentException {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new TOTorrentException("TOTorrentCreate: directory '" + file.getAbsolutePath() + "' returned error when listing files in it", 1);
        }
        ArrayList<File> arrayList = new ArrayList<File>(Arrays.asList(fileArray));
        Collections.sort(arrayList);
        long l = 0L;
        for (int i = 0; i < arrayList.size(); ++i) {
            File file2 = (File)arrayList.get(i);
            String string2 = file2.getName();
            if (string2.equals(".") || string2.equals("..")) continue;
            if (file2.isDirectory()) {
                if (string.length() > 0) {
                    string2 = string + File.separator + string2;
                }
                this.processDir(tOTorrentFileHasher, file2, vector, string2);
                continue;
            }
            if (this.ignoreFile(string2)) continue;
            if (string.length() > 0) {
                string2 = string + File.separator + string2;
            }
            long l2 = tOTorrentFileHasher.add(file2);
            TOTorrentFileImpl tOTorrentFileImpl = new TOTorrentFileImpl((TOTorrent)this, l, l2, string2);
            l += l2;
            if (this.add_other_hashes) {
                byte[] byArray = tOTorrentFileHasher.getPerFileED2KDigest();
                byte[] byArray2 = tOTorrentFileHasher.getPerFileSHA1Digest();
                tOTorrentFileImpl.setAdditionalProperty("sha1", byArray2);
                tOTorrentFileImpl.setAdditionalProperty("ed2k", byArray);
            }
            vector.addElement(tOTorrentFileImpl);
        }
    }

    public void pieceHashed(int n) {
        for (int i = 0; i < this.progress_listeners.size(); ++i) {
            int n2 = (int)((long)(n * 100) / this.piece_count);
            if (n2 == this.reported_progress) continue;
            this.reported_progress = n2;
            ((TOTorrentProgressListener)this.progress_listeners.get(i)).reportProgress(this.reported_progress);
        }
    }

    protected long calculateNumberOfPieces(File file, long l) throws TOTorrentException {
        long l2 = TOTorrentCreateImpl.getPieceCount(this.calculateTotalFileSize(file), l);
        this.report("Torrent.create.progress.piececount", "" + l2);
        return l2;
    }

    protected long calculateTotalFileSize(File file) throws TOTorrentException {
        if (this.total_file_size == -1L) {
            this.total_file_size = this.getTotalFileSize(file);
        }
        return this.total_file_size;
    }

    protected long getTotalFileSize(File file) throws TOTorrentException {
        this.report("Torrent.create.progress.parsingfiles");
        long l = this.getTotalFileSizeSupport(file);
        this.report("Torrent.create.progress.totalfilesize", l);
        this.report("Torrent.create.progress.totalfilecount", "" + this.total_file_count);
        return l;
    }

    protected long getTotalFileSizeSupport(File file) throws TOTorrentException {
        String string = file.getName();
        if (string.equals(".") || string.equals("..")) {
            return 0L;
        }
        if (!file.exists()) {
            throw new TOTorrentException("TOTorrentCreate: file '" + file.getName() + "' doesn't exist", 1);
        }
        if (file.isFile()) {
            if (!this.ignoreFile(string)) {
                ++this.total_file_count;
                return file.length();
            }
            return 0L;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new TOTorrentException("TOTorrentCreate: directory '" + file.getAbsolutePath() + "' returned error when listing files in it", 1);
        }
        long l = 0L;
        for (int i = 0; i < fileArray.length; ++i) {
            l += this.getTotalFileSizeSupport(fileArray[i]);
        }
        return l;
    }

    protected void report(String string) {
        this.report(string, null);
    }

    protected void report(String string, long l) {
        if (this.progress_listeners.size() > 0) {
            this.report(string, DisplayFormatters.formatByteCountToKiBEtc(l));
        }
    }

    protected void report(String string, String string2) {
        if (this.progress_listeners.size() > 0) {
            String string3 = MessageText.getString(string);
            for (int i = 0; i < this.progress_listeners.size(); ++i) {
                ((TOTorrentProgressListener)this.progress_listeners.get(i)).reportCurrentTask(string3 + (string2 == null ? "" : string2));
            }
        }
    }

    protected static long getTorrentDataSizeFromFileOrDirSupport(File file) {
        String string = file.getName();
        if (string.equals(".") || string.equals("..")) {
            return 0L;
        }
        if (!file.exists()) {
            return 0L;
        }
        if (file.isFile()) {
            return file.length();
        }
        File[] fileArray = file.listFiles();
        long l = 0L;
        for (int i = 0; i < fileArray.length; ++i) {
            l += TOTorrentCreateImpl.getTorrentDataSizeFromFileOrDirSupport(fileArray[i]);
        }
        return l;
    }

    public static long getTorrentDataSizeFromFileOrDir(File file) {
        return TOTorrentCreateImpl.getTorrentDataSizeFromFileOrDirSupport(file);
    }

    public static long getComputedPieceSize(long l, long l2, long l3, long l4, long l5) {
        long l6 = -1L;
        for (long i = l2; i <= l3; i <<= 1) {
            long l7 = l / i;
            if (l7 > l5) continue;
            l6 = i;
            break;
        }
        if (l6 == -1L) {
            l6 = l3;
        }
        return l6;
    }

    public static long getPieceCount(long l, long l2) {
        return (l + (l2 - 1L)) / l2;
    }

    protected void setIgnoreList() {
        try {
            this.ignore_set = TorrentUtils.getIgnoreSet();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return;
        }
    }

    protected boolean ignoreFile(String string) {
        if (this.ignore_set.contains(string.toLowerCase())) {
            this.report("Torrent.create.progress.ignoringfile", " '" + string + "'");
            return true;
        }
        return false;
    }

    protected void cancel() {
        if (!this.cancelled) {
            this.report("Torrent.create.progress.cancelled");
            this.cancelled = true;
            if (this.file_hasher != null) {
                this.file_hasher.cancel();
            }
        }
    }

    protected void addListener(TOTorrentProgressListener tOTorrentProgressListener) {
        this.progress_listeners.add(tOTorrentProgressListener);
    }

    protected void removeListener(TOTorrentProgressListener tOTorrentProgressListener) {
        this.progress_listeners.remove(tOTorrentProgressListener);
    }
}

