/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileHasherListener;
import org.gudy.azureus2.core3.util.ED2KHasher;
import org.gudy.azureus2.core3.util.SHA1Hasher;

public class TOTorrentFileHasher {
    protected boolean do_other_per_file_hash;
    protected int piece_length;
    protected Vector pieces = new Vector();
    protected byte[] buffer;
    protected int buffer_pos;
    protected SHA1Hasher overall_sha1_hash;
    protected ED2KHasher overall_ed2k_hash;
    protected byte[] sha1_digest;
    protected byte[] ed2k_digest;
    protected byte[] per_file_sha1_digest;
    protected byte[] per_file_ed2k_digest;
    protected TOTorrentFileHasherListener listener;
    protected boolean cancelled;

    protected TOTorrentFileHasher(boolean bl, boolean bl2, int n, TOTorrentFileHasherListener tOTorrentFileHasherListener) {
        if (bl) {
            this.overall_sha1_hash = new SHA1Hasher();
            this.overall_ed2k_hash = new ED2KHasher();
        }
        this.do_other_per_file_hash = bl2;
        this.piece_length = n;
        this.listener = tOTorrentFileHasherListener;
        this.buffer = new byte[this.piece_length];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long add(File file) throws TOTorrentException {
        long l = 0L;
        InputStream inputStream = null;
        SHA1Hasher sHA1Hasher = null;
        ED2KHasher eD2KHasher = null;
        try {
            try {
                if (this.do_other_per_file_hash) {
                    sHA1Hasher = new SHA1Hasher();
                    eD2KHasher = new ED2KHasher();
                }
                inputStream = new BufferedInputStream(new FileInputStream(file), 65536);
                while (true) {
                    if (this.cancelled) {
                        throw new TOTorrentException("TOTorrentCreate: operation cancelled", 9);
                    }
                    int n = inputStream.read(this.buffer, this.buffer_pos, this.piece_length - this.buffer_pos);
                    if (n <= 0) break;
                    if (this.do_other_per_file_hash) {
                        sHA1Hasher.update(this.buffer, this.buffer_pos, n);
                        eD2KHasher.update(this.buffer, this.buffer_pos, n);
                    }
                    l += (long)n;
                    this.buffer_pos += n;
                    if (this.buffer_pos != this.piece_length) continue;
                    byte[] byArray = new SHA1Hasher().calculateHash(this.buffer);
                    if (this.overall_sha1_hash != null) {
                        this.overall_sha1_hash.update(this.buffer);
                        this.overall_ed2k_hash.update(this.buffer);
                    }
                    this.pieces.add(byArray);
                    if (this.listener != null) {
                        this.listener.pieceHashed(this.pieces.size());
                    }
                    this.buffer_pos = 0;
                }
                if (this.do_other_per_file_hash) {
                    this.per_file_sha1_digest = sHA1Hasher.getDigest();
                    this.per_file_ed2k_digest = eD2KHasher.getDigest();
                }
            }
            catch (TOTorrentException tOTorrentException) {
                throw tOTorrentException;
            }
            catch (Throwable throwable) {
                throw new TOTorrentException("TOTorrentFileHasher: file read fails '" + throwable.toString() + "'", 4);
            }
            Object var10_10 = null;
            if (inputStream == null) return l;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        inputStream.close();
        return l;
    }

    protected byte[] getPerFileSHA1Digest() {
        return this.per_file_sha1_digest;
    }

    protected byte[] getPerFileED2KDigest() {
        return this.per_file_ed2k_digest;
    }

    protected byte[][] getPieces() throws TOTorrentException {
        try {
            Object object;
            if (this.buffer_pos > 0) {
                object = new byte[this.buffer_pos];
                System.arraycopy(this.buffer, 0, object, 0, this.buffer_pos);
                this.pieces.addElement(new SHA1Hasher().calculateHash((byte[])object));
                if (this.overall_sha1_hash != null) {
                    this.overall_sha1_hash.update((byte[])object);
                    this.overall_ed2k_hash.update((byte[])object);
                }
                if (this.listener != null) {
                    this.listener.pieceHashed(this.pieces.size());
                }
                this.buffer_pos = 0;
            }
            if (this.overall_sha1_hash != null && this.sha1_digest == null) {
                this.sha1_digest = this.overall_sha1_hash.getDigest();
                this.ed2k_digest = this.overall_ed2k_hash.getDigest();
            }
            object = new byte[this.pieces.size()][];
            this.pieces.copyInto((Object[])object);
            return object;
        }
        catch (Throwable throwable) {
            throw new TOTorrentException("TOTorrentFileHasher: file read fails '" + throwable.toString() + "'", 4);
        }
    }

    protected byte[] getED2KDigest() throws TOTorrentException {
        if (this.ed2k_digest == null) {
            this.getPieces();
        }
        return this.ed2k_digest;
    }

    protected byte[] getSHA1Digest() throws TOTorrentException {
        if (this.sha1_digest == null) {
            this.getPieces();
        }
        return this.sha1_digest;
    }

    protected void cancel() {
        this.cancelled = true;
    }
}

