/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogRelation;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentAnnounceURLGroupImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentAnnounceURLSetImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentXMLSerialiser;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.StringInterner;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TOTorrentImpl
extends LogRelation
implements TOTorrent {
    protected static final String TK_ANNOUNCE = "announce";
    protected static final String TK_ANNOUNCE_LIST = "announce-list";
    protected static final String TK_COMMENT = "comment";
    protected static final String TK_CREATION_DATE = "creation date";
    protected static final String TK_CREATED_BY = "created by";
    protected static final String TK_INFO = "info";
    protected static final String TK_NAME = "name";
    protected static final String TK_LENGTH = "length";
    protected static final String TK_PATH = "path";
    protected static final String TK_FILES = "files";
    protected static final String TK_PIECE_LENGTH = "piece length";
    protected static final String TK_PIECES = "pieces";
    protected static final String TK_PRIVATE = "private";
    protected static final String TK_NAME_UTF8 = "name.utf-8";
    protected static final String TK_PATH_UTF8 = "path.utf-8";
    protected static final String TK_COMMENT_UTF8 = "comment.utf-8";
    protected static final String TK_WEBSEED_BT = "httpseeds";
    protected static final String TK_WEBSEED_GR = "url-list";
    protected static final String TK_HASH_OVERRIDE = "hash-override";
    protected static final List TK_ADDITIONAL_OK_ATTRS = Arrays.asList("comment.utf-8", "azureus_properties", "httpseeds", "url-list");
    private byte[] torrent_name;
    private byte[] torrent_name_utf8;
    private byte[] comment;
    private URL announce_url;
    private TOTorrentAnnounceURLGroupImpl announce_group = new TOTorrentAnnounceURLGroupImpl(this);
    private long piece_length;
    private byte[][] pieces;
    private int number_of_pieces;
    private byte[] torrent_hash_override;
    private byte[] torrent_hash;
    private HashWrapper torrent_hash_wrapper;
    private boolean simple_torrent;
    private TOTorrentFileImpl[] files;
    private long creation_date;
    private byte[] created_by;
    private Map additional_properties = new LightHashMap(4);
    private Map additional_info_properties = new LightHashMap(4);
    private boolean created;
    private boolean serialising;
    protected AEMonitor this_mon = new AEMonitor("TOTorrent");

    protected TOTorrentImpl() {
    }

    protected TOTorrentImpl(String string, URL uRL, boolean bl) throws TOTorrentException {
        this.created = true;
        try {
            this.torrent_name = string.getBytes("UTF8");
            this.torrent_name_utf8 = this.torrent_name;
            this.setAnnounceURL(uRL);
            this.simple_torrent = bl;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TOTorrentException("Unsupported encoding for '" + string + "'", 7);
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void serialiseToBEncodedFile(File file) throws TOTorrentException {
        FilterOutputStream filterOutputStream;
        block19: {
            File file2;
            boolean bl;
            if (this.created) {
                TorrentUtils.addCreatedTorrent(this);
            }
            byte[] byArray = this.serialiseToByteArray();
            filterOutputStream = null;
            File file3 = file.getParentFile();
            if (file3 == null) {
                throw new TOTorrentException("Path '" + file + "' is invalid", 5);
            }
            if (!file3.isDirectory() && !(bl = FileUtil.mkdirs(file3))) {
                if (!file3.exists()) throw new TOTorrentException("Failed to create directory '" + file3 + "'", 5);
                if (!file3.isDirectory()) {
                    throw new TOTorrentException("Path '" + file + "' is invalid", 5);
                }
            }
            if ((file2 = new File(file3, file.getName() + ".saving")).exists()) {
                if (!file2.delete()) {
                    throw new TOTorrentException("Insufficient permissions to delete '" + file2 + "'", 5);
                }
            } else {
                boolean bl2 = false;
                try {
                    bl2 = file2.createNewFile();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!bl2) {
                    throw new TOTorrentException("Insufficient permissions to write '" + file2 + "'", 5);
                }
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file2, false);
            filterOutputStream = new BufferedOutputStream(fileOutputStream, 8192);
            filterOutputStream.write(byArray);
            ((BufferedOutputStream)filterOutputStream).flush();
            if (!Constants.isCVSVersion()) {
                fileOutputStream.getFD().sync();
            }
            filterOutputStream.close();
            filterOutputStream = null;
            if (file2.length() <= 1L) break block19;
            file.delete();
            file2.renameTo(file);
        }
        Object var9_12 = null;
        if (filterOutputStream == null) return;
        try {
            filterOutputStream.close();
            return;
        }
        catch (IOException iOException) {
            Debug.printStackTrace(iOException);
        }
        return;
        {
            catch (TOTorrentException tOTorrentException) {
                throw tOTorrentException;
            }
            catch (Throwable throwable) {
                throw new TOTorrentException("Failed to serialise torrent: " + Debug.getNestedExceptionMessage(throwable), 5);
            }
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (filterOutputStream == null) throw throwable;
            try {
                filterOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                Debug.printStackTrace(iOException);
            }
            throw throwable;
        }
    }

    protected byte[] serialiseToByteArray() throws TOTorrentException {
        if (this.created) {
            TorrentUtils.addCreatedTorrent(this);
        }
        Map map = this.serialiseToMap();
        try {
            return BEncoder.encode(map);
        }
        catch (IOException iOException) {
            throw new TOTorrentException("Failed to serialise torrent: " + Debug.getNestedExceptionMessage(iOException), 5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map serialiseToMap() throws TOTorrentException {
        Iterator iterator;
        Object object2;
        Cloneable cloneable;
        TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray;
        if (this.created && !this.serialising) {
            try {
                this.serialising = true;
                TorrentUtils.addCreatedTorrent(this);
                tOTorrentAnnounceURLSetArray = null;
                this.serialising = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.serialising = false;
                throw throwable;
            }
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        this.writeStringToMetaData(hashMap, TK_ANNOUNCE, this.announce_url.toString());
        tOTorrentAnnounceURLSetArray = this.announce_group.getAnnounceURLSets();
        if (tOTorrentAnnounceURLSetArray.length > 0) {
            cloneable = new ArrayList();
            for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
                TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = tOTorrentAnnounceURLSetArray[i];
                URL[] uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs();
                if (uRLArray.length == 0) continue;
                object2 = new ArrayList<byte[]>();
                cloneable.add(object2);
                for (int j = 0; j < uRLArray.length; ++j) {
                    object2.add(this.writeStringToMetaData(uRLArray[j].toString()));
                }
            }
            if (cloneable.size() > 0) {
                hashMap.put(TK_ANNOUNCE_LIST, cloneable);
            }
        }
        if (this.comment != null) {
            hashMap.put(TK_COMMENT, this.comment);
        }
        if (this.creation_date != 0L) {
            hashMap.put(TK_CREATION_DATE, new Long(this.creation_date));
        }
        if (this.created_by != null) {
            hashMap.put(TK_CREATED_BY, this.created_by);
        }
        cloneable = new HashMap();
        hashMap.put(TK_INFO, cloneable);
        cloneable.put(TK_PIECE_LENGTH, new Long(this.piece_length));
        if (this.pieces == null) {
            throw new TOTorrentException("Pieces is null", 5);
        }
        byte[] byArray = new byte[this.pieces.length * 20];
        for (int i = 0; i < this.pieces.length; ++i) {
            System.arraycopy(this.pieces[i], 0, byArray, i * 20, 20);
        }
        cloneable.put(TK_PIECES, byArray);
        cloneable.put(TK_NAME, this.torrent_name);
        if (this.torrent_name_utf8 != null) {
            cloneable.put(TK_NAME_UTF8, this.torrent_name_utf8);
        }
        if (this.torrent_hash_override != null) {
            cloneable.put(TK_HASH_OVERRIDE, this.torrent_hash_override);
        }
        if (this.simple_torrent) {
            iterator = this.files[0];
            cloneable.put(TK_LENGTH, new Long(iterator.getLength()));
        } else {
            iterator = new ArrayList();
            cloneable.put(TK_FILES, iterator);
            for (int i = 0; i < this.files.length; ++i) {
                object2 = this.files[i];
                Map map = ((TOTorrentFileImpl)object2).serializeToMap();
                iterator.add((Map)map);
            }
        }
        for (String string : this.additional_info_properties.keySet()) {
            cloneable.put(string, this.additional_info_properties.get(string));
        }
        for (Object object2 : this.additional_properties.keySet()) {
            Object v = this.additional_properties.get(object2);
            if (v == null) continue;
            hashMap.put(object2, v);
        }
        return hashMap;
    }

    public void serialiseToXMLFile(File file) throws TOTorrentException {
        if (this.created) {
            TorrentUtils.addCreatedTorrent(this);
        }
        TOTorrentXMLSerialiser tOTorrentXMLSerialiser = new TOTorrentXMLSerialiser(this);
        tOTorrentXMLSerialiser.serialiseToFile(file);
    }

    public byte[] getName() {
        return this.torrent_name;
    }

    protected void setName(byte[] byArray) {
        this.torrent_name = byArray;
    }

    protected void setNameUTF8(byte[] byArray) {
        this.torrent_name_utf8 = byArray;
    }

    public boolean isSimpleTorrent() {
        return this.simple_torrent;
    }

    public byte[] getComment() {
        return this.comment;
    }

    protected void setComment(byte[] byArray) {
        this.comment = byArray;
    }

    public void setComment(String string) {
        try {
            byte[] byArray = string.getBytes("UTF8");
            this.setComment(byArray);
            this.setAdditionalByteArrayProperty(TK_COMMENT_UTF8, byArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
            this.comment = null;
        }
    }

    public URL getAnnounceURL() {
        return this.announce_url;
    }

    public boolean setAnnounceURL(URL uRL) {
        String string;
        URL uRL2 = this.anonymityTransform(uRL);
        String string2 = uRL2 == null ? "" : uRL2.toString();
        String string3 = string = this.announce_url == null ? "" : this.announce_url.toString();
        if (string2.equals(string)) {
            return false;
        }
        this.announce_url = StringInterner.internURL(uRL2);
        return true;
    }

    public long getCreationDate() {
        return this.creation_date;
    }

    public void setCreationDate(long l) {
        this.creation_date = l;
    }

    public void setCreatedBy(byte[] byArray) {
        this.created_by = byArray;
    }

    protected void setCreatedBy(String string) {
        try {
            this.setCreatedBy(string.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
            this.created_by = null;
        }
    }

    public byte[] getCreatedBy() {
        return this.created_by;
    }

    public boolean isCreated() {
        return this.created;
    }

    public byte[] getHash() throws TOTorrentException {
        if (this.torrent_hash == null) {
            Map map = this.serialiseToMap();
            Map map2 = (Map)map.get(TK_INFO);
            this.setHashFromInfo(map2);
        }
        return this.torrent_hash;
    }

    public HashWrapper getHashWrapper() throws TOTorrentException {
        if (this.torrent_hash_wrapper == null) {
            this.getHash();
        }
        return this.torrent_hash_wrapper;
    }

    public boolean hasSameHashAs(TOTorrent tOTorrent) {
        try {
            byte[] byArray = tOTorrent.getHash();
            return Arrays.equals(this.getHash(), byArray);
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return false;
        }
    }

    protected void setHashFromInfo(Map map) throws TOTorrentException {
        try {
            if (this.torrent_hash_override == null) {
                SHA1Hasher sHA1Hasher = new SHA1Hasher();
                this.torrent_hash = sHA1Hasher.calculateHash(BEncoder.encode(map));
            } else {
                this.torrent_hash = this.torrent_hash_override;
            }
            this.torrent_hash_wrapper = new HashWrapper(this.torrent_hash);
        }
        catch (Throwable throwable) {
            throw new TOTorrentException("Failed to calculate hash: " + Debug.getNestedExceptionMessage(throwable), 8);
        }
    }

    public void setHashOverride(byte[] byArray) throws TOTorrentException {
        if (this.torrent_hash_override != null) {
            if (Arrays.equals(byArray, this.torrent_hash_override)) {
                return;
            }
            throw new TOTorrentException("Hash override can only be set once", 8);
        }
        if (!TorrentUtils.isDecentralised(this.announce_url)) {
            throw new TOTorrentException("Hash override can only be set on decentralised torrents", 8);
        }
        this.torrent_hash_override = byArray;
        this.torrent_hash = null;
        this.getHash();
    }

    protected byte[] getHashOverride() {
        return this.torrent_hash_override;
    }

    public void setPrivate(boolean bl) throws TOTorrentException {
        this.additional_info_properties.put(TK_PRIVATE, new Long(bl ? 1L : 0L));
        this.torrent_hash = null;
        this.getHash();
    }

    public boolean getPrivate() {
        Object v = this.additional_info_properties.get(TK_PRIVATE);
        if (v instanceof Long) {
            return ((Long)v).intValue() != 0;
        }
        return false;
    }

    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return this.announce_group;
    }

    protected void addTorrentAnnounceURLSet(URL[] uRLArray) {
        this.announce_group.addSet(new TOTorrentAnnounceURLSetImpl(this, uRLArray));
    }

    public long getSize() {
        long l = 0L;
        for (int i = 0; i < this.files.length; ++i) {
            l += this.files[i].getLength();
        }
        return l;
    }

    public long getPieceLength() {
        return this.piece_length;
    }

    protected void setPieceLength(long l) {
        this.piece_length = l;
    }

    public int getNumberOfPieces() {
        if (this.number_of_pieces == 0) {
            this.number_of_pieces = (int)((this.getSize() + (this.piece_length - 1L)) / this.piece_length);
        }
        return this.number_of_pieces;
    }

    public byte[][] getPieces() {
        return this.pieces;
    }

    public void setPieces(byte[][] byArray) {
        this.pieces = byArray;
    }

    public TOTorrentFile[] getFiles() {
        return this.files;
    }

    protected void setFiles(TOTorrentFileImpl[] tOTorrentFileImplArray) {
        this.files = tOTorrentFileImplArray;
    }

    protected boolean getSimpleTorrent() {
        return this.simple_torrent;
    }

    protected void setSimpleTorrent(boolean bl) {
        this.simple_torrent = bl;
    }

    protected Map getAdditionalProperties() {
        return this.additional_properties;
    }

    public void setAdditionalStringProperty(String string, String string2) {
        try {
            this.setAdditionalByteArrayProperty(string, this.writeStringToMetaData(string2));
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
        }
    }

    public String getAdditionalStringProperty(String string) {
        try {
            return this.readStringFromMetaData(this.getAdditionalByteArrayProperty(string));
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return null;
        }
    }

    public void setAdditionalByteArrayProperty(String string, byte[] byArray) {
        this.additional_properties.put(string, byArray);
    }

    public void setAdditionalProperty(String string, Object object) {
        if (object instanceof String) {
            this.setAdditionalStringProperty(string, (String)object);
        } else {
            this.additional_properties.put(string, object);
        }
    }

    public byte[] getAdditionalByteArrayProperty(String string) {
        Object v = this.additional_properties.get(string);
        if (v instanceof byte[]) {
            return (byte[])v;
        }
        return null;
    }

    public void setAdditionalLongProperty(String string, Long l) {
        this.additional_properties.put(string, l);
    }

    public Long getAdditionalLongProperty(String string) {
        Object v = this.additional_properties.get(string);
        if (v instanceof Long) {
            return (Long)v;
        }
        return null;
    }

    public void setAdditionalListProperty(String string, List list) {
        this.additional_properties.put(string, list);
    }

    public List getAdditionalListProperty(String string) {
        Object v = this.additional_properties.get(string);
        if (v instanceof List) {
            return (List)v;
        }
        return null;
    }

    public void setAdditionalMapProperty(String string, Map map) {
        this.additional_properties.put(string, map);
    }

    public Map getAdditionalMapProperty(String string) {
        Object v = this.additional_properties.get(string);
        if (v instanceof Map) {
            return (Map)v;
        }
        return null;
    }

    public Object getAdditionalProperty(String string) {
        return this.additional_properties.get(string);
    }

    public void removeAdditionalProperty(String string) {
        this.additional_properties.remove(string);
    }

    public void removeAdditionalProperties() {
        HashMap hashMap = new HashMap();
        for (String string : this.additional_properties.keySet()) {
            if (!TK_ADDITIONAL_OK_ATTRS.contains(string)) continue;
            hashMap.put(string, this.additional_properties.get(string));
        }
        this.additional_properties = hashMap;
    }

    protected void addAdditionalProperty(String string, Object object) {
        this.additional_properties.put(string, object);
    }

    protected void addAdditionalInfoProperty(String string, Object object) {
        this.additional_info_properties.put(string, object);
    }

    protected Map getAdditionalInfoProperties() {
        return this.additional_info_properties;
    }

    protected String readStringFromMetaData(Map map, String string) throws TOTorrentException {
        Object v = map.get(string);
        if (v instanceof byte[]) {
            return this.readStringFromMetaData((byte[])v);
        }
        return null;
    }

    protected String readStringFromMetaData(byte[] byArray) throws TOTorrentException {
        try {
            if (byArray == null) {
                return null;
            }
            return new String(byArray, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TOTorrentException("Unsupported encoding for '" + byArray + "'", 7);
        }
    }

    protected void writeStringToMetaData(Map map, String string, String string2) throws TOTorrentException {
        map.put(string, this.writeStringToMetaData(string2));
    }

    protected byte[] writeStringToMetaData(String string) throws TOTorrentException {
        try {
            return string.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new TOTorrentException("Unsupported encoding for '" + string + "'", 7);
        }
    }

    protected URL anonymityTransform(URL uRL) {
        return uRL;
    }

    public void print() {
        try {
            Object object;
            byte[] byArray = this.getHash();
            System.out.println("name = " + this.torrent_name);
            System.out.println("announce url = " + this.announce_url);
            System.out.println("announce group = " + this.announce_group.getAnnounceURLSets().length);
            System.out.println("creation date = " + this.creation_date);
            System.out.println("creation by = " + this.created_by);
            System.out.println("comment = " + this.comment);
            System.out.println("hash = " + ByteFormatter.nicePrint(byArray));
            System.out.println("piece length = " + this.getPieceLength());
            System.out.println("pieces = " + this.getNumberOfPieces());
            for (Object object2 : this.additional_info_properties.keySet()) {
                Object object3 = this.additional_info_properties.get(object2);
                try {
                    System.out.println("info prop '" + (String)object2 + "' = '" + (object3 instanceof byte[] ? new String((byte[])object3, "UTF8") : object3.toString()) + "'");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println("info prop '" + (String)object2 + "' = unsupported encoding!!!!");
                }
            }
            for (Object object3 : this.additional_properties.keySet()) {
                object = this.additional_properties.get(object3);
                try {
                    System.out.println("prop '" + (String)object3 + "' = '" + (object instanceof byte[] ? new String((byte[])object, "UTF8") : object.toString()) + "'");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    System.out.println("prop '" + (String)object3 + "' = unsupported encoding!!!!");
                }
            }
            if (this.pieces == null) {
                System.out.println("\tpieces = null");
            } else {
                for (int i = 0; i < this.pieces.length; ++i) {
                    System.out.println("\t" + ByteFormatter.nicePrint(this.pieces[i]));
                }
            }
            for (int i = 0; i < this.files.length; ++i) {
                object = this.files[i].getPathComponents();
                String string = "";
                for (int j = 0; j < ((Object)object).length; ++j) {
                    try {
                        string = string + (j == 0 ? "" : File.separator) + new String((byte[])object[j], "UTF8");
                        continue;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        System.out.println("file - unsupported encoding!!!!");
                    }
                }
                System.out.println("\t" + string + " (" + this.files[i].getLength() + ")");
            }
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
        }
    }

    public AEMonitor getMonitor() {
        return this.this_mon;
    }

    public String getRelationText() {
        return "Torrent: '" + new String(this.torrent_name) + "'";
    }

    public Object[] getQueryableInterfaces() {
        try {
            return new Object[]{AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManager(this)};
        }
        catch (Exception exception) {
            return null;
        }
    }
}

