/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.torrent.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentFileImpl;
import org.gudy.azureus2.core3.torrent.impl.TOTorrentImpl;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;

public class TOTorrentXMLSerialiser
extends XUXmlWriter {
    protected TOTorrentImpl torrent;

    protected TOTorrentXMLSerialiser(TOTorrentImpl tOTorrentImpl) {
        this.torrent = tOTorrentImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void serialiseToFile(File file) throws TOTorrentException {
        this.resetIndent();
        try {
            try {
                this.setOutputStream(new FileOutputStream(file));
                this.writeRoot();
            }
            catch (IOException iOException) {
                throw new TOTorrentException("TOTorrentXMLSerialiser: file write fails: " + iOException.toString(), 5);
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            try {
                this.closeOutputStream();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throw new TOTorrentException("TOTorrentXMLSerialiser: file close fails: " + throwable2.toString(), 5);
            }
        }
        try {}
        catch (Throwable throwable) {
            throw new TOTorrentException("TOTorrentXMLSerialiser: file close fails: " + throwable.toString(), 5);
        }
        this.closeOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeRoot() throws TOTorrentException {
        this.writeLineRaw("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.writeLineRaw("<tor:TORRENT");
        this.writeLineRaw("\txmlns:tor=\"http://azureus.sourceforge.net/files\"");
        this.writeLineRaw("\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        this.writeLineRaw("\txsi:schemaLocation=\"http://azureus.sourceforge.net/files http://azureus.sourceforge.net/files/torrent.xsd\">");
        try {
            byte[] byArray;
            long l;
            byte[] byArray2;
            Map map;
            this.indent();
            this.writeTag("ANNOUNCE_URL", this.torrent.getAnnounceURL().toString());
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = this.torrent.getAnnounceURLGroup().getAnnounceURLSets();
            if (tOTorrentAnnounceURLSetArray.length > 0) {
                this.writeLineRaw("<ANNOUNCE_LIST>");
                try {
                    this.indent();
                    for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
                        TOTorrentAnnounceURLSet tOTorrentAnnounceURLSet = tOTorrentAnnounceURLSetArray[i];
                        URL[] uRLArray = tOTorrentAnnounceURLSet.getAnnounceURLs();
                        this.writeLineRaw("<ANNOUNCE_ENTRY>");
                        try {
                            this.indent();
                            for (int j = 0; j < uRLArray.length; ++j) {
                                this.writeTag("ANNOUNCE_URL", uRLArray[j].toString());
                            }
                            map = null;
                        }
                        catch (Throwable throwable) {
                            map = null;
                            this.exdent();
                            throw throwable;
                        }
                        this.exdent();
                        this.writeLineRaw("</ANNOUNCE_ENTRY>");
                    }
                    String string = null;
                }
                catch (Throwable throwable) {
                    Object var9_13 = null;
                    this.exdent();
                    throw throwable;
                }
                this.exdent();
                this.writeLineRaw("</ANNOUNCE_LIST>");
            }
            if ((byArray2 = this.torrent.getComment()) != null) {
                this.writeLocalisableTag("COMMENT", byArray2);
            }
            if ((l = this.torrent.getCreationDate()) != 0L) {
                this.writeTag("CREATION_DATE", l);
            }
            if ((byArray = this.torrent.getCreatedBy()) != null) {
                this.writeLocalisableTag("CREATED_BY", byArray);
            }
            this.writeTag("TORRENT_HASH", this.torrent.getHash());
            byte[] byArray3 = this.torrent.getHashOverride();
            if (byArray3 != null) {
                this.writeTag("TORRENT_HASH_OVERRIDE", byArray3);
            }
            this.writeInfo();
            map = this.torrent.getAdditionalProperties();
            for (String string : map.keySet()) {
                this.writeGenericMapEntry(string, map.get(string));
            }
            Object var11_16 = null;
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            this.exdent();
            throw throwable;
        }
        this.exdent();
        this.writeLineRaw("</tor:TORRENT>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeInfo() throws TOTorrentException {
        this.writeLineRaw("<INFO>");
        try {
            Object object;
            Object object2;
            this.indent();
            this.writeLocalisableTag("NAME", this.torrent.getName());
            this.writeTag("PIECE_LENGTH", this.torrent.getPieceLength());
            TOTorrentFileImpl[] tOTorrentFileImplArray = (TOTorrentFileImpl[])this.torrent.getFiles();
            if (this.torrent.isSimpleTorrent()) {
                this.writeTag("LENGTH", tOTorrentFileImplArray[0].getLength());
            } else {
                this.writeLineRaw("<FILES>");
                try {
                    this.indent();
                    for (int i = 0; i < tOTorrentFileImplArray.length; ++i) {
                        Object var9_13;
                        this.writeLineRaw("<FILE>");
                        try {
                            Object var7_12;
                            this.indent();
                            TOTorrentFileImpl tOTorrentFileImpl = tOTorrentFileImplArray[i];
                            this.writeTag("LENGTH", tOTorrentFileImpl.getLength());
                            this.writeLineRaw("<PATH>");
                            try {
                                this.indent();
                                object2 = tOTorrentFileImpl.getPathComponents();
                                for (int j = 0; j < ((byte[][])object2).length; ++j) {
                                    this.writeLocalisableTag("COMPONENT", object2[j]);
                                }
                                var7_12 = null;
                            }
                            catch (Throwable throwable) {
                                var7_12 = null;
                                this.exdent();
                                throw throwable;
                            }
                            this.exdent();
                            this.writeLineRaw("</PATH>");
                            object2 = tOTorrentFileImpl.getAdditionalProperties();
                            for (String string : object2.keySet()) {
                                this.writeGenericMapEntry(string, object2.get(string));
                            }
                            var9_13 = null;
                        }
                        catch (Throwable throwable) {
                            var9_13 = null;
                            this.exdent();
                            throw throwable;
                        }
                        this.exdent();
                        this.writeLineRaw("</FILE>");
                    }
                    Object var11_15 = null;
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    this.exdent();
                    throw throwable;
                }
                this.exdent();
                this.writeLineRaw("</FILES>");
            }
            this.writeLineRaw("<PIECES>");
            try {
                this.indent();
                object = this.torrent.getPieces();
                for (int i = 0; i < ((byte[][])object).length; ++i) {
                    this.writeGeneric(object[i]);
                }
                Object var13_18 = null;
            }
            catch (Throwable throwable) {
                Object var13_19 = null;
                this.exdent();
                throw throwable;
            }
            this.exdent();
            this.writeLineRaw("</PIECES>");
            object = this.torrent.getAdditionalInfoProperties();
            Iterator iterator = object.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                this.writeGenericMapEntry((String)object2, object.get(object2));
            }
            Object var15_21 = null;
        }
        catch (Throwable throwable) {
            Object var15_22 = null;
            this.exdent();
            throw throwable;
        }
        this.exdent();
        this.writeLineRaw("</INFO>");
    }
}

