/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;

public abstract class TRTrackerAnnouncerImpl
implements TRTrackerAnnouncer {
    public static final LogIDs LOGID = LogIDs.TRACKER;
    protected static final int LDT_TRACKER_RESPONSE = 1;
    protected static final int LDT_URL_CHANGED = 2;
    protected static final int LDT_URL_REFRESH = 3;
    protected ListenerManager listeners = ListenerManager.createManager("TrackerClient:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object object, int n, Object object2) {
            TRTrackerAnnouncerListener tRTrackerAnnouncerListener = (TRTrackerAnnouncerListener)object;
            if (n == 1) {
                tRTrackerAnnouncerListener.receivedTrackerResponse((TRTrackerAnnouncerResponse)object2);
            } else if (n == 2) {
                Object[] objectArray = (Object[])object2;
                URL uRL = (URL)objectArray[0];
                URL uRL2 = (URL)objectArray[1];
                boolean bl = (Boolean)objectArray[2];
                tRTrackerAnnouncerListener.urlChanged(TRTrackerAnnouncerImpl.this, uRL, uRL2, bl);
            } else {
                tRTrackerAnnouncerListener.urlRefresh();
            }
        }
    });
    private Map tracker_peer_cache = new LinkedHashMap();
    private AEMonitor tracker_peer_cache_mon = new AEMonitor("TRTrackerClientClassic:PC");
    private TOTorrent torrent;

    protected TRTrackerAnnouncerImpl(TOTorrent tOTorrent) {
        this.torrent = tOTorrent;
    }

    public Map getTrackerResponseCache() {
        return this.exportTrackerCache();
    }

    public void setTrackerResponseCache(Map map) {
        int n = this.importTrackerCache(map);
        if (Logger.isEnabled()) {
            Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: imported " + n + " cached peers"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map exportTrackerCache() {
        LightHashMap lightHashMap = new LightHashMap(1);
        ArrayList arrayList = new ArrayList();
        lightHashMap.put("tracker_peers", arrayList);
        try {
            this.tracker_peer_cache_mon.enter();
            for (TRTrackerAnnouncerResponsePeer tRTrackerAnnouncerResponsePeer : this.tracker_peer_cache.values()) {
                int n;
                LightHashMap lightHashMap2 = new LightHashMap();
                lightHashMap2.put("ip", tRTrackerAnnouncerResponsePeer.getAddress().getBytes());
                lightHashMap2.put("src", tRTrackerAnnouncerResponsePeer.getSource().getBytes());
                lightHashMap2.put("port", new Long(tRTrackerAnnouncerResponsePeer.getPort()));
                int n2 = tRTrackerAnnouncerResponsePeer.getUDPPort();
                if (n2 != 0) {
                    lightHashMap2.put("udpport", new Long(n2));
                }
                if ((n = tRTrackerAnnouncerResponsePeer.getHTTPPort()) != 0) {
                    lightHashMap2.put("httpport", new Long(n));
                }
                lightHashMap2.put("prot", new Long(tRTrackerAnnouncerResponsePeer.getProtocol()));
                byte by = tRTrackerAnnouncerResponsePeer.getAZVersion();
                if (by != 1) {
                    lightHashMap2.put("azver", new Long(by));
                }
                lightHashMap2.compactify(0.9f);
                arrayList.add(lightHashMap2);
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: exported " + this.tracker_peer_cache.size() + " cached peers"));
            }
            Object var10_9 = null;
            this.tracker_peer_cache_mon.exit();
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.tracker_peer_cache_mon.exit();
            throw throwable;
        }
        return lightHashMap;
    }

    protected byte[] getAnonymousPeerId(String string, int n) {
        byte[] byArray = new byte[20];
        byArray[0] = 91;
        byArray[1] = 93;
        try {
            byte[] byArray2 = string.getBytes("UTF8");
            int n2 = byArray2.length;
            if (n2 > 18) {
                n2 = 18;
            }
            System.arraycopy(byArray2, 0, byArray, 2, n2);
            int n3 = n;
            for (int i = 2 + n2; i < 20; ++i) {
                byArray[i] = (byte)(n3 & 0xFF);
                n3 >>= 8;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Debug.printStackTrace(unsupportedEncodingException);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int importTrackerCache(Map map) {
        if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
            return 0;
        }
        if (map == null) {
            return 0;
        }
        List list = (List)map.get("tracker_peers");
        if (list == null) {
            return 0;
        }
        try {
            int n;
            this.tracker_peer_cache_mon.enter();
            for (n = 0; n < list.size(); ++n) {
                Map map2 = (Map)list.get(n);
                byte[] byArray = (byte[])map2.get("src");
                String string = byArray == null ? "Tracker" : new String(byArray);
                String string2 = new String((byte[])map2.get("ip"));
                int n2 = ((Long)map2.get("port")).intValue();
                byte[] byArray2 = this.getAnonymousPeerId(string2, n2);
                Long l = (Long)map2.get("prot");
                short s = l == null ? (short)1 : l.shortValue();
                Long l2 = (Long)map2.get("udpport");
                int n3 = l2 == null ? 0 : l2.intValue();
                Long l3 = (Long)map2.get("httpport");
                int n4 = l3 == null ? 0 : l3.intValue();
                Long l4 = (Long)map2.get("azver");
                byte by = l4 == null ? (byte)1 : l4.byteValue();
                TRTrackerAnnouncerResponsePeerImpl tRTrackerAnnouncerResponsePeerImpl = new TRTrackerAnnouncerResponsePeerImpl(string, byArray2, string2, n2, n3, n4, s, by, 0);
                this.tracker_peer_cache.put(tRTrackerAnnouncerResponsePeerImpl.getKey(), tRTrackerAnnouncerResponsePeerImpl);
            }
            n = this.tracker_peer_cache.size();
            {
                Object var20_20 = null;
                this.tracker_peer_cache_mon.exit();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                Object var20_21 = null;
                this.tracker_peer_cache_mon.exit();
                throw throwable;
            }
            catch (Throwable throwable2) {
                Debug.printStackTrace(throwable2);
                return this.tracker_peer_cache.size();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToTrackerCache(TRTrackerAnnouncerResponsePeerImpl[] tRTrackerAnnouncerResponsePeerImplArray) {
        if (!COConfigurationManager.getBooleanParameter("File.save.peers.enable")) {
            return;
        }
        int n = COConfigurationManager.getIntParameter("File.save.peers.max", 512);
        try {
            this.tracker_peer_cache_mon.enter();
            for (int i = 0; i < tRTrackerAnnouncerResponsePeerImplArray.length; ++i) {
                TRTrackerAnnouncerResponsePeerImpl tRTrackerAnnouncerResponsePeerImpl = tRTrackerAnnouncerResponsePeerImplArray[i];
                this.tracker_peer_cache.remove(tRTrackerAnnouncerResponsePeerImpl.getKey());
                this.tracker_peer_cache.put(tRTrackerAnnouncerResponsePeerImpl.getKey(), tRTrackerAnnouncerResponsePeerImpl);
            }
            Iterator iterator = this.tracker_peer_cache.keySet().iterator();
            if (n > 0) {
                while (this.tracker_peer_cache.size() > n) {
                    iterator.next();
                    iterator.remove();
                }
            }
            Object var6_6 = null;
            this.tracker_peer_cache_mon.exit();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.tracker_peer_cache_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromTrackerResponseCache(String string, int n) {
        try {
            this.tracker_peer_cache_mon.enter();
            TRTrackerAnnouncerResponsePeerImpl tRTrackerAnnouncerResponsePeerImpl = new TRTrackerAnnouncerResponsePeerImpl("", new byte[0], string, n, 0, 0, 0, 0, 0);
            if (this.tracker_peer_cache.remove(tRTrackerAnnouncerResponsePeerImpl.getKey()) != null && Logger.isEnabled()) {
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "Explicit removal of peer cache for " + string + ":" + n));
            }
            Object var5_4 = null;
            this.tracker_peer_cache_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.tracker_peer_cache_mon.exit();
            throw throwable;
        }
    }

    public static Map mergeResponseCache(Map map, Map map2) {
        List list;
        if (map == null && map2 == null) {
            return new HashMap();
        }
        if (map == null) {
            return map2;
        }
        if (map2 == null) {
            return map;
        }
        HashMap hashMap = new HashMap();
        ArrayList arrayList = (ArrayList)map.get("tracker_peers");
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        if ((list = (List)map2.get("tracker_peers")) != null) {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "TRTrackerClient: merged peer sets: p1 = " + arrayList.size() + ", p2 = " + list.size()));
            }
            for (int i = 0; i < list.size(); ++i) {
                arrayList.add(list.get(i));
            }
        }
        hashMap.put("tracker_peers", arrayList);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerAnnouncerResponsePeer[] getPeersFromCache(int n) {
        try {
            TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray;
            TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray2;
            this.tracker_peer_cache_mon.enter();
            if (this.tracker_peer_cache.size() <= n) {
                tRTrackerAnnouncerResponsePeerArray2 = new TRTrackerAnnouncerResponsePeerImpl[this.tracker_peer_cache.size()];
                this.tracker_peer_cache.values().toArray(tRTrackerAnnouncerResponsePeerArray2);
            } else {
                int n2;
                tRTrackerAnnouncerResponsePeerArray2 = new TRTrackerAnnouncerResponsePeerImpl[n];
                tRTrackerAnnouncerResponsePeerArray = this.tracker_peer_cache.keySet().iterator();
                for (n2 = 0; n2 < n; ++n2) {
                    String string = (String)tRTrackerAnnouncerResponsePeerArray.next();
                    tRTrackerAnnouncerResponsePeerArray2[n2] = (TRTrackerAnnouncerResponsePeerImpl)this.tracker_peer_cache.get(string);
                    tRTrackerAnnouncerResponsePeerArray.remove();
                }
                for (n2 = 0; n2 < n; ++n2) {
                    this.tracker_peer_cache.put(tRTrackerAnnouncerResponsePeerArray2[n2].getKey(), tRTrackerAnnouncerResponsePeerArray2[n2]);
                }
            }
            if (Logger.isEnabled()) {
                for (int i = 0; i < tRTrackerAnnouncerResponsePeerArray2.length; ++i) {
                    Logger.log(new LogEvent(this.getTorrent(), LOGID, "CACHED PEER: " + ((TRTrackerAnnouncerResponsePeerImpl)tRTrackerAnnouncerResponsePeerArray2[i]).getString()));
                }
                Logger.log(new LogEvent(this.getTorrent(), LOGID, "TRTrackerClient: returned " + tRTrackerAnnouncerResponsePeerArray2.length + " cached peers"));
            }
            tRTrackerAnnouncerResponsePeerArray = tRTrackerAnnouncerResponsePeerArray2;
            Object var7_7 = null;
            this.tracker_peer_cache_mon.exit();
            return tRTrackerAnnouncerResponsePeerArray;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.tracker_peer_cache_mon.exit();
            throw throwable;
        }
    }

    public void addListener(TRTrackerAnnouncerListener tRTrackerAnnouncerListener) {
        this.listeners.addListener(tRTrackerAnnouncerListener);
    }

    public void removeListener(TRTrackerAnnouncerListener tRTrackerAnnouncerListener) {
        this.listeners.removeListener(tRTrackerAnnouncerListener);
    }
}

