/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.util.StringInterner;

public class TRTrackerAnnouncerResponsePeerImpl
implements TRTrackerAnnouncerResponsePeer {
    private String source;
    private byte[] peer_id;
    private String address;
    private short tcp_port;
    private short udp_port;
    private short http_port;
    private short crypto;
    private byte az_version;
    private short up_speed;

    public TRTrackerAnnouncerResponsePeerImpl(String string, byte[] byArray, String string2, int n, int n2, int n3, short s, byte by, int n4) {
        this.source = StringInterner.intern(string);
        this.peer_id = byArray;
        this.address = StringInterner.intern(string2);
        this.tcp_port = (short)n;
        this.udp_port = (short)n2;
        this.http_port = (short)n3;
        this.crypto = s;
        this.az_version = by;
        this.up_speed = (short)n4;
    }

    public String getSource() {
        return this.source;
    }

    public byte[] getPeerID() {
        return this.peer_id;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.tcp_port & 0xFFFF;
    }

    public int getUDPPort() {
        return this.udp_port & 0xFFFF;
    }

    public int getHTTPPort() {
        return this.http_port & 0xFFFF;
    }

    public short getProtocol() {
        return this.crypto;
    }

    public byte getAZVersion() {
        return this.az_version;
    }

    public int getUploadSpeed() {
        return this.up_speed & 0xFFFF;
    }

    protected String getKey() {
        return this.address + ":" + this.tcp_port;
    }

    public String getString() {
        return "ip=" + this.address + (this.tcp_port == 0 ? "" : ",tcp_port=" + this.getPort()) + (this.udp_port == 0 ? "" : ",udp_port=" + this.getUDPPort()) + (this.http_port == 0 ? "" : ",http_port=" + this.getHTTPPort()) + ",prot=" + this.crypto + (this.up_speed == 0 ? "" : ",up=" + this.getUploadSpeed()) + ",ver=" + this.az_version;
    }
}

