/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl;

import java.net.URL;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraper;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperClientResolver;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperListener;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.dht.TRTrackerDHTScraperImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.ListenerManager;
import org.gudy.azureus2.core3.util.ListenerManagerDispatcher;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.plugins.download.DownloadScrapeResult;

public class TRTrackerScraperImpl
implements TRTrackerScraper {
    private static TRTrackerScraperImpl singleton;
    private static AEMonitor class_mon;
    private TRTrackerBTScraperImpl bt_scraper;
    private TRTrackerDHTScraperImpl dht_scraper;
    private TRTrackerScraperClientResolver client_resolver;
    private static final int LDT_SCRAPE_RECEIVED = 1;
    private ListenerManager listeners = ListenerManager.createManager("TrackerScraper:ListenDispatcher", new ListenerManagerDispatcher(){

        public void dispatch(Object object, int n, Object object2) {
            TRTrackerScraperListener tRTrackerScraperListener = (TRTrackerScraperListener)object;
            tRTrackerScraperListener.scrapeReceived((TRTrackerScraperResponse)object2);
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TRTrackerScraperImpl create() {
        try {
            class_mon.enter();
            if (singleton == null) {
                singleton = new TRTrackerScraperImpl();
            }
            TRTrackerScraperImpl tRTrackerScraperImpl = singleton;
            Object var2_1 = null;
            class_mon.exit();
            return tRTrackerScraperImpl;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            class_mon.exit();
            throw throwable;
        }
    }

    protected TRTrackerScraperImpl() {
        this.bt_scraper = TRTrackerBTScraperImpl.create(this);
        this.dht_scraper = TRTrackerDHTScraperImpl.create(this);
    }

    public TRTrackerScraperResponse scrape(TOTorrent tOTorrent) {
        return this.scrape(tOTorrent, false);
    }

    public TRTrackerScraperResponse scrape(TOTorrent tOTorrent, URL uRL) {
        return this.scrape(tOTorrent, uRL, false);
    }

    public TRTrackerScraperResponse scrape(TOTorrent tOTorrent, boolean bl) {
        return this.scrape(tOTorrent, null, bl);
    }

    public void setScrape(TOTorrent tOTorrent, URL uRL, DownloadScrapeResult downloadScrapeResult) {
        if (tOTorrent != null) {
            if (TorrentUtils.isDecentralised(tOTorrent)) {
                this.dht_scraper.setScrape(tOTorrent, uRL, downloadScrapeResult);
            } else {
                this.bt_scraper.setScrape(tOTorrent, uRL, downloadScrapeResult);
            }
        }
    }

    public TRTrackerScraperResponse scrape(TOTorrent tOTorrent, URL uRL, boolean bl) {
        if (tOTorrent == null) {
            return null;
        }
        if (TorrentUtils.isDecentralised(tOTorrent)) {
            return this.dht_scraper.scrape(tOTorrent, uRL, bl);
        }
        return this.bt_scraper.scrape(tOTorrent, uRL, bl);
    }

    public TRTrackerScraperResponse scrape(TRTrackerAnnouncer tRTrackerAnnouncer) {
        TOTorrent tOTorrent = tRTrackerAnnouncer.getTorrent();
        if (TorrentUtils.isDecentralised(tOTorrent)) {
            return this.dht_scraper.scrape(tRTrackerAnnouncer);
        }
        return this.bt_scraper.scrape(tRTrackerAnnouncer);
    }

    public void remove(TOTorrent tOTorrent) {
        if (TorrentUtils.isDecentralised(tOTorrent)) {
            this.dht_scraper.remove(tOTorrent);
        } else {
            this.bt_scraper.remove(tOTorrent);
        }
    }

    public void scrapeReceived(TRTrackerScraperResponse tRTrackerScraperResponse) {
        this.listeners.dispatch(1, tRTrackerScraperResponse);
    }

    public void setClientResolver(TRTrackerScraperClientResolver tRTrackerScraperClientResolver) {
        this.client_resolver = tRTrackerScraperClientResolver;
    }

    public TRTrackerScraperClientResolver getClientResolver() {
        return this.client_resolver;
    }

    public boolean isTorrentDownloading(HashWrapper hashWrapper) {
        if (this.client_resolver == null) {
            return false;
        }
        int n = this.client_resolver.getStatus(hashWrapper);
        return n == 2;
    }

    public boolean isTorrentRunning(HashWrapper hashWrapper) {
        if (this.client_resolver == null) {
            return false;
        }
        int n = this.client_resolver.getStatus(hashWrapper);
        return n == 2 || n == 3;
    }

    public boolean isNetworkEnabled(HashWrapper hashWrapper, URL uRL) {
        if (this.client_resolver == null) {
            return false;
        }
        return this.client_resolver.isNetworkEnabled(hashWrapper, uRL);
    }

    public Object[] getExtensions(HashWrapper hashWrapper) {
        if (this.client_resolver == null) {
            return null;
        }
        return this.client_resolver.getExtensions(hashWrapper);
    }

    public boolean redirectTrackerUrl(HashWrapper hashWrapper, URL uRL, URL uRL2) {
        return this.client_resolver.redirectTrackerUrl(hashWrapper, uRL, uRL2);
    }

    public void addListener(TRTrackerScraperListener tRTrackerScraperListener) {
        this.listeners.addListener(tRTrackerScraperListener);
    }

    public void removeListener(TRTrackerScraperListener tRTrackerScraperListener) {
        this.listeners.removeListener(tRTrackerScraperListener);
    }

    static {
        class_mon = new AEMonitor("TRTrackerScraper");
    }
}

