/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.bt;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTScraperResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TrackerStatus;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TrackerChecker
implements AEDiagnosticsEvidenceGenerator,
SystemTime.ChangeListener,
TimerEventPerformer {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private HashMap trackers;
    private AEMonitor trackers_mon = new AEMonitor("TrackerChecker:trackers");
    private TRTrackerBTScraperImpl scraper;
    private long nextScrapeCheckOn;
    TRTrackerBTScraperResponseImpl oldResponse;

    protected TrackerChecker(TRTrackerBTScraperImpl tRTrackerBTScraperImpl) {
        this.scraper = tRTrackerBTScraperImpl;
        this.trackers = new HashMap();
        if (!COConfigurationManager.getBooleanParameter("Tracker Client Scrape Total Disable")) {
            this.runScrapes();
        }
        AEDiagnostics.addEvidenceGenerator(this);
        SystemTime.registerClockChangeListener(this);
    }

    protected TRTrackerScraperResponseImpl getHashData(TRTrackerAnnouncer tRTrackerAnnouncer) {
        try {
            return this.getHashData(tRTrackerAnnouncer.getTrackerUrl(), tRTrackerAnnouncer.getTorrent().getHashWrapper());
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return null;
        }
    }

    protected TRTrackerScraperResponseImpl getHashData(TOTorrent tOTorrent, URL uRL) {
        try {
            return this.getHashData(uRL == null ? tOTorrent.getAnnounceURL() : uRL, tOTorrent.getHashWrapper());
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TRTrackerScraperResponseImpl getHashData(URL uRL, HashWrapper hashWrapper) {
        if (uRL == null) {
            return null;
        }
        TRTrackerScraperResponseImpl tRTrackerScraperResponseImpl = null;
        String string = uRL.toString();
        TrackerStatus trackerStatus = null;
        try {
            this.trackers_mon.enter();
            trackerStatus = (TrackerStatus)this.trackers.get(string);
            if (trackerStatus != null) {
                tRTrackerScraperResponseImpl = trackerStatus.getHashData(hashWrapper);
            } else {
                trackerStatus = new TrackerStatus(this, this.scraper.getScraper(), uRL);
                this.trackers.put(string, trackerStatus);
                if (!trackerStatus.isTrackerScrapeUrlValid() && Logger.isEnabled()) {
                    Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(hashWrapper), LOGID, 3, "Can't scrape using url '" + uRL + "' as it doesn't end in " + "'/announce', skipping."));
                }
            }
            Object var7_6 = null;
            this.trackers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.trackers_mon.exit();
            throw throwable;
        }
        if (tRTrackerScraperResponseImpl == null) {
            tRTrackerScraperResponseImpl = trackerStatus.addHash(hashWrapper);
        }
        return tRTrackerScraperResponseImpl;
    }

    protected void removeHash(TOTorrent tOTorrent) {
        try {
            this.removeHash(tOTorrent.getAnnounceURL().toString(), tOTorrent.getHashWrapper());
            TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = tOTorrent.getAnnounceURLGroup().getAnnounceURLSets();
            for (int i = 0; i < tOTorrentAnnounceURLSetArray.length; ++i) {
                URL[] uRLArray = tOTorrentAnnounceURLSetArray[i].getAnnounceURLs();
                for (int j = 0; j < uRLArray.length; ++j) {
                    this.removeHash(uRLArray[j].toString(), tOTorrent.getHashWrapper());
                }
            }
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
        }
    }

    protected void removeHash(String string, HashWrapper hashWrapper) {
        TrackerStatus trackerStatus = (TrackerStatus)this.trackers.get(string);
        if (trackerStatus != null) {
            trackerStatus.removeHash(hashWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncUpdate(TOTorrent tOTorrent, URL uRL) {
        if (tOTorrent == null) {
            return;
        }
        try {
            HashWrapper hashWrapper = tOTorrent.getHashWrapper();
            TrackerStatus trackerStatus = null;
            try {
                this.trackers_mon.enter();
                for (TrackerStatus trackerStatus2 : this.trackers.values()) {
                    Object var9_9;
                    if (uRL != null && !uRL.toString().equals(trackerStatus2.getTrackerURL().toString())) continue;
                    Map map = trackerStatus2.getHashes();
                    try {
                        trackerStatus2.getHashesMonitor().enter();
                        if (map.get(hashWrapper) != null) {
                            trackerStatus = trackerStatus2;
                            var9_9 = null;
                            trackerStatus2.getHashesMonitor().exit();
                            break;
                        }
                        var9_9 = null;
                        trackerStatus2.getHashesMonitor().exit();
                    }
                    catch (Throwable throwable) {
                        var9_9 = null;
                        trackerStatus2.getHashesMonitor().exit();
                        throw throwable;
                    }
                }
                Object var11_11 = null;
                this.trackers_mon.exit();
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                this.trackers_mon.exit();
                throw throwable;
            }
            if (trackerStatus != null) {
                trackerStatus.updateSingleHash(hashWrapper, true, false);
            }
        }
        catch (Throwable throwable) {
            Debug.out("scrape syncUpdate() exception", throwable);
        }
    }

    public void perform(TimerEvent timerEvent2) {
        this.runScrapes();
    }

    private void runScrapes() {
        long l;
        TRTrackerBTScraperResponseImpl tRTrackerBTScraperResponseImpl = this.checkForNextScrape();
        if (Logger.isEnabled() && tRTrackerBTScraperResponseImpl != this.oldResponse && tRTrackerBTScraperResponseImpl != null) {
            Logger.log(new LogEvent((Object)TorrentUtils.getDownloadManager(tRTrackerBTScraperResponseImpl.getHash()), LOGID, 0, "Next scrape will be " + tRTrackerBTScraperResponseImpl.getURL() + " in " + (tRTrackerBTScraperResponseImpl.getNextScrapeStartTime() - SystemTime.getCurrentTime()) / 1000L + " sec,type=" + (tRTrackerBTScraperResponseImpl.getTrackerStatus().getSupportsMultipeHashScrapes() ? "multi" : "single") + ",active=" + tRTrackerBTScraperResponseImpl.getTrackerStatus().getNumActiveScrapes()));
        }
        if (tRTrackerBTScraperResponseImpl == null) {
            l = 60000L;
        } else {
            long l2 = tRTrackerBTScraperResponseImpl.getNextScrapeStartTime();
            long l3 = l2 - SystemTime.getCurrentTime() + 25L;
            if (l3 <= 0L) {
                if (tRTrackerBTScraperResponseImpl.getTrackerStatus().getNumActiveScrapes() > 0) {
                    l = 2000L;
                } else {
                    try {
                        tRTrackerBTScraperResponseImpl.getTrackerStatus().updateSingleHash(tRTrackerBTScraperResponseImpl.getHash(), false);
                        l = 0L;
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                        l = 30000L;
                    }
                }
            } else {
                l = l3;
                if (l > 30000L) {
                    l = 30000L;
                }
            }
        }
        this.nextScrapeCheckOn = SystemTime.getCurrentTime() + l;
        this.oldResponse = tRTrackerBTScraperResponseImpl;
        TRTrackerBTAnnouncerImpl.tracker_timer.addEvent(this.nextScrapeCheckOn, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TRTrackerBTScraperResponseImpl checkForNextScrape() {
        boolean bl;
        long l = Long.MAX_VALUE;
        TRTrackerBTScraperResponseImpl tRTrackerBTScraperResponseImpl = null;
        long l2 = Long.MAX_VALUE;
        TRTrackerBTScraperResponseImpl tRTrackerBTScraperResponseImpl2 = null;
        try {
            this.trackers_mon.enter();
            for (TrackerStatus trackerStatus : this.trackers.values()) {
                Object var16_13;
                if (!trackerStatus.isTrackerScrapeUrlValid()) continue;
                boolean bl2 = trackerStatus.getNumActiveScrapes() > 0;
                Map map = trackerStatus.getHashes();
                try {
                    trackerStatus.getHashesMonitor().enter();
                    for (TRTrackerBTScraperResponseImpl tRTrackerBTScraperResponseImpl3 : map.values()) {
                        if (tRTrackerBTScraperResponseImpl3.getStatus() == 3) continue;
                        long l3 = tRTrackerBTScraperResponseImpl3.getNextScrapeStartTime();
                        if (bl2) {
                            if (l3 >= l) continue;
                            l = l3;
                            tRTrackerBTScraperResponseImpl = tRTrackerBTScraperResponseImpl3;
                            continue;
                        }
                        if (l3 >= l2) continue;
                        l2 = l3;
                        tRTrackerBTScraperResponseImpl2 = tRTrackerBTScraperResponseImpl3;
                    }
                    var16_13 = null;
                    trackerStatus.getHashesMonitor().exit();
                }
                catch (Throwable throwable) {
                    var16_13 = null;
                    trackerStatus.getHashesMonitor().exit();
                    throw throwable;
                }
            }
            Object var18_15 = null;
            this.trackers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var18_16 = null;
            this.trackers_mon.exit();
            throw throwable;
        }
        boolean bl3 = bl = l != Long.MAX_VALUE && l < l2;
        if (bl && l2 - SystemTime.getCurrentTime() > 2000L) {
            return tRTrackerBTScraperResponseImpl;
        }
        return tRTrackerBTScraperResponseImpl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clockChanged(long l, long l2) {
        if (Math.abs(l2) < 60000L) {
            return;
        }
        try {
            this.trackers_mon.enter();
            for (TrackerStatus trackerStatus : this.trackers.values()) {
                Object var13_9;
                Map map = trackerStatus.getHashes();
                try {
                    trackerStatus.getHashesMonitor().enter();
                    for (TRTrackerBTScraperResponseImpl tRTrackerBTScraperResponseImpl : map.values()) {
                        long l3 = tRTrackerBTScraperResponseImpl.getNextScrapeStartTime();
                        if (l3 <= 0L) continue;
                        tRTrackerBTScraperResponseImpl.setNextScrapeStartTime(l3 + l2);
                    }
                    var13_9 = null;
                    trackerStatus.getHashesMonitor().exit();
                }
                catch (Throwable throwable) {
                    var13_9 = null;
                    trackerStatus.getHashesMonitor().exit();
                    throw throwable;
                }
            }
            Object var15_11 = null;
            this.trackers_mon.exit();
        }
        catch (Throwable throwable) {
            Object var15_12 = null;
            this.trackers_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter indentWriter) {
        indentWriter.println("BTScraper - now = " + SystemTime.getCurrentTime());
        try {
            indentWriter.indent();
            try {
                this.trackers_mon.enter();
                for (Map.Entry entry : this.trackers.entrySet()) {
                    Object var10_9;
                    TrackerStatus trackerStatus = (TrackerStatus)entry.getValue();
                    indentWriter.println("Tracker: " + trackerStatus.getString());
                    try {
                        indentWriter.indent();
                        trackerStatus.getHashesMonitor().enter();
                        Map map = trackerStatus.getHashes();
                        for (Map.Entry entry2 : map.entrySet()) {
                            TRTrackerBTScraperResponseImpl tRTrackerBTScraperResponseImpl = (TRTrackerBTScraperResponseImpl)entry2.getValue();
                            indentWriter.println(tRTrackerBTScraperResponseImpl.getString());
                        }
                        var10_9 = null;
                        trackerStatus.getHashesMonitor().exit();
                        indentWriter.exdent();
                    }
                    catch (Throwable throwable) {
                        var10_9 = null;
                        trackerStatus.getHashesMonitor().exit();
                        indentWriter.exdent();
                        throw throwable;
                    }
                }
                Object var12_11 = null;
                this.trackers_mon.exit();
            }
            catch (Throwable throwable) {
                Object var12_12 = null;
                this.trackers_mon.exit();
                throw throwable;
            }
            Object var14_14 = null;
            indentWriter.exdent();
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            indentWriter.exdent();
            throw throwable;
        }
    }

    public long getNextScrapeCheckOn() {
        return this.nextScrapeCheckOn;
    }
}

