/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.client.impl.dht;

import java.net.URL;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncer;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerDataProvider;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerException;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponse;
import org.gudy.azureus2.core3.tracker.client.TRTrackerAnnouncerResponsePeer;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponseImpl;
import org.gudy.azureus2.core3.tracker.client.impl.TRTrackerAnnouncerResponsePeerImpl;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.clientid.ClientIDException;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResult;
import org.gudy.azureus2.plugins.download.DownloadAnnounceResultPeer;
import org.gudy.azureus2.pluginsimpl.local.clientid.ClientIDManagerImpl;

public class TRTrackerDHTAnnouncerImpl
extends TRTrackerAnnouncerImpl {
    private TOTorrent torrent;
    private HashWrapper torrent_hash;
    private byte[] data_peer_id;
    private String tracker_status_str;
    private long last_update_time;
    private int state = 1;
    private TRTrackerAnnouncerResponseImpl last_response;
    private boolean manual;

    public TRTrackerDHTAnnouncerImpl(TOTorrent tOTorrent, String[] stringArray, boolean bl) throws TRTrackerAnnouncerException {
        super(tOTorrent);
        this.torrent = tOTorrent;
        this.manual = bl;
        try {
            this.torrent_hash = this.torrent.getHashWrapper();
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
        }
        try {
            this.data_peer_id = ClientIDManagerImpl.getSingleton().generatePeerID(this.torrent, false);
        }
        catch (ClientIDException clientIDException) {
            throw new TRTrackerAnnouncerException("TRTrackerAnnouncer: Peer ID generation fails", clientIDException);
        }
        this.last_response = new TRTrackerAnnouncerResponseImpl(this.torrent.getAnnounceURL(), this.torrent_hash, 0, 0L, "Initialising");
        this.tracker_status_str = MessageText.getString("PeerManager.status.checking") + "...";
    }

    public void setAnnounceDataProvider(TRTrackerAnnouncerDataProvider tRTrackerAnnouncerDataProvider) {
    }

    public boolean isManual() {
        return this.manual;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public URL getTrackerUrl() {
        return this.torrent.getAnnounceURL();
    }

    public void setTrackerUrl(URL uRL) {
        Debug.out("setTrackerURL not supported for DHT");
    }

    public void resetTrackerUrl(boolean bl) {
    }

    public void cloneFrom(TRTrackerAnnouncer tRTrackerAnnouncer) {
        this.data_peer_id = tRTrackerAnnouncer.getPeerId();
    }

    public void setIPOverride(String string) {
    }

    public void clearIPOverride() {
    }

    public int getPort() {
        return 0;
    }

    public byte[] getPeerId() {
        return this.data_peer_id;
    }

    public void setRefreshDelayOverrides(int n) {
    }

    public int getTimeUntilNextUpdate() {
        long l = (SystemTime.getCurrentTime() - this.last_update_time) / 1000L;
        return (int)(this.last_response.getTimeToWait() - l);
    }

    public int getLastUpdateTime() {
        return (int)(this.last_update_time / 1000L);
    }

    public void update(boolean bl) {
        this.state = 2;
        this.checkCache();
    }

    public void complete(boolean bl) {
        this.state = 3;
    }

    public void stop(boolean bl) {
        this.state = 4;
    }

    public void destroy() {
    }

    public int getStatus() {
        return this.state;
    }

    public String getStatusString() {
        return this.tracker_status_str;
    }

    public TRTrackerAnnouncerResponse getLastResponse() {
        return this.last_response;
    }

    public void refreshListeners() {
    }

    public void setAnnounceResult(DownloadAnnounceResult downloadAnnounceResult) {
        TRTrackerAnnouncerResponseImpl tRTrackerAnnouncerResponseImpl;
        this.last_update_time = SystemTime.getCurrentTime();
        if (downloadAnnounceResult.getResponseType() == 2) {
            this.tracker_status_str = MessageText.getString("PeerManager.status.error");
            String string = downloadAnnounceResult.getError();
            if (string != null) {
                this.tracker_status_str = this.tracker_status_str + " (" + string + ")";
            }
            tRTrackerAnnouncerResponseImpl = new TRTrackerAnnouncerResponseImpl(downloadAnnounceResult.getURL(), this.torrent_hash, 0, downloadAnnounceResult.getTimeToWait(), string);
        } else {
            DownloadAnnounceResultPeer[] downloadAnnounceResultPeerArray = downloadAnnounceResult.getPeers();
            TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray = new TRTrackerAnnouncerResponsePeerImpl[downloadAnnounceResultPeerArray.length];
            for (int i = 0; i < downloadAnnounceResultPeerArray.length; ++i) {
                DownloadAnnounceResultPeer downloadAnnounceResultPeer = downloadAnnounceResultPeerArray[i];
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(this.torrent, LOGID, "EXTERNAL PEER DHT: ip=" + downloadAnnounceResultPeer.getAddress() + ",port=" + downloadAnnounceResultPeer.getPort() + ",prot=" + downloadAnnounceResultPeer.getProtocol()));
                }
                int n = 0;
                byte by = 1;
                tRTrackerAnnouncerResponsePeerArray[i] = new TRTrackerAnnouncerResponsePeerImpl(downloadAnnounceResultPeer.getSource(), downloadAnnounceResultPeer.getPeerID(), downloadAnnounceResultPeer.getAddress(), downloadAnnounceResultPeer.getPort(), downloadAnnounceResultPeer.getUDPPort(), n, downloadAnnounceResultPeer.getProtocol(), by, 0);
            }
            this.addToTrackerCache((TRTrackerAnnouncerResponsePeerImpl[])tRTrackerAnnouncerResponsePeerArray);
            this.tracker_status_str = MessageText.getString("PeerManager.status.ok");
            tRTrackerAnnouncerResponseImpl = new TRTrackerAnnouncerResponseImpl(downloadAnnounceResult.getURL(), this.torrent_hash, 2, downloadAnnounceResult.getTimeToWait(), tRTrackerAnnouncerResponsePeerArray);
        }
        this.last_response = tRTrackerAnnouncerResponseImpl;
        this.listeners.dispatch(1, tRTrackerAnnouncerResponseImpl);
    }

    protected void checkCache() {
        TRTrackerAnnouncerResponsePeer[] tRTrackerAnnouncerResponsePeerArray;
        if (this.last_response.getStatus() != 2 && (tRTrackerAnnouncerResponsePeerArray = this.getPeersFromCache(100)).length > 0) {
            this.last_response.setPeers(tRTrackerAnnouncerResponsePeerArray);
            this.listeners.dispatch(1, this.last_response);
        }
    }

    public void generateEvidence(IndentWriter indentWriter) {
        indentWriter.println("DHT announce: " + (this.last_response == null ? "null" : this.last_response.getString()));
    }
}

