/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentFinder;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostTorrentHostImpl;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TRHostConfigImpl {
    public static final String LOG_FILE_NAME = "tracker.log";
    public static final long BACKUP_RETENTION_PERIOD = 604800000L;
    private TRHostImpl host;
    private AEMonitor save_lock_mon = new AEMonitor("TRHostConfig:SL");
    private String log_dir;
    private volatile boolean loading = false;
    private volatile boolean save_outstanding = false;
    private Map saved_stats = new HashMap();
    private List saved_stats_to_delete = new ArrayList();
    private boolean config_exists = true;
    private AEMonitor this_mon = new AEMonitor("TRHostConfig");

    protected TRHostConfigImpl(TRHostImpl tRHostImpl) {
        this.host = tRHostImpl;
        this.log_dir = SystemProperties.getUserPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadConfig(TRHostTorrentFinder tRHostTorrentFinder) {
        try {
            try {
                this.this_mon.enter();
                this.loading = true;
                Map map = FileUtil.readResilientConfigFile("tracker.config");
                List list = (List)map.get("torrents");
                if (list == null) {
                    Object var19_5 = null;
                    this.loading = false;
                    this.this_mon.exit();
                    return;
                }
                for (Map map2 : list) {
                    Long l = (Long)map2.get("persistent");
                    boolean bl = l == null || l == 1L;
                    Long l2 = (Long)map2.get("passive");
                    boolean bl2 = l2 != null && l2 == 1L;
                    Long l3 = (Long)map2.get("dateadded");
                    long l4 = l3 == null ? SystemTime.getCurrentTime() : l3;
                    byte[] byArray = (byte[])map2.get("hash");
                    if (bl) {
                        Object object;
                        Object object2;
                        TOTorrent tOTorrent;
                        int n = ((Long)map2.get("status")).intValue();
                        if (n == 0) {
                            n = 1;
                        }
                        if ((tOTorrent = tRHostTorrentFinder.lookupTorrent(byArray)) == null && bl2 && (object2 = (byte[])map2.get("torrent_file")) != null) {
                            try {
                                object = new File(new String((byte[])object2, "ISO-8859-1"));
                                tOTorrent = TorrentUtils.readFromFile((File)object, true, true);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (tOTorrent != null) {
                            object2 = this.host.addTorrent(tOTorrent, n, true, bl2, l4);
                            if (!(object2 instanceof TRHostTorrentHostImpl)) continue;
                            object = (TRHostTorrentHostImpl)object2;
                            this.recoverStats((TRHostTorrentHostImpl)object, map2);
                            continue;
                        }
                        if (!COConfigurationManager.getBooleanParameter("Tracker Public Enable")) continue;
                        this.host.addExternalTorrent(byArray, n, l4);
                        continue;
                    }
                    this.saved_stats.put(new HashWrapper(byArray), map2);
                }
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                Object var19_7 = null;
                this.loading = false;
                this.this_mon.exit();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var19_8 = null;
            this.loading = false;
            this.this_mon.exit();
            throw throwable;
        }
        Object var19_6 = null;
        this.loading = false;
        this.this_mon.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recoverStats(TRHostTorrentHostImpl tRHostTorrentHostImpl) {
        block5: {
            try {
                HashWrapper hashWrapper = tRHostTorrentHostImpl.getTorrent().getHashWrapper();
                Map map = (Map)this.saved_stats.get(hashWrapper);
                if (map == null) break block5;
                this.recoverStats(tRHostTorrentHostImpl, map);
                List list = this.saved_stats_to_delete;
                synchronized (list) {
                    this.saved_stats_to_delete.add(hashWrapper);
                }
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    private void recoverStats(TRHostTorrentHostImpl tRHostTorrentHostImpl, Map map) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        Long l8 = (Long)map.get("dateadded");
        long l9 = l8 == null ? SystemTime.getCurrentTime() : l8;
        Map map2 = (Map)map.get("stats");
        if (map2 != null) {
            Long l10;
            Long l11;
            l = (Long)map2.get("completed");
            l2 = (Long)map2.get("announces");
            l4 = (Long)map2.get("uploaded");
            l5 = (Long)map2.get("downloaded");
            Long l12 = (Long)map2.get("scrapes");
            if (l12 != null) {
                l3 = l12;
            }
            if ((l11 = (Long)map2.get("bytesin")) != null) {
                l6 = l11;
            }
            if ((l10 = (Long)map2.get("bytesout")) != null) {
                l7 = l10;
            }
        }
        tRHostTorrentHostImpl.setStartOfDayValues(l9, l, l2, l3, l4, l5, l6, l7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void saveConfig(boolean var1_1) {
        if (this.loading) {
            return;
        }
        if (this.saved_stats_to_delete.size() > 0) {
            var2_2 = this.saved_stats_to_delete;
            synchronized (var2_2) {
                var3_4 = new HashMap<K, V>(this.saved_stats);
                for (var4_5 = 0; var4_5 < this.saved_stats_to_delete.size(); ++var4_5) {
                    var3_4.remove(this.saved_stats_to_delete.get(var4_5));
                }
                this.saved_stats_to_delete.clear();
                this.saved_stats = var3_4;
            }
        }
        if (!var1_1) {
            if (this.save_outstanding == false) return;
        }
        this.save_outstanding = false;
        try {
            var2_2 = new HashMap<K, V>();
            var3_4 = new ArrayList<E>();
            var4_6 = this.host.getTorrents();
            var5_7 = new ArrayList<StringBuffer>();
            var6_8 = new HashSet<Object>();
            for (var7_9 = 0; var7_9 < var4_6.length; ++var7_9) {
                try {
                    var8_11 = var4_6[var7_9];
                    var6_8.add(var8_11.getTorrent().getHashWrapper());
                    var9_14 = new StringBuffer(2048);
                    var10_15 = var8_11.getTorrent().getHash();
                    var11_17 = var8_11.getTorrent().getName();
                    var12_18 = var8_11.getStatus();
                    var13_21 = var8_11.getCompletedCount();
                    var15_24 = var8_11.getAnnounceCount();
                    var17_26 = var8_11.getScrapeCount();
                    var19_27 = var8_11.getTotalUploaded();
                    var21_28 = var8_11.getTotalDownloaded();
                    var23_29 = var8_11.getTotalBytesIn();
                    var25_30 = var8_11.getTotalBytesOut();
                    var27_31 = var8_11.getDateAdded();
                    var29_32 = var8_11.getSeedCount();
                    var30_33 = var8_11.getLeecherCount();
                    var31_34 = new HashMap<String, Object>();
                    var31_34.put("persistent", new Long(var8_11.isPersistent() != false ? 1L : 0L));
                    var31_34.put("passive", new Long(var8_11.isPassive() != false ? 1L : 0L));
                    if (var8_11.isPassive()) {
                        try {
                            var32_35 = TorrentUtils.getTorrentFileName(var8_11.getTorrent());
                            var31_34.put("torrent_file", var32_35.getBytes("ISO-8859-1"));
                        }
                        catch (Throwable var32_36) {
                            Debug.printStackTrace(var32_36);
                        }
                    }
                    var31_34.put("hash", var10_15);
                    var31_34.put("dateadded", new Long(var27_31));
                    var31_34.put("status", new Long(var12_18));
                    var3_4.add(var31_34);
                    var32_35 = new HashMap<K, V>();
                    var31_34.put("stats", var32_35);
                    var32_35.put("completed", new Long(var13_21));
                    var32_35.put("announces", new Long(var15_24));
                    var32_35.put("scrapes", new Long(var17_26));
                    var32_35.put("uploaded", new Long(var19_27));
                    var32_35.put("downloaded", new Long(var21_28));
                    var32_35.put("bytesin", new Long(var23_29));
                    var32_35.put("bytesout", new Long(var25_30));
                    var9_14.append(new String((byte[])var11_17, "UTF8"));
                    var9_14.append(",");
                    var9_14.append(ByteFormatter.nicePrint((byte[])var10_15, true));
                    var9_14.append(",");
                    var9_14.append(var12_18);
                    var9_14.append(",");
                    var9_14.append(var29_32);
                    var9_14.append(",");
                    var9_14.append(var30_33);
                    var9_14.append(",");
                    var9_14.append(var13_21);
                    var9_14.append(",");
                    var9_14.append(var15_24);
                    var9_14.append(",");
                    var9_14.append(var17_26);
                    var9_14.append(",");
                    var9_14.append(DisplayFormatters.formatByteCountToKiBEtc(var19_27));
                    var9_14.append(",");
                    var9_14.append(DisplayFormatters.formatByteCountToKiBEtc(var21_28));
                    var9_14.append(",");
                    var9_14.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(var8_11.getAverageUploaded()));
                    var9_14.append(",");
                    var9_14.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(var8_11.getAverageDownloaded()));
                    var9_14.append(",");
                    var9_14.append(DisplayFormatters.formatByteCountToKiBEtc(var8_11.getTotalLeft()));
                    var9_14.append(",");
                    var9_14.append(DisplayFormatters.formatByteCountToKiBEtc(var23_29));
                    var9_14.append(",");
                    var9_14.append(DisplayFormatters.formatByteCountToKiBEtc(var25_30));
                    var9_14.append(",");
                    var9_14.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(var8_11.getAverageBytesIn()));
                    var9_14.append(",");
                    var9_14.append(DisplayFormatters.formatByteCountToKiBEtcPerSec(var8_11.getAverageBytesOut()));
                    var9_14.append("\r\n");
                    var5_7.add(var9_14);
                    continue;
                }
                catch (TOTorrentException var8_12) {
                    Debug.printStackTrace(var8_12);
                }
            }
            var7_10 = this.saved_stats.keySet().iterator();
            var8_13 = SystemTime.getCurrentTime();
            while (var7_10.hasNext()) {
                var10_15 = (HashWrapper)var7_10.next();
                if (var6_8.contains(var10_15)) continue;
                var11_17 = (Map)this.saved_stats.get(var10_15);
                var12_19 = (Long)var11_17.get("backup_time");
                if (var12_19 == null) {
                    var12_19 = new Long(var8_13);
                    var11_17.put("backup_time", var12_19);
                }
                if (var8_13 - var12_19 >= 604800000L) continue;
                var3_4.add(var11_17);
                var6_8.add(var10_15);
            }
            var2_2.put("torrents", var3_4);
            try {
                block34: {
                    this.save_lock_mon.enter();
                    if (var4_6.length == 0) {
                        if (this.config_exists) {
                            FileUtil.deleteResilientConfigFile("tracker.config");
                            this.config_exists = false;
                        }
                    } else {
                        this.config_exists = true;
                        FileUtil.writeResilientConfigFile("tracker.config", (Map)var2_2);
                    }
                    if (COConfigurationManager.getBooleanParameter("Tracker Log Enable") && var5_7.size() > 0) {
                        try {
                            var10_15 = "[" + new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss").format(new Date()) + "] ";
                            var11_17 = null;
                            var12_20 = new File(this.log_dir.concat(File.separator).concat("tracker.log"));
                            try {
                                try {
                                    var11_17 = new PrintWriter(new FileWriter(var12_20, true));
                                    for (var13_22 = 0; var13_22 < var5_7.size(); ++var13_22) {
                                        var14_37 = (StringBuffer)var5_7.get(var13_22);
                                        var15_25 = (String)var10_15 + var14_37.toString();
                                        var11_17.print(var15_25);
                                    }
                                    var34_38 = null;
                                    if (var11_17 == null) break block34;
                                }
                                catch (Throwable var13_23) {
                                    Debug.printStackTrace(var13_23);
                                    var34_39 = null;
                                    if (var11_17 != null) {
                                        try {
                                            var11_17.close();
                                        }
                                        catch (Throwable var35_42) {}
                                    }
                                    break block34;
                                }
                            }
                            catch (Throwable var33_44) {
                                var34_40 = null;
                                if (var11_17 == null) throw var33_44;
                                ** try [egrp 8[TRYBLOCK] [8 : 1457->1465)] { 
lbl212:
                                // 1 sources

                                var11_17.close();
                                throw var33_44;
lbl214:
                                // 1 sources

                                catch (Throwable var35_43) {
                                    // empty catch block
                                }
                                throw var33_44;
                            }
                            try {}
                            catch (Throwable var35_41) {}
                            var11_17.close();
                        }
                        catch (Throwable var10_16) {
                            Debug.printStackTrace(var10_16);
                        }
                    }
                }
                var37_45 = null;
                this.save_lock_mon.exit();
                return;
            }
            catch (Throwable var36_47) {
                var37_46 = null;
                this.save_lock_mon.exit();
                throw var36_47;
            }
        }
        catch (Throwable var2_3) {
            Debug.printStackTrace(var2_3);
        }
    }

    protected void saveRequired() {
        this.save_outstanding = true;
    }
}

