/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilEncodingException;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLGroup;
import org.gudy.azureus2.core3.torrent.TOTorrentAnnounceURLSet;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;

public class TRHostExternalTorrent
implements TOTorrent {
    private byte[] name;
    private byte[] hash;
    private HashWrapper hash_wrapper;
    private URL announce_url;
    protected Map additional_properties = new HashMap();
    protected AEMonitor this_mon = new AEMonitor("TRHostExternalTorrent");

    protected TRHostExternalTorrent(byte[] byArray, URL uRL) {
        this.hash = byArray;
        this.hash_wrapper = new HashWrapper(this.hash);
        this.announce_url = uRL;
        this.name = ByteFormatter.nicePrint(this.hash, true).getBytes();
        try {
            LocaleTorrentUtil.setDefaultTorrentEncoding(this);
        }
        catch (LocaleUtilEncodingException localeUtilEncodingException) {
            Debug.printStackTrace(localeUtilEncodingException);
        }
    }

    public byte[] getName() {
        return this.name;
    }

    public boolean isSimpleTorrent() {
        return true;
    }

    public byte[] getComment() {
        return null;
    }

    public void setComment(String string) {
    }

    public long getCreationDate() {
        return 0L;
    }

    public void setCreationDate(long l) {
    }

    public byte[] getCreatedBy() {
        return null;
    }

    public void setCreatedBy(byte[] byArray) {
    }

    public boolean isCreated() {
        return false;
    }

    public URL getAnnounceURL() {
        return this.announce_url;
    }

    public boolean setAnnounceURL(URL uRL) {
        return false;
    }

    public TOTorrentAnnounceURLGroup getAnnounceURLGroup() {
        return new TOTorrentAnnounceURLGroup(){

            public TOTorrentAnnounceURLSet[] getAnnounceURLSets() {
                return new TOTorrentAnnounceURLSet[0];
            }

            public void setAnnounceURLSets(TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray) {
            }

            public TOTorrentAnnounceURLSet createAnnounceURLSet(URL[] uRLArray) {
                return new TOTorrentAnnounceURLSet(){

                    public URL[] getAnnounceURLs() {
                        return new URL[0];
                    }

                    public void setAnnounceURLs(URL[] uRLArray) {
                    }
                };
            }
        };
    }

    public void addTorrentAnnounceURLSet(URL[] uRLArray) {
    }

    public byte[][] getPieces() {
        return new byte[0][];
    }

    public void setPieces(byte[][] byArray) {
    }

    public int getNumberOfPieces() {
        return 0;
    }

    public long getPieceLength() {
        return -1L;
    }

    public long getSize() {
        return -1L;
    }

    public TOTorrentFile[] getFiles() {
        return new TOTorrentFile[0];
    }

    public byte[] getHash() throws TOTorrentException {
        return this.hash;
    }

    public HashWrapper getHashWrapper() throws TOTorrentException {
        return this.hash_wrapper;
    }

    public void setHashOverride(byte[] byArray) throws TOTorrentException {
        throw new TOTorrentException("Not supported", 8);
    }

    public boolean getPrivate() {
        return false;
    }

    public void setPrivate(boolean bl) throws TOTorrentException {
    }

    public boolean hasSameHashAs(TOTorrent tOTorrent) {
        try {
            byte[] byArray = tOTorrent.getHash();
            return Arrays.equals(this.hash, byArray);
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
            return false;
        }
    }

    public void setAdditionalStringProperty(String string, String string2) {
        try {
            this.additional_properties.put(string, string2.getBytes("UTF8"));
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
        }
    }

    public String getAdditionalStringProperty(String string) {
        try {
            Object v = this.additional_properties.get(string);
            if (v == null) {
                return null;
            }
            if (!(v instanceof byte[])) {
                Debug.out("property '" + string + "' is not a byte[]: " + v);
                return null;
            }
            return new String((byte[])v, "UTF8");
        }
        catch (Throwable throwable) {
            Debug.printStackTrace(throwable);
            return null;
        }
    }

    public void setAdditionalByteArrayProperty(String string, byte[] byArray) {
        this.additional_properties.put(string, byArray);
    }

    public byte[] getAdditionalByteArrayProperty(String string) {
        return (byte[])this.additional_properties.get(string);
    }

    public void setAdditionalLongProperty(String string, Long l) {
        this.additional_properties.put(string, l);
    }

    public void setAdditionalProperty(String string, Object object) {
        if (object instanceof String) {
            this.setAdditionalStringProperty(string, (String)object);
        } else {
            this.additional_properties.put(string, object);
        }
    }

    public Long getAdditionalLongProperty(String string) {
        return (Long)this.additional_properties.get(string);
    }

    public void setAdditionalListProperty(String string, List list) {
        this.additional_properties.put(string, list);
    }

    public List getAdditionalListProperty(String string) {
        return (List)this.additional_properties.get(string);
    }

    public void setAdditionalMapProperty(String string, Map map) {
        this.additional_properties.put(string, map);
    }

    public Map getAdditionalMapProperty(String string) {
        return (Map)this.additional_properties.get(string);
    }

    public Object getAdditionalProperty(String string) {
        return this.additional_properties.get(string);
    }

    public void removeAdditionalProperty(String string) {
        this.additional_properties.remove(string);
    }

    public void removeAdditionalProperties() {
        this.additional_properties.clear();
    }

    public void serialiseToBEncodedFile(File file) throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    public Map serialiseToMap() throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    public void serialiseToXMLFile(File file) throws TOTorrentException {
        throw new TOTorrentException("External Torrent", 5);
    }

    public AEMonitor getMonitor() {
        return this.this_mon;
    }

    public void print() {
    }
}

