/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.host.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.tracker.host.TRHostPeer;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrent;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentListener;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRemovalVetoException;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentRequest;
import org.gudy.azureus2.core3.tracker.host.TRHostTorrentWillBeRemovedListener;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostImpl;
import org.gudy.azureus2.core3.tracker.host.impl.TRHostPeerHostImpl;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrent;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerTorrentStats;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;

public class TRHostTorrentHostImpl
implements TRHostTorrent {
    private TRHostImpl host;
    private TRTrackerServer server;
    private TRTrackerServerTorrent server_torrent;
    private TOTorrent torrent;
    private long date_added;
    private int port;
    private List listeners_cow = new ArrayList();
    private List removal_listeners = new ArrayList();
    private int status = 1;
    private boolean persistent;
    private boolean passive;
    private long sos_uploaded;
    private long sos_downloaded;
    private long sos_bytes_in;
    private long sos_bytes_out;
    private long sos_announce;
    private long sos_scrape;
    private long sos_complete;
    private long last_uploaded;
    private long last_downloaded;
    private long last_bytes_in;
    private long last_bytes_out;
    private long last_announce;
    private long last_scrape;
    private Average average_uploaded = Average.getInstance(60000, 600);
    private Average average_downloaded = Average.getInstance(60000, 600);
    private Average average_bytes_in = Average.getInstance(60000, 600);
    private Average average_bytes_out = Average.getInstance(60000, 600);
    private Average average_announce = Average.getInstance(60000, 600);
    private Average average_scrape = Average.getInstance(60000, 600);
    private boolean disable_reply_caching;
    private HashMap data;
    protected AEMonitor this_mon = new AEMonitor("TRHostTorrentHost");

    protected TRHostTorrentHostImpl(TRHostImpl tRHostImpl, TRTrackerServer tRTrackerServer, TOTorrent tOTorrent, int n, long l) {
        this.host = tRHostImpl;
        this.server = tRTrackerServer;
        this.torrent = tOTorrent;
        this.port = n;
        this.date_added = l;
    }

    public int getPort() {
        return this.port;
    }

    public void start() {
        this.host.startTorrent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startSupport() {
        try {
            block4: {
                try {
                    this.this_mon.enter();
                    this.status = 2;
                    this.server_torrent = this.server.permit("", this.torrent.getHash(), true);
                    if (!this.disable_reply_caching) break block4;
                    this.server_torrent.disableCaching();
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                    Object var3_2 = null;
                    this.this_mon.exit();
                }
            }
            Object var3_1 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
        this.host.hostTorrentStateChange(this);
    }

    public void stop() {
        this.host.stopTorrent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopSupport() {
        try {
            try {
                TRTrackerServerTorrentStats tRTrackerServerTorrentStats;
                this.this_mon.enter();
                this.status = 1;
                this.server.deny(this.torrent.getHash(), true);
                TRTrackerServerTorrent tRTrackerServerTorrent = this.server_torrent;
                TRTrackerServerTorrentStats tRTrackerServerTorrentStats2 = tRTrackerServerTorrentStats = tRTrackerServerTorrent == null ? null : tRTrackerServerTorrent.getStats();
                if (tRTrackerServerTorrentStats != null) {
                    this.sos_uploaded += tRTrackerServerTorrentStats.getUploaded();
                    this.sos_downloaded += tRTrackerServerTorrentStats.getDownloaded();
                    this.sos_bytes_in += tRTrackerServerTorrentStats.getBytesIn();
                    this.sos_bytes_out += tRTrackerServerTorrentStats.getBytesOut();
                    this.sos_announce += tRTrackerServerTorrentStats.getAnnounceCount();
                    this.sos_scrape += tRTrackerServerTorrentStats.getScrapeCount();
                    this.sos_complete += tRTrackerServerTorrentStats.getCompletedCount();
                    tRTrackerServerTorrentStats = null;
                }
                this.last_uploaded = 0L;
                this.last_downloaded = 0L;
                this.last_bytes_in = 0L;
                this.last_bytes_out = 0L;
                this.last_announce = 0L;
                this.last_scrape = 0L;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
                Object var4_5 = null;
                this.this_mon.exit();
            }
            Object var4_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
        this.host.hostTorrentStateChange(this);
    }

    public void remove() throws TRHostTorrentRemovalVetoException {
        this.canBeRemoved();
        this.stop();
        this.host.remove(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canBeRemoved() throws TRHostTorrentRemovalVetoException {
        ArrayList arrayList;
        try {
            this.this_mon.enter();
            arrayList = new ArrayList(this.removal_listeners);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ((TRHostTorrentWillBeRemovedListener)arrayList.get(i)).torrentWillBeRemoved(this);
        }
        return true;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    protected void setPersistent(boolean bl) {
        this.persistent = bl;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setPassive(boolean bl) {
        this.passive = bl;
    }

    public long getDateAdded() {
        return this.date_added;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    protected void setTorrent(TOTorrent tOTorrent) {
        this.torrent = tOTorrent;
    }

    public TRTrackerServerTorrent getTrackerTorrent() {
        return this.server_torrent;
    }

    public TRHostPeer[] getPeers() {
        try {
            TRTrackerServerPeer[] tRTrackerServerPeerArray = this.server.getPeers(this.torrent.getHash());
            if (tRTrackerServerPeerArray != null) {
                TRHostPeer[] tRHostPeerArray = new TRHostPeer[tRTrackerServerPeerArray.length];
                for (int i = 0; i < tRTrackerServerPeerArray.length; ++i) {
                    tRHostPeerArray[i] = new TRHostPeerHostImpl(tRTrackerServerPeerArray[i]);
                }
                return tRHostPeerArray;
            }
        }
        catch (TOTorrentException tOTorrentException) {
            Debug.printStackTrace(tOTorrentException);
        }
        return new TRHostPeer[0];
    }

    protected TRTrackerServerTorrentStats getStats() {
        TRTrackerServerTorrent tRTrackerServerTorrent = this.server_torrent;
        if (tRTrackerServerTorrent != null) {
            return tRTrackerServerTorrent.getStats();
        }
        return null;
    }

    protected void setStartOfDayValues(long l, long l2, long l3, long l4, long l5, long l6, long l7, long l8) {
        this.date_added = l;
        this.sos_complete = l2;
        this.sos_announce = l3;
        this.sos_scrape = l4;
        this.sos_uploaded = l5;
        this.sos_downloaded = l6;
        this.sos_bytes_in = l7;
        this.sos_bytes_out = l8;
    }

    public int getSeedCount() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            return tRTrackerServerTorrentStats.getSeedCount();
        }
        return 0;
    }

    public int getLeecherCount() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            return tRTrackerServerTorrentStats.getLeecherCount();
        }
        return 0;
    }

    public int getBadNATCount() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            return tRTrackerServerTorrentStats.getBadNATPeerCount();
        }
        return 0;
    }

    protected void updateStats() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            long l = tRTrackerServerTorrentStats.getUploaded();
            long l2 = l - this.last_uploaded;
            if (l2 < 0L) {
                l2 = 0L;
            }
            this.average_uploaded.addValue(l2);
            this.last_uploaded = l;
            long l3 = tRTrackerServerTorrentStats.getDownloaded();
            long l4 = l3 - this.last_downloaded;
            if (l4 < 0L) {
                l4 = 0L;
            }
            this.average_downloaded.addValue(l4);
            this.last_downloaded = l3;
            long l5 = tRTrackerServerTorrentStats.getBytesIn();
            long l6 = l5 - this.last_bytes_in;
            if (l6 < 0L) {
                l6 = 0L;
            }
            this.average_bytes_in.addValue(l6);
            this.last_bytes_in = l5;
            long l7 = tRTrackerServerTorrentStats.getBytesOut();
            long l8 = l7 - this.last_bytes_out;
            if (l8 < 0L) {
                l8 = 0L;
            }
            this.average_bytes_out.addValue(l8);
            this.last_bytes_out = l7;
            long l9 = tRTrackerServerTorrentStats.getAnnounceCount();
            long l10 = l9 - this.last_announce;
            if (l10 < 0L) {
                l10 = 0L;
            }
            this.average_announce.addValue(l10);
            this.last_announce = l9;
            long l11 = tRTrackerServerTorrentStats.getScrapeCount();
            long l12 = l11 - this.last_scrape;
            if (l12 < 0L) {
                l12 = 0L;
            }
            this.average_scrape.addValue(l12);
            this.last_scrape = l11;
        }
    }

    protected TRTrackerServer getServer() {
        return this.server;
    }

    public long getTotalUploaded() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            return this.sos_uploaded + tRTrackerServerTorrentStats.getUploaded();
        }
        return this.sos_uploaded;
    }

    public long getTotalDownloaded() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            return this.sos_downloaded + tRTrackerServerTorrentStats.getDownloaded();
        }
        return this.sos_downloaded;
    }

    public long getTotalLeft() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            return tRTrackerServerTorrentStats.getAmountLeft();
        }
        return 0L;
    }

    public long getTotalBytesIn() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            return this.sos_bytes_in + tRTrackerServerTorrentStats.getBytesIn();
        }
        return this.sos_bytes_in;
    }

    public long getTotalBytesOut() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            return this.sos_bytes_out + tRTrackerServerTorrentStats.getBytesOut();
        }
        return this.sos_bytes_out;
    }

    public long getAnnounceCount() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            return this.sos_announce + tRTrackerServerTorrentStats.getAnnounceCount();
        }
        return this.sos_announce;
    }

    public long getScrapeCount() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            return this.sos_scrape + tRTrackerServerTorrentStats.getScrapeCount();
        }
        return this.sos_scrape;
    }

    public long getCompletedCount() {
        TRTrackerServerTorrentStats tRTrackerServerTorrentStats = this.getStats();
        if (tRTrackerServerTorrentStats != null) {
            return this.sos_complete + tRTrackerServerTorrentStats.getCompletedCount();
        }
        return this.sos_complete;
    }

    public long getAverageBytesIn() {
        return this.average_bytes_in.getAverage();
    }

    public long getAverageBytesOut() {
        return this.average_bytes_out.getAverage();
    }

    public long getAverageUploaded() {
        return this.average_uploaded.getAverage();
    }

    public long getAverageDownloaded() {
        return this.average_downloaded.getAverage();
    }

    public long getAverageAnnounceCount() {
        return this.average_announce.getAverage();
    }

    public long getAverageScrapeCount() {
        return this.average_scrape.getAverage();
    }

    public void disableReplyCaching() {
        TRTrackerServerTorrent tRTrackerServerTorrent = this.server_torrent;
        this.disable_reply_caching = true;
        if (tRTrackerServerTorrent != null) {
            tRTrackerServerTorrent.disableCaching();
        }
    }

    protected void preProcess(TRHostTorrentRequest tRHostTorrentRequest) throws TRHostException {
        List list = this.listeners_cow;
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((TRHostTorrentListener)list.get(i)).preProcess(tRHostTorrentRequest);
                continue;
            }
            catch (TRHostException tRHostException) {
                throw tRHostException;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    protected void postProcess(TRHostTorrentRequest tRHostTorrentRequest) throws TRHostException {
        List list = this.listeners_cow;
        for (int i = 0; i < list.size(); ++i) {
            try {
                ((TRHostTorrentListener)list.get(i)).postProcess(tRHostTorrentRequest);
                continue;
            }
            catch (TRHostException tRHostException) {
                throw tRHostException;
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TRHostTorrentListener tRHostTorrentListener) {
        try {
            this.this_mon.enter();
            ArrayList<TRHostTorrentListener> arrayList = new ArrayList<TRHostTorrentListener>(this.listeners_cow);
            arrayList.add(tRHostTorrentListener);
            this.listeners_cow = arrayList;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
        this.host.torrentListenerRegistered();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(TRHostTorrentListener tRHostTorrentListener) {
        try {
            this.this_mon.enter();
            ArrayList arrayList = new ArrayList(this.listeners_cow);
            arrayList.remove(tRHostTorrentListener);
            this.listeners_cow = arrayList;
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemovalListener(TRHostTorrentWillBeRemovedListener tRHostTorrentWillBeRemovedListener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.add(tRHostTorrentWillBeRemovedListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRemovalListener(TRHostTorrentWillBeRemovedListener tRHostTorrentWillBeRemovedListener) {
        try {
            this.this_mon.enter();
            this.removal_listeners.remove(tRHostTorrentWillBeRemovedListener);
            Object var3_2 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public Object getData(String string) {
        if (this.data == null) {
            return null;
        }
        return this.data.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(String string, Object object) {
        try {
            this.this_mon.enter();
            if (this.data == null) {
                this.data = new HashMap();
            }
            if (object == null) {
                if (this.data.containsKey(string)) {
                    this.data.remove(string);
                }
            } else {
                this.data.put(string, object);
            }
            Object var4_3 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }
}

