/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.protocol.udp;

import com.aelitis.net.udp.uc.PRUDPPacketHandler;
import com.aelitis.net.udp.uc.PRUDPPacketReply;
import com.aelitis.net.udp.uc.PRUDPPacketReplyDecoder;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import com.aelitis.net.udp.uc.PRUDPPacketRequestDecoder;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;

public class PRUDPTrackerCodecs {
    private static boolean registered = false;

    public static void registerCodecs() {
        if (registered) {
            return;
        }
        registered = true;
        PRUDPPacketReplyDecoder pRUDPPacketReplyDecoder = new PRUDPPacketReplyDecoder(){

            public PRUDPPacketReply decode(PRUDPPacketHandler pRUDPPacketHandler, InetSocketAddress inetSocketAddress, DataInputStream dataInputStream, int n, int n2) throws IOException {
                switch (n) {
                    case 0: {
                        return new PRUDPPacketReplyConnect(dataInputStream, n2);
                    }
                    case 1: {
                        if (PRUDPPacketTracker.VERSION == 1) {
                            return new PRUDPPacketReplyAnnounce(dataInputStream, n2);
                        }
                        return new PRUDPPacketReplyAnnounce2(dataInputStream, n2);
                    }
                    case 2: {
                        if (PRUDPPacketTracker.VERSION == 1) {
                            return new PRUDPPacketReplyScrape(dataInputStream, n2);
                        }
                        return new PRUDPPacketReplyScrape2(dataInputStream, n2);
                    }
                    case 3: {
                        return new PRUDPPacketReplyError(dataInputStream, n2);
                    }
                }
                throw new IOException("Unrecognised action '" + n + "'");
            }
        };
        HashMap<Integer, 1> hashMap = new HashMap<Integer, 1>();
        hashMap.put(new Integer(0), pRUDPPacketReplyDecoder);
        hashMap.put(new Integer(1), pRUDPPacketReplyDecoder);
        hashMap.put(new Integer(2), pRUDPPacketReplyDecoder);
        hashMap.put(new Integer(3), pRUDPPacketReplyDecoder);
        PRUDPPacketReply.registerDecoders(hashMap);
        PRUDPPacketRequestDecoder pRUDPPacketRequestDecoder = new PRUDPPacketRequestDecoder(){

            public PRUDPPacketRequest decode(PRUDPPacketHandler pRUDPPacketHandler, DataInputStream dataInputStream, long l, int n, int n2) throws IOException {
                switch (n) {
                    case 0: {
                        return new PRUDPPacketRequestConnect(dataInputStream, l, n2);
                    }
                    case 1: {
                        if (PRUDPPacketTracker.VERSION == 1) {
                            return new PRUDPPacketRequestAnnounce(dataInputStream, l, n2);
                        }
                        return new PRUDPPacketRequestAnnounce2(dataInputStream, l, n2);
                    }
                    case 2: {
                        return new PRUDPPacketRequestScrape(dataInputStream, l, n2);
                    }
                }
                throw new IOException("unsupported request type");
            }
        };
        HashMap<Integer, 2> hashMap2 = new HashMap<Integer, 2>();
        hashMap2.put(new Integer(0), pRUDPPacketRequestDecoder);
        hashMap2.put(new Integer(1), pRUDPPacketRequestDecoder);
        hashMap2.put(new Integer(2), pRUDPPacketRequestDecoder);
        PRUDPPacketRequest.registerDecoders(hashMap2);
    }
}

