/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.tcp;

import com.aelitis.azureus.core.dht.netcoords.DHTNetworkPositionManager;
import com.aelitis.azureus.core.util.HTTPUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.bouncycastle.util.encoders.Base64;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerException;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerPeer;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerTCP;
import org.gudy.azureus2.core3.util.AsyncController;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.UrlUtils;

public abstract class TRTrackerServerProcessorTCP
extends TRTrackerServerProcessor {
    protected static final int SOCKET_TIMEOUT = 5000;
    protected static final char CR = '\r';
    protected static final char FF = '\n';
    protected static final String NL = "\r\n";
    private static final String lc_azureus_name = "Azureus".toLowerCase();
    protected static final byte[] HTTP_RESPONSE_START = "HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nServer: Azureus 4.3.0.4\r\nConnection: close\r\nContent-Length: ".getBytes();
    protected static final byte[] HTTP_RESPONSE_XML_START = "HTTP/1.1 200 OK\r\nContent-Type: text/xml; charset=\"utf-8\"\r\nServer: Azureus 4.3.0.4\r\nConnection: close\r\nContent-Length: ".getBytes();
    protected static final byte[] HTTP_RESPONSE_END_GZIP = "\r\nContent-Encoding: gzip\r\n\r\n".getBytes();
    protected static final byte[] HTTP_RESPONSE_END_NOGZIP = "\r\n\r\n".getBytes();
    private TRTrackerServerTCP server;
    private String server_url;
    private boolean disable_timeouts = false;

    protected TRTrackerServerProcessorTCP(TRTrackerServerTCP tRTrackerServerTCP) {
        this.server = tRTrackerServerTCP;
        this.server_url = (this.server.isSSL() ? "https" : "http") + "://" + UrlUtils.convertIPV6Host(this.server.getHost()) + ":" + this.server.getPort();
    }

    protected boolean areTimeoutsDisabled() {
        return this.disable_timeouts;
    }

    protected void setTimeoutsDisabled(boolean bl) {
        this.disable_timeouts = bl;
    }

    protected TRTrackerServerTCP getServer() {
        return this.server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected boolean processRequest(String var1_1, String var2_2, String var3_3, InetSocketAddress var4_4, InetSocketAddress var5_5, boolean var6_6, boolean var7_7, InputStream var8_8, OutputStream var9_9, AsyncController var10_10) throws IOException {
        block125: {
            block126: {
                var11_11 = var3_3;
                var12_12 = -1;
                try {
                    block127: {
                        block123: {
                            block120: {
                                block121: {
                                    block122: {
                                        var13_13 = null;
                                        var14_14 = null;
                                        var15_15 = false;
                                        var16_16 = false;
                                        if (var11_11.startsWith("/announce?")) {
                                            var12_12 = 1;
                                            var11_11 = var11_11.substring(10);
                                            break block120;
                                        }
                                        if (var11_11.startsWith("/scrape?")) {
                                            var12_12 = 2;
                                            var11_11 = var11_11.substring(8);
                                            break block120;
                                        }
                                        if (var11_11.equals("/scrape")) {
                                            var12_12 = 3;
                                            var11_11 = "";
                                            break block120;
                                        }
                                        if (var11_11.startsWith("/query?")) {
                                            var12_12 = 4;
                                            var11_11 = var11_11.substring(7);
                                            break block120;
                                        }
                                        var17_17 = TRTrackerServerImpl.redirect_on_not_found;
                                        if (var6_6) {
                                            if (var17_17.length() == 0) {
                                                throw new Exception("Tracker only supports announce and scrape functions");
                                            }
                                            break block121;
                                        }
                                        this.setTaskState("external request");
                                        this.disable_timeouts = true;
                                        var18_22 = this.doAuthentication(var3_3, var1_1, var9_9, false);
                                        if (var18_22 != null) break block122;
                                        var19_26 = false;
                                        var56_30 = null;
                                        this.setTaskState("final os flush");
                                        var9_9.flush();
                                        return var19_26;
                                    }
                                    var19_27 = new boolean[]{var7_7};
                                    if (!this.handleExternalRequest(var4_4, var5_5, var18_22, var11_11, var1_1, var8_8, var9_9, var10_10, (boolean[])var19_27)) break block121;
                                    var20_37 = var19_27[0];
                                    var56_31 = null;
                                    this.setTaskState("final os flush");
                                    var9_9.flush();
                                    return (boolean)var20_37;
                                }
                                if (var17_17.length() > 0) {
                                    var9_9.write(("HTTP/1.1 301 Moved Permanently\r\nLocation: " + var17_17 + "\r\n" + "\r\n").getBytes());
                                } else {
                                    var9_9.write("HTTP/1.1 404 Not Found\r\n\r\nPage not found.\r\n".getBytes());
                                }
                                var9_9.flush();
                                var18_23 = false;
                                var56_32 = null;
                                this.setTaskState("final os flush");
                                var9_9.flush();
                                return var18_23;
                            }
                            if (this.doAuthentication(var3_3, var1_1, var9_9, true) != null) break block123;
                            var17_18 = false;
                            var56_33 = null;
                            this.setTaskState("final os flush");
                            var9_9.flush();
                            return var17_18;
                        }
                        try {
                            var17_19 = var2_2.indexOf("accept-encoding:");
                            if (var17_19 != -1 && (var18_24 = var1_1.indexOf("\r\n", var17_19)) != -1) {
                                if (var17_19 > 0 && (var19_28 = var2_2.charAt(var17_19 - 1)) != '\n' && var19_28 != ' ') {
                                    var17_19 = -1;
                                }
                                if (var17_19 != -1) {
                                    var19_29 = var2_2.substring(var17_19 + 16, var18_24);
                                    var15_15 = HTTPUtils.canGZIP(var19_29);
                                }
                            }
                            this.setTaskState("decoding announce/scrape");
                            var18_24 = 0;
                            var19_27 = null;
                            var20_38 = null;
                            var21_40 = null;
                            var22_45 = null;
                            var23_47 = 0;
                            var24_49 = null;
                            var25_51 = 0L;
                            var27_56 = 0L;
                            var29_58 = 0L;
                            var31_59 = -1;
                            var32_60 = false;
                            var33_61 = 0;
                            var34_62 = null;
                            var35_63 = 0;
                            var36_64 = 0;
                            var37_65 = 0;
                            var38_66 = 0;
                            var39_67 = 0;
                            var40_68 = false;
                            var41_69 = null;
                            var42_70 = 0;
                            var43_71 = false;
                            var44_72 = null;
                            var46_74 = var45_73 = var5_5.getAddress().getHostAddress();
                            while (var18_24 < var11_11.length()) {
                                var47_75 = var11_11.indexOf(38, var18_24);
                                if (var47_75 == -1) {
                                    var48_77 = var11_11.substring(var18_24);
                                } else {
                                    var48_77 = var11_11.substring(var18_24, var47_75);
                                    var18_24 = var47_75 + 1;
                                }
                                var49_78 = var48_77.indexOf(61);
                                if (var49_78 == -1) {
                                    throw new Exception("format invalid");
                                }
                                var50_80 = var48_77.substring(0, var49_78).toLowerCase();
                                var51_81 = URLDecoder.decode(var48_77.substring(var49_78 + 1), "ISO-8859-1");
                                if (var50_80.equals("info_hash")) {
                                    var52_82 = var51_81.getBytes("ISO-8859-1");
                                    if (var19_27 == null) {
                                        var19_27 = var52_82;
                                    } else {
                                        if (var20_38 == null) {
                                            var20_38 = new ArrayList<byte[]>();
                                            var20_38.add((byte[])var19_27);
                                        }
                                        var20_38.add(var52_82);
                                    }
                                } else if (var50_80.equals("peer_id")) {
                                    var22_45 = new HashWrapper(var51_81.getBytes("ISO-8859-1"));
                                } else if (var50_80.equals("no_peer_id")) {
                                    var32_60 = var51_81.equals("1");
                                } else if (var50_80.equals("compact")) {
                                    if (this.server.isCompactEnabled() && var51_81.equals("1") && var33_61 == 0) {
                                        var33_61 = 1;
                                    }
                                } else if (var50_80.equals("key")) {
                                    if (this.server.isKeyEnabled()) {
                                        var34_62 = var51_81;
                                    }
                                } else if (var50_80.equals("port")) {
                                    var23_47 = Integer.parseInt(var51_81);
                                } else if (var50_80.equals("event")) {
                                    var24_49 = var51_81;
                                } else {
                                    if (var50_80.equals("ip")) {
                                        if (HostNameToIPResolver.isNonDNSName(var51_81)) break block125;
                                        break block126;
                                    }
                                    if (var50_80.equals("uploaded")) {
                                        var25_51 = Long.parseLong(var51_81);
                                    } else if (var50_80.equals("downloaded")) {
                                        var27_56 = Long.parseLong(var51_81);
                                    } else if (var50_80.equals("left")) {
                                        var29_58 = Long.parseLong(var51_81);
                                    } else if (var50_80.equals("numwant")) {
                                        var31_59 = Integer.parseInt(var51_81);
                                    } else if (var50_80.equals("azudp")) {
                                        var37_65 = Integer.parseInt(var51_81);
                                        var33_61 = 2;
                                    } else if (var50_80.equals("azhttp")) {
                                        var38_66 = Integer.parseInt(var51_81);
                                    } else if (var50_80.equals("azver")) {
                                        var39_67 = Integer.parseInt(var51_81);
                                    } else if (var50_80.equals("supportcrypto")) {
                                        if (var35_63 == 0) {
                                            var35_63 = 1;
                                        }
                                    } else if (var50_80.equals("requirecrypto")) {
                                        var35_63 = 2;
                                    } else if (var50_80.equals("cryptoport")) {
                                        var36_64 = Integer.parseInt(var51_81);
                                    } else if (var50_80.equals("azq")) {
                                        var40_68 = true;
                                    } else if (var50_80.equals("azsf")) {
                                        var41_69 = var51_81;
                                    } else if (var50_80.equals("link")) {
                                        var21_40 = var51_81;
                                    } else if (var50_80.equals("outform")) {
                                        if (var51_81.equals("xml")) {
                                            var16_16 = true;
                                        }
                                    } else if (var50_80.equals("hide")) {
                                        var43_71 = Integer.parseInt(var51_81) == 1;
                                    } else if (TRTrackerServerImpl.supportsExtensions()) {
                                        if (var50_80.equals("aznp")) {
                                            try {
                                                var44_72 = DHTNetworkPositionManager.deserialisePosition(var5_5.getAddress(), Base32.decode(var51_81));
                                            }
                                            catch (Throwable var52_85) {}
                                        } else if (var50_80.equals("azup")) {
                                            var42_70 = Integer.parseInt(var51_81);
                                        }
                                    }
                                }
lbl212:
                                // 2 sources

                                ** while (var47_75 == -1)
lbl213:
                                // 1 sources

                            }
lbl214:
                            // 2 sources

                            if (var43_71) {
                                var23_47 = 0;
                                var36_64 = 0;
                                var38_66 = 0;
                                var37_65 = 0;
                            }
                            if (var35_63 == 2 && var36_64 != 0) {
                                var23_47 = var36_64;
                            }
                            var47_76 /* !! */  = null;
                            if (var20_38 != null) {
                                var47_76 /* !! */  = new byte[var20_38.size()][];
                                var20_38.toArray((T[])var47_76 /* !! */ );
                            } else if (var19_27 != null) {
                                var47_76 /* !! */  = new byte[][]{(byte[])var19_27};
                            }
                            if (var16_16) {
                                var33_61 = 16;
                            } else if (var39_67 >= 2) {
                                var33_61 = 3;
                            }
                            var48_77 = new Map[1];
                            var49_79 = new TRTrackerServerPeerImpl[1];
                            var14_14 = this.processTrackerRequest(this.server, var11_11, var48_77, var49_79, var12_12, var47_76 /* !! */ , var21_40, var41_69, var22_45, var32_60, (byte)var33_61, var34_62, var24_49, var40_68, var23_47 & 65535, var37_65 & 65535, var38_66 & 65535, var45_73, var46_74, var27_56, var25_51, var29_58, var31_59, (byte)var35_63, (byte)var39_67, var42_70, var44_72);
                            var13_13 = var48_77[0];
                            if (var12_12 == 2 && var2_2.indexOf(TRTrackerServerProcessorTCP.lc_azureus_name) != -1) {
                                var13_13.put("aztracker", new Long(1L));
                            }
                            if (var13_13.get("_data") == null) {
                                var50_80 = var49_79[0];
                                if (var50_80 == null) {
                                    var50_80 = new TRTrackerServerProcessor.lightweightPeer(var46_74, var23_47, var22_45);
                                }
                                this.server.postProcess((TRTrackerServerPeer)var50_80, var14_14, var12_12, var11_11, var13_13);
                            }
                        }
                        catch (Exception var17_20) {
                            var18_22 = null;
                            var19_27 = null;
                            if (var17_20 instanceof TRTrackerServerException) {
                                var20_38 = (TRTrackerServerException)var17_20;
                                var21_41 = var20_38.getResponseCode();
                                var19_27 = var20_38.getErrorEntries();
                                if (var21_41 != -1) {
                                    var22_46 = "HTTP/1.1 " + var21_41 + " " + var20_38.getResponseText() + "\r\n";
                                    var23_48 = var20_38.getResponseHeaders();
                                    for (Map.Entry<K, V> var25_52 : var23_48.entrySet()) {
                                        var26_87 = (String)var25_52.getKey();
                                        var27_57 = (String)var25_52.getValue();
                                        var22_46 = var22_46 + var26_87 + ": " + var27_57 + "\r\n";
                                    }
                                    var25_53 = null;
                                    if (var19_27 != null) {
                                        var25_54 = BEncoder.encode((Map)var19_27);
                                        var22_46 = var22_46 + "Content-Length: " + var25_54.length + "\r\n";
                                    }
                                    var22_46 = var22_46 + "\r\n";
                                    var9_9.write(var22_46.getBytes());
                                    if (var25_55 != null) {
                                        var9_9.write((byte[])var25_55);
                                    }
                                    var9_9.flush();
                                    var26_88 = false;
                                    var56_34 = null;
                                    this.setTaskState("final os flush");
                                    var9_9.flush();
                                    return var26_88;
                                }
                                if (var20_38.isUserMessage()) {
                                    var18_22 = var20_38.getMessage();
                                }
                            } else if (var17_20 instanceof NullPointerException) {
                                var17_20.printStackTrace();
                            }
                            var20_38 = var17_20.getMessage();
                            if (var20_38 == null || var20_38.length() == 0) {
                                var20_38 = var17_20.toString();
                            }
                            var13_13 = new HashMap<String, Object>();
                            var13_13.put("failure reason", (Long)var20_38);
                            if (var18_22 != null) {
                                var13_13.put("warning message", (Long)var18_22);
                            }
                            if (var19_27 == null) break block127;
                            var13_13.putAll((Map<String, Long>)var19_27);
                        }
                    }
                    this.setTaskState("writing response");
                    if (var16_16) {
                        var19_27 = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                        var19_27.append("<RESULT>");
                        if (var14_14 != null) {
                            var19_27.append("<BTIH>");
                            var19_27.append(ByteFormatter.encodeString(var14_14.getHash().getBytes()));
                            var19_27.append("</BTIH>");
                            var19_27.append(BEncoder.encodeToXML(var13_13, true));
                        }
                        var19_27.append("</RESULT>");
                        var17_21 /* !! */  = var19_27.toString().getBytes("UTF-8");
                        var18_25 = TRTrackerServerProcessorTCP.HTTP_RESPONSE_XML_START;
                    } else {
                        var17_21 /* !! */  = (byte[])var13_13.get("_data");
                        if (var17_21 /* !! */  == null) {
                            var17_21 /* !! */  = BEncoder.encode(var13_13);
                            if (var17_21 /* !! */ .length > 1000000) {
                                var19_27 = new File("bdecoder.dump");
                                var20_38 = TRTrackerServerProcessorTCP.class;
                                // MONITORENTER : org.gudy.azureus2.core3.tracker.server.impl.tcp.TRTrackerServerProcessorTCP.class
                                Debug.out("Output is too large, saving diagnostics to " + var19_27.toString());
                                var21_42 = new PrintWriter(new FileWriter((File)var19_27));
                                BDecoder.print(var21_42, var13_13);
                                var21_42.close();
                            }
                            var13_13.put("_data", (Long)var17_21 /* !! */ );
                        }
                        var18_25 = TRTrackerServerProcessorTCP.HTTP_RESPONSE_START;
                    }
                    if (var15_15) {
                        var19_27 = (byte[])var13_13.get("_gzipdata");
                        if (var19_27 == null) {
                            var20_38 = new ByteArrayOutputStream(var17_21 /* !! */ .length);
                            var21_44 = new GZIPOutputStream((OutputStream)var20_38);
                            var21_44.write(var17_21 /* !! */ );
                            var21_44.close();
                            var19_27 = var20_38.toByteArray();
                            var13_13.put("_gzipdata", (Long)var19_27);
                        }
                        var17_21 /* !! */  = (byte[])var19_27;
                    }
                    this.setTaskState("writing header");
                    var9_9.write(var18_25);
                    var19_27 = String.valueOf(var17_21 /* !! */ .length).getBytes();
                    var9_9.write((byte[])var19_27);
                    var20_39 = var18_25.length + ((Object)var19_27).length;
                    this.setTaskState("writing content");
                    if (var15_15) {
                        var9_9.write(TRTrackerServerProcessorTCP.HTTP_RESPONSE_END_GZIP);
                        var20_39 += TRTrackerServerProcessorTCP.HTTP_RESPONSE_END_GZIP.length;
                    } else {
                        var9_9.write(TRTrackerServerProcessorTCP.HTTP_RESPONSE_END_NOGZIP);
                        var20_39 += TRTrackerServerProcessorTCP.HTTP_RESPONSE_END_NOGZIP.length;
                    }
                    var9_9.write(var17_21 /* !! */ );
                    this.server.updateStats(var12_12, var14_14, var1_1.length(), var20_39 + var17_21 /* !! */ .length);
                    var56_35 = null;
                    this.setTaskState("final os flush");
                    var9_9.flush();
                    return false;
                }
                catch (Throwable var55_89) {
                    var56_36 = null;
                    this.setTaskState("final os flush");
                    var9_9.flush();
                    throw var55_89;
                }
            }
            for (var52_83 = 0; var52_83 < var51_81.length(); ++var52_83) {
                var53_86 = var51_81.charAt(var52_83);
                if (var53_86 == '.' || var53_86 == ':' || Character.isDigit(var53_86)) continue;
                throw new Exception("IP override address must be resolved by the client");
            }
            try {
                var51_81 = HostNameToIPResolver.syncResolve(var51_81).getHostAddress();
            }
            catch (UnknownHostException var52_84) {
                throw new Exception("IP override address must be resolved by the client");
            }
        }
        var46_74 = var51_81;
        ** GOTO lbl212
    }

    protected String doAuthentication(String string, String string2, OutputStream outputStream, boolean bl) throws IOException {
        boolean bl2;
        boolean bl3 = !bl && this.server.isWebPasswordEnabled();
        boolean bl4 = bl2 = bl && this.server.isTrackerPasswordEnabled();
        if (bl3 && this.server.isWebPasswordHTTPSOnly() && !this.server.isSSL()) {
            outputStream.write("HTTP/1.1 403 BAD\r\n\r\nAccess Denied\r\n".getBytes());
            outputStream.flush();
            return null;
        }
        if (bl2 || bl3) {
            int n = string2.indexOf("Authorization:");
            if (n == -1) {
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        String string3 = (this.server.isSSL() ? "https" : "http") + "://" + UrlUtils.convertIPV6Host(this.server.getHost()) + ":" + this.server.getPort() + string;
                        URL uRL = new URL(string3);
                        if (this.server.performExternalAuthorisation(uRL, "", "")) {
                            return "";
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        Debug.printStackTrace(malformedURLException);
                    }
                }
            } else {
                Object object;
                Object object2;
                int n2 = string2.indexOf(32, n);
                int n3 = string2.indexOf(32, n2 + 1);
                String string4 = string2.substring(n3, string2.indexOf(13, n3)).trim();
                String string5 = new String(Base64.decode(string4));
                int n4 = string5.indexOf(58);
                String string6 = string5.substring(0, n4);
                String string7 = string5.substring(n4 + 1);
                boolean bl5 = false;
                if (this.server.hasExternalAuthorisation()) {
                    try {
                        object2 = (this.server.isSSL() ? "https" : "http") + "://" + UrlUtils.convertIPV6Host(this.server.getHost()) + ":" + this.server.getPort() + string;
                        object = new URL((String)object2);
                        if (this.server.performExternalAuthorisation((URL)object, string6, string7)) {
                            return string6;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        Debug.printStackTrace(malformedURLException);
                    }
                    bl5 = true;
                }
                if (this.server.hasInternalAuthorisation() && !bl5) {
                    try {
                        byte[] byArray;
                        object2 = new SHA1Hasher();
                        object = string7.getBytes();
                        byte[] byArray2 = ((byte[])object).length > 0 ? ((SHA1Hasher)object2).calculateHash((byte[])object) : new byte[]{};
                        if (string6.equals("<internal>") ? Arrays.equals(byArray = Base64.decode(string7), this.server.getPassword()) : string6.equalsIgnoreCase(this.server.getUsername()) && Arrays.equals(byArray2, this.server.getPassword())) {
                            return string6;
                        }
                    }
                    catch (Exception exception) {
                        Debug.printStackTrace(exception);
                    }
                }
            }
            outputStream.write(("HTTP/1.1 401 BAD\r\nWWW-Authenticate: Basic realm=\"" + this.server.getName() + "\"\r\n\r\nAccess Denied\r\n").getBytes());
            outputStream.flush();
            return null;
        }
        return "";
    }

    protected boolean handleExternalRequest(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, String string, String string2, String string3, InputStream inputStream, OutputStream outputStream, AsyncController asyncController, boolean[] blArray) throws IOException {
        URL uRL = new URL(this.server_url + (string2.startsWith("/") ? string2 : "/" + string2));
        return this.server.handleExternalRequest(inetSocketAddress, inetSocketAddress2, string, string2, uRL, string3, inputStream, outputStream, asyncController, blArray);
    }
}

