/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.udp;

import com.aelitis.net.udp.uc.PRUDPPacket;
import com.aelitis.net.udp.uc.PRUDPPacketRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.protocol.PRHelpers;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyConnect;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyError;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketReplyScrape2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestAnnounce2;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketRequestScrape;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPPacketTracker;
import org.gudy.azureus2.core3.tracker.protocol.udp.PRUDPTrackerCodecs;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerPeerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerProcessor;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerTorrentImpl;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerUDP;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SystemTime;

public class TRTrackerServerProcessorUDP
extends TRTrackerServerProcessor {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    public static final long CONNECTION_ID_LIFETIME = 180000L;
    private TRTrackerServerUDP server;
    private DatagramSocket socket;
    private DatagramPacket request_dg;
    private static Map connection_id_map = new LinkedHashMap();
    private static SecureRandom random = RandomUtils.SECURE_RANDOM;
    private static AEMonitor random_mon = new AEMonitor("TRTrackerServerUDP:rand");

    protected TRTrackerServerProcessorUDP(TRTrackerServerUDP tRTrackerServerUDP, DatagramSocket datagramSocket, DatagramPacket datagramPacket) {
        this.server = tRTrackerServerUDP;
        this.socket = datagramSocket;
        this.request_dg = datagramPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void runSupport() {
        block30: {
            DataInputStream dataInputStream;
            block29: {
                int n;
                Object[] objectArray;
                TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl;
                PRUDPPacket pRUDPPacket;
                byte[] byArray;
                block28: {
                    byArray = new byte[this.request_dg.getLength()];
                    System.arraycopy(this.request_dg.getData(), 0, byArray, 0, byArray.length);
                    int n2 = byArray.length;
                    String string = null;
                    byte[] byArray2 = null;
                    byte[] byArray3 = null;
                    if (this.server.isTrackerPasswordEnabled()) {
                        int n3;
                        if (byArray.length < 17) {
                            Logger.log(new LogEvent(LOGID, 1, "TRTrackerServerProcessorUDP: packet received but authorisation missing"));
                            return;
                        }
                        byArray2 = new byte[8];
                        byArray3 = new byte[8];
                        System.arraycopy(byArray, n2 -= 16, byArray2, 0, 8);
                        for (n3 = 0; n3 < 8 && byArray2[n3] != 0; ++n3) {
                        }
                        string = new String(byArray2, 0, n3);
                        System.arraycopy(byArray, n2 + 8, byArray3, 0, 8);
                    }
                    dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, 0, n2));
                    String string2 = this.request_dg.getAddress().getHostAddress();
                    PRUDPPacketRequest pRUDPPacketRequest = PRUDPPacketRequest.deserialiseRequest(null, dataInputStream);
                    Logger.log(new LogEvent(LOGID, "TRTrackerServerProcessorUDP: packet received: " + pRUDPPacketRequest.getString()));
                    pRUDPPacket = null;
                    tRTrackerServerTorrentImpl = null;
                    if (byArray2 != null) {
                        Object object;
                        byte[] byArray4 = null;
                        if (this.server.hasExternalAuthorisation()) {
                            try {
                                object = new URL("udp://" + this.server.getHost() + ":" + this.server.getPort() + "/");
                                byArray4 = this.server.performExternalAuthorisation((URL)object, string);
                            }
                            catch (MalformedURLException malformedURLException) {
                                Debug.printStackTrace(malformedURLException);
                            }
                            if (byArray4 == null) {
                                Logger.log(new LogEvent(LOGID, 3, "TRTrackerServerProcessorUDP: auth fails for user '" + string + "'"));
                                pRUDPPacket = new PRUDPPacketReplyError(pRUDPPacketRequest.getTransactionId(), "Access Denied");
                            }
                        } else {
                            byArray4 = this.server.getPassword();
                        }
                        if (pRUDPPacket == null) {
                            object = new SHA1Hasher();
                            ((SHA1Hasher)object).update(byArray, 0, n2);
                            ((SHA1Hasher)object).update(byArray2);
                            ((SHA1Hasher)object).update(byArray4);
                            objectArray = ((SHA1Hasher)object).getDigest();
                            for (int i = 0; i < byArray3.length; ++i) {
                                if (byArray3[i] == objectArray[i]) continue;
                                Logger.log(new LogEvent(LOGID, 3, "TRTrackerServerProcessorUDP: auth fails for user '" + string + "'"));
                                pRUDPPacket = new PRUDPPacketReplyError(pRUDPPacketRequest.getTransactionId(), "Access Denied");
                                break;
                            }
                        }
                    }
                    n = -1;
                    if (pRUDPPacket == null) {
                        if (this.server.isEnabled()) {
                            try {
                                int n4 = pRUDPPacketRequest.getAction();
                                if (n4 == 0) {
                                    pRUDPPacket = this.handleConnect(string2, pRUDPPacketRequest);
                                    break block28;
                                }
                                if (n4 == 1) {
                                    objectArray = this.handleAnnounceAndScrape(string2, pRUDPPacketRequest, 1);
                                    pRUDPPacket = (PRUDPPacket)objectArray[0];
                                    tRTrackerServerTorrentImpl = (TRTrackerServerTorrentImpl)objectArray[1];
                                    n = 1;
                                    break block28;
                                }
                                if (n4 == 2) {
                                    objectArray = this.handleAnnounceAndScrape(string2, pRUDPPacketRequest, 2);
                                    pRUDPPacket = (PRUDPPacket)objectArray[0];
                                    tRTrackerServerTorrentImpl = (TRTrackerServerTorrentImpl)objectArray[1];
                                    n = 2;
                                    break block28;
                                }
                                pRUDPPacket = new PRUDPPacketReplyError(pRUDPPacketRequest.getTransactionId(), "unsupported action");
                            }
                            catch (Throwable throwable) {
                                objectArray = throwable.getMessage();
                                if (objectArray == null) {
                                    objectArray = throwable.toString();
                                }
                                pRUDPPacket = new PRUDPPacketReplyError(pRUDPPacketRequest.getTransactionId(), (String)objectArray);
                            }
                        } else {
                            System.out.println("UDP Tracker: replying 'disabled' to " + string2);
                            pRUDPPacket = new PRUDPPacketReplyError(pRUDPPacketRequest.getTransactionId(), "UDP Tracker disabled");
                        }
                    }
                }
                if (pRUDPPacket == null) break block29;
                InetAddress inetAddress = this.request_dg.getAddress();
                objectArray = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)objectArray);
                pRUDPPacket.serialise(dataOutputStream);
                byte[] byArray5 = objectArray.toByteArray();
                DatagramPacket datagramPacket = new DatagramPacket(byArray5, byArray5.length, inetAddress, this.request_dg.getPort());
                this.socket.send(datagramPacket);
                this.server.updateStats(n, tRTrackerServerTorrentImpl, byArray.length, byArray5.length);
            }
            Object var18_25 = null;
            try {
                dataInputStream.close();
            }
            catch (Throwable throwable) {}
            break block30;
            {
                catch (Throwable throwable) {
                    Logger.log(new LogEvent(LOGID, "TRTrackerServerProcessorUDP: processing fails", throwable));
                    Object var18_26 = null;
                    try {
                        dataInputStream.close();
                    }
                    catch (Throwable throwable2) {}
                }
            }
            catch (Throwable throwable) {
                Object var18_27 = null;
                try {
                    dataInputStream.close();
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void interruptTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long allocateConnectionId(String string) {
        try {
            random_mon.enter();
            long l = random.nextLong();
            Long l2 = new Long(l);
            connectionData connectionData2 = new connectionData(string);
            Iterator iterator = connection_id_map.keySet().iterator();
            while (iterator.hasNext()) {
                Long l3 = (Long)iterator.next();
                connectionData connectionData3 = (connectionData)connection_id_map.get(l3);
                if (connectionData2.getTime() - connectionData3.getTime() <= 180000L) break;
                iterator.remove();
            }
            connection_id_map.put(l2, connectionData2);
            long l4 = l;
            Object var10_9 = null;
            random_mon.exit();
            return l4;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            random_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConnectionId(String string, long l) {
        boolean bl;
        connectionData connectionData2;
        Long l2;
        block3: {
            try {
                random_mon.enter();
                l2 = new Long(l);
                connectionData2 = (connectionData)connection_id_map.get(l2);
                if (connectionData2 != null) break block3;
                boolean bl2 = false;
                Object var9_7 = null;
                random_mon.exit();
                return bl2;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                random_mon.exit();
                throw throwable;
            }
        }
        connection_id_map.remove(l2);
        boolean bl3 = bl = connectionData2.getAddress().equals(string);
        Object var9_8 = null;
        random_mon.exit();
        return bl3;
    }

    protected PRUDPPacket handleConnect(String string, PRUDPPacketRequest pRUDPPacketRequest) {
        long l = this.allocateConnectionId(string);
        PRUDPPacketReplyConnect pRUDPPacketReplyConnect = new PRUDPPacketReplyConnect(pRUDPPacketRequest.getTransactionId(), l);
        return pRUDPPacketReplyConnect;
    }

    protected Object[] handleAnnounceAndScrape(String string, PRUDPPacketRequest pRUDPPacketRequest, int n) throws Exception {
        PRUDPPacketRequest pRUDPPacketRequest2;
        if (!this.checkConnectionId(string, pRUDPPacketRequest.getConnectionId())) {
            return null;
        }
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        HashWrapper hashWrapper = null;
        short s = 0;
        String string2 = null;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n2 = -1;
        String string3 = null;
        if (n == 1) {
            int n3;
            int n4;
            if (PRUDPPacketTracker.VERSION == 1) {
                pRUDPPacketRequest2 = (PRUDPPacketRequestAnnounce)pRUDPPacketRequest;
                arrayList.add(((PRUDPPacketRequestAnnounce)pRUDPPacketRequest2).getHash());
                hashWrapper = new HashWrapper(((PRUDPPacketRequestAnnounce)pRUDPPacketRequest2).getPeerId());
                s = ((PRUDPPacketRequestAnnounce)pRUDPPacketRequest2).getPort();
                n4 = ((PRUDPPacketRequestAnnounce)pRUDPPacketRequest2).getEvent();
                switch (n4) {
                    case 2: {
                        string2 = "started";
                        break;
                    }
                    case 3: {
                        string2 = "stopped";
                        break;
                    }
                    case 1: {
                        string2 = "completed";
                    }
                }
                l = ((PRUDPPacketRequestAnnounce)pRUDPPacketRequest2).getUploaded();
                l2 = ((PRUDPPacketRequestAnnounce)pRUDPPacketRequest2).getDownloaded();
                l3 = ((PRUDPPacketRequestAnnounce)pRUDPPacketRequest2).getLeft();
                n2 = ((PRUDPPacketRequestAnnounce)pRUDPPacketRequest2).getNumWant();
                n3 = ((PRUDPPacketRequestAnnounce)pRUDPPacketRequest2).getIPAddress();
                if (n3 != 0) {
                    string = PRHelpers.intToAddress(n3);
                }
            } else {
                pRUDPPacketRequest2 = (PRUDPPacketRequestAnnounce2)pRUDPPacketRequest;
                arrayList.add(((PRUDPPacketRequestAnnounce2)pRUDPPacketRequest2).getHash());
                hashWrapper = new HashWrapper(((PRUDPPacketRequestAnnounce2)pRUDPPacketRequest2).getPeerId());
                s = ((PRUDPPacketRequestAnnounce2)pRUDPPacketRequest2).getPort();
                n4 = ((PRUDPPacketRequestAnnounce2)pRUDPPacketRequest2).getEvent();
                switch (n4) {
                    case 2: {
                        string2 = "started";
                        break;
                    }
                    case 3: {
                        string2 = "stopped";
                        break;
                    }
                    case 1: {
                        string2 = "completed";
                    }
                }
                l = ((PRUDPPacketRequestAnnounce2)pRUDPPacketRequest2).getUploaded();
                l2 = ((PRUDPPacketRequestAnnounce2)pRUDPPacketRequest2).getDownloaded();
                l3 = ((PRUDPPacketRequestAnnounce2)pRUDPPacketRequest2).getLeft();
                n2 = ((PRUDPPacketRequestAnnounce2)pRUDPPacketRequest2).getNumWant();
                n3 = ((PRUDPPacketRequestAnnounce2)pRUDPPacketRequest2).getIPAddress();
                if (n3 != 0) {
                    string = PRHelpers.intToAddress(n3);
                }
                string3 = "" + ((PRUDPPacketRequestAnnounce2)pRUDPPacketRequest2).getKey();
            }
        } else {
            pRUDPPacketRequest2 = (PRUDPPacketRequestScrape)pRUDPPacketRequest;
            arrayList.addAll(((PRUDPPacketRequestScrape)pRUDPPacketRequest2).getHashes());
        }
        pRUDPPacketRequest2 = new Map[1];
        TRTrackerServerPeerImpl[] tRTrackerServerPeerImplArray = new TRTrackerServerPeerImpl[1];
        TRTrackerServerTorrentImpl tRTrackerServerTorrentImpl = this.processTrackerRequest(this.server, "", (Map[])pRUDPPacketRequest2, tRTrackerServerPeerImplArray, n, (byte[][])arrayList.toArray((T[])new byte[0][0]), null, null, hashWrapper, false, (byte)0, string3, string2, false, s, 0, 0, string, string, l2, l, l3, n2, (byte)0, (byte)1, 0, null);
        PRUDPPacketRequest pRUDPPacketRequest3 = pRUDPPacketRequest2[0];
        if (n == 1) {
            if (PRUDPPacketTracker.VERSION == 1) {
                PRUDPPacketReplyAnnounce pRUDPPacketReplyAnnounce = new PRUDPPacketReplyAnnounce(pRUDPPacketRequest.getTransactionId());
                pRUDPPacketReplyAnnounce.setInterval(((Long)pRUDPPacketRequest3.get("interval")).intValue());
                List list = (List)pRUDPPacketRequest3.get("peers");
                int[] nArray = new int[list.size()];
                short[] sArray = new short[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    Map map = (Map)list.get(i);
                    nArray[i] = PRHelpers.addressToInt(new String((byte[])map.get("ip")));
                    sArray[i] = ((Long)map.get("port")).shortValue();
                }
                pRUDPPacketReplyAnnounce.setPeers(nArray, sArray);
                return new Object[]{pRUDPPacketReplyAnnounce, tRTrackerServerTorrentImpl};
            }
            PRUDPPacketReplyAnnounce2 pRUDPPacketReplyAnnounce2 = new PRUDPPacketReplyAnnounce2(pRUDPPacketRequest.getTransactionId());
            pRUDPPacketReplyAnnounce2.setInterval(((Long)pRUDPPacketRequest3.get("interval")).intValue());
            boolean bl = string.equals("127.0.0.1");
            Map map = tRTrackerServerTorrentImpl.exportScrapeToMap("", string, !bl);
            int n5 = ((Long)map.get("complete")).intValue();
            int n6 = ((Long)map.get("incomplete")).intValue();
            pRUDPPacketReplyAnnounce2.setLeechersSeeders(n6, n5);
            List list = (List)pRUDPPacketRequest3.get("peers");
            int[] nArray = new int[list.size()];
            short[] sArray = new short[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                Map map2 = (Map)list.get(i);
                nArray[i] = PRHelpers.addressToInt(new String((byte[])map2.get("ip")));
                sArray[i] = ((Long)map2.get("port")).shortValue();
            }
            pRUDPPacketReplyAnnounce2.setPeers(nArray, sArray);
            return new Object[]{pRUDPPacketReplyAnnounce2, tRTrackerServerTorrentImpl};
        }
        if (PRUDPPacketTracker.VERSION == 1) {
            PRUDPPacketReplyScrape pRUDPPacketReplyScrape = new PRUDPPacketReplyScrape(pRUDPPacketRequest.getTransactionId());
            Map map = (Map)pRUDPPacketRequest3.get("files");
            byte[][] byArrayArray = new byte[map.size()][];
            int[] nArray = new int[byArrayArray.length];
            int[] nArray2 = new int[byArrayArray.length];
            int[] nArray3 = new int[byArrayArray.length];
            Iterator iterator = map.keySet().iterator();
            int n7 = 0;
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                byArrayArray[n7] = string4.getBytes("ISO-8859-1");
                Map map3 = (Map)map.get(string4);
                nArray[n7] = ((Long)map3.get("complete")).intValue();
                nArray3[n7] = ((Long)map3.get("incomplete")).intValue();
                nArray2[n7] = ((Long)map3.get("downloaded")).intValue();
                ++n7;
            }
            pRUDPPacketReplyScrape.setDetails(byArrayArray, nArray, nArray2, nArray3);
            return new Object[]{pRUDPPacketReplyScrape, tRTrackerServerTorrentImpl};
        }
        PRUDPPacketReplyScrape2 pRUDPPacketReplyScrape2 = new PRUDPPacketReplyScrape2(pRUDPPacketRequest.getTransactionId());
        Map map = (Map)pRUDPPacketRequest3.get("files");
        int[] nArray = new int[map.size()];
        int[] nArray4 = new int[nArray.length];
        int[] nArray5 = new int[nArray.length];
        Iterator iterator = map.keySet().iterator();
        int n8 = 0;
        while (iterator.hasNext()) {
            String string5 = (String)iterator.next();
            Map map4 = (Map)map.get(string5);
            nArray[n8] = ((Long)map4.get("complete")).intValue();
            nArray5[n8] = ((Long)map4.get("incomplete")).intValue();
            nArray4[n8] = ((Long)map4.get("downloaded")).intValue();
            ++n8;
        }
        pRUDPPacketReplyScrape2.setDetails(nArray, nArray4, nArray5);
        return new Object[]{pRUDPPacketReplyScrape2, tRTrackerServerTorrentImpl};
    }

    static {
        PRUDPTrackerCodecs.registerCodecs();
    }

    protected static class connectionData {
        protected String address;
        protected long time;

        protected connectionData(String string) {
            this.address = string;
            this.time = SystemTime.getCurrentTime();
        }

        protected String getAddress() {
            return this.address;
        }

        protected long getTime() {
            return this.time;
        }
    }
}

