/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.server.impl.udp;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.tracker.server.TRTrackerServerRequestListener;
import org.gudy.azureus2.core3.tracker.server.impl.TRTrackerServerImpl;
import org.gudy.azureus2.core3.tracker.server.impl.udp.TRTrackerServerProcessorUDP;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.ThreadPool;

public class TRTrackerServerUDP
extends TRTrackerServerImpl {
    private static final LogIDs LOGID = LogIDs.TRACKER;
    private static final int THREAD_POOL_SIZE = 10;
    private ThreadPool thread_pool;
    private int port;
    private DatagramSocket dg_socket;
    private volatile boolean closed;

    public TRTrackerServerUDP(String string, int n, boolean bl) {
        super(string, bl);
        this.port = n;
        this.thread_pool = new ThreadPool("TrackerServer:UDP:" + this.port, 10);
        try {
            DatagramSocket datagramSocket;
            InetSocketAddress inetSocketAddress;
            InetAddress inetAddress = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
            if (inetAddress == null) {
                inetSocketAddress = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), this.port);
                datagramSocket = new DatagramSocket(this.port);
            } else {
                inetSocketAddress = new InetSocketAddress(inetAddress, this.port);
                datagramSocket = new DatagramSocket(inetSocketAddress);
            }
            datagramSocket.setReuseAddress(true);
            this.dg_socket = datagramSocket;
            final InetSocketAddress inetSocketAddress2 = inetSocketAddress;
            AEThread aEThread = new AEThread("TRTrackerServerUDP:recv.loop"){

                public void runSupport() {
                    TRTrackerServerUDP.this.recvLoop(TRTrackerServerUDP.this.dg_socket, inetSocketAddress2);
                }
            };
            aEThread.setDaemon(true);
            aEThread.start();
            Logger.log(new LogEvent(LOGID, "TRTrackerServerUDP: recv established on port " + this.port));
        }
        catch (Throwable throwable) {
            Logger.log(new LogEvent(LOGID, "TRTrackerServerUDP: DatagramSocket bind failed on port " + this.port, throwable));
        }
    }

    protected void recvLoop(DatagramSocket datagramSocket, InetSocketAddress inetSocketAddress) {
        long l = 0L;
        long l2 = 0L;
        while (!this.closed) {
            try {
                byte[] byArray = new byte[8192];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetSocketAddress);
                datagramSocket.receive(datagramPacket);
                ++l;
                l2 = 0L;
                String string = datagramPacket.getAddress().getHostAddress();
                if (this.ip_filter.isInRange(string, "Tracker", null)) continue;
                this.thread_pool.run(new TRTrackerServerProcessorUDP(this, datagramSocket, datagramPacket));
            }
            catch (Throwable throwable) {
                if (this.closed) continue;
                Logger.log(new LogEvent(LOGID, "TRTrackerServer: receive failed on port " + this.port, throwable));
                if ((++l2 <= 100L || l != 0L) && l2 <= 1000L) continue;
                Logger.logTextResource(new LogAlert(false, 3, "Network.alert.acceptfail"), new String[]{"" + this.port, "UDP"});
                break;
            }
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return COConfigurationManager.getStringParameter("Tracker IP", "");
    }

    public boolean isSSL() {
        return false;
    }

    public void addRequestListener(TRTrackerServerRequestListener tRTrackerServerRequestListener) {
    }

    public void removeRequestListener(TRTrackerServerRequestListener tRTrackerServerRequestListener) {
    }

    protected void closeSupport() {
        this.closed = true;
        try {
            this.dg_socket.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.destroySupport();
    }
}

