/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.tracker.util;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.tracker.client.impl.bt.TRTrackerBTAnnouncerImpl;
import org.gudy.azureus2.core3.tracker.util.TRTrackerUtilsListener;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.UrlUtils;

public class TRTrackerUtils {
    private static String[] BLACKLISTED_HOSTS = new String[]{"krypt.dyndns.org"};
    private static int[] BLACKLISTED_PORTS = new int[]{81};
    private static String tracker_ip;
    private static Set<String> tracker_ip_aliases;
    private static Map override_map;
    private static String bind_ip;
    private static String ports_for_url;
    private static String ports_for_url_with_crypto;
    private static CopyOnWriteList listeners;
    private static AEThread2 listener_thread;
    private static Map az_trackers;
    private static Map udp_probe_results;

    private static String computePortsForURL(boolean bl, boolean bl2) {
        String string;
        int n;
        int n2;
        boolean bl3 = COConfigurationManager.getBooleanParameter("Proxy.Data.Enable") && COConfigurationManager.getBooleanParameter("Proxy.Data.SOCKS.inform");
        if (bl2 &= !COConfigurationManager.getBooleanParameter("Tracker Client No Port Announce")) {
            if (bl3) {
                n2 = 0;
                n = 0;
            } else {
                n2 = COConfigurationManager.getIntParameter("TCP.Listen.Port");
                n = COConfigurationManager.getIntParameter("UDP.Listen.Port");
            }
            string = COConfigurationManager.getStringParameter("TCP.Listen.Port.Override");
            if (!string.equals("")) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Throwable throwable) {
                    Debug.printStackTrace(throwable);
                }
            }
        } else {
            n2 = 0;
            n = 0;
        }
        string = "";
        if (bl) {
            string = string + "&requirecrypto=1";
            string = string + "&port=0&cryptoport=" + n2;
        } else {
            boolean bl4 = COConfigurationManager.getBooleanParameter("network.transport.encrypted.require");
            string = bl4 ? string + "&requirecrypto=1" : string + "&supportcrypto=1";
            string = bl4 && !COConfigurationManager.getBooleanParameter("network.transport.encrypted.fallback.incoming") && COConfigurationManager.getBooleanParameter("network.transport.encrypted.use.crypto.port") ? string + "&port=0&cryptoport=" + n2 : string + "&port=" + n2;
            string = string + "&azudp=" + n;
            if (n2 == 0) {
                string = string + "&hide=1";
            }
            if (COConfigurationManager.getBooleanParameter("HTTP.Data.Listen.Port.Enable")) {
                int n3 = COConfigurationManager.getIntParameter("HTTP.Data.Listen.Port.Override");
                if (n3 == 0) {
                    n3 = COConfigurationManager.getIntParameter("HTTP.Data.Listen.Port");
                }
                string = string + "&azhttp=" + n3;
            }
        }
        return string;
    }

    public static String getPublicIPOverride() {
        String string = COConfigurationManager.getStringParameter("Override Ip", "");
        if (string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
            while (stringTokenizer.hasMoreTokens()) {
                String string2;
                String string3 = stringTokenizer.nextToken().trim();
                if (string3.length() <= 0 || (string2 = AENetworkClassifier.categoriseAddress(string3)) != "Public") continue;
                return string3;
            }
        }
        return null;
    }

    static void readConfig() {
        String[] stringArray;
        tracker_ip = COConfigurationManager.getStringParameter("Tracker IP", "");
        tracker_ip = UrlUtils.expandIPV6Host(tracker_ip);
        String string = COConfigurationManager.getStringParameter("Tracker IP Aliases", "");
        if (string.length() > 0) {
            tracker_ip_aliases = new HashSet<String>();
            stringArray = string.split(",");
            for (String string2 : stringArray) {
                String object = string2.trim();
                if (object.length() <= 0) continue;
                tracker_ip_aliases.add(object);
            }
        } else {
            tracker_ip_aliases = null;
        }
        stringArray = COConfigurationManager.getStringParameter("Override Ip", "");
        StringTokenizer stringTokenizer = new StringTokenizer((String)stringArray, ";");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.length() <= 0) continue;
            hashMap.put(AENetworkClassifier.categoriseAddress(string2), string2);
        }
        override_map = hashMap;
        InetAddress inetAddress = NetworkAdmin.getSingleton().getSingleHomedServiceBindAddress();
        bind_ip = inetAddress == null || inetAddress.isAnyLocalAddress() ? "" : inetAddress.getHostAddress();
    }

    public static boolean isHosting(URL uRL) {
        if (tracker_ip.length() > 0) {
            String string = UrlUtils.expandIPV6Host(uRL.getHost());
            boolean bl = string.equalsIgnoreCase(tracker_ip);
            if (!bl && tracker_ip_aliases != null) {
                bl = tracker_ip_aliases.contains(string);
            }
            return bl;
        }
        return false;
    }

    public static String getTrackerIP() {
        return tracker_ip;
    }

    public static boolean isTrackerEnabled() {
        return TRTrackerUtils.getAnnounceURLs().length > 0;
    }

    public static URL[][] getAnnounceURLs() {
        List list;
        String string = COConfigurationManager.getStringParameter("Tracker IP", "");
        ArrayList arrayList = new ArrayList();
        if (string.length() > 0) {
            int n;
            ArrayList<URL> arrayList2;
            int n2;
            if (COConfigurationManager.getBooleanParameter("Tracker Port Enable")) {
                n2 = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                try {
                    arrayList2 = new ArrayList<URL>();
                    arrayList2.add(new URL("http://" + UrlUtils.convertIPV6Host(string) + ":" + n2 + "/announce"));
                    list = TRTrackerUtils.stringToPorts(COConfigurationManager.getStringParameter("Tracker Port Backups"));
                    for (n = 0; n < list.size(); ++n) {
                        arrayList2.add(new URL("http://" + UrlUtils.convertIPV6Host(string) + ":" + (Integer)list.get(n) + "/announce"));
                    }
                    arrayList.add(arrayList2);
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.printStackTrace(malformedURLException);
                }
            }
            if (COConfigurationManager.getBooleanParameter("Tracker Port SSL Enable")) {
                n2 = COConfigurationManager.getIntParameter("Tracker Port SSL", 7000);
                try {
                    arrayList2 = new ArrayList();
                    arrayList2.add(new URL("https://" + UrlUtils.convertIPV6Host(string) + ":" + n2 + "/announce"));
                    list = TRTrackerUtils.stringToPorts(COConfigurationManager.getStringParameter("Tracker Port SSL Backups"));
                    for (n = 0; n < list.size(); ++n) {
                        arrayList2.add(new URL("https://" + UrlUtils.convertIPV6Host(string) + ":" + (Integer)list.get(n) + "/announce"));
                    }
                    arrayList.add(arrayList2);
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.printStackTrace(malformedURLException);
                }
            }
            if (COConfigurationManager.getBooleanParameter("Tracker Port UDP Enable")) {
                n2 = COConfigurationManager.getIntParameter("Tracker Port", 6969);
                boolean bl = COConfigurationManager.getBooleanParameter("Tracker Password Enable Torrent");
                try {
                    list = new ArrayList<URL>();
                    list.add(new URL("udp://" + UrlUtils.convertIPV6Host(string) + ":" + n2 + "/announce" + (bl ? "?auth" : "")));
                    arrayList.add(list);
                }
                catch (MalformedURLException malformedURLException) {
                    Debug.printStackTrace(malformedURLException);
                }
            }
        }
        URL[][] uRLArray = new URL[arrayList.size()][];
        for (int i = 0; i < arrayList.size(); ++i) {
            list = (ArrayList<URL>)arrayList.get(i);
            URL[] uRLArray2 = new URL[list.size()];
            list.toArray(uRLArray2);
            uRLArray[i] = uRLArray2;
        }
        return uRLArray;
    }

    protected static List stringToPorts(String string) {
        string = string.replace(',', ';');
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        while (stringTokenizer.hasMoreTokens()) {
            try {
                arrayList.add(new Integer(stringTokenizer.nextToken().trim()));
            }
            catch (Throwable throwable) {
                Debug.out("Invalid port entry in '" + string + "'", throwable);
            }
        }
        return arrayList;
    }

    public static URL adjustURLForHosting(URL uRL) {
        if (TRTrackerUtils.isHosting(uRL)) {
            String string = uRL.getProtocol() + "://";
            string = bind_ip.length() < 7 ? string + "127.0.0.1" : string + bind_ip;
            int n = uRL.getPort();
            if (n != -1) {
                string = string + ":" + uRL.getPort();
            }
            string = string + uRL.getPath();
            String string2 = uRL.getQuery();
            if (string2 != null) {
                string = string + "?" + string2;
            }
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                Debug.printStackTrace(malformedURLException);
            }
        }
        return uRL;
    }

    public static String adjustHostFromHosting(String string) {
        if (tracker_ip.length() > 0) {
            String string2 = AENetworkClassifier.categoriseAddress(string);
            String string3 = (String)override_map.get(string2);
            if (string3 == null) {
                string3 = tracker_ip;
            }
            if (TRTrackerUtils.isLoopback(string)) {
                return string3;
            }
        }
        return string;
    }

    public static boolean isLoopback(String string) {
        return string.equals("127.0.0.1") || string.equals("0:0:0:0:0:0:0:1") || string.equals("::1") || string.equals(bind_ip);
    }

    public static void checkForBlacklistedURLs(URL uRL) throws IOException {
        for (int i = 0; i < BLACKLISTED_HOSTS.length; ++i) {
            if (!uRL.getHost().equalsIgnoreCase(BLACKLISTED_HOSTS[i]) || uRL.getPort() != BLACKLISTED_PORTS[i]) continue;
            throw new IOException("http://" + BLACKLISTED_HOSTS[i] + ":" + BLACKLISTED_PORTS[i] + "/ is not a tracker");
        }
    }

    public static Map mergeResponseCache(Map map, Map map2) {
        return TRTrackerBTAnnouncerImpl.mergeResponseCache(map, map2);
    }

    public static String getPortsForURL() {
        return ports_for_url;
    }

    public static String getPortsForURLFullCrypto() {
        return ports_for_url_with_crypto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAZTracker(URL uRL) {
        String string = uRL.getHost();
        if (Constants.isAzureusDomain(string)) {
            return true;
        }
        Map map = az_trackers;
        synchronized (map) {
            return az_trackers.containsKey(string + ":" + uRL.getPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAZTracker(URL uRL, boolean bl) {
        String string = uRL.getHost() + ":" + uRL.getPort();
        Map map = az_trackers;
        synchronized (map) {
            boolean bl2 = false;
            if (az_trackers.get(string) == null) {
                if (bl) {
                    az_trackers.put(string, new Long(SystemTime.getCurrentTime()));
                    bl2 = true;
                }
            } else if (!bl && az_trackers.remove(string) != null) {
                bl2 = true;
            }
            if (bl2) {
                COConfigurationManager.setParameter("Tracker Client AZ Instances", az_trackers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isUDPProbeOK(URL uRL) {
        String string = uRL.getHost();
        if (Constants.isAzureusDomain(string)) {
            return false;
        }
        Map map = udp_probe_results;
        synchronized (map) {
            return udp_probe_results.containsKey(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUDPProbeResult(URL uRL, boolean bl) {
        String string = uRL.getHost();
        Map map = udp_probe_results;
        synchronized (map) {
            boolean bl2 = false;
            if (udp_probe_results.get(string) == null) {
                if (bl) {
                    if (udp_probe_results.size() > 512) {
                        udp_probe_results.clear();
                    }
                    udp_probe_results.put(string, new Long(SystemTime.getCurrentTime()));
                    bl2 = true;
                }
            } else if (!bl && udp_probe_results.remove(string) != null) {
                bl2 = true;
            }
            if (bl2) {
                COConfigurationManager.setParameter("Tracker Client UDP Probe Results", udp_probe_results);
            }
        }
    }

    public static void addListener(TRTrackerUtilsListener tRTrackerUtilsListener) {
        listeners.add(tRTrackerUtilsListener);
    }

    public static void removeListener(TRTrackerUtilsListener tRTrackerUtilsListener) {
        listeners.remove(tRTrackerUtilsListener);
    }

    static {
        listeners = new CopyOnWriteList();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"Proxy.Data.Enable", "Proxy.Data.SOCKS.inform", "TCP.Listen.Port.Override", "Tracker Client No Port Announce", "network.transport.encrypted.use.crypto.port", "network.transport.encrypted.require", "network.transport.encrypted.fallback.incoming", "TCP.Listen.Port", "UDP.Listen.Port", "HTTP.Data.Listen.Port", "HTTP.Data.Listen.Port.Override", "HTTP.Data.Listen.Port.Enable", "Tracker Client Min Announce Interval"}, new ParameterListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void parameterChanged(String string) {
                String string2 = TRTrackerUtils.computePortsForURL(false, true);
                String string3 = TRTrackerUtils.computePortsForURL(true, false);
                if (ports_for_url != null && !ports_for_url.equals(string2)) {
                    CopyOnWriteList copyOnWriteList = listeners;
                    synchronized (copyOnWriteList) {
                        if (listener_thread == null) {
                            listener_thread = new AEThread2("TRTrackerUtils:listener", true){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    try {
                                        Thread.sleep(30000L);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    Object object = listeners;
                                    synchronized (object) {
                                        listener_thread = null;
                                    }
                                    object = listeners.iterator();
                                    while (object.hasNext()) {
                                        try {
                                            ((TRTrackerUtilsListener)object.next()).announceDetailsChanged();
                                        }
                                        catch (Throwable throwable) {
                                            Debug.printStackTrace(throwable);
                                        }
                                    }
                                }
                            };
                            listener_thread.start();
                        }
                    }
                }
                ports_for_url = string2;
                ports_for_url_with_crypto = string3;
            }
        });
        az_trackers = COConfigurationManager.getMapParameter("Tracker Client AZ Instances", new HashMap());
        udp_probe_results = COConfigurationManager.getMapParameter("Tracker Client UDP Probe Results", new HashMap());
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                TRTrackerUtils.readConfig();
            }
        });
        NetworkAdmin.getSingleton().addPropertyChangeListener(new NetworkAdminPropertyChangeListener(){

            public void propertyChanged(String string) {
                if (string == "Default Bind IP") {
                    TRTrackerUtils.readConfig();
                }
            }
        });
        TRTrackerUtils.readConfig();
    }
}

