/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.TimeZone;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemTime;

public class AEDiagnosticsLogger {
    private static final int MAX_PENDING = 8192;
    private String name;
    private int max_size;
    private File debug_dir;
    private boolean timestamp_enable = true;
    private boolean force;
    private boolean first_file = true;
    private boolean first_write = true;
    private PrintWriter current_writer;
    private LinkedList<StringBuilder> pending;
    private int pending_size;
    private boolean direct_writes;
    private boolean close_pws = false;
    private static final String start_date;
    private static final long timezone_offset;

    protected AEDiagnosticsLogger(File file, String string, int n, boolean bl) {
        this.debug_dir = file;
        this.name = string;
        this.max_size = n;
        this.direct_writes = bl;
        try {
            File file2 = this.getLogFile();
            this.first_file = false;
            File file3 = this.getLogFile();
            this.first_file = true;
            if (file2.exists() && file3.exists() && file2.lastModified() < file3.lastModified()) {
                this.first_file = false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void setForced() {
        this.force = true;
    }

    protected String getName() {
        return this.name;
    }

    public void setMaxFileSize(int n) {
        this.max_size = n;
    }

    public void enableTimeStamp(boolean bl) {
        this.timestamp_enable = bl;
    }

    public void log(Throwable throwable) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(byteArrayOutputStream));
            throwable.printStackTrace(printWriter);
            printWriter.close();
            this.log(byteArrayOutputStream.toString());
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public void logAndOut(String string) {
        this.logAndOut(string, false);
    }

    public void logAndOut(String string, boolean bl) {
        if (bl) {
            System.err.println(string);
        } else {
            System.out.println(string);
        }
        this.log(string);
    }

    public void logAndOut(Throwable throwable) {
        throwable.printStackTrace();
        this.log(throwable);
    }

    public static String getTimestamp() {
        long l = SystemTime.getCurrentTime();
        l += timezone_offset;
        int n = (int)(l /= 1000L) % 60;
        int n2 = (int)(l / 60L) % 60;
        int n3 = (int)(l / 3600L) % 24;
        char[] cArray = new char[11];
        cArray[0] = 91;
        AEDiagnosticsLogger.format(n3, cArray, 1);
        cArray[3] = 58;
        AEDiagnosticsLogger.format(n2, cArray, 4);
        cArray[6] = 58;
        AEDiagnosticsLogger.format(n, cArray, 7);
        cArray[9] = 93;
        cArray[10] = 32;
        return new String(cArray);
    }

    private static final void format(int n, char[] cArray, int n2) {
        if (n < 10) {
            cArray[n2] = 48;
            cArray[n2 + 1] = (char)(48 + n);
        } else {
            cArray[n2] = (char)(48 + n / 10);
            cArray[n2 + 1] = (char)(48 + n % 10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void log(String string) {
        if (!AEDiagnostics.loggers_enabled && !this.force) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + 20);
        String string2 = this.timestamp_enable ? AEDiagnosticsLogger.getTimestamp() : null;
        AEDiagnosticsLogger aEDiagnosticsLogger = this;
        synchronized (aEDiagnosticsLogger) {
            if (this.first_write) {
                this.first_write = false;
                Calendar calendar = GregorianCalendar.getInstance();
                stringBuilder.append("\r\n[");
                stringBuilder.append(start_date);
                stringBuilder.append("] Log File Opened for ");
                stringBuilder.append(Constants.APP_NAME);
                stringBuilder.append(" ");
                stringBuilder.append("4.3.0.4");
                stringBuilder.append("\r\n");
            }
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            stringBuilder.append(string);
            if (!this.direct_writes) {
                if (this.pending == null) {
                    this.pending = new LinkedList();
                }
                this.pending.add(stringBuilder);
                this.pending_size += stringBuilder.length();
                if (this.pending_size > 8192) {
                    this.writePending();
                }
                return;
            }
            this.write(stringBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(StringBuilder stringBuilder) {
        try {
            File file = this.getLogFile();
            if (file.length() >= (long)this.max_size) {
                if (this.current_writer != null) {
                    this.current_writer.close();
                    this.current_writer = null;
                }
                this.first_file = !this.first_file;
                file = this.getLogFile();
                file.delete();
            }
            if (this.current_writer == null) {
                this.current_writer = new PrintWriter(new FileWriter(file, true));
            }
            this.current_writer.println(stringBuilder);
            this.current_writer.flush();
        }
        catch (Throwable throwable) {
        }
        finally {
            if (this.current_writer != null && this.close_pws) {
                this.current_writer.close();
                this.current_writer = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writePending() {
        AEDiagnosticsLogger aEDiagnosticsLogger = this;
        synchronized (aEDiagnosticsLogger) {
            if (this.pending == null) {
                return;
            }
            try {
                File file = this.getLogFile();
                if (file.length() >= (long)this.max_size) {
                    if (this.current_writer != null) {
                        this.current_writer.close();
                        this.current_writer = null;
                    }
                    this.first_file = !this.first_file;
                    file = this.getLogFile();
                    file.delete();
                }
                if (this.current_writer == null) {
                    this.current_writer = new PrintWriter(new FileWriter(file, true));
                }
                for (StringBuilder stringBuilder : this.pending) {
                    this.current_writer.println(stringBuilder);
                }
                this.current_writer.flush();
            }
            catch (Throwable throwable) {
            }
            finally {
                this.direct_writes = true;
                this.pending = null;
                if (this.current_writer != null && this.close_pws) {
                    this.current_writer.close();
                    this.current_writer = null;
                }
            }
        }
    }

    private File getLogFile() {
        return new File(this.debug_dir, this.getName() + "_" + (this.first_file ? "1" : "2") + ".log");
    }

    private static String format(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    static {
        long l = System.currentTimeMillis();
        start_date = new SimpleDateFormat().format(new Date(l));
        timezone_offset = TimeZone.getDefault().getOffset(l);
    }
}

