/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.Collections;
import java.util.Map;
import org.gudy.azureus2.core3.util.AEMonSem;
import org.gudy.azureus2.core3.util.Debug;

public class AEMonitor
extends AEMonSem {
    private int dont_wait = 1;
    private int nests = 0;
    private int total_reserve = 0;
    private int total_release = 1;
    protected Thread owner;
    protected Thread last_waiter;

    public AEMonitor(String string) {
        super(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enter() {
        if (DEBUG) {
            this.debugEntry();
        }
        Thread thread = Thread.currentThread();
        AEMonitor aEMonitor = this;
        synchronized (aEMonitor) {
            ++this.entry_count;
            if (this.owner == thread) {
                ++this.nests;
            } else {
                block14: {
                    if (this.dont_wait == 0) {
                        try {
                            try {
                                block13: {
                                    ++this.waiting;
                                    this.last_waiter = thread;
                                    if (this.waiting > 1) {
                                        // empty if block
                                    }
                                    int n = 0;
                                    do {
                                        this.wait();
                                        if (this.total_reserve != this.total_release) break block13;
                                    } while (++n <= 1024);
                                    --this.waiting;
                                    Debug.out("AEMonitor: spurious wakeup limit exceeded");
                                    throw new Throwable("die die die");
                                }
                                ++this.total_reserve;
                            }
                            catch (Throwable throwable) {
                                --this.waiting;
                                this.owner = thread;
                                Debug.out("**** monitor interrupted ****");
                                throw new RuntimeException("AEMonitor:interrupted");
                            }
                            Object var5_5 = null;
                            this.last_waiter = null;
                            break block14;
                        }
                        catch (Throwable throwable) {
                            Object var5_6 = null;
                            this.last_waiter = null;
                            throw throwable;
                        }
                    }
                    ++this.total_reserve;
                    --this.dont_wait;
                }
                this.owner = thread;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean enter(int n) {
        if (DEBUG) {
            this.debugEntry();
        }
        Thread thread = Thread.currentThread();
        AEMonitor aEMonitor = this;
        synchronized (aEMonitor) {
            ++this.entry_count;
            if (this.owner == thread) {
                ++this.nests;
            } else {
                if (this.dont_wait == 0) {
                    try {
                        try {
                            ++this.waiting;
                            this.last_waiter = thread;
                            this.wait(n);
                            if (this.total_reserve == this.total_release) {
                                --this.waiting;
                                boolean bl = false;
                                Object var6_6 = null;
                                this.last_waiter = null;
                                return bl;
                            }
                            ++this.total_reserve;
                        }
                        catch (Throwable throwable) {
                            --this.waiting;
                            this.owner = thread;
                            Debug.out("**** monitor interrupted ****");
                            throw new RuntimeException("AEMonitor:interrupted");
                        }
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        this.last_waiter = null;
                        throw throwable;
                    }
                    Object var6_7 = null;
                    this.last_waiter = null;
                } else {
                    ++this.total_reserve;
                    --this.dont_wait;
                }
                this.owner = thread;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void exit() {
        try {
            AEMonitor aEMonitor = this;
            synchronized (aEMonitor) {
                if (this.nests > 0) {
                    if (DEBUG && this.owner != Thread.currentThread()) {
                        Debug.out("nested exit but current thread not owner");
                    }
                    --this.nests;
                } else {
                    this.owner = null;
                    ++this.total_release;
                    if (this.waiting != 0) {
                        --this.waiting;
                        this.notify();
                    } else {
                        ++this.dont_wait;
                        if (this.dont_wait > 1) {
                            Debug.out("**** AEMonitor '" + this.name + "': multiple exit detected");
                        }
                    }
                }
            }
            Object var4_3 = null;
            if (!DEBUG) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!DEBUG) throw throwable;
            this.debugExit();
            throw throwable;
        }
        this.debugExit();
    }

    public boolean isHeld() {
        return this.owner == Thread.currentThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasWaiters() {
        AEMonitor aEMonitor = this;
        synchronized (aEMonitor) {
            return this.waiting > 0;
        }
    }

    public static Map getSynchronisedMap(Map map) {
        return Collections.synchronizedMap(map);
    }
}

