/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gudy.azureus2.core3.util.AEVerifierException;

public class AEVerifier {
    private static final String pub_exp = "10001";
    private static final String modulus = "9a68296f49bf47b2a83ae4ba3cdb5a840a2689e5b36a6f2bfc27b916fc4dc9437f9087c4f0b5ae2fc5127a901b3c048753aa63d29cd7f9da7c81d475380de68236bd919230b0074aa6f40f29a78ac4a14e84fb8946cbcb5a840d1c2f77d83c795c289e37135843b8da008e082654a83b8bd3341b9f2ff6064e20b6c7ba89a707a1f3e1d8b2e0035dae539b04e49775eba23e5cbe89e22290da6c84ec3f450d07";

    public static void verifyData(File file) throws AEVerifierException, Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(pub_exp, 16));
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        AEVerifier.verifyData(file, rSAPublicKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void verifyData(File file, RSAPublicKey rSAPublicKey) throws AEVerifierException, Exception {
        ZipInputStream zipInputStream = null;
        try {
            ZipEntry zipEntry;
            zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            byte[] byArray = null;
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(rSAPublicKey);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                int n;
                if (zipEntry.isDirectory()) continue;
                String string = zipEntry.getName();
                ByteArrayOutputStream byteArrayOutputStream = null;
                if (string.equalsIgnoreCase("azureus.sig")) {
                    byteArrayOutputStream = new ByteArrayOutputStream();
                }
                byte[] byArray2 = new byte[65536];
                while ((n = zipInputStream.read(byArray2)) > 0) {
                    if (byteArrayOutputStream == null) {
                        signature.update(byArray2, 0, n);
                        continue;
                    }
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                if (byteArrayOutputStream == null) continue;
                byArray = byteArrayOutputStream.toByteArray();
            }
            if (byArray == null) {
                throw new AEVerifierException(1, "Signature missing from file");
            }
            if (!signature.verify(byArray)) {
                throw new AEVerifierException(2, "Signature doesn't match data");
            }
            Object var11_10 = null;
            if (zipInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (zipInputStream == null) throw throwable;
            zipInputStream.close();
            throw throwable;
        }
        zipInputStream.close();
    }

    public static void verifyData(String string, byte[] byArray) throws AEVerifierException, Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(modulus, 16), new BigInteger(pub_exp, 16));
        RSAPublicKey rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        Signature signature = Signature.getInstance("MD5withRSA");
        signature.initVerify(rSAPublicKey);
        signature.update(string.getBytes("UTF-8"));
        if (!signature.verify(byArray)) {
            throw new AEVerifierException(2, "Data verification failed, signature doesn't match data");
        }
    }
}

