/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.instancemanager.AZInstance;
import com.aelitis.azureus.core.instancemanager.AZInstanceManager;
import com.aelitis.azureus.core.proxy.AEProxyFactory;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HostNameToIPResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressUtils {
    public static final byte LAN_LOCAL_MAYBE = 0;
    public static final byte LAN_LOCAL_YES = 1;
    public static final byte LAN_LOCAL_NO = 2;
    private static AZInstanceManager instance_manager;
    private static Map host_map;

    public static URL adjustURL(URL uRL) {
        String string;
        uRL = AEProxyFactory.getAddressMapper().internalise(uRL);
        if (host_map != null && (string = (String)host_map.get(uRL.getHost())) != null) {
            String string2 = uRL.toExternalForm();
            try {
                int n = string2.indexOf("//") + 2;
                int n2 = string2.indexOf("/", n);
                String string3 = string2.substring(n, n2);
                int n3 = string3.indexOf(58);
                String string4 = n3 == -1 ? "" : string3.substring(n3);
                String string5 = string2.substring(0, n) + string + string4 + string2.substring(n2);
                uRL = new URL(string5);
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        return uRL;
    }

    public static synchronized void addHostRedirect(String string, String string2) {
        System.out.println("AddressUtils::addHostRedirect - " + string + " -> " + string2);
        HashMap<String, String> hashMap = host_map == null ? new HashMap<String, String>() : new HashMap(host_map);
        hashMap.put(string, string2);
        host_map = hashMap;
    }

    public static InetSocketAddress adjustTCPAddress(InetSocketAddress inetSocketAddress, boolean bl) {
        return AddressUtils.adjustAddress(inetSocketAddress, bl, 1);
    }

    public static InetSocketAddress adjustUDPAddress(InetSocketAddress inetSocketAddress, boolean bl) {
        return AddressUtils.adjustAddress(inetSocketAddress, bl, 2);
    }

    public static InetSocketAddress adjustDHTAddress(InetSocketAddress inetSocketAddress, boolean bl) {
        return AddressUtils.adjustAddress(inetSocketAddress, bl, 3);
    }

    private static InetSocketAddress adjustAddress(InetSocketAddress inetSocketAddress, boolean bl, int n) {
        if (instance_manager == null) {
            try {
                instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        if (instance_manager == null || !instance_manager.isInitialized()) {
            return inetSocketAddress;
        }
        InetSocketAddress inetSocketAddress2 = bl ? instance_manager.getLANAddress(inetSocketAddress, n) : instance_manager.getExternalAddress(inetSocketAddress, n);
        if (inetSocketAddress2 == null) {
            inetSocketAddress2 = inetSocketAddress;
        }
        return inetSocketAddress2;
    }

    public static List getLANAddresses(String string) {
        ArrayList<String> arrayList;
        block8: {
            arrayList = new ArrayList<String>();
            arrayList.add(string);
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                if (AddressUtils.isLANLocalAddress(string) == 2) break block8;
                if (instance_manager == null) {
                    try {
                        instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
                    }
                    catch (Throwable throwable) {
                        Debug.printStackTrace(throwable);
                    }
                }
                if (instance_manager == null || !instance_manager.isInitialized()) {
                    return arrayList;
                }
                AZInstance[] aZInstanceArray = instance_manager.getOtherInstances();
                for (int i = 0; i < aZInstanceArray.length; ++i) {
                    AZInstance aZInstance = aZInstanceArray[i];
                    List list = aZInstance.getInternalAddresses();
                    if (!list.contains(inetAddress)) continue;
                    for (int j = 0; j < list.size(); ++j) {
                        InetAddress inetAddress2 = (InetAddress)list.get(j);
                        String string2 = inetAddress2.getHostAddress();
                        if (arrayList.contains(string2)) continue;
                        arrayList.add(string2);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public static byte isLANLocalAddress(InetSocketAddress inetSocketAddress) {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        return AddressUtils.isLANLocalAddress(inetAddress);
    }

    public static byte isLANLocalAddress(InetAddress inetAddress) {
        if (inetAddress == null) {
            return 2;
        }
        if (instance_manager == null && AzureusCoreFactory.isCoreAvailable()) {
            try {
                instance_manager = AzureusCoreFactory.getSingleton().getInstanceManager();
            }
            catch (Throwable throwable) {
                Debug.printStackTrace(throwable);
            }
        }
        if (instance_manager == null || !instance_manager.isInitialized()) {
            return 0;
        }
        return instance_manager.isLANAddress(inetAddress) ? (byte)1 : 2;
    }

    public static byte isLANLocalAddress(String string) {
        byte by = 0;
        try {
            by = AddressUtils.isLANLocalAddress(HostNameToIPResolver.syncResolve(string));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return by;
    }

    public static boolean isGlobalAddressV6(InetAddress inetAddress) {
        return inetAddress instanceof Inet6Address && !inetAddress.isAnyLocalAddress() && !inetAddress.isLinkLocalAddress() && !inetAddress.isLoopbackAddress() && !inetAddress.isMulticastAddress() && !inetAddress.isSiteLocalAddress() && !((Inet6Address)inetAddress).isIPv4CompatibleAddress();
    }

    public static boolean isTeredo(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet6Address)) {
            return false;
        }
        byte[] byArray = inetAddress.getAddress();
        return byArray[0] == 32 && byArray[1] == 1 && byArray[2] == 0 && byArray[3] == 0;
    }

    public static boolean is6to4(InetAddress inetAddress) {
        if (!(inetAddress instanceof Inet6Address)) {
            return false;
        }
        byte[] byArray = inetAddress.getAddress();
        return byArray[0] == 32 && byArray[1] == 2;
    }

    public static InetAddress pickBestGlobalV6Address(List<InetAddress> list) {
        InetAddress inetAddress = null;
        int n = 0;
        for (InetAddress inetAddress2 : list) {
            if (!AddressUtils.isGlobalAddressV6(inetAddress2)) continue;
            int n2 = 3;
            if (AddressUtils.isTeredo(inetAddress2)) {
                n2 = 1;
            } else if (AddressUtils.is6to4(inetAddress2)) {
                n2 = 2;
            }
            if (n2 <= n) continue;
            inetAddress = inetAddress2;
            n = n2;
        }
        return inetAddress;
    }

    static {
        host_map = null;
    }
}

