/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;

public class Average {
    private final int refreshRate;
    private final int period;
    private final int nbElements;
    private long lastUpdate;
    private long[] values;

    protected Average(int n, int n2) {
        this.refreshRate = n;
        this.period = n2;
        this.nbElements = n2 * 1000 / n + 2;
        this.lastUpdate = this.getEffectiveTime() / (long)n;
    }

    public static Average getInstance(int n, int n2) {
        if (n < 100) {
            return null;
        }
        if (n2 * 1000 < n) {
            return null;
        }
        return new Average(n, n2);
    }

    public synchronized void clear() {
        this.values = null;
        this.lastUpdate = this.getEffectiveTime() / (long)this.refreshRate;
    }

    public synchronized void cloneFrom(Average average) {
        Object[] objectArray = average.getCloneDetails();
        this.values = (long[])objectArray[0];
        this.lastUpdate = (Long)objectArray[1];
    }

    private synchronized Object[] getCloneDetails() {
        return new Object[]{this.values, new Long(this.lastUpdate)};
    }

    private void update(long l) {
        if (this.lastUpdate < l - (long)this.nbElements) {
            this.lastUpdate = l - (long)this.nbElements - 1L;
        }
        if (this.values != null) {
            for (long i = this.lastUpdate + 1L; i <= l; ++i) {
                this.values[(int)(i % (long)this.nbElements)] = 0L;
            }
            this.values[(int)((l + 1L) % (long)this.nbElements)] = 0L;
        }
        this.lastUpdate = l;
    }

    public synchronized void addValue(long l) {
        if (this.values == null && l != 0L) {
            this.values = new long[this.nbElements];
        }
        if (this.values != null) {
            long l2 = this.getEffectiveTime() / (long)this.refreshRate;
            this.update(l2);
            int n = (int)(l2 % (long)this.nbElements);
            this.values[n] = this.values[n] + l;
        }
    }

    public long getAverage() {
        return this.getSum() / (long)this.period;
    }

    public double getDoubleAverage() {
        return (double)this.getSum() / (double)this.period;
    }

    public String getDoubleAverageAsString(int n) {
        return DisplayFormatters.formatDecimal(this.getDoubleAverage(), n);
    }

    public long getAverage(int n) {
        int n2;
        int n3 = n2 = n <= 0 ? this.nbElements - 2 : n / this.refreshRate;
        if (n2 <= 0) {
            n2 = 1;
        } else if (n2 > this.nbElements - 2) {
            n2 = this.nbElements - 2;
        }
        if (n2 == 1) {
            return this.getPointValue();
        }
        long l = this.getSum(n2) / (long)(this.period * n2 / (this.nbElements - 2));
        return l;
    }

    public synchronized long getPointValue() {
        long l = this.getEffectiveTime() / (long)this.refreshRate;
        this.update(l);
        return this.values != null ? this.values[(int)((l - 1L) % (long)this.nbElements)] : 0L;
    }

    protected final synchronized long getSum() {
        long l = 0L;
        if (this.values != null) {
            long l2 = this.getEffectiveTime() / (long)this.refreshRate;
            this.update(l2);
            for (long i = l2 + 2L; i < l2 + (long)this.nbElements; ++i) {
                l += this.values[(int)(i % (long)this.nbElements)];
            }
        }
        return l;
    }

    protected final synchronized long getSum(int n) {
        long l = this.getEffectiveTime() / (long)this.refreshRate;
        this.update(l);
        long l2 = 0L;
        if (n < 1) {
            n = 1;
        } else if (n > this.nbElements - 2) {
            n = this.nbElements - 2;
        }
        long l3 = l + (long)this.nbElements;
        long l4 = l3 - (long)n;
        if (this.values != null) {
            for (long i = l4; i < l3; ++i) {
                l2 += this.values[(int)(i % (long)this.nbElements)];
            }
        }
        return l2;
    }

    protected long getEffectiveTime() {
        return SystemTime.getSteppedMonotonousTime();
    }
}

