/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gudy.azureus2.core3.util.BEncodingException;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.StringInterner;

public class BDecoder {
    private static final int MAX_BYTE_ARRAY_SIZE = 0x800000;
    private static final int MAX_MAP_KEY_SIZE = 65536;
    private static final boolean TRACE = false;
    private boolean recovery_mode;
    private ByteBuffer keyBytesBuffer = ByteBuffer.allocate(32);
    private final char[] numberChars = new char[32];

    public static Map decode(byte[] byArray) throws IOException {
        return new BDecoder().decodeByteArray(byArray);
    }

    public static Map decode(byte[] byArray, int n, int n2) throws IOException {
        return new BDecoder().decodeByteArray(byArray, n, n2);
    }

    public static Map decode(BufferedInputStream bufferedInputStream) throws IOException {
        return new BDecoder().decodeStream(bufferedInputStream);
    }

    public Map decodeByteArray(byte[] byArray) throws IOException {
        return this.decode(new BDecoderInputStreamArray(byArray));
    }

    public Map decodeByteArray(byte[] byArray, int n, int n2) throws IOException {
        return this.decode(new BDecoderInputStreamArray(byArray, n, n2));
    }

    public Map decodeStream(BufferedInputStream bufferedInputStream) throws IOException {
        return this.decodeStream(bufferedInputStream, true);
    }

    public Map decodeStream(BufferedInputStream bufferedInputStream, boolean bl) throws IOException {
        Object object = this.decodeInputStream(bufferedInputStream, 0, bl);
        if (object == null) {
            throw new BEncodingException("BDecoder: zero length file");
        }
        if (!(object instanceof Map)) {
            throw new BEncodingException("BDecoder: top level isn't a Map");
        }
        return (Map)object;
    }

    private Map decode(InputStream inputStream) throws IOException {
        Object object = this.decodeInputStream(inputStream, 0, true);
        if (object == null) {
            throw new BEncodingException("BDecoder: zero length file");
        }
        if (!(object instanceof Map)) {
            throw new BEncodingException("BDecoder: top level isn't a Map");
        }
        return (Map)object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object decodeInputStream(InputStream inputStream, int n, boolean bl) throws IOException {
        LightHashMap lightHashMap;
        block23: {
            if (n == 0 && !inputStream.markSupported()) {
                throw new IOException("InputStream must support the mark() method");
            }
            inputStream.mark(Integer.MAX_VALUE);
            int n2 = inputStream.read();
            switch (n2) {
                case 100: {
                    lightHashMap = new LightHashMap();
                    try {}
                    catch (Throwable throwable) {
                        if (!this.recovery_mode) {
                            if (!(throwable instanceof IOException)) throw new IOException(Debug.getNestedExceptionMessage(throwable));
                            throw (IOException)throwable;
                        }
                        break block23;
                    }
                    break;
                }
                case 108: {
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    try {
                        Object object = null;
                        while (true) {
                            if ((object = this.decodeInputStream(inputStream, n + 1, bl)) == null) {
                                arrayList.trimToSize();
                                inputStream.mark(Integer.MAX_VALUE);
                                n2 = inputStream.read();
                                inputStream.reset();
                                if (n <= 0) return arrayList;
                                if (n2 != -1) return arrayList;
                                throw new BEncodingException("BDecoder: invalid input data, 'e' missing from end of list");
                            }
                            arrayList.add(object);
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.recovery_mode) return arrayList;
                        if (!(throwable instanceof IOException)) throw new IOException(Debug.getNestedExceptionMessage(throwable));
                        throw (IOException)throwable;
                    }
                }
                case -1: 
                case 101: {
                    return null;
                }
                case 105: {
                    return this.getNumberFromStream(inputStream, 'e');
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    inputStream.reset();
                    return this.getByteArrayFromStream(inputStream);
                }
                default: {
                    int n3 = inputStream.available();
                    if (n3 > 256) {
                        n3 = 256;
                    }
                    byte[] byArray = new byte[n3];
                    inputStream.read(byArray);
                    throw new BEncodingException("BDecoder: unknown command '" + n2 + ", remainder = " + new String(byArray));
                }
            }
            while (true) {
                Object object;
                ByteBuffer byteBuffer;
                inputStream.mark(Integer.MAX_VALUE);
                n2 = inputStream.read();
                if (n2 == 101 || n2 == -1) break;
                inputStream.reset();
                int n4 = (int)this.getNumberFromStream(inputStream, ':');
                if (n4 < this.keyBytesBuffer.capacity()) {
                    byteBuffer = this.keyBytesBuffer;
                    byteBuffer.position(0).limit(n4);
                } else {
                    byteBuffer = this.keyBytesBuffer = ByteBuffer.allocate(n4);
                }
                this.getByteArrayFromStream(inputStream, n4, byteBuffer.array());
                if (n4 > 65536) {
                    String string = "dictionary key is too large, max=65536: value=" + new String(byteBuffer.array(), 0, 128);
                    System.err.println(string);
                    throw new IOException(string);
                }
                CharBuffer charBuffer = Constants.BYTE_CHARSET.decode(byteBuffer);
                String string = new String(charBuffer.array(), 0, charBuffer.limit());
                if (bl) {
                    string = StringInterner.intern(string);
                }
                if ((object = this.decodeInputStream(inputStream, n + 1, bl)) == null) {
                    System.err.println("Invalid encoding - value not serialsied for '" + string + "' - ignoring");
                    break;
                }
                if (lightHashMap.put(string, object) == null) continue;
                Debug.out("BDecoder: key '" + string + "' already exists!");
            }
            inputStream.mark(Integer.MAX_VALUE);
            n2 = inputStream.read();
            inputStream.reset();
            if (n > 0 && n2 == -1) {
                throw new BEncodingException("BDecoder: invalid input data, 'e' missing from end of dictionary");
            }
        }
        if (!(lightHashMap instanceof LightHashMap)) return lightHashMap;
        lightHashMap.compactify(-0.9f);
        return lightHashMap;
    }

    private long getNumberFromStream(InputStream inputStream, char c) throws IOException {
        int n = inputStream.read();
        int n2 = 0;
        while (n != c && n >= 0) {
            this.numberChars[n2++] = (char)n;
            if (n2 == this.numberChars.length) {
                throw new NumberFormatException("Number too large: " + new String(this.numberChars, 0, n2) + "...");
            }
            n = inputStream.read();
        }
        if (n < 0) {
            return -1L;
        }
        if (n2 == 0) {
            return 0L;
        }
        try {
            return BDecoder.parseLong(this.numberChars, 0, n2);
        }
        catch (NumberFormatException numberFormatException) {
            String string = new String(this.numberChars, 0, n2);
            try {
                double d = Double.parseDouble(string);
                long l = (long)d;
                Debug.out("Invalid number '" + string + "' - decoding as " + l + " and attempting recovery");
                return l;
            }
            catch (Throwable throwable) {
                throw numberFormatException;
            }
        }
    }

    public static long parseLong(char[] cArray, int n, int n2) {
        if (n2 > 0) {
            long l;
            if (cArray[n] == '0') {
                return 0L;
            }
            long l2 = 0L;
            boolean bl = false;
            int n3 = n;
            if (cArray[n3] == '-') {
                bl = true;
                l = Long.MIN_VALUE;
                ++n3;
            } else {
                if (n2 == 1) {
                    int n4 = cArray[n3] - 48;
                    if (n4 < 0 || n4 > 9) {
                        throw new NumberFormatException(new String(cArray, n, n2));
                    }
                    return n4;
                }
                l = -9223372036854775807L;
            }
            int n5 = n + n2;
            if (n3 < n5) {
                int n6;
                if ((n6 = cArray[n3++] - 48) < 0 || n6 > 9) {
                    throw new NumberFormatException(new String(cArray, n, n2));
                }
                l2 = -n6;
            }
            long l3 = l / 10L;
            while (n3 < n5) {
                int n7;
                if ((n7 = cArray[n3++] - 48) < 0 || n7 > 9) {
                    throw new NumberFormatException(new String(cArray, n, n2));
                }
                if (l2 < l3) {
                    throw new NumberFormatException(new String(cArray, n, n2));
                }
                if ((l2 *= 10L) < l + (long)n7) {
                    throw new NumberFormatException(new String(cArray, n, n2));
                }
                l2 -= (long)n7;
            }
            if (bl) {
                if (n3 > n + 1) {
                    return l2;
                }
                throw new NumberFormatException(new String(cArray, n, n2));
            }
            return -l2;
        }
        throw new NumberFormatException(new String(cArray, n, n2));
    }

    private byte[] getByteArrayFromStream(InputStream inputStream) throws IOException {
        int n = (int)this.getNumberFromStream(inputStream, ':');
        if (n < 0) {
            return null;
        }
        if (n > 0x800000) {
            throw new IOException("Byte array length too large (" + n + ")");
        }
        byte[] byArray = new byte[n];
        this.getByteArrayFromStream(inputStream, n, byArray);
        return byArray;
    }

    private void getByteArrayFromStream(InputStream inputStream, int n, byte[] byArray) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 != n && (n3 = inputStream.read(byArray, n2, n - n2)) > 0; n2 += n3) {
        }
        if (n2 != n) {
            throw new IOException("BDecoder::getByteArrayFromStream: truncated");
        }
    }

    public void setRecoveryMode(boolean bl) {
        this.recovery_mode = bl;
    }

    public static void print(Object object) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        BDecoder.print(printWriter, object);
        printWriter.flush();
        System.out.println(stringWriter.toString());
    }

    public static void print(PrintWriter printWriter, Object object) {
        BDecoder.print(printWriter, object, "", false);
    }

    private static void print(PrintWriter printWriter, Object object, String string, boolean bl) {
        String string2;
        String string3 = string2 = bl ? "" : string;
        if (object instanceof Long) {
            printWriter.println(string2 + object);
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length == 20) {
                printWriter.println(string2 + " { " + ByteFormatter.nicePrint(byArray) + " }");
            } else if (byArray.length < 64) {
                printWriter.println(new String(byArray) + " [" + ByteFormatter.encodeString(byArray) + "]");
            } else {
                printWriter.println("[byte array length " + byArray.length);
            }
        } else if (object instanceof String) {
            printWriter.println(string2 + object);
        } else if (object instanceof List) {
            List list = (List)object;
            printWriter.println(string2 + "[");
            for (int i = 0; i < list.size(); ++i) {
                printWriter.print(string + "  (" + i + ") ");
                BDecoder.print(printWriter, list.get(i), string + "    ", true);
            }
            printWriter.println(string + "]");
        } else {
            Map map = (Map)object;
            for (String string4 : map.keySet()) {
                if (string4.length() > 256) {
                    printWriter.print(string + string4.substring(0, 256) + "... = ");
                } else {
                    printWriter.print(string + string4 + " = ");
                }
                BDecoder.print(printWriter, map.get(string4), string + "  ", true);
            }
        }
    }

    public static Map decodeStrings(Map map) {
        if (map == null) {
            return null;
        }
        for (Map.Entry entry : map.entrySet()) {
            Object v = entry.getValue();
            if (v instanceof byte[]) {
                try {
                    entry.setValue(new String((byte[])v, "UTF-8"));
                }
                catch (Throwable throwable) {
                    System.err.println(throwable);
                }
                continue;
            }
            if (v instanceof Map) {
                BDecoder.decodeStrings((Map)v);
                continue;
            }
            if (!(v instanceof List)) continue;
            BDecoder.decodeStrings((List)v);
        }
        return map;
    }

    public static List decodeStrings(List list) {
        if (list == null) {
            return null;
        }
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (e instanceof byte[]) {
                try {
                    String string = new String((byte[])e, "UTF-8");
                    list.set(i, string);
                }
                catch (Throwable throwable) {
                    System.err.println(throwable);
                }
                continue;
            }
            if (e instanceof Map) {
                BDecoder.decodeStrings((Map)e);
                continue;
            }
            if (!(e instanceof List)) continue;
            BDecoder.decodeStrings((List)e);
        }
        return list;
    }

    private static void print(File file, File file2) {
        try {
            BDecoder bDecoder = new BDecoder();
            bDecoder.setRecoveryMode(false);
            PrintWriter printWriter = new PrintWriter(new FileWriter(file2));
            BDecoder.print(printWriter, bDecoder.decodeStream(new BufferedInputStream(new FileInputStream(file))));
            printWriter.flush();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        BDecoder.print(new File("C:\\Temp\\tables.config"), new File("C:\\Temp\\tables.txt"));
    }

    private class BDecoderInputStreamArray
    extends InputStream {
        private final byte[] buffer;
        private final int count;
        private int pos;
        private int mark;

        private BDecoderInputStreamArray(byte[] byArray) {
            this.buffer = byArray;
            this.count = this.buffer.length;
        }

        private BDecoderInputStreamArray(byte[] byArray, int n, int n2) {
            this.buffer = byArray;
            this.pos = n;
            this.count = Math.min(n + n2, byArray.length);
            this.mark = n;
        }

        public int read() throws IOException {
            return this.pos < this.count ? this.buffer[this.pos++] & 0xFF : -1;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.pos >= this.count) {
                return -1;
            }
            if (this.pos + n2 > this.count) {
                n2 = this.count - this.pos;
            }
            if (n2 <= 0) {
                return 0;
            }
            System.arraycopy(this.buffer, this.pos, byArray, n, n2);
            this.pos += n2;
            return n2;
        }

        public int available() throws IOException {
            return this.count - this.pos;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int n) {
            this.mark = this.pos;
        }

        public void reset() throws IOException {
            this.pos = this.mark;
        }
    }
}

