/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.core3.util;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayHashMap<T> {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected Entry<T>[] table;
    protected int size;
    private int threshold;
    final float loadFactor;

    public ByteArrayHashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
    }

    public ByteArrayHashMap(int n) {
        this(n, 0.75f);
    }

    public ByteArrayHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public T get(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return this.get(byArray2);
    }

    public T get(byte[] byArray) {
        int n = ByteArrayHashMap.hash(byArray);
        int n2 = ByteArrayHashMap.indexFor(n, this.table.length);
        Entry<Object> entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && ByteArrayHashMap.eq(byArray, entry.key)) {
                return (T)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public boolean containsKey(byte[] byArray) {
        int n = ByteArrayHashMap.hash(byArray);
        int n2 = ByteArrayHashMap.indexFor(n, this.table.length);
        Entry<Object> entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && ByteArrayHashMap.eq(byArray, entry.key)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public T put(byte[] byArray, T t) {
        int n = ByteArrayHashMap.hash(byArray);
        int n2 = ByteArrayHashMap.indexFor(n, this.table.length);
        Entry<Object> entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && ByteArrayHashMap.eq(byArray, entry.key)) {
                Object s = entry.value;
                entry.value = t;
                return (T)s;
            }
            entry = entry.next;
        }
        this.addEntry(n, byArray, t, n2);
        return null;
    }

    public T remove(byte[] byArray) {
        Entry<T> entry = this.removeEntryForKey(byArray);
        return entry == null ? null : (T)entry.value;
    }

    public void clear() {
        Entry<T>[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    public List<byte[]> keys() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i = 0; i < this.table.length; ++i) {
            Entry<Object> entry = this.table[i];
            while (entry != null) {
                arrayList.add(entry.key);
                entry = entry.next;
            }
        }
        return arrayList;
    }

    public List<T> values() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.table.length; ++i) {
            Entry<Object> entry = this.table[i];
            while (entry != null) {
                arrayList.add(entry.value);
                entry = entry.next;
            }
        }
        return arrayList;
    }

    public ByteArrayHashMap<T> duplicate() {
        ByteArrayHashMap byteArrayHashMap = new ByteArrayHashMap(this.size, this.loadFactor);
        for (int i = 0; i < this.table.length; ++i) {
            Entry<Object> entry = this.table[i];
            while (entry != null) {
                byteArrayHashMap.put(entry.key, entry.value);
                entry = entry.next;
            }
        }
        return byteArrayHashMap;
    }

    void resize(int n) {
        Entry<T>[] entryArray = this.table;
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    void transfer(Entry<T>[] entryArray) {
        Entry<T>[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry<Object> entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = ByteArrayHashMap.indexFor(entry2.hash, n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    Entry<T> removeEntryForKey(byte[] byArray) {
        Entry<T> entry;
        int n = ByteArrayHashMap.hash(byArray);
        int n2 = ByteArrayHashMap.indexFor(n, this.table.length);
        Entry<Object> entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.hash == n && ByteArrayHashMap.eq(byArray, entry2.key)) {
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    void addEntry(int n, byte[] byArray, T t, int n2) {
        this.table[n2] = new Entry<T>(n, byArray, t, this.table[n2]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n, byte[] byArray, T t, int n2) {
        this.table[n2] = new Entry<T>(n, byArray, t, this.table[n2]);
        ++this.size;
    }

    private static final int hash(byte[] byArray) {
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            n = 31 * n + byArray[i];
        }
        return n;
    }

    private static final boolean eq(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    private static final int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Entry<S> {
        public final byte[] key;
        public S value;
        public final int hash;
        public Entry<S> next;

        Entry(int n, byte[] byArray, S s, Entry<S> entry) {
            this.value = s;
            this.next = entry;
            this.key = byArray;
            this.hash = n;
        }

        public byte[] getKey() {
            return this.key;
        }

        public S getValue() {
            return this.value;
        }
    }
}

